/*
 * Decompiled with CFR 0.152.
 */
package Nasca;

import Jampack.JampackException;
import Nasca.AStar;
import Nasca.GraphNode;
import Nasca.ProtonLabel;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.H1CS;
import rdcPanda.Hsqc;
import rdcPanda.ModelRdc;
import rdcPanda.Nasca;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.Peak;
import rdcPanda.RotaPattern;

public class NascaNew {
    public void main(String[] args) throws JampackException {
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String strOut = String.valueOf(userDir) + "/outFiles/";
        String strParametersFileName = "Nasca.input";
        NascaNew nasca = new NascaNew();
        nasca.doNasca(src, strOut, strParametersFileName);
    }

    public Vector<H1CS> ExtractBackboneAsignment(Vector<H1CS> vecAsg) {
        Vector<H1CS> vecBBAsg = new Vector<H1CS>();
        int i = 0;
        while (i < vecAsg.size()) {
            H1CS h1cs = vecAsg.elementAt(i);
            String atom = h1cs.getAtomName();
            if (atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("HA1") || atom.equalsIgnoreCase("HA2") || atom.equalsIgnoreCase("HA3") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("CB")) {
                vecBBAsg.add(h1cs);
            }
            ++i;
        }
        return vecBBAsg;
    }

    public void Initialization(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2, double[][] MapScore, Vector<H1CS> vecBBAsg) {
        GraphNode node;
        int j;
        double errCB = 0.25;
        Peak pk = new Peak();
        int i = 0;
        while (i < vecResonGraph.size()) {
            j = 0;
            while (j < vecLabels.size()) {
                Map2[i][j] = 1;
                MapScore[i][j] = -9999.9;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            node = vecResonGraph.elementAt(i);
            boolean isAsged = node.getIsAssigned();
            if (isAsged) {
                int resNo = node.getResNo();
                String atomName = node.getAtomName();
                j = 0;
                while (j < vecLabels.size()) {
                    ProtonLabel label = vecLabels.elementAt(j);
                    int resNoStruct = label.getResNo();
                    String atomNameStuct = label.getAtomName();
                    String resNameStruct = label.getResName();
                    String subAtomNameStruct = atomNameStuct;
                    if (atomNameStuct.length() > 2) {
                        subAtomNameStruct = atomNameStuct.substring(0, 2);
                    }
                    if (resNoStruct == resNo && atomNameStuct.equalsIgnoreCase(atomName) || resNoStruct == resNo && resNameStruct.equalsIgnoreCase("GLY") && subAtomNameStruct.equalsIgnoreCase(atomName)) {
                        if (node.getIsAssigned()) {
                            label.setIsAssigned(true);
                        }
                        Map2[i][j] = 1;
                        node.asgedId = j;
                        label.asgedId = i;
                        int k = 0;
                        while (k < vecResonGraph.size()) {
                            if (k != i) {
                                Map2[k][j] = 0;
                            }
                            ++k;
                        }
                    } else {
                        Map2[i][j] = 0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            node = vecResonGraph.elementAt(i);
            double cs_heavy = node.getCSHeavy();
            boolean isAsged = node.getIsAssigned();
            if (!isAsged) {
                j = 0;
                while (j < vecLabels.size()) {
                    ProtonLabel nodeStruct = vecLabels.elementAt(j);
                    double csHeavyStruct = 0.0;
                    int resNoStruct = nodeStruct.getResNo();
                    String atomNameStuct = nodeStruct.getAtomName();
                    String resNameStruct = nodeStruct.getResName();
                    String subAtomNameStruct = atomNameStuct;
                    String heavyNameStruct = pk.GetHeavyAtomFromProton(resNameStruct, atomNameStuct);
                    if (atomNameStuct.length() > 2) {
                        subAtomNameStruct = atomNameStuct.substring(0, 2);
                    }
                    if (subAtomNameStruct.equalsIgnoreCase("HB") && heavyNameStruct.equalsIgnoreCase("CB")) {
                        int k = 0;
                        while (k < vecBBAsg.size()) {
                            H1CS h1cs = vecBBAsg.elementAt(k);
                            String CB_atom = h1cs.getAtomName();
                            int CB_resNo = h1cs.getResidueNo();
                            if (CB_atom.equalsIgnoreCase("CB") && CB_resNo == resNoStruct && CB_atom.equalsIgnoreCase("CB")) {
                                csHeavyStruct = h1cs.getH1CS();
                            }
                            ++k;
                        }
                        Map2[i][j] = Math.abs(csHeavyStruct - cs_heavy) < errCB ? 1 : 0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        j = 0;
        while (j < vecLabels.size()) {
            ProtonLabel ndProton = vecLabels.elementAt(j);
            String atom = ndProton.getAtomName();
            String res = ndProton.getResName();
            String heavy = pk.GetHeavyAtomFromProton(res, atom);
            int resNo = ndProton.getResNo();
            int k = 0;
            while (k < vecLabels.size()) {
                if (j != k) {
                    ProtonLabel ndProton2 = vecLabels.elementAt(k);
                    String atom2 = ndProton2.getAtomName();
                    String res2 = ndProton2.getResName();
                    String heavy2 = pk.GetHeavyAtomFromProton(res2, atom2);
                    int resNo2 = ndProton2.getResNo();
                    if (heavy.equalsIgnoreCase(heavy2) && resNo == resNo2) {
                        ndProton.stereoID = k;
                        ndProton2.stereoID = j;
                    }
                }
                ++k;
            }
            ++j;
        }
    }

    public void RefineMappingBasedBMRBOutliers(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2, Vector<H1CS> vecBMRBNew) {
        Peak pk = new Peak();
        int i = 0;
        while (i < vecResonGraph.size()) {
            GraphNode node = vecResonGraph.elementAt(i);
            double csH = node.getCSProton();
            double csHeavy = node.getCSHeavy();
            boolean isAsged = node.getIsAssigned();
            if (!isAsged) {
                int j = 0;
                while (j < vecLabels.size()) {
                    String atomName;
                    ProtonLabel label = vecLabels.elementAt(j);
                    String resName = label.getResName();
                    String subAtomName = atomName = label.getAtomName();
                    String heavyName = pk.GetHeavyAtomFromProton(resName, atomName);
                    int k = 0;
                    while (k < vecBMRBNew.size()) {
                        H1CS h1csB = vecBMRBNew.elementAt(k);
                        String resB = h1csB.getResidueType();
                        String atomB = h1csB.getAtomName();
                        double cs_L = h1csB.getCSLower();
                        double cs_U = h1csB.getCSUpper();
                        subAtomName = atomName;
                        if (subAtomName.length() > atomB.length()) {
                            subAtomName = atomName.substring(0, atomB.length());
                        }
                        if (resB.equalsIgnoreCase(resName) && atomB.equalsIgnoreCase(subAtomName) && atomB.substring(0, 1).equalsIgnoreCase("H") && (csH < cs_L || csH > cs_U)) {
                            Map2[i][j] = 0;
                        }
                        if (resB.equalsIgnoreCase(resName) && atomB.equalsIgnoreCase(heavyName) && (csHeavy < cs_L || csHeavy > cs_U)) {
                            Map2[i][j] = 0;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void UpdateMappingSet(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2) {
        GraphNode nodeReson;
        int i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = vecResonGraph.elementAt(i);
            nodeReson.EmptyMappingSet();
            ++i;
        }
        int j = 0;
        while (j < vecLabels.size()) {
            ProtonLabel label = vecLabels.elementAt(j);
            label.EmptyMappingSet();
            ++j;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = vecResonGraph.elementAt(i);
            j = 0;
            while (j < vecLabels.size()) {
                ProtonLabel label = vecLabels.elementAt(j);
                if (Map2[i][j] == 1) {
                    nodeReson.addMappingNode(label);
                    label.addMappingNode(nodeReson);
                }
                ++j;
            }
            ++i;
        }
    }

    public void UpdateIsRestrained(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2) {
        int i = 0;
        while (i < vecResonGraph.size()) {
            GraphNode nodeReson = vecResonGraph.elementAt(i);
            if (nodeReson.getMappingSet().size() < 5) {
                nodeReson.setIsRestrained(true);
            }
            ++i;
        }
    }

    public void UpdateStereoSymSet(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2) {
        GraphNode nodeReson;
        double errHeavy = 0.1;
        Peak pk = new Peak();
        int i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = vecResonGraph.elementAt(i);
            nodeReson.vecStereoSymSet = new Vector();
            ++i;
        }
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = vecResonGraph.elementAt(i);
            double cs_heavy = nodeReson.getCSHeavy();
            Vector<GraphNode> vec_sym = nodeReson.vecSymSet;
            Vector<ProtonLabel> vec_map = nodeReson.getMappingSet();
            int t = 0;
            while (t < vec_sym.size()) {
                GraphNode nodeReson2 = vec_sym.elementAt(t);
                double cs_heavy2 = nodeReson2.getCSHeavy();
                Vector<ProtonLabel> vec_map2 = nodeReson2.getMappingSet();
                boolean isMap = false;
                int k = 0;
                while (k < vec_map.size()) {
                    ProtonLabel ndProton1 = vec_map.elementAt(k);
                    String atom1 = ndProton1.getAtomName();
                    String res1 = ndProton1.getResName();
                    String heavyName1 = pk.GetHeavyAtomFromProton(res1, atom1);
                    int w = 0;
                    while (w < vec_map2.size()) {
                        ProtonLabel ndProton2 = vec_map2.elementAt(w);
                        String atom2 = ndProton2.getAtomName();
                        String res2 = ndProton2.getResName();
                        String heavyName2 = pk.GetHeavyAtomFromProton(res2, atom2);
                        if (heavyName1.equalsIgnoreCase(heavyName2)) {
                            isMap = true;
                        }
                        ++w;
                    }
                    ++k;
                }
                if (isMap && Math.abs(cs_heavy - cs_heavy2) < errHeavy) {
                    nodeReson.vecStereoSymSet.add(nodeReson2);
                    nodeReson2.vecStereoSymSet.add(nodeReson);
                    nodeReson.stereoID = nodeReson2.getID();
                    nodeReson2.stereoID = nodeReson.getID();
                }
                ++t;
            }
            ++i;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = vecResonGraph.elementAt(i);
            Vector<GraphNode> vecStereoSet = nodeReson.vecStereoSymSet;
            int k = 0;
            while (k < vecStereoSet.size()) {
                GraphNode nodeStereo = vecStereoSet.elementAt(k);
                int curID = nodeStereo.getID();
                boolean isInPre = false;
                int t = 0;
                while (t < vecStereoSet.size()) {
                    GraphNode nodeTemp = vecStereoSet.elementAt(t);
                    if (t != k && nodeTemp.getID() == curID) {
                        isInPre = true;
                    }
                    ++t;
                }
                if (isInPre) {
                    vecStereoSet.remove(k);
                    --k;
                }
                ++k;
            }
            ++i;
        }
    }

    public boolean isInCloseAdj(ProtonLabel nodeSrc, ProtonLabel nodeObj) {
        boolean isIn = false;
        int i = 0;
        while (i < nodeSrc.vecCloseAdj.size()) {
            ProtonLabel ndTemp = nodeSrc.vecCloseAdj.elementAt(i);
            if (ndTemp.getID() == nodeObj.getID()) {
                isIn = true;
            }
            ++i;
        }
        return isIn;
    }

    public boolean isMappedBetwTwoSetsCalScore(GraphNode nodeReson, ProtonLabel label, Vector<GraphNode> vecNodeSetA, Vector<ProtonLabel> vecNodeSetB, int[][] M, boolean isConsiderAssigned, int threshold, double[] Score, Vector<Noesy> vecNoesy) {
        boolean isMapped = false;
        int counter = 0;
        Peak pk = new Peak();
        double cs_proton = nodeReson.getCSProton();
        double cs_heavy = nodeReson.getCSHeavy();
        String res = label.getResName();
        String atom = label.getAtomName();
        int resNo = label.getResNo();
        String heavName = pk.GetHeavyAtomFromProton(res, atom);
        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
        int i = 0;
        while (i < vecNodeSetA.size()) {
            GraphNode nodeA = vecNodeSetA.elementAt(i);
            boolean isAsgedA = nodeA.getIsAssigned();
            int idA = nodeA.getID();
            if (!isConsiderAssigned || isAsgedA) {
                int j = 0;
                while (j < vecNodeSetB.size()) {
                    String atomName;
                    ProtonLabel nodeB = vecNodeSetB.elementAt(j);
                    boolean isAsgedB = nodeB.getIsAssigned();
                    String subAtom = atomName = nodeB.getAtomName();
                    if (atomName.length() >= 2) {
                        subAtom = atomName.substring(0, 2);
                    }
                    int idB = nodeB.getID();
                    if (!(!isConsiderAssigned ? !isAsgedB && !subAtom.equalsIgnoreCase("HB") : !isAsgedB)) {
                        if (M[idA][idB] == 1) {
                            double cs_protonSec = nodeA.getCSProton();
                            double cs_heavySec = nodeA.getCSHeavy();
                            String resSec = nodeB.getResName();
                            String atomSec = nodeB.getAtomName();
                            String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                            int resNoSec = nodeB.getResNo();
                            double distUp = 6.0;
                            if (this.isInCloseAdj(nodeB, label)) {
                                distUp = 2.7;
                            }
                            vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                            vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                            ++counter;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (counter >= threshold) {
            isMapped = true;
        }
        Assign asg = new Assign();
        int[] numPeaks = new int[1];
        double csErrH = 0.04;
        double csErrN = 0.4;
        double csErrCA = 0.4;
        BackNoe bkNoe = new BackNoe();
        Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
        double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesy, numPeaks, true);
        Score[0] = vecBackNoe.size() > 1 ? (dbScore *= (double)vecBackNoeNew.size()) : 0.0;
        return isMapped;
    }

    public void RefineMappingBasedRestrained(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2, double[][] MapScore, Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew) {
        int sizeReson = 2;
        int sizeStruct = 2;
        int restrainThreshold = 5;
        Peak pk = new Peak();
        H1CS h1cs = new H1CS();
        this.UpdateStereoSymSet(vecResonGraph, vecLabels, Map2);
        int j = 0;
        while (j < vecLabels.size()) {
            ProtonLabel label = vecLabels.elementAt(j);
            String resName = label.getResName();
            String atomName = label.getAtomName();
            int resNo = label.getResNo();
            boolean isRestrained = false;
            if (!label.getIsAssigned()) {
                String subAtom = atomName;
                if (atomName.length() >= 2) {
                    subAtom = atomName.substring(0, 2);
                }
                if (subAtom.equalsIgnoreCase("HB")) {
                    sizeReson = label.stereoID >= 0 ? 1 : 1;
                    Vector<RotaPattern> vecNeighborSC = new Vector<RotaPattern>();
                    int i = 0;
                    while (i < vecResonGraph.size()) {
                        if (Map2[i][j] != 0) {
                            String heavyName;
                            GraphNode node = vecResonGraph.elementAt(i);
                            double cs_proton = node.getCSProton();
                            double cs_heavy = node.getCSHeavy();
                            Vector<GraphNode> vecAdj = node.getAdjVec();
                            boolean isAssigned = node.getIsAssigned();
                            if (!isAssigned && ((heavyName = pk.GetHeavyAtomFromProton(resName, atomName)).substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C"))) {
                                Vector<ProtonLabel> vecAdj2 = label.getAdjVec();
                                if (vecAdj.size() < 1 || vecAdj2.size() < 1) {
                                    System.out.println("debugging...we found an empty neiborhood...");
                                } else {
                                    double[] neighborSC = new double[1];
                                    boolean isRestrainTemp = false;
                                    isRestrainTemp = this.isMappedBetwTwoSetsCalScore(node, label, vecAdj, vecAdj2, Map2, true, restrainThreshold, neighborSC, vecNewNoesy);
                                    Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                                    vecOneSCAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                                    vecOneSCAsg.add(new H1CS(resNo, resName, heavyName, cs_heavy));
                                    double asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecBMRBNew);
                                    neighborSC[0] = neighborSC[0] + asgScore;
                                    MapScore[i][j] = neighborSC[0];
                                    if (isRestrainTemp) {
                                        isRestrained = true;
                                    }
                                    RotaPattern rp = new RotaPattern(i, neighborSC[0]);
                                    vecNeighborSC.add(rp);
                                }
                            }
                        }
                        ++i;
                    }
                    label.setIsRestrained(true);
                    Collections.sort(vecNeighborSC, new RotaPattern.scoreComparator());
                    i = 0;
                    while (i < vecResonGraph.size()) {
                        boolean isIn = false;
                        int h = 0;
                        while (h < Math.min(8, vecNeighborSC.size())) {
                            RotaPattern rotPatn = (RotaPattern)vecNeighborSC.elementAt(h);
                            int graph_ID = rotPatn.getResNo();
                            GraphNode nodeTemp = vecResonGraph.elementAt(graph_ID);
                            int stereoIDTemp = nodeTemp.stereoID;
                            if (i == graph_ID || i == stereoIDTemp) {
                                isIn = true;
                            }
                            ++h;
                        }
                        if (!isIn) {
                            Map2[i][j] = 0;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
    }

    public void RefineMappingForHG(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2, double[][] MapScore, Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew) {
        Nasca isoGraph = new Nasca();
        Peak pk = new Peak();
        H1CS h1cs = new H1CS();
        int restrainThreshold = 15;
        this.UpdateStereoSymSet(vecResonGraph, vecLabels, Map2);
        int j = 0;
        while (j < vecLabels.size()) {
            ProtonLabel node2 = vecLabels.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            int resNo = node2.getResNo();
            boolean isRestrained = false;
            if (!node2.getIsAssigned()) {
                if (resNo == 3 && atomName.equalsIgnoreCase("HB2")) {
                    System.out.println("debugging...");
                }
                String subAtom = atomName;
                if (atomName.length() >= 2) {
                    subAtom = atomName.substring(0, 2);
                }
                if (subAtom.equalsIgnoreCase("HG") || subAtom.equalsIgnoreCase("HD") || subAtom.equalsIgnoreCase("HE") || subAtom.equalsIgnoreCase("HH") || subAtom.equalsIgnoreCase("HZ")) {
                    Vector<RotaPattern> vecNeighborSC = new Vector<RotaPattern>();
                    int i = 0;
                    while (i < vecResonGraph.size()) {
                        if (Map2[i][j] != 0) {
                            String heavyName;
                            GraphNode node = vecResonGraph.elementAt(i);
                            double cs_proton = node.getCSProton();
                            double cs_heavy = node.getCSHeavy();
                            Vector<GraphNode> vecAdj = node.getAdjVec();
                            boolean isAssigned = node.getIsAssigned();
                            if (!isAssigned && ((heavyName = pk.GetHeavyAtomFromProton(resName, atomName)).substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C"))) {
                                Vector<ProtonLabel> vecAdj2 = node2.getAdjVec();
                                if (vecAdj.size() < 1 || vecAdj2.size() < 1) {
                                    System.out.println("debugging...we found an empty neiborhood...");
                                } else {
                                    double[] neighborSC = new double[1];
                                    boolean isRestrainTemp = false;
                                    isRestrainTemp = this.isMappedBetwTwoSetsCalScore(node, node2, vecAdj, vecAdj2, Map2, false, restrainThreshold, neighborSC, vecNewNoesy);
                                    Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                                    vecOneSCAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                                    vecOneSCAsg.add(new H1CS(resNo, resName, heavyName, cs_heavy));
                                    double asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecBMRBNew);
                                    neighborSC[0] = neighborSC[0] + asgScore;
                                    MapScore[i][j] = neighborSC[0];
                                    if (isRestrainTemp) {
                                        isRestrained = true;
                                    }
                                    RotaPattern rp = new RotaPattern(i, neighborSC[0]);
                                    vecNeighborSC.add(rp);
                                }
                            }
                        }
                        ++i;
                    }
                    node2.setIsRestrained(true);
                    Collections.sort(vecNeighborSC, new RotaPattern.scoreComparator());
                    i = 0;
                    while (i < vecResonGraph.size()) {
                        boolean isIn = false;
                        int h = 0;
                        while (h < Math.min(20, vecNeighborSC.size())) {
                            RotaPattern rotPatn = (RotaPattern)vecNeighborSC.elementAt(h);
                            int graph_ID = rotPatn.getResNo();
                            GraphNode nodeTemp = vecResonGraph.elementAt(graph_ID);
                            int stereoIDTemp = nodeTemp.stereoID;
                            if (i == graph_ID || i == stereoIDTemp) {
                                isIn = true;
                            }
                            ++h;
                        }
                        if (!isIn) {
                            Map2[i][j] = 0;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
    }

    public int RefineMappingDeeCut(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecHPositions, int[][] Map2, double[][] MapScore, Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        int counter = 0;
        int j = 0;
        while (j < vecHPositions.size()) {
            String atom;
            String res;
            String heavyName;
            ProtonLabel nodeProton = vecHPositions.elementAt(j);
            if (!nodeProton.getIsAssigned() && !(heavyName = pk.GetHeavyAtomFromProton(res = nodeProton.getResName(), atom = nodeProton.getAtomName())).equalsIgnoreCase("CB")) {
                int resNo = nodeProton.getResNo();
                Vector<GraphNode> vecMapSet = nodeProton.getMappingSet();
                Vector<ProtonLabel> vecAdj = nodeProton.getAdjVec();
                if (vecMapSet.size() >= 1 && vecAdj.size() >= 1 && !nodeProton.getIsAssigned()) {
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        double asgScore;
                        GraphNode ndMapCur = vecMapSet.elementAt(k);
                        boolean isPruned = false;
                        double csCur_proton = ndMapCur.getCSProton();
                        double csCur_heavy = ndMapCur.getCSHeavy();
                        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                        vecOneSCAsg.add(new H1CS(resNo, res, atom, csCur_proton));
                        vecOneSCAsg.add(new H1CS(resNo, res, heavyName, csCur_heavy));
                        double totalCurScore = asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecBMRBNew);
                        int t = 0;
                        while (t < vecAdj.size()) {
                            Vector<GraphNode> vecNdCurAdjMap;
                            ProtonLabel ndCurAdj = vecAdj.elementAt(t);
                            if (!ndCurAdj.getIsAssigned() && (vecNdCurAdjMap = ndCurAdj.getMappingSet()).size() >= 1) {
                                int resNoAdj = ndCurAdj.getResNo();
                                String resAdj = ndCurAdj.getResName();
                                String atomAdj = ndCurAdj.getAtomName();
                                String heavyNameAdj = pk.GetHeavyAtomFromProton(resAdj, atomAdj);
                                int maxAdjID = -1;
                                double maxScore = -9999.9;
                                Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                                int a = 0;
                                while (a < vecNdCurAdjMap.size()) {
                                    GraphNode ndAdjMap = vecNdCurAdjMap.elementAt(a);
                                    Vector<Noesy> vecNoesyTwo = new Vector<Noesy>();
                                    vecNoesyTwo.addAll(ndMapCur.vecAdjNOESY);
                                    vecNoesyTwo.addAll(ndAdjMap.vecAdjNOESY);
                                    double csAdjMapProton = ndAdjMap.getCSProton();
                                    double csAdjMapHeavy = ndAdjMap.getCSHeavy();
                                    vecBackNoe.add(new BackNoe(csCur_proton, csCur_heavy, csAdjMapProton, 6.0, 0.0, resNo, resNoAdj, res, resAdj, atom, heavyName, atomAdj));
                                    vecBackNoe.add(new BackNoe(csAdjMapProton, csAdjMapHeavy, csCur_proton, 6.0, 0.0, resNoAdj, resNo, resAdj, res, atomAdj, heavyNameAdj, atom));
                                    Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                                    int[] numPeaks = new int[1];
                                    double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                                    dbScore *= (double)vecBackNoeNew.size();
                                    if (dbScore > maxScore) {
                                        maxScore = dbScore;
                                        maxAdjID = a;
                                    }
                                    ++a;
                                }
                                totalCurScore += maxScore;
                            }
                            ++t;
                        }
                        int h = 0;
                        while (h < vecMapSet.size()) {
                            if (h != k) {
                                double asgOtherScore;
                                GraphNode ndMapCurOther = vecMapSet.elementAt(h);
                                double csOther_proton = ndMapCurOther.getCSProton();
                                double csOther_heavy = ndMapCurOther.getCSHeavy();
                                Vector<H1CS> vecOneSCAsgOther = new Vector<H1CS>();
                                vecOneSCAsgOther.add(new H1CS(resNo, res, atom, csOther_proton));
                                vecOneSCAsgOther.add(new H1CS(resNo, res, heavyName, csOther_heavy));
                                double totalOtherScore = asgOtherScore = h1cs.BMRBSatisticsScore(vecOneSCAsgOther, vecBMRBNew);
                                int minAdjID = -1;
                                int t2 = 0;
                                while (t2 < vecAdj.size()) {
                                    Vector<GraphNode> vecNdCurAdjMap;
                                    ProtonLabel ndCurAdj = vecAdj.elementAt(t2);
                                    if (!ndCurAdj.getIsAssigned() && (vecNdCurAdjMap = ndCurAdj.getMappingSet()).size() >= 1) {
                                        int resNoAdj = ndCurAdj.getResNo();
                                        String resAdj = ndCurAdj.getResName();
                                        String atomAdj = ndCurAdj.getAtomName();
                                        String heavyNameAdj = pk.GetHeavyAtomFromProton(resAdj, atomAdj);
                                        minAdjID = -1;
                                        double minScore = 999999.9;
                                        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                                        int a = 0;
                                        while (a < vecNdCurAdjMap.size()) {
                                            GraphNode ndAdjMap = vecNdCurAdjMap.elementAt(a);
                                            Vector<Noesy> vecNoesyTwo = new Vector<Noesy>();
                                            vecNoesyTwo.addAll(ndMapCurOther.vecAdjNOESY);
                                            vecNoesyTwo.addAll(ndAdjMap.vecAdjNOESY);
                                            double csAdjMapProton = ndAdjMap.getCSProton();
                                            double csAdjMapHeavy = ndAdjMap.getCSHeavy();
                                            vecBackNoe.add(new BackNoe(csCur_proton, csCur_heavy, csAdjMapProton, 6.0, 0.0, resNo, resNoAdj, res, resAdj, atom, heavyName, atomAdj));
                                            vecBackNoe.add(new BackNoe(csAdjMapProton, csAdjMapHeavy, csCur_proton, 6.0, 0.0, resNoAdj, resNo, resAdj, res, atomAdj, heavyNameAdj, atom));
                                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                                            int[] numPeaks = new int[1];
                                            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                                            dbScore *= (double)vecBackNoeNew.size();
                                            if (dbScore < minScore) {
                                                minScore = dbScore;
                                                minAdjID = a;
                                            }
                                            ++a;
                                        }
                                        totalOtherScore += minScore;
                                    }
                                    ++t2;
                                }
                                if (totalCurScore < totalOtherScore) {
                                    isPruned = true;
                                    break;
                                }
                            }
                            ++h;
                        }
                        if (isPruned) {
                            Map2[ndMapCur.getID()][nodeProton.getID()] = 0;
                            ++counter;
                        }
                        ++k;
                    }
                }
            }
            ++j;
        }
        return counter;
    }

    public void PrintAllPossibleMappings(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2) {
        int j = 0;
        while (j < vecLabels.size()) {
            String atomName;
            ProtonLabel label = vecLabels.elementAt(j);
            int resNo = label.getResNo();
            String resName = label.getResName();
            String subAtomName = atomName = label.getAtomName();
            if (atomName.length() > 2) {
                subAtomName = atomName.substring(0, 2);
            }
            if (!(atomName.equalsIgnoreCase("H") || subAtomName.equalsIgnoreCase("HA") || subAtomName.equalsIgnoreCase("HN"))) {
                System.out.println(String.valueOf(resName) + resNo + "-" + atomName + ":");
                int i = 0;
                while (i < vecResonGraph.size()) {
                    GraphNode node = vecResonGraph.elementAt(i);
                    double cs_h = node.getCSProton();
                    double cs_heavy = node.getCSHeavy();
                    if (Map2[i][j] == 1) {
                        System.out.format("        %.3f ,  %.3f%n", cs_h, cs_heavy);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void StatisticsAllSCAssignment(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, int[][] Map2, Vector<H1CS> vecRefAsg) {
        Peak pk = new Peak();
        int totalScH = 0;
        int missing = 0;
        boolean averSize = false;
        boolean sum = false;
        boolean maxSize = false;
        String maxStr = "";
        int[] counter = new int[200];
        Assign asg = new Assign();
        boolean notInRef = false;
        boolean[] isProtonFound = new boolean[vecLabels.size()];
        int j = 0;
        while (j < vecLabels.size()) {
            isProtonFound[j] = false;
            ++j;
        }
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        int k = 0;
        while (k < vecRefAsg.size()) {
            H1CS h1cs = vecRefAsg.elementAt(k);
            int resRefNo = h1cs.getResidueNo();
            String resRef = h1cs.getResidueType();
            String atomRef = h1cs.getAtomName();
            double csRef = h1cs.getH1CS();
            double csHeavyRef = -999.9;
            if (!(atomRef.equalsIgnoreCase("CA") || atomRef.equalsIgnoreCase("N") || atomRef.equalsIgnoreCase("HN") || atomRef.equalsIgnoreCase("H") || atomRef.equalsIgnoreCase("HA") || atomRef.equalsIgnoreCase("HA1") || atomRef.equalsIgnoreCase("HA2") || atomRef.equalsIgnoreCase("HA3") || atomRef.equalsIgnoreCase("C") || atomRef.equalsIgnoreCase("CO") || atomRef.equalsIgnoreCase("CB") || !atomRef.substring(0, 1).equalsIgnoreCase("H"))) {
                String heavyRef = pk.GetHeavyAtomFromProton(resRef, atomRef);
                ++totalScH;
                int t = 0;
                while (t < vecRefAsg.size()) {
                    H1CS h1csTemp = vecRefAsg.elementAt(t);
                    int resNoTemp = h1csTemp.getResidueNo();
                    String atomTemp = h1csTemp.getAtomName();
                    if (atomTemp.equalsIgnoreCase(heavyRef) && resNoTemp == resRefNo) {
                        csHeavyRef = h1csTemp.getH1CS();
                    }
                    ++t;
                }
                boolean isRefInCur = false;
                int j2 = 0;
                while (j2 < vecLabels.size()) {
                    int resNo;
                    String atom;
                    ProtonLabel nodeStr = vecLabels.elementAt(j2);
                    String subAtom = atom = nodeStr.getAtomName();
                    if (atom.length() > atomRef.length()) {
                        subAtom = atom.substring(0, atomRef.length());
                    }
                    if ((resNo = nodeStr.getResNo()) == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                        Vector<GraphNode> vecMapSet = nodeStr.getMappingSet();
                        int w = 0;
                        while (w < vecMapSet.size()) {
                            GraphNode resonNode = vecMapSet.elementAt(w);
                            double csProton = resonNode.getCSProton();
                            double csHeavy = resonNode.getCSHeavy();
                            if (Math.abs(csProton - csRef) < 0.05 && Math.abs(csHeavy - csHeavyRef) < 0.5) {
                                isRefInCur = true;
                            }
                            ++w;
                        }
                    }
                    ++j2;
                }
                if (!isRefInCur) {
                    ++missing;
                    System.out.println("Missing proton assignment: " + resRef + " " + resRefNo + " - " + atomRef);
                }
            }
            ++k;
        }
        System.out.println("Total number of sidechain protons in ref table: " + totalScH);
        System.out.println("Total number of missing sidechain assignments: " + missing);
    }

    public void doNasca(String src, String strOut, String strInput) throws JampackException {
        int j;
        boolean isDebug = false;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        int nIs4DNoesy = 0;
        String strReson = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strResNameScheme = "";
        String strIsCheckLongAA = "";
        String strHaNoesy3D = "";
        String strResFormat = "";
        String strBB = "";
        String stroutName = "";
        String strNoesyFormat = "";
        String strOutOrFormat = "";
        String strIsCheck = "";
        String strRefPdb = "";
        String strRefNameSchem = "";
        String strIsWholeStr = "";
        String strPdbNameScheme = "";
        String str4DNoesy = "";
        String stroutResonName = "";
        String strOutResonFormat = "";
        int nIsoriginalUp = 0;
        double noeLimit = 0.0;
        double metCor = 0.0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("PDBNAMESCHEME")) {
                strPdbNameScheme = paraMap.get("PDBNAMESCHEME");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("NOELIMIT")) {
                noeLimit = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("IS4DNOESY")) {
                nIs4DNoesy = Integer.parseInt(paraMap.get("IS4DNOESY"));
            }
            if (paraMap.containsKey("4D-NOESY")) {
                str4DNoesy = paraMap.get("4D-NOESY");
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            if (paraMap.containsKey("RESNAMESCHEME")) {
                strResNameScheme = paraMap.get("RESNAMESCHEME");
            }
            if (paraMap.containsKey("NOESY-FORMAT")) {
                strNoesyFormat = paraMap.get("NOESY-FORMAT");
            }
            if (paraMap.containsKey("ISCHECKLONGAA")) {
                strIsCheckLongAA = paraMap.get("ISCHECKLONGAA");
            }
            if (paraMap.containsKey("ISCHECK")) {
                strIsCheck = paraMap.get("ISCHECK");
            }
            if (paraMap.containsKey("REFPDB")) {
                strRefPdb = paraMap.get("REFPDB");
            }
            if (paraMap.containsKey("METHYL-CORRECTION")) {
                metCor = Double.parseDouble(paraMap.get("METHYL-CORRECTION"));
            }
            if (paraMap.containsKey("REFNAMESCHEME")) {
                strRefNameSchem = paraMap.get("REFNAMESCHEME");
            }
            if (paraMap.containsKey("ISWHOLESTRUCTURE")) {
                strIsWholeStr = paraMap.get("ISWHOLESTRUCTURE");
            }
            if (paraMap.containsKey("ISOUTORFORMAT")) {
                strOutOrFormat = paraMap.get("ISOUTORFORMAT");
            }
            if (paraMap.containsKey("OUTRESONANCENAME")) {
                stroutResonName = paraMap.get("OUTRESONANCENAME");
            }
            if (paraMap.containsKey("OUTRESONANCEFORMAT")) {
                strOutResonFormat = paraMap.get("OUTRESONANCEFORMAT");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<Object> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        Vector<Object> Noe4DVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!str4DNoesy.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + str4DNoesy;
            Noe4DVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView4D(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNoesy4D = new Vector<Noesy>();
        vecNoesy4D.addAll(Noe4DVec);
        Vector<Object> vecNewNoesy = new Vector();
        if (vecNoesy.size() > 0) {
            vecNewNoesy = noesy.SetCalibration(vecNoesy);
        }
        Vector<Object> vecNewNoesy4D = new Vector();
        if (vecNoesy4D.size() > 0) {
            vecNewNoesy4D = noesy.SetCalibration(vecNoesy4D);
        }
        double[] constant = new double[1];
        Vector<Pdb> vecSSE = new Vector<Pdb>();
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        String pdbFile = String.valueOf(src) + strBB;
        Vector<Pdb> pdbVecBB = pp.readPdb(pdbFile);
        Vector<Pdb> pdbVecNew = new Vector();
        pdbVecNew = strIsWholeStr.equalsIgnoreCase("1") ? pp.residueNameUpdateNoStr(vecSeq, pdbVecBB) : pp.residueNameUpdate(vecSeq, pdbVecBB);
        Vector<Object> pdbVecNewSec = new Vector();
        if (strPdbNameScheme.equalsIgnoreCase("PDB-OLD")) {
            pdbVecNewSec = pp.nameConvertOrder(pdbVecNew);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecNew);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-OLD")) {
            Vector<Pdb> pdbVecSSE22 = pp.nameConvertOrder(pdbVecNew);
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecSSE22);
        } else {
            pdbVecNewSec.addAll(pdbVecNew);
        }
        Vector<Object> vecStructureAll = new Vector<Object>();
        vecStructureAll.addAll(pdbVecNewSec);
        Vector<Pdb> vecBBTemp = pp.OutputBackbone(pdbVecNewSec);
        pdbVecNewSec = new Vector();
        pdbVecNewSec.addAll(vecBBTemp);
        ProtonLabel protonLabel = new ProtonLabel();
        GraphNode graphNode = new GraphNode();
        String userDir = System.getProperty("user.dir");
        String srcRot = String.valueOf(userDir) + "/system/rot-lib/";
        Vector<ProtonLabel> vecLabels = protonLabel.ConstructProtonLabelSet(pdbVecNewSec, srcRot, 5.0);
        Vector<Object> vecAsgNew = new Vector();
        vecAsgNew = h1CS.CSNameConvertFromBMRBNewToPDBNew(assignVec);
        assignVec = new Vector();
        assignVec.addAll(vecAsgNew);
        Vector<H1CS> vecBBAsg = this.ExtractBackboneAsignment(assignVec);
        Vector<GraphNode> vecResonNodeSet = graphNode.ConstructInitResonGraphFromAsgedList(vecBBAsg, null);
        i = 0;
        while (i < vecNewNoesy.size()) {
            Noesy ne = (Noesy)vecNewNoesy.elementAt(i);
            double csH1 = ne.getH1();
            double csHeavy = ne.getHeavy();
            double csH2 = ne.getH2();
            Vector<Object> vecResGraphTemp = new Vector();
            vecResGraphTemp = graphNode.AddResonanceNode(vecResonNodeSet, csH1, csHeavy, 0.02, 0.1, 0.1);
            vecResonNodeSet = new Vector();
            vecResonNodeSet.addAll(vecResGraphTemp);
            ++i;
        }
        i = 0;
        while (i < vecResonNodeSet.size()) {
            GraphNode node = vecResonNodeSet.elementAt(i);
            Vector<GraphNode> vecAdj = node.getAdjVec();
            int counter = 1;
            double csProtonSum = node.getCSProton();
            double csHeavySum = node.getCSHeavy();
            int k = 0;
            while (k < vecAdj.size()) {
                GraphNode ndAdj = vecAdj.elementAt(k);
                csProtonSum += ndAdj.getCSProton();
                csHeavySum += ndAdj.getCSHeavy();
                ++counter;
                ++k;
            }
            node.setProtonCS(csProtonSum /= (double)counter);
            node.setHeavyCS(csHeavySum /= (double)counter);
            node.EmptyAdjSet();
            ++i;
        }
        Vector<GraphNode> vecResonGraph = graphNode.ConstructResonGraph(vecResonNodeSet, vecNewNoesy, 0.04, 0.04, 0.1, 0.1);
        graphNode.ConstructResonGraphSymmetry(vecResonNodeSet, vecNewNoesy, 0.03, 0.03, 0.1, 0.1);
        String srcBMRB = String.valueOf(userDir) + "/system/BMRB_CS.txt";
        Vector<H1CS> vecBMRB = h1CS.ReadBMRBSatistics(srcBMRB);
        Vector<H1CS> vecBMRBNew = new Vector();
        vecBMRBNew = h1CS.CSNameConvertFromBMRBNewToPDBNew(vecBMRB);
        int[][] Map2 = new int[vecResonGraph.size()][vecLabels.size()];
        double[][] MapScore = new double[vecResonGraph.size()][vecLabels.size()];
        this.Initialization(vecResonGraph, vecLabels, Map2, MapScore, vecBBAsg);
        this.RefineMappingBasedBMRBOutliers(vecResonGraph, vecLabels, Map2, vecBMRBNew);
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        this.UpdateIsRestrained(vecResonGraph, vecLabels, Map2);
        this.RefineMappingBasedRestrained(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        this.RefineMappingForHG(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        this.RefineMappingDeeCut(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        this.PrintAllPossibleMappings(vecResonGraph, vecLabels, Map2);
        this.StatisticsAllSCAssignment(vecResonGraph, vecLabels, Map2, assignVec);
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        H1CS h1cs = new H1CS();
        AStar astar = new AStar();
        Vector<H1CS> vecAsgNewT0 = astar.AStarSearchForSCAsgs(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        Vector<H1CS> vecAsgNewT = h1cs.DeleteRepeatAsg(vecAsgNewT0);
        h1cs.PrintAllAssignment(vecAsgNewT);
        h1cs.PrintAllAssignmentCyana(vecAsgNewT);
        String outResFileName = String.valueOf(userDir) + stroutResonName;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outResFileName)));
            if (strOutResonFormat.equalsIgnoreCase("CYANA")) {
                h1cs.PrintAllAssignmentToFileCyana(vecAsgNewT, out);
            } else {
                h1cs.PrintAllAssignmentToFileBMRB(vecAsgNewT, out);
            }
            out.close();
            System.out.println("The NOE assignment table has been generated in " + outResFileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + outResFileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        h1cs.CompareSCAsgsWRefAsgs(vecAsgNewT, assignVec, vecBBAsg);
        double counter = 0.0;
        int t = 0;
        while (t < vecLabels.size()) {
            ProtonLabel node = vecLabels.elementAt(t);
            String ndAtom = node.getAtomName();
            int ndNo = node.getResNo();
            int k = 0;
            while (k < assignVec.size()) {
                H1CS h1csT = (H1CS)assignVec.elementAt(k);
                int refNo = h1csT.getResidueNo();
                String atom = h1csT.getAtomName();
                String subNdAtom = ndAtom;
                if (ndAtom.length() > atom.length()) {
                    subNdAtom = ndAtom.substring(0, atom.length());
                }
                if (atom.substring(0, 1).equalsIgnoreCase("H") && ndNo == refNo && subNdAtom.equalsIgnoreCase(atom)) {
                    counter += 1.0;
                    break;
                }
                ++k;
            }
            ++t;
        }
        System.out.println("Completeness of reference assignment table is: " + counter / (double)vecLabels.size());
        counter = 0.0;
        int k = 0;
        while (k < vecAsgNewT.size()) {
            H1CS h1csT = vecAsgNewT.elementAt(k);
            String atom = h1csT.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                counter += 1.0;
            }
            ++k;
        }
        System.out.println("Completeness of our assignment table is: " + counter / (double)vecLabels.size());
        Vector<Object> vecAmbgAsg = new Vector();
        allH1Vec = new Vector();
        allH1Vec = pk.allProtonSorted(vecAsgNewT);
        Collections.sort(allH1Vec, new Peak.csComparator());
        vecAmbgAsg = asg.InitAmbiAssignment(nErr, c13Err, hnErr, haErr, h1Err, vecAsgNewT, allH1Vec, vecNewNoesy);
        Vector<Noe> vecAmbgAsgTemp = noesy.SetCalibrationCyana(vecAmbgAsg, vecNewNoesy, constant[0]);
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecAmbgAsgTemp);
        Vector<Noe> vecNoeRefine2 = new Vector<Noe>();
        i = 0;
        while (i < vecAmbgAsg.size()) {
            Noe noe = (Noe)vecAmbgAsg.elementAt(i);
            int noA = noe.getResidueNoA();
            int noB = noe.getResidueNoB();
            String atomA = noe.getAtomA();
            String atomB = noe.getAtomB();
            if (noA != noB || !atomA.equalsIgnoreCase(atomB)) {
                boolean isIn = true;
                if (strOutOrFormat.equalsIgnoreCase("0")) {
                    j = 0;
                    while (j < vecNoeRefine2.size()) {
                        Noe noeT = (Noe)vecNoeRefine2.elementAt(j);
                        int noAT = noeT.getResidueNoA();
                        int noBT = noeT.getResidueNoB();
                        String atomAT = noeT.getAtomA();
                        String atomBT = noeT.getAtomB();
                        if (noA == noAT && atomA.equalsIgnoreCase(atomAT) && noB == noBT && atomB.equalsIgnoreCase(atomBT)) {
                            isIn = false;
                        }
                        if (noA == noBT && atomA.equalsIgnoreCase(atomBT) && noB == noAT && atomB.equalsIgnoreCase(atomAT)) {
                            isIn = false;
                        }
                        ++j;
                    }
                }
                if (isIn) {
                    vecNoeRefine2.add(noe);
                }
            }
            ++i;
        }
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecNoeRefine2);
        Vector<Pdb> vecRotStructure = pp.RotamSelectAndStructure(hnErr, nErr, c13Err, pdbVecNewSec, vecAsgNewT, srcRot, vecNewNoesy, 4.5, 1, constant[0]);
        Vector<Object> vecRefinedNoes = new Vector();
        vecRefinedNoes = asg.PrunAmbgNoeAsg(vecRotStructure, vecAmbgAsg, noeLimit, 0.0, nIsoriginalUp);
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        if (!strOutOrFormat.equalsIgnoreCase("1")) {
            i = 0;
            while (i < vecAmbgAsg.size()) {
                Noe noe = (Noe)vecAmbgAsg.elementAt(i);
                int firstResNo = noe.getResidueNoA();
                int secondResNo = noe.getResidueNoB();
                String firstResName = noe.getResidueA();
                String secondResName = noe.getResidueB();
                String firstAtomName = noe.getAtomA();
                String secondAtomName = noe.getAtomB();
                if (secondResNo < firstResNo) {
                    noe.setResNoA(secondResNo);
                    noe.setResNoB(firstResNo);
                    noe.setAtom1Name(secondAtomName);
                    noe.setAtom2Name(firstAtomName);
                    noe.setResNameA(secondResName);
                    noe.setResNameB(firstResName);
                }
                ++i;
            }
            Collections.sort(vecAmbgAsg, new Noe.noeComparatorC());
        }
        if (strIsCheckLongAA.equalsIgnoreCase("1")) {
            Vector<Noe> vecTemp = new Vector<Noe>();
            i = 0;
            while (i < vecRefinedNoes.size()) {
                Noe noe = (Noe)vecRefinedNoes.elementAt(i);
                int firstResNo = noe.getResidueNoA();
                int secondResNo = noe.getResidueNoB();
                String firstResName = noe.getResidueA();
                String secondResName = noe.getResidueB();
                String atomA = noe.getAtomA();
                String atomB = noe.getAtomB();
                String subAtomA = atomA;
                String subAtomB = atomB;
                if (atomA.length() >= 2) {
                    subAtomA = atomA.substring(0, 2);
                }
                if (atomB.length() >= 2) {
                    subAtomB = atomB.substring(0, 2);
                }
                if (Math.abs(firstResNo - secondResNo) <= 4) {
                    vecTemp.add(noe);
                } else {
                    boolean isKeep = true;
                    if (pk.isCharged(firstResName) && pk.isHydrophobic(secondResName)) {
                        isKeep = false;
                    }
                    if (pk.isCharged(secondResName) && pk.isHydrophobic(firstResName)) {
                        isKeep = false;
                    }
                    if ((subAtomB.equalsIgnoreCase("HN") || subAtomB.equalsIgnoreCase("H") || subAtomB.equalsIgnoreCase("HA") || subAtomB.equalsIgnoreCase("HB")) && (subAtomA.equalsIgnoreCase("HN") || subAtomA.equalsIgnoreCase("H") || subAtomA.equalsIgnoreCase("HA") || subAtomA.equalsIgnoreCase("HB"))) {
                        isKeep = true;
                    }
                    if (isKeep) {
                        vecTemp.add(noe);
                    }
                }
                ++i;
            }
            vecRefinedNoes = new Vector();
            vecRefinedNoes.addAll(vecTemp);
        }
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        Noe ne = new Noe();
        Vector<Noe> vecNoeNewT = ne.NameConvertFromPDBNewToPDBNew(vecRefinedNoes);
        vecRefinedNoes = new Vector();
        vecRefinedNoes.addAll(vecNoeNewT);
        vecNoeRefine2 = new Vector();
        Vector<Noe> vecNoeUniq = new Vector<Noe>();
        i = 0;
        while (i < vecRefinedNoes.size()) {
            Noe noe = (Noe)vecRefinedNoes.elementAt(i);
            int pkID = noe.getPeakID();
            boolean isUniq = true;
            j = 0;
            while (j < vecRefinedNoes.size()) {
                Noe noeT;
                int pkIDT;
                if (i != j && pkID == (pkIDT = (noeT = (Noe)vecRefinedNoes.elementAt(j)).getPeakID())) {
                    isUniq = false;
                }
                ++j;
            }
            if (isUniq) {
                vecNoeUniq.add(noe);
            }
            ++i;
        }
        double[] number = new double[4];
        if (strIsCheck.equalsIgnoreCase("1")) {
            Noe noe_temp = new Noe();
            String pdbFileXray = String.valueOf(src) + strRefPdb;
            Vector<Pdb> vecTempPdbBB = pp.readPdb(pdbFileXray);
            Vector<Object> vecTempPdbBB2 = new Vector();
            if (strRefNameSchem.equalsIgnoreCase("PDB-OLD")) {
                vecTempPdbBB2 = pp.nameConvertOrder(vecTempPdbBB);
            } else if (strRefNameSchem.equalsIgnoreCase("BMRB-NEW")) {
                vecTempPdbBB2 = pp.nameConvert2PDBNew(vecTempPdbBB);
            } else if (strRefNameSchem.equalsIgnoreCase("BMRB-OLD")) {
                Vector<Pdb> pdbVecSSE22 = pp.nameConvertOrder(vecTempPdbBB);
                vecTempPdbBB2 = pp.nameConvert2PDBNew(pdbVecSSE22);
            } else {
                vecTempPdbBB2.addAll(vecTempPdbBB);
            }
            System.out.println("============================================ ");
            System.out.println("====Comparisons with reference structure===== ");
            noe_temp.CompareAsgToRefStr(vecRefinedNoes, vecTempPdbBB2, 6.0, 0.0, number);
            System.out.println("Number of correct NOE assignments in reference structure=  " + number[0]);
            System.out.println("Number of wrong NOE assignments in reference structure=  " + number[1]);
            System.out.println("Number of correct Long-Rang NOE assignments in reference structure=  " + number[2]);
            System.out.println("Number of wrong Long-Rang NOE assignments in reference structure=  " + number[3]);
            System.out.println("============================================ ");
        }
        String userDirTemp = System.getProperty("user.dir");
        if (strOutOrFormat.equalsIgnoreCase("0")) {
            String fileName = String.valueOf(userDirTemp) + stroutName;
            String xplorNoeStr = "";
            double[] disUpper = new double[1];
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                out.println("!REMARK: Total number of NOESY cross peaks is " + (vecNoesy.size() + vecNoesy4D.size()));
                out.println("!REMARK: Total number of NOEs is " + vecRefinedNoes.size());
                out.println("!REMARK: the number of unique NOE assignments is " + vecNoeUniq.size());
                out.println("!REMARK: the number of multiple NOE assignments is " + (vecRefinedNoes.size() - vecNoeUniq.size()));
                out.println("!REMARK: Number of correct assignments in reference structure=  " + number[0]);
                out.println("!REMARK: Number of wrong assignments in reference structure=  " + number[1]);
                out.println("!REMARK: Number of correct Long-Rang NOE assignments in reference structure=  " + number[2]);
                out.println("!REMARK: Number of wrong Long-Rang NOE assignments in reference structure=  " + number[3]);
                out.println("");
                out.println("");
                i = 0;
                while (i < vecRefinedNoes.size()) {
                    Noe noe = (Noe)vecRefinedNoes.elementAt(i);
                    int resNo1 = noe.getResidueNoA();
                    int resNo2 = noe.getResidueNoB();
                    String res1 = noe.getResidueA();
                    String res2 = noe.getResidueB();
                    String atom1 = noe.getAtomA();
                    String atom2 = noe.getAtomB();
                    double distUpper = noe.getUpper();
                    xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                    if (isDebug) {
                        System.out.println(xplorNoeStr);
                    }
                    out.println(xplorNoeStr);
                    ++i;
                }
                out.close();
                System.out.println("The NOE assignment table has been generated in " + fileName);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + fileName);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        } else if (strOutOrFormat.equalsIgnoreCase("1")) {
            Noe noeTemp = new Noe();
            Vector<Noe> vecMultiAsg = noeTemp.ConvertSingleToMultiAsg(vecRefinedNoes);
            String fileName = String.valueOf(userDirTemp) + stroutName;
            noeTemp.OutputMultiNOEAsg(vecMultiAsg, fileName);
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }
}

