/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.Cartesian;
import rdcPanda.H1CS;
import rdcPanda.HcchTocsy;
import rdcPanda.Hdist;
import rdcPanda.HnNoe;
import rdcPanda.Matrix;
import rdcPanda.Noe;
import rdcPanda.Pdb;
import rdcPanda.RotaPattern;
import rdcPanda.ScNoe;

public class Peak {
    private String nucleus = null;
    private double cs;
    private double intensity;
    private boolean isAssg = true;

    public Peak() {
        this.nucleus = null;
        this.cs = 0.0;
        this.intensity = 0.0;
        this.isAssg = true;
    }

    public Peak(double csV) {
        this.nucleus = null;
        this.cs = csV;
        this.intensity = 0.0;
        this.isAssg = true;
    }

    public Peak(String type, double no) {
        this.nucleus = type;
        this.cs = no;
        this.intensity = 0.0;
        this.isAssg = true;
    }

    public Peak(String type, double no, boolean isAsg) {
        this.nucleus = type;
        this.cs = no;
        this.intensity = 0.0;
        this.isAssg = isAsg;
    }

    public Peak(String type, double no, double inten) {
        this.nucleus = type;
        this.cs = no;
        this.intensity = inten;
        this.isAssg = true;
    }

    public Peak(String type, double no, double inten, boolean isAsg) {
        this.nucleus = type;
        this.cs = no;
        this.intensity = inten;
        this.isAssg = isAsg;
    }

    public double getCS() {
        return this.cs;
    }

    public boolean getIsAssg() {
        return this.isAssg;
    }

    public String getNucleus() {
        return this.nucleus;
    }

    public void setCS(double R) {
        this.cs = R;
    }

    public void setNucleus(String R) {
        this.nucleus = R;
    }

    public String toString() {
        String desc = String.valueOf(this.nucleus) + "  " + this.cs + "   " + this.intensity;
        return desc;
    }

    public String GetHeavyAtomFromProton(String resName, String protonName) {
        String desc = "";
        String temp = "";
        if (!protonName.substring(0, 1).equalsIgnoreCase("H")) {
            desc = " ";
            return desc;
        }
        if (protonName.equalsIgnoreCase("H") || protonName.equalsIgnoreCase("HN")) {
            desc = "N";
            return desc;
        }
        if (resName.equalsIgnoreCase("ARG")) {
            if (protonName.length() >= 3 && protonName.substring(0, 2).equalsIgnoreCase("HH")) {
                desc = "N" + protonName.substring(1, 3);
                return desc;
            }
            if (protonName.length() >= 2) {
                if (protonName.substring(0, 2).equalsIgnoreCase("HE")) {
                    desc = "NE";
                    return desc;
                }
                if (protonName.substring(0, 2).equalsIgnoreCase("HH")) {
                    desc = "NH";
                    return desc;
                }
            }
        }
        if (resName.equalsIgnoreCase("GLU")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.length() >= 2) {
                if (protonName.equalsIgnoreCase("HE2")) {
                    desc = "OE2";
                    return desc;
                }
                if (protonName.equalsIgnoreCase("HE1")) {
                    desc = "OE1";
                    return desc;
                }
            }
        }
        if (resName.equalsIgnoreCase("GLU")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.length() >= 2) {
                if (protonName.equalsIgnoreCase("HD2")) {
                    desc = "OD2";
                    return desc;
                }
                if (protonName.equalsIgnoreCase("HD1")) {
                    desc = "OD1";
                    return desc;
                }
            }
        }
        if (resName.equalsIgnoreCase("CYS")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.length() >= 2 && protonName.substring(0, 2).equalsIgnoreCase("HG")) {
                desc = "SG";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("SER")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.length() >= 2 && protonName.substring(0, 2).equalsIgnoreCase("HG")) {
                desc = "OG";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("THR")) {
            if (protonName.equalsIgnoreCase("HB")) {
                desc = "CB";
                return desc;
            }
            if (protonName.length() > 4) {
                protonName = protonName.substring(0, 4);
            }
            if (protonName.length() >= 3 && protonName.substring(0, 3).equalsIgnoreCase("HG2")) {
                desc = "CG2";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("TRP")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.equalsIgnoreCase("HE1")) {
                desc = "NE1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HD1")) {
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE3")) {
                desc = "CE3";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HZ2")) {
                desc = "CZ2";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HZ3")) {
                desc = "CZ3";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HH2")) {
                desc = "CH2";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("TYR")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.equalsIgnoreCase("HD1")) {
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HD2")) {
                desc = "CD2";
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HD")) {
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE1")) {
                desc = "CE1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE")) {
                desc = "CE1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE2")) {
                desc = "CE2";
                desc = "CE1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HH")) {
                desc = "OH";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("GLN")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.length() >= 2 && protonName.substring(0, 2).equalsIgnoreCase("HE")) {
                desc = "NE2";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("ASN")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.length() >= 2 && protonName.substring(0, 2).equalsIgnoreCase("HD")) {
                desc = "ND2";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("HIS")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.equalsIgnoreCase("HD1")) {
                desc = "ND1";
                desc = "CD2";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HD2")) {
                desc = "CD2";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HD")) {
                desc = "CD2";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE2")) {
                desc = "NE2";
                desc = "CE1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE1")) {
                desc = "CE1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE")) {
                desc = "CE1";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("LYS")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.length() >= 2 && protonName.substring(0, 2).equalsIgnoreCase("HZ")) {
                desc = "NZ";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("MET") && protonName.length() >= 2 && protonName.substring(0, 2).equalsIgnoreCase("HE")) {
            desc = "CE";
            return desc;
        }
        if (resName.equalsIgnoreCase("ILE")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.equalsIgnoreCase("HD1")) {
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HG2")) {
                desc = "CG2";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HG1")) {
                desc = "CG1";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("LEU")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.equalsIgnoreCase("HD1")) {
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HD2")) {
                desc = "CD2";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("PHE")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.equalsIgnoreCase("HD1")) {
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HD2")) {
                desc = "CD2";
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HD")) {
                desc = "CD1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE1")) {
                desc = "CE1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE2")) {
                desc = "CE2";
                desc = "CE1";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HE")) {
                desc = "CE1";
                return desc;
            }
        }
        if (resName.equalsIgnoreCase("VAL")) {
            if (protonName.length() > 3) {
                protonName = protonName.substring(0, 3);
            }
            if (protonName.equalsIgnoreCase("HG2")) {
                desc = "CG2";
                return desc;
            }
            if (protonName.equalsIgnoreCase("HG1")) {
                desc = "CG1";
                return desc;
            }
        }
        temp = protonName.substring(1, 2);
        desc = "C" + temp;
        return desc;
    }

    public String xplorNoeStatement(int no1, String nucleus1, int no2, String nucleus2, double dis) {
        String str = "assign ((resid     " + String.valueOf(no1) + "  and name      " + nucleus1 + "))   ((resid     " + String.valueOf(no2) + " and name    " + nucleus2 + "))      " + String.valueOf(dis);
        return str;
    }

    public double[] noeLimit(double dis) {
        double[] noeLimits = new double[3];
        double lowerLimit = 1.8;
        double middle = 0.0;
        double upLimit = 5.5;
        double methylCorrection = 2.5;
        double strongBound = 2.7;
        double middleBound = 3.5;
        double methylBound = 6.5;
        double methylMin = 4.0;
        if (dis <= lowerLimit) {
            upLimit = methylCorrection + dis;
            if (upLimit < methylMin) {
                upLimit = methylMin;
            }
        } else {
            upLimit = dis > lowerLimit && dis <= middleBound ? methylCorrection + dis : (dis > middleBound && dis <= upLimit ? methylCorrection + dis : (dis > upLimit && dis <= methylBound ? dis + 0.5 * lowerLimit : methylBound + 1.0));
        }
        noeLimits[0] = lowerLimit;
        noeLimits[1] = middle;
        noeLimits[2] = upLimit;
        return noeLimits;
    }

    public String xplorNoeStatementNew(int no1, String resid1, String nucleus1, int no2, String resid, String nucleus2, double dis) {
        double lowerLimit = 1.8;
        double middle = 0.0;
        double upLimit = 5.5;
        double methylCorrection = 3.0;
        double strongBound = 2.7;
        double middleBound = 3.5;
        double methylBound = 7.0;
        double methylMin = 4.0;
        double[] noeLimits = new double[3];
        boolean isMethyl = false;
        if (resid1.equalsIgnoreCase("ALA") && nucleus1.equalsIgnoreCase("HB")) {
            nucleus1 = "HB#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HD1")) {
            nucleus1 = "HD1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD1")) {
            nucleus1 = "HD1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD2")) {
            nucleus1 = "HD2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG1")) {
            nucleus1 = "HG1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("THR") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else {
            if (!resid1.equalsIgnoreCase("ARG")) {
                resid1.equalsIgnoreCase("PRO");
            }
            if (!(resid1.equalsIgnoreCase("ASP") || resid1.equalsIgnoreCase("CYS") || resid1.equalsIgnoreCase("HIS") || resid1.equalsIgnoreCase("SER") || resid1.equalsIgnoreCase("TRP") || resid1.equalsIgnoreCase("ASN") || resid1.equalsIgnoreCase("LEU") || resid1.equalsIgnoreCase("VAL") || resid1.equalsIgnoreCase("TYR"))) {
                resid1.equalsIgnoreCase("PHE");
            }
            if (!resid1.equalsIgnoreCase("GLU") && !resid1.equalsIgnoreCase("MET")) {
                resid1.equalsIgnoreCase("GLN");
            }
            resid1.equalsIgnoreCase("GLY");
            resid1.equalsIgnoreCase("ILE");
            if (!resid1.equalsIgnoreCase("LYS")) {
                resid1.equalsIgnoreCase("PRO");
            }
            if (nucleus1.equalsIgnoreCase("H")) {
                nucleus1 = "HN";
            }
            upLimit = dis < strongBound ? strongBound : dis;
            noeLimits[0] = lowerLimit;
            noeLimits[1] = middle;
            noeLimits[2] = upLimit;
        }
        if (resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB")) {
            nucleus2 = "HB#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1")) {
            nucleus2 = "HD1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1")) {
            nucleus2 = "HD1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2")) {
            nucleus2 = "HD2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1")) {
            nucleus2 = "HG1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else {
            if (!resid.equalsIgnoreCase("ARG")) {
                resid.equalsIgnoreCase("PRO");
            }
            if (!(resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("ASN") || resid.equalsIgnoreCase("LEU") || resid.equalsIgnoreCase("VAL") || resid.equalsIgnoreCase("TYR"))) {
                resid.equalsIgnoreCase("PHE");
            }
            if (!resid.equalsIgnoreCase("GLU") && !resid.equalsIgnoreCase("MET")) {
                resid.equalsIgnoreCase("GLN");
            }
            resid.equalsIgnoreCase("GLY");
            resid.equalsIgnoreCase("ILE");
            if (!resid.equalsIgnoreCase("LYS")) {
                resid.equalsIgnoreCase("PRO");
            }
            if (nucleus2.equalsIgnoreCase("H")) {
                nucleus2 = "HN";
            }
            upLimit = dis < strongBound ? strongBound : dis;
            if (!isMethyl) {
                noeLimits[0] = lowerLimit;
                noeLimits[1] = middle;
                noeLimits[2] = upLimit;
            }
        }
        lowerLimit = noeLimits[0];
        middle = noeLimits[1];
        upLimit = noeLimits[2];
        String strDis1 = String.format("%.3f", dis);
        String strDis2 = String.format("%.3f", dis - 1.8);
        String str = "assign ( resid     " + String.valueOf(no1) + "  and name       " + nucleus1 + " )   ( resid     " + String.valueOf(no2) + " and name     " + nucleus2 + " )      " + strDis1 + "   " + strDis2 + "  " + String.valueOf(0.0);
        return str;
    }

    public String xplorNoeStatement(int no1, String resid1, String nucleus1, int no2, String resid, String nucleus2, double dis, double[] disUp) {
        double lowerLimit = 1.8;
        double middle = 0.0;
        double upLimit = 5.5;
        double methylCorrection = 3.0;
        double strongBound = 2.7;
        double middleBound = 3.5;
        double methylBound = 7.0;
        double methylMin = 4.0;
        double[] noeLimits = new double[3];
        boolean isMethyl = false;
        if (resid1.equalsIgnoreCase("ALA") && nucleus1.equalsIgnoreCase("HB")) {
            nucleus1 = "HB#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HD1")) {
            nucleus1 = "HD1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD1")) {
            nucleus1 = "HD1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD2")) {
            nucleus1 = "HD2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG1")) {
            nucleus1 = "HG1#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else if (resid1.equalsIgnoreCase("THR") && nucleus1.equalsIgnoreCase("HG2")) {
            nucleus1 = "HG2#";
            noeLimits = this.noeLimit(dis);
            isMethyl = true;
        } else {
            if (resid1.equalsIgnoreCase("ARG") || resid1.equalsIgnoreCase("PRO")) {
                if (nucleus1.equalsIgnoreCase("HB2")) {
                    nucleus1 = "HB1";
                }
                if (nucleus1.equalsIgnoreCase("HB3")) {
                    nucleus1 = "HB2";
                }
                if (nucleus1.equalsIgnoreCase("HG2")) {
                    nucleus1 = "HG1";
                }
                if (nucleus1.equalsIgnoreCase("HG3")) {
                    nucleus1 = "HG2";
                }
                if (nucleus1.equalsIgnoreCase("HD2")) {
                    nucleus1 = "HD1";
                }
                if (nucleus1.equalsIgnoreCase("HD3")) {
                    nucleus1 = "HD2";
                }
            }
            if (resid1.equalsIgnoreCase("ASP") || resid1.equalsIgnoreCase("CYS") || resid1.equalsIgnoreCase("HIS") || resid1.equalsIgnoreCase("SER") || resid1.equalsIgnoreCase("TRP") || resid1.equalsIgnoreCase("ASN") || resid1.equalsIgnoreCase("LEU") || resid1.equalsIgnoreCase("VAL") || resid1.equalsIgnoreCase("TYR") || resid1.equalsIgnoreCase("PHE")) {
                if (nucleus1.equalsIgnoreCase("HB2")) {
                    nucleus1 = "HB1";
                }
                if (nucleus1.equalsIgnoreCase("HB3")) {
                    nucleus1 = "HB2";
                }
            }
            if (resid1.equalsIgnoreCase("GLU") || resid1.equalsIgnoreCase("MET") || resid1.equalsIgnoreCase("GLN")) {
                if (nucleus1.equalsIgnoreCase("HB2")) {
                    nucleus1 = "HB1";
                }
                if (nucleus1.equalsIgnoreCase("HB3")) {
                    nucleus1 = "HB2";
                }
                if (nucleus1.equalsIgnoreCase("HG2")) {
                    nucleus1 = "HG1";
                }
                if (nucleus1.equalsIgnoreCase("HG3")) {
                    nucleus1 = "HG2";
                }
            }
            if (resid1.equalsIgnoreCase("GLY")) {
                if (nucleus1.equalsIgnoreCase("HA2")) {
                    nucleus1 = "HA1";
                }
                if (nucleus1.equalsIgnoreCase("HA3")) {
                    nucleus1 = "HA2";
                }
            }
            if (resid1.equalsIgnoreCase("ILE")) {
                if (nucleus1.equalsIgnoreCase("HG12")) {
                    nucleus1 = "HG11";
                }
                if (nucleus1.equalsIgnoreCase("HG13")) {
                    nucleus1 = "HG12";
                }
            }
            if (resid1.equalsIgnoreCase("LYS") || resid1.equalsIgnoreCase("PRO")) {
                if (nucleus1.equalsIgnoreCase("HB2")) {
                    nucleus1 = "HB1";
                }
                if (nucleus1.equalsIgnoreCase("HB3")) {
                    nucleus1 = "HB2";
                }
                if (nucleus1.equalsIgnoreCase("HG2")) {
                    nucleus1 = "HG1";
                }
                if (nucleus1.equalsIgnoreCase("HG3")) {
                    nucleus1 = "HG2";
                }
                if (nucleus1.equalsIgnoreCase("HD2")) {
                    nucleus1 = "HD1";
                }
                if (nucleus1.equalsIgnoreCase("HD3")) {
                    nucleus1 = "HD2";
                }
                if (nucleus1.equalsIgnoreCase("HE2")) {
                    nucleus1 = "HE1";
                }
                if (nucleus1.equalsIgnoreCase("HE3")) {
                    nucleus1 = "HE2";
                }
            }
            if (nucleus1.equalsIgnoreCase("H")) {
                nucleus1 = "HN";
            }
            upLimit = dis < strongBound ? strongBound : dis;
            noeLimits[0] = lowerLimit;
            noeLimits[1] = middle;
            noeLimits[2] = upLimit;
        }
        if (resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB")) {
            nucleus2 = "HB#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1")) {
            nucleus2 = "HD1#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1")) {
            nucleus2 = "HD1#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2")) {
            nucleus2 = "HD2#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1")) {
            nucleus2 = "HG1#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
        } else {
            if (resid.equalsIgnoreCase("ARG") || resid.equalsIgnoreCase("PRO")) {
                if (nucleus2.equalsIgnoreCase("HB2")) {
                    nucleus2 = "HB1";
                }
                if (nucleus2.equalsIgnoreCase("HB3")) {
                    nucleus2 = "HB2";
                }
                if (nucleus2.equalsIgnoreCase("HG2")) {
                    nucleus2 = "HG1";
                }
                if (nucleus2.equalsIgnoreCase("HG3")) {
                    nucleus2 = "HG2";
                }
                if (nucleus2.equalsIgnoreCase("HD2")) {
                    nucleus2 = "HD1";
                }
                if (nucleus2.equalsIgnoreCase("HD3")) {
                    nucleus2 = "HD2";
                }
            }
            if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("ASN") || resid.equalsIgnoreCase("LEU") || resid.equalsIgnoreCase("VAL") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("PHE")) {
                if (nucleus2.equalsIgnoreCase("HB2")) {
                    nucleus2 = "HB1";
                }
                if (nucleus2.equalsIgnoreCase("HB3")) {
                    nucleus2 = "HB2";
                }
            }
            if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET") || resid.equalsIgnoreCase("GLN")) {
                if (nucleus2.equalsIgnoreCase("HB2")) {
                    nucleus2 = "HB1";
                }
                if (nucleus2.equalsIgnoreCase("HB3")) {
                    nucleus2 = "HB2";
                }
                if (nucleus2.equalsIgnoreCase("HG2")) {
                    nucleus2 = "HG1";
                }
                if (nucleus2.equalsIgnoreCase("HG3")) {
                    nucleus2 = "HG2";
                }
            }
            if (resid.equalsIgnoreCase("GLY")) {
                if (nucleus2.equalsIgnoreCase("HA2")) {
                    nucleus2 = "HA1";
                }
                if (nucleus2.equalsIgnoreCase("HA3")) {
                    nucleus2 = "HA2";
                }
            }
            if (resid.equalsIgnoreCase("ILE")) {
                if (nucleus2.equalsIgnoreCase("HG12")) {
                    nucleus2 = "HG11";
                }
                if (nucleus2.equalsIgnoreCase("HG13")) {
                    nucleus2 = "HG12";
                }
            }
            if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                if (nucleus2.equalsIgnoreCase("HB2")) {
                    nucleus2 = "HB1";
                }
                if (nucleus2.equalsIgnoreCase("HB3")) {
                    nucleus2 = "HB2";
                }
                if (nucleus2.equalsIgnoreCase("HG2")) {
                    nucleus2 = "HG1";
                }
                if (nucleus2.equalsIgnoreCase("HG3")) {
                    nucleus2 = "HG2";
                }
                if (nucleus2.equalsIgnoreCase("HD2")) {
                    nucleus2 = "HD1";
                }
                if (nucleus2.equalsIgnoreCase("HD3")) {
                    nucleus2 = "HD2";
                }
                if (nucleus2.equalsIgnoreCase("HE2")) {
                    nucleus2 = "HE1";
                }
                if (nucleus2.equalsIgnoreCase("HE3")) {
                    nucleus2 = "HE2";
                }
            }
            if (nucleus2.equalsIgnoreCase("H")) {
                nucleus2 = "HN";
            }
            upLimit = dis < strongBound ? strongBound : dis;
            if (!isMethyl) {
                noeLimits[0] = lowerLimit;
                noeLimits[1] = middle;
                noeLimits[2] = upLimit;
            }
        }
        lowerLimit = noeLimits[0];
        middle = noeLimits[1];
        upLimit = noeLimits[2];
        String str = "assign (resid     " + String.valueOf(no1) + "  and name       " + nucleus1 + ")   (resid     " + String.valueOf(no2) + " and name     " + nucleus2 + ")      " + String.valueOf(lowerLimit) + "   " + String.valueOf(middle) + "  " + String.valueOf(upLimit);
        disUp[0] = upLimit;
        return str;
    }

    public String xplorNoeStatement_old(int no1, String nucleus1, int no2, String resid, String nucleus2, double dis, double[] disUp) {
        double lowerLimit = 1.8;
        double middle = 0.0;
        double upLimit = 5.5;
        double methylCorrection = 3.0;
        double strongBound = 2.7;
        double middleBound = 3.5;
        double methylBound = 7.0;
        double methylMin = 4.0;
        double[] noeLimits = new double[3];
        if (resid.equalsIgnoreCase("ALA") && nucleus2.equals("HB")) {
            nucleus2 = "HB#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equals("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equals("HD1")) {
            nucleus2 = "HD1#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equals("HD1")) {
            nucleus2 = "HD1#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equals("HD2")) {
            nucleus2 = "HD2#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equals("HG1")) {
            nucleus2 = "HG1#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equals("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
        } else if (resid.equalsIgnoreCase("THR") && nucleus2.equals("HG2")) {
            nucleus2 = "HG2#";
            noeLimits = this.noeLimit(dis);
        } else {
            if (nucleus2.equals("HA3")) {
                nucleus2 = "HA1";
            } else if (nucleus2.equals("HB3")) {
                nucleus2 = "HB1";
            } else if (nucleus2.equals("HG3")) {
                nucleus2 = "HG1";
            } else if (nucleus2.equals("HD3")) {
                nucleus2 = "HD1";
            } else if (nucleus2.equals("HE3")) {
                nucleus2 = "HE1";
            } else if (nucleus2.equals("HD21")) {
                nucleus2 = "HD22";
            } else if (nucleus2.equals("HD22")) {
                nucleus2 = "HD21";
            } else if (nucleus2.equals("HE21")) {
                nucleus2 = "HE22";
            } else if (nucleus2.equals("HE22")) {
                nucleus2 = "HE21";
            }
            upLimit = dis < strongBound ? strongBound : dis;
            noeLimits[0] = lowerLimit;
            noeLimits[1] = middle;
            noeLimits[2] = upLimit;
        }
        lowerLimit = noeLimits[0];
        middle = noeLimits[1];
        upLimit = noeLimits[2];
        String str = "assign (resid     " + String.valueOf(no1) + "  and name       " + nucleus1 + ")   (resid     " + String.valueOf(no2) + " and name     " + nucleus2 + ")      " + String.valueOf(lowerLimit) + "   " + String.valueOf(middle) + "  " + String.valueOf(upLimit);
        disUp[0] = upLimit;
        return str;
    }

    public double length(double[] v1) {
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        return v1Len;
    }

    public double[] internuclearVec(double[] n1, double[] n2) {
        return new double[]{n2[0] - n1[0], n2[1] - n1[1], n2[2] - n1[2]};
    }

    public Vector<Peak> allProtonSorted_old(Vector<Assign> asgVec) {
        Assign assign = new Assign();
        Map aMap = new TreeMap();
        int no = 0;
        String aaType = "";
        double csValue = 0.0;
        Vector<Peak> pkVec = new Vector<Peak>();
        String ss = "";
        String nucleus = "";
        int j = 0;
        while (j < asgVec.size()) {
            assign = asgVec.elementAt(j);
            no = assign.getResidueNo();
            aaType = assign.getResidueType();
            aMap = assign.getMap();
            for (Map.Entry e : aMap.entrySet()) {
                csValue = (Double)e.getValue();
                nucleus = (String)e.getKey();
                if (nucleus.equalsIgnoreCase("CA") || nucleus.equalsIgnoreCase("CB") || nucleus.equalsIgnoreCase("N") || nucleus.equalsIgnoreCase("H") || nucleus.equalsIgnoreCase("ND") || nucleus.equalsIgnoreCase("NE")) continue;
                ss = String.valueOf(aaType) + no + "-" + nucleus;
                pkVec.add(new Peak(ss, csValue));
            }
            ++j;
        }
        return pkVec;
    }

    public Vector<Peak> allProtonSorted(Vector<H1CS> asgVec) {
        H1CS assign = new H1CS();
        TreeMap aMap = new TreeMap();
        int no = 0;
        String aaType = "";
        double csValue = 0.0;
        Vector<Peak> pkVec = new Vector<Peak>();
        String ss = "";
        String nucleus = "";
        int j = 0;
        while (j < asgVec.size()) {
            assign = asgVec.elementAt(j);
            no = assign.getResidueNo();
            aaType = assign.getResidueType();
            nucleus = assign.getAtomName();
            csValue = assign.getH1CS();
            if (nucleus.substring(0, 1).equalsIgnoreCase("H") || nucleus.substring(0, 1).equalsIgnoreCase("Q")) {
                ss = String.valueOf(aaType) + no + "-" + nucleus;
                pkVec.add(new Peak(ss, csValue));
            }
            ++j;
        }
        return pkVec;
    }

    public Vector ringResonanceAsg(double csValue, double hErr) {
        Vector<Peak> pkVec = new Vector<Peak>();
        String ss = "";
        if (csValue > 6.02 - hErr && csValue < 8.8 + hErr) {
            ss = "PHE4-HE1";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "PHE45-HE1";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > 6.02 - hErr && csValue < 8.8 + hErr) {
            ss = "PHE4-HE2";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "PHE45-HE2";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > 6.02 - hErr && csValue < 9.5 + hErr) {
            ss = "PHE4-HZ";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "PHE45-HZ";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > 6.02 - hErr && csValue < 7.86 + hErr) {
            ss = "TYR59-HE1";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > 6.02 - hErr && csValue < 8.5 + hErr) {
            ss = "TYR59-HE2";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > -2.02 - hErr && csValue < 2.69 + hErr) {
            ss = "ILE13-HG12";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "ILE23-HG12";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "ILE36-HG12";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "ILE61-HG12";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > -2.04 - hErr && csValue < 2.99 + hErr) {
            ss = "ILE13-HG13";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "ILE23-HG13";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "ILE36-HG13";
            pkVec.add(new Peak(ss, csValue, false));
            ss = "ILE61-HG13";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > 0.04 - hErr && csValue < 3.66 + hErr) {
            ss = "GLN41-HG2";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > 0.05 - hErr && csValue < 3.66 + hErr) {
            ss = "GLN41-HG3";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > -0.82 - hErr && csValue < 3.01 + hErr) {
            ss = "LYS27-HG2";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > -0.87 - hErr && csValue < 2.99 + hErr) {
            ss = "LYS27-HG3";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > 1.17 - hErr && csValue < 4.32 + hErr) {
            ss = "LYS27-HE2";
            pkVec.add(new Peak(ss, csValue, false));
        }
        if (csValue > 1.1 - hErr && csValue < 4.55 + hErr) {
            ss = "LYS27-HE3";
            pkVec.add(new Peak(ss, csValue, false));
        }
        return pkVec;
    }

    public Vector scNoeGenerate(Vector h1CSVec, int resNo1, String nucleus1, double csH1Err, Vector pdbVecXray) {
        String atomName2 = "";
        double[] coordA = new double[3];
        double[] coordB = new double[3];
        boolean found = false;
        double noeLimits = 5.5;
        double[] noeXray = new double[1];
        double csH1 = 0.0;
        double csH2 = 0.0;
        double cs1 = 0.0;
        double cs2 = 0.0;
        String strTemp = "";
        Vector<ScNoe> scNoe = new Vector<ScNoe>();
        long seed = 951179L;
        Random rr = new Random(seed);
        H1CS h1CS = new H1CS();
        int i = 0;
        while (i < pdbVecXray.size()) {
            Pdb pp2 = (Pdb)pdbVecXray.elementAt(i);
            Vector<Cartesian> atomVec2 = pp2.getAtomVec();
            int resNo2 = pp2.getResidueNo();
            int j = 0;
            while (j < atomVec2.size()) {
                Cartesian cc2 = atomVec2.elementAt(j);
                atomName2 = cc2.getAtom();
                found = this.checkNoe2(pdbVecXray, resNo1, nucleus1, resNo2, atomName2, noeLimits, 2.5, noeXray);
                strTemp = atomName2.substring(0, 1);
                if (strTemp.equalsIgnoreCase("H") && found) {
                    int k = 0;
                    while (k < h1CSVec.size()) {
                        h1CS = (H1CS)h1CSVec.elementAt(k);
                        if (h1CS.getResidueNo() == resNo1 && nucleus1.equalsIgnoreCase(h1CS.getAtomName())) {
                            cs1 = h1CS.getH1CS();
                        }
                        if (h1CS.getResidueNo() == resNo2 && atomName2.equalsIgnoreCase(h1CS.getAtomName())) {
                            cs2 = h1CS.getH1CS();
                        }
                        ++k;
                    }
                    csH1 = cs1 + csH1Err * rr.nextGaussian();
                    csH2 = cs2 + csH1Err * rr.nextGaussian();
                    scNoe.add(new ScNoe(csH1, csH2, 0.0));
                }
                ++j;
            }
            ++i;
        }
        return scNoe;
    }

    public Vector BackCSGenerate(Vector allCSVec, int resNo1, String resName1, String atomName1, int resNo2, String resName2, String atomName2, String heavyName2, double csSigma) {
        long seed = 951179L;
        Random rr = new Random(seed);
        H1CS cs = null;
        double db_cs = 0.0;
        double db_csH1 = 0.0;
        double db_csH2 = 0.0;
        double db_csHeavy2 = 0.0;
        Vector<Object> inputs = new Vector<Object>();
        int i = 0;
        while (i < allCSVec.size()) {
            cs = (H1CS)allCSVec.elementAt(i);
            int res_no = cs.getResidueNo();
            String res_name = cs.getResidueType();
            String atom_name = cs.getAtomName();
            db_cs = cs.getH1CS();
            if (res_no == resNo1 && res_name.equalsIgnoreCase(resName1) && atom_name.equalsIgnoreCase(atomName1)) {
                db_csH1 = db_cs + csSigma * rr.nextGaussian();
            }
            if (res_no == resNo2 && res_name.equalsIgnoreCase(resName2) && atom_name.equalsIgnoreCase(atomName2)) {
                db_csH2 = db_cs + csSigma * rr.nextGaussian();
            }
            if (res_no == resNo2 && res_name.equalsIgnoreCase(resName2) && atom_name.equalsIgnoreCase(heavyName2)) {
                db_csHeavy2 = db_cs + csSigma * rr.nextGaussian();
            }
            ++i;
        }
        if (heavyName2.substring(0, 1).equalsIgnoreCase("C")) {
            inputs.add(new HcchTocsy(resNo2, resName2, db_csH2, db_csHeavy2, db_csH1, 0.0));
        }
        if (heavyName2.substring(0, 1).equalsIgnoreCase("N")) {
            inputs.add(new HnNoe(resNo2, resName2, db_csH2, db_csHeavy2, db_csH1, 0.0));
        }
        return inputs;
    }

    public Vector ubqNoeGenerate(Vector h1CSVec, double csH1Err, Vector pdbVecXray) {
        Vector ubqNoe = new Vector();
        Vector scNoe = this.scNoeGenerate(h1CSVec, 4, "HD1", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 4, "HD2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 4, "HE1", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 4, "HE2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 4, "H", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 4, "HA", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 4, "HB2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 4, "HB3", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 45, "HD1", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 45, "HD2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 45, "HE1", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 45, "HE2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 45, "H", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 45, "HA", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 45, "HB2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 45, "HB3", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 68, "HD2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 68, "HE1", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 68, "H", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 68, "HA", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 68, "HB2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 68, "HB3", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 59, "HD1", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 59, "HD2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 59, "HE1", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 59, "HE2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 59, "H", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 59, "HA", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 59, "HB2", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        scNoe = this.scNoeGenerate(h1CSVec, 59, "HB3", csH1Err, pdbVecXray);
        ubqNoe.addAll(scNoe);
        return ubqNoe;
    }

    public Vector<Peak> rangeSearch(Vector sortedH1Vec, double csValue, double h1Err) {
        Vector<Peak> pkVec = new Vector<Peak>();
        Peak pk = new Peak();
        double cs = 0.0;
        double a = csValue - h1Err;
        double b = csValue + h1Err;
        int index = Collections.binarySearch(sortedH1Vec, new Peak(a), new csComparator());
        int i = 0;
        if (index < 0) {
            i = -(index + 1);
            while (i < sortedH1Vec.size()) {
                pk = (Peak)sortedH1Vec.elementAt(i);
                cs = pk.getCS();
                if (cs <= b) {
                    pkVec.add(pk);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            cs = -999.99;
            i = index;
            while (i < sortedH1Vec.size()) {
                pk = (Peak)sortedH1Vec.elementAt(i);
                cs = pk.getCS();
                if (!(cs <= b)) break;
                pkVec.add(pk);
                ++i;
            }
            cs = -999.99;
            i = index;
            while (i > 0) {
                pk = (Peak)sortedH1Vec.elementAt(i);
                cs = pk.getCS();
                if (cs == a) {
                    pkVec.add(pk);
                    --i;
                    continue;
                }
                break;
            }
        }
        return pkVec;
    }

    public Vector rangeSearchScNoeCS1(Vector sortedH1Vec, double csValue, double h1Err) {
        Vector<ScNoe> pkVec = new Vector<ScNoe>();
        ScNoe scNoe = new ScNoe();
        Collections.sort(sortedH1Vec, new ScNoe.cs1Comparator());
        double cs = 0.0;
        double a = csValue - h1Err;
        double b = csValue + h1Err;
        int index = Collections.binarySearch(sortedH1Vec, new ScNoe(a), new ScNoe.cs1Comparator());
        int i = 0;
        if (index < 0) {
            i = -(index + 1);
            while (i < sortedH1Vec.size()) {
                scNoe = (ScNoe)sortedH1Vec.elementAt(i);
                cs = scNoe.getHCS1();
                if (cs <= b) {
                    pkVec.add(scNoe);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            cs = -999.99;
            i = index;
            while (i < sortedH1Vec.size()) {
                scNoe = (ScNoe)sortedH1Vec.elementAt(i);
                cs = scNoe.getHCS1();
                if (!(cs <= b)) break;
                pkVec.add(scNoe);
                ++i;
            }
            cs = -999.99;
            i = index;
            while (i > 0) {
                scNoe = (ScNoe)sortedH1Vec.elementAt(i);
                cs = scNoe.getHCS1();
                if (cs == a) {
                    pkVec.add(scNoe);
                    --i;
                    continue;
                }
                break;
            }
        }
        return pkVec;
    }

    public Vector rangeSearchScNoeCS2(Vector sortedH1Vec, double csValue, double h1Err) {
        Vector<ScNoe> pkVec = new Vector<ScNoe>();
        ScNoe scNoe = new ScNoe();
        Collections.sort(sortedH1Vec, new ScNoe.cs2Comparator());
        double cs = 0.0;
        double a = csValue - h1Err;
        double b = csValue + h1Err;
        int index = Collections.binarySearch(sortedH1Vec, new ScNoe(0.0, a), new ScNoe.cs2Comparator());
        int i = 0;
        if (index < 0) {
            i = -(index + 1);
            while (i < sortedH1Vec.size()) {
                scNoe = (ScNoe)sortedH1Vec.elementAt(i);
                cs = scNoe.getHCS2();
                if (cs <= b) {
                    pkVec.add(scNoe);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            cs = -999.99;
            i = index;
            while (i < sortedH1Vec.size()) {
                scNoe = (ScNoe)sortedH1Vec.elementAt(i);
                cs = scNoe.getHCS2();
                if (!(cs <= b)) break;
                pkVec.add(scNoe);
                ++i;
            }
            cs = -999.99;
            i = index;
            while (i > 0) {
                scNoe = (ScNoe)sortedH1Vec.elementAt(i);
                cs = scNoe.getHCS2();
                if (cs == a) {
                    pkVec.add(scNoe);
                    --i;
                    continue;
                }
                break;
            }
        }
        return pkVec;
    }

    public void noeAssign1st(Vector h1Vec, Vector asgVec) {
        int i = 0;
        int j = 0;
        int k = 0;
        Vector oneHnVec = new Vector();
        Vector oneHaVec = new Vector();
        Vector oneH1Vec = new Vector();
        Assign asg = new Assign();
        Peak pk = new Peak();
        double h1Err = 0.04;
        double csOfB = 0.0;
        HnNoe hnNoe = new HnNoe();
        int resNo1 = 0;
        int resNo2 = 0;
        int resNo3 = 0;
        Vector<Object> bVec = new Vector();
        Vector<Object> cVec = new Vector();
        String resId = "";
        String aaType = "";
        int index = 0;
        HcchTocsy hcch = new HcchTocsy();
        i = 0;
        while (i < asgVec.size()) {
            asg = (Assign)asgVec.elementAt(i);
            oneHnVec = asg.getHnNoeVec();
            oneHaVec = asg.getHaNoeVec();
            resNo1 = asg.getResidueNo();
            aaType = asg.getResidueType();
            System.out.println(String.valueOf(resNo1) + "  " + aaType);
            bVec = new Vector();
            j = 0;
            while (j < oneHnVec.size()) {
                hnNoe = (HnNoe)oneHnVec.elementAt(j);
                csOfB = hnNoe.getH1();
                bVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                if (bVec.isEmpty()) {
                    System.out.println("NO Assign:  " + hnNoe);
                }
                if (bVec.size() < 3) {
                    System.out.println(hnNoe);
                    k = 0;
                    while (k < bVec.size()) {
                        pk = (Peak)bVec.elementAt(k);
                        resId = pk.getNucleus();
                        resNo2 = Integer.parseInt(resId.substring(3, index = resId.indexOf("-")));
                        if (resNo2 == resNo1) {
                            System.out.println("Intra NOEs:");
                            System.out.println(pk);
                        } else if (Math.abs(resNo2 - resNo1) == 1) {
                            System.out.print("Seq NOEs:  ");
                            System.out.println(pk);
                        } else if (Math.abs(resNo2 - resNo1) > 1 && Math.abs(resNo2 - resNo1) <= 3) {
                            System.out.print("Med NOEs:  ");
                            System.out.println(pk);
                        } else {
                            System.out.print("Long NOEs:  ");
                            System.out.println(pk);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            cVec = new Vector();
            j = 0;
            while (j < oneHaVec.size()) {
                hcch = (HcchTocsy)oneHaVec.elementAt(j);
                csOfB = hcch.getH1();
                cVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                if (cVec.isEmpty()) {
                    System.out.println("NO Assign2:  " + hcch);
                }
                if (cVec.size() < 3) {
                    System.out.println(hcch);
                    k = 0;
                    while (k < cVec.size()) {
                        pk = (Peak)cVec.elementAt(k);
                        resId = pk.getNucleus();
                        resNo3 = Integer.parseInt(resId.substring(3, index = resId.indexOf("-")));
                        if (resNo3 == resNo1) {
                            System.out.println("Intra NOEs");
                        } else if (Math.abs(resNo3 - resNo1) == 1) {
                            System.out.print("Seq NOEs:  ");
                            System.out.println(pk);
                        } else if (Math.abs(resNo3 - resNo1) > 1 && Math.abs(resNo3 - resNo1) <= 3) {
                            System.out.print("Med NOEs:  ");
                            System.out.println(pk);
                        } else {
                            System.out.print("Long NOEs:  ");
                            System.out.println(pk);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public Vector SimulatedCaNoe(Vector pdbVecXray, Vector asgVec, double distBound) {
        Vector<HcchTocsy> vecCaNoe = new Vector<HcchTocsy>();
        String atomNameA = "";
        String atomNameB = "";
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        int firstResNo = 0;
        int secondResNo = 0;
        String firstResName = "";
        String secondResName = "";
        RotaPattern rp = new RotaPattern();
        boolean found = false;
        double[] noeXray = new double[1];
        int i = 0;
        while (i < pdbVecXray.size()) {
            Pdb pdbA = (Pdb)pdbVecXray.elementAt(i);
            Vector<Cartesian> atomVecA = pdbA.getAtomVec();
            firstResNo = pdbA.getResidueNo();
            firstResName = pdbA.getResidue();
            int j = 0;
            while (j < atomVecA.size()) {
                ccA = atomVecA.elementAt(j);
                atomNameA = ccA.getAtom();
                coordA = ccA.getXYZ();
                if (atomNameA.equalsIgnoreCase("HA")) {
                    int k = 0;
                    while (k < pdbVecXray.size()) {
                        Pdb pdbB = (Pdb)pdbVecXray.elementAt(k);
                        Vector<Cartesian> atomVecB = pdbB.getAtomVec();
                        int m = 0;
                        while (m < atomVecB.size()) {
                            ccB = atomVecB.elementAt(m);
                            atomNameB = ccB.getAtom();
                            coordB = ccB.getXYZ();
                            double dist = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                            secondResNo = pdbB.getResidueNo();
                            secondResName = pdbB.getResidue();
                            found = false;
                            double noeLimits = 4.5;
                            found = this.checkNoe_old(pdbVecXray, asgVec, firstResNo, "HA", secondResNo, atomNameB, noeLimits, 2.5, noeXray);
                            if (atomNameB.substring(0, 1).equalsIgnoreCase("H") && found) {
                                Hdist hdist = new Hdist(ccB, secondResNo, secondResName, atomNameB, ccA, firstResNo, firstResName, atomNameA, dist);
                                BackNoe backNoe = rp.SimulateBackCompNOEPeak(asgVec, hdist);
                                double csH1 = backNoe.getCSH1();
                                double csHeavy = backNoe.getCSHeavy();
                                double csH2 = backNoe.getCSH2();
                                HcchTocsy hcchTocsy = new HcchTocsy(firstResNo, firstResName, csH1, csHeavy, csH2, 0.0);
                                if (csH1 != -999.9 && csHeavy != -999.9 && csH2 != -999.9) {
                                    vecCaNoe.add(hcchTocsy);
                                }
                            }
                            ++m;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return vecCaNoe;
    }

    public void BackNOEGenerate(Vector h1Vec, Vector asgVec, Vector pdbVecXray, Vector allCSVec, Vector allHnVec, Vector allHaVec) {
        int i = 0;
        int j = 0;
        int k = 0;
        Vector HnVec = new Vector();
        Vector HaVec = new Vector();
        Vector oneHnVec = new Vector();
        Vector oneHaVec = new Vector();
        Vector oneH1Vec = new Vector();
        Assign asg = new Assign();
        Peak pk = new Peak();
        Pdb pp = new Pdb();
        double h1Err = 0.04;
        double csOfB = 0.0;
        double haErr = 0.02;
        HnNoe hnNoe = new HnNoe();
        HcchTocsy haNoe = new HcchTocsy();
        int resNo1 = 0;
        int resNo2 = 0;
        boolean resNo3 = false;
        Vector<Peak> bVec = new Vector<Peak>();
        Vector<Object> bVecTemp = new Vector();
        Vector bVecTemp2 = new Vector();
        Vector<Peak> cVec = new Vector<Peak>();
        String resId = "";
        String aaType = "";
        String res = "";
        int index = 0;
        HcchTocsy hcch = new HcchTocsy();
        double[] dis1 = new double[]{0.0};
        boolean hasNOE = false;
        boolean assigned = false;
        boolean found = false;
        boolean minIndex = false;
        double minDis = 0.0;
        Vector pkVec = new Vector();
        System.out.println(" ! The NOEs Assignment from N15 NOESY");
        double noeLimits = 5.5;
        double[] noeXray = new double[1];
        double[] noeXray2 = new double[1];
        String xplorNoeStr = "";
        String strOutput = "";
        double[] disUpper = new double[1];
        Map aMap = new TreeMap();
        double csRes1 = 0.0;
        double csRes2 = 0.0;
        boolean isSymm = false;
        double simCSH = 0.0;
        boolean isAssg = true;
        String heavyName2 = "";
        double csSigma = 0.0;
        i = 0;
        while (i < asgVec.size()) {
            double[] allDis;
            String nucleus;
            asg = (Assign)asgVec.elementAt(i);
            aMap = asg.getMap();
            csRes1 = (Double)aMap.get("HN");
            oneHnVec = asg.getHnNoeVec();
            oneHaVec = asg.getHaNoeVec();
            oneH1Vec = asg.getH1NoeVec();
            allHnVec.addAll(oneHnVec);
            allHaVec.addAll(oneHaVec);
            if (!oneH1Vec.isEmpty()) {
                allHnVec.addAll(oneH1Vec);
            }
            resNo1 = asg.getResidueNo();
            aaType = asg.getResidueType();
            bVec = new Vector();
            bVecTemp = new Vector();
            j = 0;
            while (j < oneHnVec.size()) {
                bVec = new Vector();
                hnNoe = (HnNoe)oneHnVec.elementAt(j);
                csOfB = hnNoe.getH1();
                bVecTemp = this.rangeSearch(h1Vec, csOfB, h1Err);
                if (bVecTemp.isEmpty()) break;
                k = 0;
                while (k < bVecTemp.size()) {
                    pk = (Peak)bVecTemp.elementAt(k);
                    resId = pk.getNucleus();
                    index = resId.indexOf("-");
                    resNo2 = Integer.parseInt(resId.substring(3, index));
                    res = resId.substring(0, 3);
                    nucleus = resId.substring(index + 1);
                    csOfB = pk.getCS();
                    if (!res.equalsIgnoreCase("DMP")) {
                        bVec.add(pk);
                        bVecTemp2 = new Vector();
                    }
                    ++k;
                }
                allDis = new double[bVec.size()];
                assigned = false;
                k = 0;
                while (k < bVec.size()) {
                    isSymm = false;
                    pk = (Peak)bVec.elementAt(k);
                    resId = pk.getNucleus();
                    index = resId.indexOf("-");
                    resNo2 = Integer.parseInt(resId.substring(3, index));
                    res = resId.substring(0, 3);
                    nucleus = resId.substring(index + 1);
                    if (nucleus.equalsIgnoreCase("HN")) {
                        nucleus = "H";
                    }
                    csRes2 = pk.getCS();
                    isAssg = pk.getIsAssg();
                    found = this.checkNoe_old(pdbVecXray, asgVec, resNo1, "H", resNo2, nucleus, noeLimits, 2.5, noeXray);
                    if (found) {
                        heavyName2 = this.GetHeavyAtomFromProton(res, nucleus);
                        if (heavyName2.substring(0, 1).equalsIgnoreCase("N")) {
                            HnVec = this.BackCSGenerate(allCSVec, resNo1, aaType, "H", resNo2, res, nucleus, heavyName2, csSigma);
                            allHnVec.addAll(HnVec);
                        }
                        if (heavyName2.substring(0, 1).equalsIgnoreCase("C")) {
                            HaVec = this.BackCSGenerate(allCSVec, resNo1, aaType, "H", resNo2, res, nucleus, heavyName2, csSigma);
                            allHaVec.addAll(HaVec);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < oneHaVec.size()) {
                cVec = new Vector();
                haNoe = (HcchTocsy)oneHaVec.elementAt(j);
                csOfB = haNoe.getH1();
                bVecTemp = this.rangeSearch(h1Vec, csOfB, h1Err);
                if (bVecTemp.isEmpty()) break;
                k = 0;
                while (k < bVecTemp.size()) {
                    pk = (Peak)bVecTemp.elementAt(k);
                    resId = pk.getNucleus();
                    index = resId.indexOf("-");
                    resNo2 = Integer.parseInt(resId.substring(3, index));
                    res = resId.substring(0, 3);
                    nucleus = resId.substring(index + 1);
                    csOfB = pk.getCS();
                    if (!res.equalsIgnoreCase("DMP")) {
                        cVec.add(pk);
                        bVecTemp2 = new Vector();
                    }
                    ++k;
                }
                allDis = new double[cVec.size()];
                assigned = false;
                k = 0;
                while (k < cVec.size()) {
                    isSymm = false;
                    pk = (Peak)cVec.elementAt(k);
                    resId = pk.getNucleus();
                    index = resId.indexOf("-");
                    resNo2 = Integer.parseInt(resId.substring(3, index));
                    res = resId.substring(0, 3);
                    nucleus = resId.substring(index + 1);
                    if (nucleus.equalsIgnoreCase("HN")) {
                        nucleus = "H";
                    }
                    csRes2 = pk.getCS();
                    isAssg = pk.getIsAssg();
                    found = this.checkNoe_old(pdbVecXray, asgVec, resNo1, "HA", resNo2, nucleus, noeLimits, 2.5, noeXray);
                    if (found) {
                        heavyName2 = this.GetHeavyAtomFromProton(res, nucleus);
                        if (heavyName2.substring(0, 1).equalsIgnoreCase("N")) {
                            HnVec = this.BackCSGenerate(allCSVec, resNo1, aaType, "HA", resNo2, res, nucleus, heavyName2, csSigma);
                            allHnVec.addAll(HnVec);
                        } else {
                            HaVec = this.BackCSGenerate(allCSVec, resNo1, aaType, "HA", resNo2, res, nucleus, heavyName2, csSigma);
                            allHaVec.addAll(HaVec);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void noeAssign2ndLW(Vector h1Vec, Vector asgVec, Vector pdbVec, Vector pdbVecXray) {
        int crNOEAsg = 0;
        int wrNOEAsg = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        Vector oneHnVec = new Vector();
        Vector oneHaVec = new Vector();
        Vector oneH1Vec = new Vector();
        Assign asg = new Assign();
        Peak pk = new Peak();
        Pdb pp = new Pdb();
        double h1Err = 0.04;
        double csOfB = 0.0;
        double haErr = 0.02;
        double chkErr = 0.04;
        HnNoe hnNoe = new HnNoe();
        int resNo1 = 0;
        int resNo2 = 0;
        boolean resNo3 = false;
        Vector<Object> bVec = new Vector();
        Vector bVecTemp = new Vector();
        Vector bVecTemp2 = new Vector();
        Vector cVec = new Vector();
        String resId = "";
        String aaType = "";
        String res = "";
        int index = 0;
        HcchTocsy hcch = new HcchTocsy();
        double[] dis1 = new double[]{0.0};
        boolean hasNOE = false;
        boolean assigned = false;
        boolean assignedFromAsgCS = false;
        boolean found = false;
        boolean minIndex = false;
        double minDis = 0.0;
        Vector pkVec = new Vector();
        System.out.println(" ! The NOEs Assignment from N15 NOESY");
        double noeLimits = 5.5;
        double[] noeXray = new double[1];
        double[] noeXray2 = new double[1];
        String xplorNoeStr = "";
        String strOutput = "";
        double[] disUpper = new double[1];
        Map aMap = new TreeMap();
        double csRes1 = 0.0;
        double csRes2 = 0.0;
        boolean isSymm = false;
        double simCSH = 0.0;
        boolean isAssg = true;
        double noeCSHN = 0.0;
        double noeCSH1 = 0.0;
        String src = "./inputFiles/rotasamp-small/";
        Vector<Object> pdbRotamA = new Vector();
        Vector<Object> pdbRotamB = new Vector();
        Vector pdbRotamNewA = new Vector();
        Vector pdbRotamNewB = new Vector();
        int ind1 = 0;
        i = 0;
        while (i < asgVec.size()) {
            asg = (Assign)asgVec.elementAt(i);
            aMap = asg.getMap();
            csRes1 = (Double)aMap.get("HN");
            oneHnVec = asg.getHnNoeVec();
            oneHaVec = asg.getHaNoeVec();
            resNo1 = asg.getResidueNo();
            aaType = asg.getResidueType();
            System.out.println("!  " + aaType + "  " + resNo1);
            bVec = new Vector();
            bVecTemp = new Vector();
            j = 0;
            while (j < oneHnVec.size()) {
                bVec = new Vector();
                hnNoe = (HnNoe)oneHnVec.elementAt(j);
                csOfB = hnNoe.getH1();
                noeCSHN = hnNoe.getHN();
                noeCSH1 = hnNoe.getH1();
                bVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                if (bVec.isEmpty()) {
                    System.out.println("NO Assign by CS  " + hnNoe);
                    break;
                }
                double[] allDis = new double[bVec.size()];
                assigned = false;
                assignedFromAsgCS = false;
                k = 0;
                while (k < bVec.size()) {
                    String rotamFile;
                    Pdb pdbA;
                    isSymm = false;
                    pk = (Peak)bVec.elementAt(k);
                    resId = pk.getNucleus();
                    index = resId.indexOf("-");
                    resNo2 = Integer.parseInt(resId.substring(3, index));
                    res = resId.substring(0, 3);
                    String nucleus = resId.substring(index + 1);
                    if (nucleus.equalsIgnoreCase("HN")) {
                        nucleus = "H";
                    }
                    csRes2 = pk.getCS();
                    isAssg = pk.getIsAssg();
                    if (aaType.equalsIgnoreCase("ALA") || aaType.equalsIgnoreCase("GLY")) {
                        pdbRotamNewA = new Vector();
                        ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
                        pdbA = (Pdb)pdbVec.elementAt(ind1);
                        pdbRotamNewA.add(pdbA);
                    } else {
                        rotamFile = String.valueOf(src) + aaType.toLowerCase() + ".pdb";
                        pdbRotamA = pp.readPdb(rotamFile);
                        pdbRotamNewA = pp.nameConvert(pdbRotamA);
                    }
                    if (res.equalsIgnoreCase("ALA") || res.equalsIgnoreCase("GLY")) {
                        pdbRotamNewB = new Vector();
                        ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
                        pdbA = (Pdb)pdbVec.elementAt(ind1);
                        pdbRotamNewB.add(pdbA);
                    } else {
                        rotamFile = String.valueOf(src) + res.toLowerCase() + ".pdb";
                        pdbRotamB = pp.readPdb(rotamFile);
                        pdbRotamNewB = pp.nameConvert(pdbRotamB);
                    }
                    hasNOE = pp.measureDisFromRotam(pdbVec, pdbRotamNewA, pdbRotamNewB, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
                    allDis[k] = dis1[0];
                    if (hasNOE) {
                        found = this.checkNoe_old(pdbVecXray, asgVec, resNo1, "H", resNo2, nucleus, noeLimits, 2.5, noeXray);
                        if (dis1[0] <= 6.0) {
                            xplorNoeStr = this.xplorNoeStatement_old(resNo1, "HN", resNo2, res, nucleus, dis1[0], disUpper);
                            strOutput = String.valueOf(String.valueOf(noeCSHN)) + "  " + String.valueOf(noeCSH1) + "  " + aaType + "-HN" + " " + String.valueOf(resNo1) + "  " + res + "-" + nucleus + "  " + String.valueOf(resNo2) + "  " + disUpper[0] + "  " + String.valueOf(isAssg) + "  " + String.valueOf(isSymm) + " " + String.valueOf(found);
                            System.out.println(strOutput);
                            assigned = true;
                            if (found) {
                                ++crNOEAsg;
                            } else {
                                ++wrNOEAsg;
                            }
                        }
                    }
                    ++k;
                }
                if (!assigned) {
                    System.out.println("NO Assign by CS  " + hnNoe);
                }
                ++j;
            }
            ++i;
        }
        System.out.println("/////////////////////////////////////////////// ");
        System.out.println("The number of correct HN-NOE assignment is:  " + crNOEAsg);
        System.out.println("The number of wrong HN NOE assignment is:  " + wrNOEAsg);
        System.out.println(" ///////////////////////////////////////////////");
    }

    public void noeAssign2nd(Vector h1Vec, Vector asgVec, Vector pdbVec, Vector pdbVecXray, Vector hnNoeVec, Vector cNoeVec) {
        int crNOEAsg = 0;
        int wrNOEAsg = 0;
        int nonNOEAsg = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        Vector oneHnVec = new Vector();
        Vector oneHaVec = new Vector();
        Vector oneH1Vec = new Vector();
        Assign asg = new Assign();
        Peak pk = new Peak();
        Pdb pp = new Pdb();
        double h1Err = 0.04;
        double csOfB = 0.0;
        double haErr = 0.02;
        double chkErr = 0.04;
        HnNoe hnNoe = new HnNoe();
        int resNo1 = 0;
        int resNo2 = 0;
        boolean resNo3 = false;
        Vector<Object> bVec = new Vector();
        Vector bVecTemp = new Vector();
        Vector bVecTemp2 = new Vector();
        Vector cVec = new Vector();
        String resId = "";
        String aaType = "";
        String res = "";
        int index = 0;
        HcchTocsy hcch = new HcchTocsy();
        double[] dis1 = new double[]{0.0};
        boolean hasNOE = false;
        boolean assigned = false;
        boolean assignedFromAsgCS = false;
        boolean found = false;
        boolean minIndex = false;
        double minDis = 0.0;
        Vector pkVec = new Vector();
        System.out.println(" ! The NOEs Assignment from N15 NOESY");
        double noeLimits = 5.5;
        double[] noeXray = new double[1];
        double[] noeXray2 = new double[1];
        String xplorNoeStr = "";
        String strOutput = "";
        double[] disUpper = new double[1];
        Map aMap = new TreeMap();
        double csRes1 = 0.0;
        double csRes2 = 0.0;
        boolean isSymm = false;
        double simCSH = 0.0;
        boolean isAssg = true;
        double noeCSHN = 0.0;
        double noeCSH1 = 0.0;
        String src = "../inputFiles/rotasamp-small/";
        Vector<Object> pdbRotamA = new Vector();
        Vector<Object> pdbRotamB = new Vector();
        Vector pdbRotamNewA = new Vector();
        Vector pdbRotamNewB = new Vector();
        Vector pdbRotamNewA2 = new Vector();
        Vector<Pdb> pdbRotamNewB2 = new Vector<Pdb>();
        Vector pdbRotamNewARef = new Vector();
        Vector pdbRotamNewBRef = new Vector();
        int ind1 = 0;
        RotaPattern rp = new RotaPattern();
        i = 0;
        while (i < asgVec.size()) {
            asg = (Assign)asgVec.elementAt(i);
            aMap = asg.getMap();
            csRes1 = (Double)aMap.get("HN");
            oneHnVec = asg.getHnNoeVec();
            oneHaVec = asg.getHaNoeVec();
            resNo1 = asg.getResidueNo();
            aaType = asg.getResidueType();
            bVec = new Vector();
            bVecTemp = new Vector();
            j = 0;
            while (j < oneHnVec.size()) {
                bVec = new Vector();
                hnNoe = (HnNoe)oneHnVec.elementAt(j);
                csOfB = hnNoe.getH1();
                noeCSHN = hnNoe.getHN();
                noeCSH1 = hnNoe.getH1();
                bVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                if (!bVec.isEmpty()) {
                    double[] allDis = new double[bVec.size()];
                    assigned = false;
                    assignedFromAsgCS = false;
                    k = 0;
                    while (k < bVec.size()) {
                        String rotamFile;
                        Pdb pdbA;
                        isSymm = false;
                        pk = (Peak)bVec.elementAt(k);
                        resId = pk.getNucleus();
                        index = resId.indexOf("-");
                        resNo2 = Integer.parseInt(resId.substring(3, index));
                        res = resId.substring(0, 3);
                        String nucleus = resId.substring(index + 1);
                        if (nucleus.equalsIgnoreCase("HN")) {
                            nucleus = "H";
                        }
                        csRes2 = pk.getCS();
                        isAssg = pk.getIsAssg();
                        pdbRotamNewA = new Vector();
                        pdbRotamNewA2 = new Vector();
                        if (aaType.equalsIgnoreCase("GLY")) {
                            ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
                            pdbA = (Pdb)pdbVec.elementAt(ind1);
                            pdbRotamNewA.add(pdbA);
                        } else {
                            rotamFile = String.valueOf(src) + aaType.toLowerCase() + ".pdb";
                            pdbRotamA = pp.readPdb(rotamFile);
                            pdbRotamNewA = pp.nameConvert4SmallRotLibCS(pdbRotamA);
                        }
                        pdbRotamNewB = new Vector();
                        pdbRotamNewB2 = new Vector();
                        if (res.equalsIgnoreCase("GLY")) {
                            ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
                            pdbA = (Pdb)pdbVec.elementAt(ind1);
                            Pdb pdbARef = (Pdb)pdbVec.elementAt(ind1);
                            pdbRotamNewB.add(pdbA);
                            pdbRotamNewB2.add(pdbARef);
                        } else {
                            rotamFile = String.valueOf(src) + res.toLowerCase() + ".pdb";
                            pdbRotamB = pp.readPdb(rotamFile);
                            pdbRotamNewB = pp.nameConvert4SmallRotLibCS(pdbRotamB);
                        }
                        int indRef1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
                        int indRef2 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
                        int[] index_temp = new int[2];
                        if (indRef1 >= 0) {
                            pdbRotamNewARef = rp.RefineRotLib(pdbRotamNewA, pdbVec, asgVec, hnNoeVec, cNoeVec, resNo1, 6.0, 1, index_temp, pdbVecXray);
                        }
                        if (indRef2 >= 0) {
                            pdbRotamNewBRef = rp.RefineRotLib(pdbRotamNewB, pdbVec, asgVec, hnNoeVec, cNoeVec, resNo2, 6.0, 1, index_temp, pdbVecXray);
                        }
                        hasNOE = pp.measureDisFromRotam(pdbVecXray, pdbRotamNewARef, pdbRotamNewBRef, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
                        allDis[k] = dis1[0];
                        if (hasNOE) {
                            found = this.checkNoe_old(pdbVecXray, asgVec, resNo1, "H", resNo2, nucleus, noeLimits, 2.5, noeXray);
                            if (dis1[0] <= 6.0) {
                                xplorNoeStr = this.xplorNoeStatement_old(resNo1, "HN", resNo2, res, nucleus, dis1[0], disUpper);
                                strOutput = String.valueOf(String.valueOf(noeCSHN)) + "  " + String.valueOf(noeCSH1) + "  " + aaType + "-HN" + " " + String.valueOf(resNo1) + "  " + res + "-" + nucleus + "  " + String.valueOf(resNo2) + "  " + disUpper[0] + "  " + String.valueOf(isAssg) + "  " + String.valueOf(isSymm) + " " + String.valueOf(found);
                                System.out.println(xplorNoeStr);
                                assigned = true;
                                if (found) {
                                    ++crNOEAsg;
                                } else {
                                    ++wrNOEAsg;
                                }
                            }
                        }
                        ++k;
                    }
                    if (!assigned) {
                        ++nonNOEAsg;
                    }
                }
                ++j;
            }
            ++i;
        }
        System.out.println("/////////////////////////////////////////////// ");
        System.out.println("The number of correct HN-NOE assignment is:  " + crNOEAsg);
        System.out.println("The number of wrong HN NOE assignment is:  " + wrNOEAsg);
        System.out.println("The number of not assigned peaks is:  " + nonNOEAsg);
        System.out.println(" ///////////////////////////////////////////////");
    }

    public void noeAssign3rdLW(Vector h1Vec, Vector asgVec, Vector pdbVec, Vector pdbVecXray, Vector hnNoeVec, Vector cNoeVec) {
        int crNOEAsg = 0;
        int wrNOEAsg = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        Vector oneHnVec = new Vector();
        Vector oneHaVec = new Vector();
        Vector oneH1Vec = new Vector();
        Assign asg = new Assign();
        Peak pk = new Peak();
        Pdb pp = new Pdb();
        double h1Err = 0.04;
        double csOfB = 0.0;
        HnNoe hnNoe = new HnNoe();
        int resNo1 = 0;
        int resNo2 = 0;
        int resNo3 = 0;
        Vector bVec = new Vector();
        Vector<Object> cVec = new Vector();
        double haErr = 0.02;
        double chkErr = 0.04;
        Vector cVecTemp = new Vector();
        Vector cVecTemp2 = new Vector();
        double[] disUpper = new double[1];
        String resId = "";
        String aaType = "";
        String res = "";
        int index = 0;
        HcchTocsy hcch = new HcchTocsy();
        double[] dis1 = new double[]{0.0};
        boolean hasNOE = false;
        boolean assigned = false;
        boolean assignedFromAsgCS = false;
        boolean found = false;
        boolean minIndex = false;
        double minDis = 0.0;
        Vector pkVec = new Vector();
        System.out.println(" ! Ha The NOEs Assignment from C13 NOESY");
        double noeLimits = 5.0;
        double[] noeXray = new double[1];
        String xplorNoeStr = "";
        String strOutput = "";
        Map aMap = new TreeMap();
        double csRes1 = 0.0;
        double csRes2 = 0.0;
        boolean isSymm = false;
        boolean isAssg = true;
        double noeCSHA = 0.0;
        double noeCSH1 = 0.0;
        String src = "./inputFiles/rotasamp-small/";
        Vector<Object> pdbRotamA = new Vector();
        Vector<Object> pdbRotamB = new Vector();
        Vector pdbRotamNewA = new Vector();
        Vector pdbRotamNewB = new Vector();
        int ind1 = 0;
        i = 0;
        while (i < asgVec.size()) {
            asg = (Assign)asgVec.elementAt(i);
            oneHnVec = asg.getHnNoeVec();
            oneHaVec = asg.getHaNoeVec();
            aMap = asg.getMap();
            csRes1 = (Double)aMap.get("HN");
            resNo1 = asg.getResidueNo();
            aaType = asg.getResidueType();
            System.out.println("!  " + aaType + "  " + resNo1);
            cVec = new Vector();
            cVecTemp = new Vector();
            j = 0;
            while (j < oneHaVec.size()) {
                cVec = new Vector();
                hcch = (HcchTocsy)oneHaVec.elementAt(j);
                csOfB = hcch.getH1();
                noeCSHA = hcch.getHA();
                noeCSH1 = hcch.getH1();
                cVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                if (cVec.isEmpty()) {
                    System.out.println("NO Assign2:  " + hcch);
                }
                assigned = false;
                assignedFromAsgCS = false;
                k = 0;
                while (k < cVec.size()) {
                    String rotamFile;
                    Pdb pdbA;
                    isSymm = false;
                    pk = (Peak)cVec.elementAt(k);
                    resId = pk.getNucleus();
                    index = resId.indexOf("-");
                    resNo3 = Integer.parseInt(resId.substring(3, index));
                    index = resId.indexOf("-");
                    resNo2 = Integer.parseInt(resId.substring(3, index));
                    res = resId.substring(0, 3);
                    String nucleus = resId.substring(index + 1);
                    csRes2 = pk.getCS();
                    isAssg = pk.getIsAssg();
                    if (aaType.equalsIgnoreCase("ALA") || aaType.equalsIgnoreCase("GLY")) {
                        pdbRotamNewA = new Vector();
                        ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
                        pdbA = (Pdb)pdbVec.elementAt(ind1);
                        pdbRotamNewA.add(pdbA);
                    } else {
                        rotamFile = String.valueOf(src) + aaType.toLowerCase() + ".pdb";
                        pdbRotamA = pp.readPdb(rotamFile);
                        pdbRotamNewA = pp.nameConvert(pdbRotamA);
                    }
                    if (res.equalsIgnoreCase("ALA") || res.equalsIgnoreCase("GLY")) {
                        pdbRotamNewB = new Vector();
                        ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
                        pdbA = (Pdb)pdbVec.elementAt(ind1);
                        pdbRotamNewB.add(pdbA);
                    } else {
                        rotamFile = String.valueOf(src) + res.toLowerCase() + ".pdb";
                        pdbRotamB = pp.readPdb(rotamFile);
                        pdbRotamNewB = pp.nameConvert(pdbRotamB);
                    }
                    hasNOE = pp.measureDisFromRotam(pdbVec, pdbRotamNewA, pdbRotamNewB, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
                    if (hasNOE) {
                        found = this.checkNoe_old(pdbVecXray, asgVec, resNo1, "HA", resNo2, nucleus, noeLimits, 2.5, noeXray);
                        if (dis1[0] <= 6.0) {
                            if (!nucleus.equals("HN")) {
                                xplorNoeStr = this.xplorNoeStatement_old(resNo1, "HA", resNo2, res, nucleus, dis1[0] - 0.4, disUpper);
                                strOutput = String.valueOf(String.valueOf(noeCSHA)) + "  " + String.valueOf(noeCSH1) + "  " + aaType + "-HA" + " " + String.valueOf(resNo1) + "  " + res + "-" + nucleus + "  " + String.valueOf(resNo2) + "  " + disUpper[0] + "  " + String.valueOf(isAssg) + "  " + String.valueOf(isSymm) + " " + String.valueOf(found);
                            }
                            System.out.println(strOutput);
                            assigned = true;
                            if (found) {
                                ++crNOEAsg;
                            } else {
                                ++wrNOEAsg;
                            }
                        }
                    }
                    ++k;
                }
                if (!assigned) {
                    System.out.println("NO Assign by CS  " + hcch);
                }
                ++j;
            }
            ++i;
        }
        System.out.println("/////////////////////////////////////////////// ");
        System.out.println("The number of correct Ha NOE assignment is:  " + crNOEAsg);
        System.out.println("The number of wrong Ha NOE assignment is:  " + wrNOEAsg);
        System.out.println(" ///////////////////////////////////////////////");
    }

    public void noeAssign3rd(Vector h1Vec, Vector asgVec, Vector pdbVec, Vector pdbVecXray, Vector hnNoeVec, Vector cNoeVec) {
        int crNOEAsg = 0;
        int wrNOEAsg = 0;
        int nonNOEAsg = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        Vector oneHnVec = new Vector();
        Vector oneHaVec = new Vector();
        Vector oneH1Vec = new Vector();
        Assign asg = new Assign();
        Peak pk = new Peak();
        Pdb pp = new Pdb();
        double h1Err = 0.04;
        double csOfB = 0.0;
        HnNoe hnNoe = new HnNoe();
        int resNo1 = 0;
        int resNo2 = 0;
        int resNo3 = 0;
        Vector bVec = new Vector();
        Vector<Object> cVec = new Vector();
        double haErr = 0.02;
        double chkErr = 0.04;
        Vector cVecTemp = new Vector();
        Vector cVecTemp2 = new Vector();
        double[] disUpper = new double[1];
        String resId = "";
        String aaType = "";
        String res = "";
        int index = 0;
        HcchTocsy hcch = new HcchTocsy();
        double[] dis1 = new double[]{0.0};
        boolean hasNOE = false;
        boolean assigned = false;
        boolean assignedFromAsgCS = false;
        boolean found = false;
        boolean minIndex = false;
        double minDis = 0.0;
        Vector pkVec = new Vector();
        System.out.println(" ! Ha The NOEs Assignment from C13 NOESY");
        double noeLimits = 5.0;
        double[] noeXray = new double[1];
        String xplorNoeStr = "";
        String strOutput = "";
        Map aMap = new TreeMap();
        double csRes1 = 0.0;
        double csRes2 = 0.0;
        boolean isSymm = false;
        boolean isAssg = true;
        double noeCSHA = 0.0;
        double noeCSH1 = 0.0;
        String src = "../inputFiles/rotasamp-small/";
        Vector<Object> pdbRotamA = new Vector();
        Vector<Object> pdbRotamB = new Vector();
        Vector pdbRotamNewA = new Vector();
        Vector pdbRotamNewB = new Vector();
        int ind1 = 0;
        RotaPattern rp = new RotaPattern();
        Vector pdbRotamNewARef = new Vector();
        Vector pdbRotamNewBRef = new Vector();
        i = 0;
        while (i < asgVec.size()) {
            asg = (Assign)asgVec.elementAt(i);
            oneHnVec = asg.getHnNoeVec();
            oneHaVec = asg.getHaNoeVec();
            aMap = asg.getMap();
            csRes1 = (Double)aMap.get("HN");
            resNo1 = asg.getResidueNo();
            aaType = asg.getResidueType();
            cVec = new Vector();
            cVecTemp = new Vector();
            j = 0;
            while (j < oneHaVec.size()) {
                cVec = new Vector();
                hcch = (HcchTocsy)oneHaVec.elementAt(j);
                csOfB = hcch.getH1();
                noeCSHA = hcch.getHA();
                noeCSH1 = hcch.getH1();
                cVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                assigned = false;
                assignedFromAsgCS = false;
                k = 0;
                while (k < cVec.size()) {
                    String rotamFile;
                    Pdb pdbA;
                    isSymm = false;
                    pk = (Peak)cVec.elementAt(k);
                    resId = pk.getNucleus();
                    index = resId.indexOf("-");
                    resNo3 = Integer.parseInt(resId.substring(3, index));
                    index = resId.indexOf("-");
                    resNo2 = Integer.parseInt(resId.substring(3, index));
                    res = resId.substring(0, 3);
                    String nucleus = resId.substring(index + 1);
                    csRes2 = pk.getCS();
                    isAssg = pk.getIsAssg();
                    pdbRotamNewA = new Vector();
                    if (aaType.equalsIgnoreCase("GLY")) {
                        pdbRotamNewA = new Vector();
                        ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
                        pdbA = (Pdb)pdbVec.elementAt(ind1);
                        pdbRotamNewA.add(pdbA);
                    } else {
                        rotamFile = String.valueOf(src) + aaType.toLowerCase() + ".pdb";
                        pdbRotamA = pp.readPdb(rotamFile);
                        pdbRotamNewA = pp.nameConvert4SmallRotLibCS(pdbRotamA);
                    }
                    pdbRotamNewB = new Vector();
                    if (res.equalsIgnoreCase("GLY")) {
                        pdbRotamNewB = new Vector();
                        ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
                        pdbA = (Pdb)pdbVec.elementAt(ind1);
                        pdbRotamNewB.add(pdbA);
                    } else {
                        rotamFile = String.valueOf(src) + res.toLowerCase() + ".pdb";
                        pdbRotamB = pp.readPdb(rotamFile);
                        pdbRotamNewB = pp.nameConvert4SmallRotLibCS(pdbRotamB);
                    }
                    int indRef1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
                    int indRef2 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
                    int[] index_temp = new int[2];
                    if (indRef1 >= 0) {
                        pdbRotamNewARef = rp.RefineRotLib(pdbRotamNewA, pdbVec, asgVec, hnNoeVec, cNoeVec, resNo1, 6.0, 1, index_temp, pdbVecXray);
                    }
                    if (indRef2 >= 0) {
                        pdbRotamNewBRef = rp.RefineRotLib(pdbRotamNewB, pdbVec, asgVec, hnNoeVec, cNoeVec, resNo2, 6.0, 1, index_temp, pdbVecXray);
                    }
                    if (hasNOE = pp.measureDisFromRotam(pdbVec, pdbRotamNewARef, pdbRotamNewBRef, resNo1, aaType, "HA", resNo2, res, nucleus, dis1)) {
                        found = this.checkNoe_old(pdbVecXray, asgVec, resNo1, "HA", resNo2, nucleus, noeLimits, 2.5, noeXray);
                        if (dis1[0] <= 6.0) {
                            if (!nucleus.equals("HN")) {
                                xplorNoeStr = this.xplorNoeStatement_old(resNo1, "HA", resNo2, res, nucleus, dis1[0] - 0.4, disUpper);
                                strOutput = String.valueOf(String.valueOf(noeCSHA)) + "  " + String.valueOf(noeCSH1) + "  " + aaType + "-HA" + " " + String.valueOf(resNo1) + "  " + res + "-" + nucleus + "  " + String.valueOf(resNo2) + "  " + disUpper[0] + "  " + String.valueOf(isAssg) + "  " + String.valueOf(isSymm) + " " + String.valueOf(found);
                            }
                            System.out.println(xplorNoeStr);
                            assigned = true;
                            if (found) {
                                ++crNOEAsg;
                            } else {
                                ++wrNOEAsg;
                            }
                        }
                    }
                    ++k;
                }
                if (!assigned) {
                    ++nonNOEAsg;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("/////////////////////////////////////////////// ");
        System.out.println("The number of correct Ha NOE assignment is:  " + crNOEAsg);
        System.out.println("The number of wrong Ha NOE assignment is:  " + wrNOEAsg);
        System.out.println("The number of not assigned peaks is:  " + nonNOEAsg);
        System.out.println(" ///////////////////////////////////////////////");
    }

    public boolean checkSymmetry(Vector scNoe, double csBbH, double csScH, double winErr) {
        ScNoe scNoeTemp = new ScNoe();
        boolean isSymm = false;
        int i = 0;
        while (i < scNoe.size()) {
            scNoeTemp = (ScNoe)scNoe.elementAt(i);
            if (scNoeTemp.getHCS1() >= csScH - winErr && scNoeTemp.getHCS1() <= csScH + winErr && scNoeTemp.getHCS2() >= csBbH - winErr && scNoeTemp.getHCS2() <= csBbH + winErr) {
                isSymm = true;
            }
            ++i;
        }
        return isSymm;
    }

    public boolean CheckBackNOE(Vector hnNoeVec, Vector haNoeVec, Vector csAllAsg, int resNo1, String resName1, String atomName1, int resNo2, String resName2, String atomName2, double chkErr) {
        double dbTempH2;
        double dbTempHeavy1;
        double dbTempH1;
        boolean isBackNoe = false;
        String heavyName2 = "";
        H1CS cs = new H1CS();
        String res_name = "";
        String atom_name = "";
        double db_csH1 = 0.0;
        double db_csH2 = 0.0;
        double db_csHeavy2 = 0.0;
        HnNoe hnNoe = new HnNoe();
        HcchTocsy hcchTocsy = new HcchTocsy();
        heavyName2 = this.GetHeavyAtomFromProton(resName2, atomName2);
        int i = 0;
        while (i < csAllAsg.size()) {
            cs = (H1CS)csAllAsg.elementAt(i);
            int res_no = cs.getResidueNo();
            res_name = cs.getResidueType();
            atom_name = cs.getAtomName();
            double db_cs = cs.getH1CS();
            if (res_no == resNo1 && res_name.equalsIgnoreCase(resName1) && atom_name.equalsIgnoreCase(atomName1)) {
                db_csH1 = db_cs;
            }
            if (res_no == resNo2 && res_name.equalsIgnoreCase(resName2) && atom_name.equalsIgnoreCase(atomName2)) {
                db_csH2 = db_cs;
            }
            if (res_no == resNo2 && res_name.equalsIgnoreCase(resName2) && atom_name.equalsIgnoreCase(heavyName2)) {
                db_csHeavy2 = db_cs;
            }
            ++i;
        }
        if (heavyName2.substring(0, 1).equalsIgnoreCase("N")) {
            i = 0;
            while (i < hnNoeVec.size()) {
                hnNoe = (HnNoe)hnNoeVec.elementAt(i);
                dbTempH1 = hnNoe.getHN();
                dbTempHeavy1 = hnNoe.getN15();
                dbTempH2 = hnNoe.getH1();
                if (Math.abs(dbTempHeavy1 - db_csHeavy2) < chkErr && Math.abs(dbTempH1 - db_csH2) < chkErr && Math.abs(dbTempH2 - db_csH1) < chkErr) {
                    isBackNoe = true;
                }
                ++i;
            }
        }
        if (heavyName2.substring(0, 1).equalsIgnoreCase("C")) {
            i = 0;
            while (i < haNoeVec.size()) {
                hcchTocsy = (HcchTocsy)haNoeVec.elementAt(i);
                dbTempH1 = hcchTocsy.getHA();
                dbTempHeavy1 = hcchTocsy.getC13();
                dbTempH2 = hcchTocsy.getH1();
                if (Math.abs(dbTempHeavy1 - db_csHeavy2) < chkErr && Math.abs(dbTempH1 - db_csH2) < chkErr && Math.abs(dbTempH2 - db_csH1) < chkErr) {
                    isBackNoe = true;
                }
                ++i;
            }
        }
        return isBackNoe;
    }

    public boolean isHydrophobic(String resName) {
        return resName.equalsIgnoreCase("VAL") || resName.equalsIgnoreCase("ILE") || resName.equalsIgnoreCase("LEU") || resName.equalsIgnoreCase("MET") || resName.equalsIgnoreCase("PHE") || resName.equalsIgnoreCase("TRP") || resName.equalsIgnoreCase("CYS") || resName.equalsIgnoreCase("ALA") || resName.equalsIgnoreCase("TYR") || resName.equalsIgnoreCase("HIS");
    }

    public boolean isCharged(String resName) {
        return resName.equalsIgnoreCase("GLU") || resName.equalsIgnoreCase("ASP") || resName.equalsIgnoreCase("ARG") || resName.equalsIgnoreCase("LYS") || resName.equalsIgnoreCase("HIS");
    }

    public boolean checkNoe(Vector pdbVec, int no, String nucleus, int no2, String nucleus2, double noeLimit, double methylCorrection, double[] noe) {
        int index2;
        int j;
        double[] coordA = new double[3];
        double[] coordB = new double[3];
        Cartesian cc = null;
        String atomName = "";
        String aName = "";
        Vector pkVec = new Vector();
        Assign asg = new Assign();
        TreeMap aMap = new TreeMap();
        double distance = 0.0;
        double cs = -999.99;
        int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
        if (index < 0) {
            noe[0] = -999.9;
            return false;
        }
        Pdb pp = (Pdb)pdbVec.elementAt(index);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        String resid = pp.getResidue();
        double distanceUp = 1000.0;
        boolean found = false;
        double min = distanceUp;
        noe[0] = distanceUp;
        boolean isMethel = false;
        Vector<Cartesian> vecCartesianA = new Vector<Cartesian>();
        if (resid.equalsIgnoreCase("ALA") && nucleus.length() > 1) {
            if (nucleus.substring(0, 2).equalsIgnoreCase("HB")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3")) {
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                        isMethel = true;
                    }
                    ++j;
                }
            }
        } else if (resid.equalsIgnoreCase("ILE") && nucleus.length() > 2) {
            if (nucleus.substring(0, 3).equalsIgnoreCase("HG2")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) {
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                        isMethel = true;
                    }
                    ++j;
                }
            }
        } else if (resid.equalsIgnoreCase("ILE") && nucleus.length() > 2) {
            if (nucleus.substring(0, 3).equalsIgnoreCase("HD1")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) {
                        isMethel = true;
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                    }
                    ++j;
                }
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus.length() > 2) {
            if (nucleus.substring(0, 3).equalsIgnoreCase("HD1")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) {
                        isMethel = true;
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                    }
                    ++j;
                }
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus.length() > 2) {
            if (nucleus.substring(0, 3).equalsIgnoreCase("HD1")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) {
                        isMethel = true;
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                    }
                    ++j;
                }
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus.length() > 2) {
            if (nucleus.substring(0, 3).equalsIgnoreCase("HD2")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23")) {
                        isMethel = true;
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                    }
                    ++j;
                }
            }
        } else if (resid.equalsIgnoreCase("VAL") && nucleus.length() > 2) {
            if (nucleus.substring(0, 3).equalsIgnoreCase("HG1")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13")) {
                        isMethel = true;
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                    }
                    ++j;
                }
            }
        } else if (resid.equalsIgnoreCase("VAL") && nucleus.length() > 2) {
            if (nucleus.substring(0, 3).equalsIgnoreCase("HG2")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) {
                        isMethel = true;
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                    }
                    ++j;
                }
            }
        } else if (resid.equalsIgnoreCase("THR") && nucleus.length() > 2) {
            if (nucleus.substring(0, 3).equalsIgnoreCase("HG2")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) {
                        isMethel = true;
                        coordA = cc.getXYZ();
                        vecCartesianA.add(new Cartesian(atomName, coordA));
                    }
                    ++j;
                }
            }
        } else {
            if (nucleus.equalsIgnoreCase("HN")) {
                nucleus = "H";
            }
            j = 0;
            while (j < atomVec.size()) {
                cc = atomVec.elementAt(j);
                atomName = cc.getAtom();
                if (atomName.equalsIgnoreCase("HN")) {
                    atomName = "H";
                }
                if (atomName.equalsIgnoreCase(nucleus)) {
                    coordA = cc.getXYZ();
                    vecCartesianA.add(new Cartesian(atomName, coordA));
                }
                ++j;
            }
        }
        if ((index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator())) < 0) {
            noe[0] = -999.9;
            return false;
        }
        Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
        Vector<Cartesian> atomVec2 = pp2.getAtomVec();
        resid = pp2.getResidue();
        distanceUp = 1000.0;
        found = false;
        min = distanceUp;
        noe[0] = distanceUp;
        if (resid.equalsIgnoreCase("ALA") && nucleus2.length() > 1) {
            if (nucleus2.substring(0, 2).equalsIgnoreCase("HB")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.length() > 2) {
            if (nucleus2.substring(0, 3).equalsIgnoreCase("HG2")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.length() > 2) {
            if (nucleus2.substring(0, 3).equalsIgnoreCase("HD1")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.length() > 2) {
            if (nucleus2.substring(0, 3).equalsIgnoreCase("HD1")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.length() > 2) {
            if (nucleus2.substring(0, 3).equalsIgnoreCase("HD1")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.length() > 2) {
            if (nucleus2.substring(0, 3).equalsIgnoreCase("HD2")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.length() > 2) {
            if (nucleus2.substring(0, 3).equalsIgnoreCase("HG1")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.length() > 2) {
            if (nucleus2.substring(0, 3).equalsIgnoreCase("HG2")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else if (resid.equalsIgnoreCase("THR") && nucleus2.length() > 2) {
            if (nucleus2.substring(0, 3).equalsIgnoreCase("HG2")) {
                j = 0;
                while (j < atomVec2.size()) {
                    cc = atomVec2.elementAt(j);
                    atomName = cc.getAtom();
                    if (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) {
                        coordB = cc.getXYZ();
                        int h = 0;
                        while (h < vecCartesianA.size()) {
                            Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                            coordA = cartesianA.getXYZ();
                            distance = this.length(this.internuclearVec(coordB, coordA));
                            if (distance < noe[0]) {
                                noe[0] = distance;
                            }
                            ++h;
                        }
                    }
                    ++j;
                }
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            }
        } else {
            if (nucleus2.equalsIgnoreCase("HN")) {
                nucleus2 = "H";
            }
            j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if (atomName.equalsIgnoreCase("HN")) {
                    atomName = "H";
                }
                if (atomName.equalsIgnoreCase(nucleus2)) {
                    coordB = cc.getXYZ();
                    int h = 0;
                    while (h < vecCartesianA.size()) {
                        Cartesian cartesianA = (Cartesian)vecCartesianA.elementAt(h);
                        coordA = cartesianA.getXYZ();
                        distance = this.length(this.internuclearVec(coordB, coordA));
                        if (distance < noe[0]) {
                            noe[0] = distance;
                        }
                        ++h;
                    }
                }
                ++j;
            }
            if (isMethel) {
                if (noe[0] <= noeLimit) {
                    found = true;
                    noe[1] = methylCorrection;
                }
            } else if (noe[0] <= noeLimit) {
                found = true;
                noe[1] = 0.0;
            }
        }
        return found;
    }

    public boolean checkNoeNew(Vector pdbVec, int no, String nucleus, int no2, String nucleus2, double noeLimit, double methylCorrection, double[] noe) {
        boolean isFoundAtomA = false;
        boolean isFoundAtomB = false;
        double[] coordA = new double[3];
        double[] coordB = new double[3];
        Cartesian cc = null;
        String atomName = "";
        String aName = "";
        Vector pkVec = new Vector();
        Assign asg = new Assign();
        TreeMap aMap = new TreeMap();
        double distance = 0.0;
        double cs = -999.99;
        int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
        if (index < 0) {
            noe[0] = -999.9;
            return false;
        }
        Pdb pp = (Pdb)pdbVec.elementAt(index);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        String resid = pp.getResidue();
        double distanceUp = 1000.0;
        boolean found = false;
        double min = distanceUp;
        noe[0] = distanceUp;
        noe[1] = 0.0;
        boolean isMethel = false;
        String atomSub = "";
        if (nucleus.equalsIgnoreCase("H")) {
            nucleus = "HN";
        }
        atomSub = nucleus;
        if (nucleus.length() >= 2) {
            if (nucleus.substring(nucleus.length() - 2, nucleus.length()).equalsIgnoreCase("##")) {
                atomSub = nucleus.substring(0, nucleus.length() - 2);
            } else if (nucleus.substring(nucleus.length() - 1, nucleus.length()).equalsIgnoreCase("#")) {
                atomSub = nucleus.substring(0, nucleus.length() - 1);
            }
        }
        Vector<Cartesian> vecCartesianA = new Vector<Cartesian>();
        int countA = 0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        int j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            String atomPPName = cc.getAtom();
            if (atomPPName.equalsIgnoreCase("H")) {
                atomPPName = "HN";
            }
            String sub_atomPPName = atomPPName;
            if (atomPPName.length() >= atomSub.length() && !atomSub.equalsIgnoreCase("O") && !atomSub.equalsIgnoreCase("N")) {
                sub_atomPPName = atomPPName.substring(0, atomSub.length());
            }
            if (sub_atomPPName.equalsIgnoreCase(atomSub)) {
                isFoundAtomA = true;
                coordA = cc.getXYZ();
                ++countA;
                sumX += coordA[0];
                sumY += coordA[1];
                sumZ += coordA[2];
                if (atomPPName.length() - atomSub.length() == 1 || atomPPName.length() - atomSub.length() == 2) {
                    isMethel = true;
                }
            }
            ++j;
        }
        coordA[0] = sumX / (double)countA;
        coordA[1] = sumY / (double)countA;
        coordA[2] = sumZ / (double)countA;
        vecCartesianA.add(new Cartesian(atomSub, coordA));
        int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
        if (index2 < 0) {
            noe[0] = -999.9;
            return false;
        }
        Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
        Vector<Cartesian> atomVec2 = pp2.getAtomVec();
        resid = pp2.getResidue();
        distanceUp = 1000.0;
        found = false;
        min = distanceUp;
        noe[0] = distanceUp;
        if (nucleus2.equalsIgnoreCase("H")) {
            nucleus2 = "HN";
        }
        atomSub = nucleus2;
        if (nucleus2.length() >= 2) {
            if (nucleus2.substring(nucleus2.length() - 2, nucleus2.length()).equalsIgnoreCase("##")) {
                atomSub = nucleus2.substring(0, nucleus2.length() - 2);
            } else if (nucleus2.substring(nucleus2.length() - 1, nucleus2.length()).equalsIgnoreCase("#")) {
                atomSub = nucleus2.substring(0, nucleus2.length() - 1);
            }
        }
        int countB = 0;
        sumX = 0.0;
        sumY = 0.0;
        sumZ = 0.0;
        j = 0;
        while (j < atomVec2.size()) {
            cc = atomVec2.elementAt(j);
            String atomPPName = cc.getAtom();
            if (atomPPName.equalsIgnoreCase("H")) {
                atomPPName = "HN";
            }
            String sub_atomPPName = atomPPName;
            if (atomPPName.length() >= atomSub.length() && !atomSub.equalsIgnoreCase("O") && !atomSub.equalsIgnoreCase("N")) {
                sub_atomPPName = atomPPName.substring(0, atomSub.length());
            }
            if (sub_atomPPName.equalsIgnoreCase(atomSub)) {
                isFoundAtomB = true;
                if (atomPPName.length() - atomSub.length() == 1 || atomPPName.length() - atomSub.length() == 2) {
                    isMethel = true;
                }
                coordB = cc.getXYZ();
                ++countB;
                sumX += coordB[0];
                sumY += coordB[1];
                sumZ += coordB[2];
            }
            ++j;
        }
        coordB[0] = sumX / (double)countB;
        coordB[1] = sumY / (double)countB;
        coordB[2] = sumZ / (double)countB;
        distance = this.length(this.internuclearVec(coordB, coordA));
        if (distance < noe[0]) {
            noe[0] = distance;
        }
        double dbCorrection = 0.0;
        if (isMethel) {
            dbCorrection = methylCorrection;
            noe[1] = 0.5;
        }
        if (noe[0] <= noeLimit + dbCorrection && isFoundAtomA && isFoundAtomB) {
            found = true;
        }
        return found;
    }

    public boolean checkNoeNew2(Vector pdbVec, int no, String nucleus, int no2, String nucleus2, double noeLimit, double methylCorrection, double[] noe) {
        boolean isFoundAtomA = false;
        boolean isFoundAtomB = false;
        double[] coordA = new double[3];
        double[] coordB = new double[3];
        Cartesian cc = null;
        String atomName = "";
        String aName = "";
        Vector pkVec = new Vector();
        Assign asg = new Assign();
        TreeMap aMap = new TreeMap();
        double distance = 0.0;
        double cs = -999.99;
        int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
        if (index < 0) {
            noe[0] = -999.9;
            return false;
        }
        Pdb pp = (Pdb)pdbVec.elementAt(index);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        String resid = pp.getResidue();
        double distanceUp = 1000.0;
        boolean found = false;
        double min = distanceUp;
        noe[0] = distanceUp;
        noe[1] = 0.0;
        boolean isMethel = false;
        String atomSub = "";
        if (nucleus.equalsIgnoreCase("H")) {
            nucleus = "HN";
        }
        atomSub = nucleus;
        if (nucleus.length() >= 2) {
            if (nucleus.substring(nucleus.length() - 2, nucleus.length()).equalsIgnoreCase("##")) {
                atomSub = nucleus.substring(0, nucleus.length() - 2);
            } else if (nucleus.substring(nucleus.length() - 1, nucleus.length()).equalsIgnoreCase("#")) {
                atomSub = nucleus.substring(0, nucleus.length() - 1);
            }
        }
        Vector<Cartesian> vecCartesianA = new Vector<Cartesian>();
        int countA = 0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        int j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            String atomPPName = cc.getAtom();
            if (atomPPName.equalsIgnoreCase("H")) {
                atomPPName = "HN";
            }
            String sub_atomPPName = atomPPName;
            if (atomPPName.length() >= atomSub.length() && !atomSub.equalsIgnoreCase("O") && !atomSub.equalsIgnoreCase("N")) {
                sub_atomPPName = atomPPName.substring(0, atomSub.length());
            }
            if (sub_atomPPName.equalsIgnoreCase(atomSub)) {
                isFoundAtomA = true;
                coordA = cc.getXYZ();
                ++countA;
                sumX += coordA[0];
                sumY += coordA[1];
                sumZ += coordA[2];
                if (atomPPName.length() - atomSub.length() == 1 || atomPPName.length() - atomSub.length() == 2) {
                    isMethel = true;
                }
            }
            ++j;
        }
        coordA[0] = sumX / (double)countA;
        coordA[1] = sumY / (double)countA;
        coordA[2] = sumZ / (double)countA;
        vecCartesianA.add(new Cartesian(atomSub, coordA));
        int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
        if (index2 < 0) {
            noe[0] = -999.9;
            return false;
        }
        Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
        Vector<Cartesian> atomVec2 = pp2.getAtomVec();
        resid = pp2.getResidue();
        distanceUp = 1000.0;
        found = false;
        min = distanceUp;
        noe[0] = distanceUp;
        if (nucleus2.equalsIgnoreCase("H")) {
            nucleus2 = "HN";
        }
        atomSub = nucleus2;
        if (nucleus2.length() >= 2) {
            if (nucleus2.substring(nucleus2.length() - 2, nucleus2.length()).equalsIgnoreCase("##")) {
                atomSub = nucleus2.substring(0, nucleus2.length() - 2);
            } else if (nucleus2.substring(nucleus2.length() - 1, nucleus2.length()).equalsIgnoreCase("#")) {
                atomSub = nucleus2.substring(0, nucleus2.length() - 1);
            }
        }
        int countB = 0;
        sumX = 0.0;
        sumY = 0.0;
        sumZ = 0.0;
        j = 0;
        while (j < atomVec2.size()) {
            cc = atomVec2.elementAt(j);
            String atomPPName = cc.getAtom();
            if (atomPPName.equalsIgnoreCase("H")) {
                atomPPName = "HN";
            }
            String sub_atomPPName = atomPPName;
            if (atomPPName.length() >= atomSub.length() && !atomSub.equalsIgnoreCase("O") && !atomSub.equalsIgnoreCase("N")) {
                sub_atomPPName = atomPPName.substring(0, atomSub.length());
            }
            if (sub_atomPPName.equalsIgnoreCase(atomSub)) {
                isFoundAtomB = true;
                if (atomPPName.length() - atomSub.length() == 1 || atomPPName.length() - atomSub.length() == 2) {
                    isMethel = true;
                }
                coordB = cc.getXYZ();
                ++countB;
                sumX += coordB[0];
                sumY += coordB[1];
                sumZ += coordB[2];
            }
            ++j;
        }
        coordB[0] = sumX / (double)countB;
        coordB[1] = sumY / (double)countB;
        coordB[2] = sumZ / (double)countB;
        distance = this.length(this.internuclearVec(coordB, coordA));
        if (distance < noe[0]) {
            noe[0] = distance;
        }
        double dbCorrection = 0.5;
        if (isMethel) {
            dbCorrection = methylCorrection;
            noe[1] = 0.5;
        }
        if (noe[0] <= noeLimit + dbCorrection && isFoundAtomA && isFoundAtomB) {
            found = true;
        }
        return found;
    }

    public double getCSFromList(Vector vecAsg, int resNo, String atom) {
        if (atom.equalsIgnoreCase("HN")) {
            atom = "H";
        }
        int i = 0;
        while (i < vecAsg.size()) {
            H1CS h1cs = (H1CS)vecAsg.elementAt(i);
            String atomName = h1cs.getAtomName();
            if (atomName.equalsIgnoreCase("HN")) {
                atomName = "H";
            }
            int no = h1cs.getResidueNo();
            double cs = h1cs.getH1CS();
            if (no == resNo && atom.equalsIgnoreCase(atomName)) {
                return cs;
            }
            ++i;
        }
        return -999.9;
    }

    public Vector CheckLongRangNOE(Vector vecNoe, int Threshold) {
        String secondAtomName;
        String firstAtomName;
        String secondResName;
        String firstResName;
        int secondResNo;
        int firstResNo;
        Vector<Noe> vecNewNoe = new Vector<Noe>();
        Noe noe = new Noe();
        Noe noeCheck = new Noe();
        int i = 0;
        while (i < vecNoe.size()) {
            noe = (Noe)vecNoe.elementAt(i);
            firstResNo = noe.getResidueNoA();
            secondResNo = noe.getResidueNoB();
            firstResName = noe.getResidueA();
            secondResName = noe.getResidueB();
            firstAtomName = noe.getAtomA();
            secondAtomName = noe.getAtomB();
            int number = 0;
            int j = 0;
            while (j < vecNoe.size()) {
                if (i != j) {
                    noeCheck = (Noe)vecNoe.elementAt(j);
                    int resNo1 = noeCheck.getResidueNoA();
                    int resNo2 = noeCheck.getResidueNoB();
                    String atomName1 = noeCheck.getAtomA();
                    String atomName2 = noeCheck.getAtomB();
                    if (Math.abs(firstResNo - resNo1) <= 0 && Math.abs(secondResNo - resNo2) <= 0) {
                        ++number;
                    }
                    if (Math.abs(firstResNo - resNo2) <= 0 && Math.abs(secondResNo - resNo1) <= 0) {
                        ++number;
                    }
                }
                ++j;
            }
            if (number >= Threshold) {
                vecNewNoe.add(noe);
            }
            ++i;
        }
        i = 0;
        while (i < vecNewNoe.size()) {
            noe = (Noe)vecNewNoe.elementAt(i);
            firstResNo = noe.getResidueNoA();
            secondResNo = noe.getResidueNoB();
            firstResName = noe.getResidueA();
            secondResName = noe.getResidueB();
            firstAtomName = noe.getAtomA();
            secondAtomName = noe.getAtomB();
            ++i;
        }
        return vecNewNoe;
    }

    public Vector CheckNoeSym(Vector vecNoe) {
        Peak pk = new Peak();
        Vector<Noe> vecNewNoe = new Vector<Noe>();
        Noe noe = new Noe();
        Noe noeCheck = new Noe();
        double dist_from_inten = 0.0;
        boolean isBack = false;
        int i = 0;
        while (i < vecNoe.size()) {
            noe = (Noe)vecNoe.elementAt(i);
            int firstResNo = noe.getResidueNoA();
            int secondResNo = noe.getResidueNoB();
            String firstResName = noe.getResidueA();
            String secondResName = noe.getResidueB();
            String firstAtomName = noe.getAtomA();
            String secondAtomName = noe.getAtomB();
            dist_from_inten = noe.getUpper();
            isBack = false;
            int j = 0;
            while (j < vecNoe.size()) {
                if (i != j) {
                    noeCheck = (Noe)vecNoe.elementAt(j);
                    int resNo1 = noeCheck.getResidueNoA();
                    int resNo2 = noeCheck.getResidueNoB();
                    String atomName1 = noeCheck.getAtomA();
                    String atomName2 = noeCheck.getAtomB();
                    if (firstResNo == resNo2 && secondResNo == resNo1) {
                        isBack = true;
                    }
                }
                ++j;
            }
            if (isBack) {
                vecNewNoe.add(noe);
            }
            ++i;
        }
        return vecNewNoe;
    }

    public boolean checkNoe_old(Vector pdbVec, Vector asgVec, int no, String nucleus, int no2, String nucleus2, double noeLimit, double methylCorrection, double[] noe) {
        double[] coordA = new double[3];
        double[] coordB = new double[3];
        Cartesian cc = null;
        String atomName = "";
        String aName = "";
        Vector pkVec = new Vector();
        Assign asg = new Assign();
        TreeMap aMap = new TreeMap();
        double distance = 0.0;
        double cs = -999.99;
        int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
        if (index < 0) {
            return false;
        }
        Pdb pp = (Pdb)pdbVec.elementAt(index);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        int i = 0;
        while (i < atomVec.size()) {
            cc = atomVec.elementAt(i);
            atomName = cc.getAtom();
            if (atomName.equalsIgnoreCase(nucleus)) {
                coordA = cc.getXYZ();
            }
            ++i;
        }
        int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
        if (index2 < 0) {
            return false;
        }
        Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
        Vector<Cartesian> atomVec2 = pp2.getAtomVec();
        String resid = pp2.getResidue();
        double distanceUp = 1000.0;
        boolean found = false;
        double min = distanceUp;
        noe[0] = distanceUp;
        if (resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else {
            if (nucleus2.equalsIgnoreCase("HN")) {
                nucleus2 = "H";
            }
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if (atomName.equalsIgnoreCase(nucleus2)) {
                    coordB = cc.getXYZ();
                    noe[0] = this.length(this.internuclearVec(coordB, coordA));
                }
                ++j;
            }
            if (noe[0] <= noeLimit) {
                found = true;
            }
        }
        return found;
    }

    public boolean checkNoe2(Vector pdbVec, int no, String nucleus, int no2, String nucleus2, double noeLimit, double methylCorrection, double[] noe) {
        double[] coordA = new double[3];
        double[] coordB = new double[3];
        Cartesian cc = null;
        String atomName = "";
        String aName = "";
        Vector pkVec = new Vector();
        Assign asg = new Assign();
        TreeMap aMap = new TreeMap();
        double distance = 0.0;
        double cs = -999.99;
        int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
        if (index < 0) {
            return false;
        }
        Pdb pp = (Pdb)pdbVec.elementAt(index);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        int i = 0;
        while (i < atomVec.size()) {
            cc = atomVec.elementAt(i);
            atomName = cc.getAtom();
            if (atomName.equalsIgnoreCase(nucleus)) {
                coordA = cc.getXYZ();
            }
            ++i;
        }
        int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
        if (index2 < 0) {
            return false;
        }
        Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
        Vector<Cartesian> atomVec2 = pp2.getAtomVec();
        String resid = pp2.getResidue();
        double distanceUp = 1000.0;
        boolean found = false;
        double min = distanceUp;
        noe[0] = distanceUp;
        if (resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                noe[0] = distanceUp;
                if ((atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else if (resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2")) {
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if ((atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23")) && (distance = this.length(this.internuclearVec(coordB = cc.getXYZ(), coordA))) < noe[0]) {
                    noe[0] = distance;
                }
                ++j;
            }
            if (noe[0] <= noeLimit + methylCorrection) {
                found = true;
            }
        } else {
            if (nucleus2.equalsIgnoreCase("HN")) {
                nucleus2 = "H";
            }
            int j = 0;
            while (j < atomVec2.size()) {
                cc = atomVec2.elementAt(j);
                atomName = cc.getAtom();
                if (atomName.equalsIgnoreCase(nucleus2)) {
                    coordB = cc.getXYZ();
                    noe[0] = this.length(this.internuclearVec(coordB, coordA));
                }
                ++j;
            }
            if (noe[0] <= noeLimit) {
                found = true;
            }
        }
        return found;
    }

    public Vector allNoes(Vector pdbVec, Vector asgVec, double[] coordA, double noeLimit, double methylCorrection) {
        Cartesian cc = null;
        String atomName = "";
        String aName = "";
        Vector<Object> atomVec = new Vector();
        Vector<Peak> pkVec = new Vector<Peak>();
        Assign asg = new Assign();
        Map aMap = new TreeMap();
        Pdb pp = new Pdb();
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        double distance = 0.0;
        double cs = -999.99;
        int index = -1;
        int i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            index = Collections.binarySearch(asgVec, new Assign(no), new Assign.assignComparator());
            if (index > 0) {
                asg = (Assign)asgVec.elementAt(index);
                aMap = asg.getMap();
            } else {
                aMap = new TreeMap();
            }
            String resid = pp.getResidue().trim();
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atomName = cc.getAtom();
                if (atomName.indexOf("H") > -1) {
                    if (aMap.get(atomName) == null) {
                        if (resid.equalsIgnoreCase("ALA") && (atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3"))) {
                            aName = "HB";
                            cs = (Double)aMap.get(aName);
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit + methylCorrection) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        } else if (resid.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            aName = "HG2";
                            cs = (Double)aMap.get(aName);
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit + methylCorrection) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        } else if (resid.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                            aName = "HD1";
                            cs = (Double)aMap.get(aName);
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit + methylCorrection) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        } else if (resid.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                            aName = "HD1";
                            cs = (Double)aMap.get(aName);
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit + methylCorrection) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        } else if (resid.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23"))) {
                            aName = "HD2";
                            cs = (Double)aMap.get(aName);
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit + methylCorrection) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        } else if (resid.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13"))) {
                            aName = "HG1";
                            cs = (Double)aMap.get(aName);
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit + methylCorrection) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        } else if (resid.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            aName = "HG2";
                            cs = (Double)aMap.get(aName);
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit + methylCorrection) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        } else if (resid.equalsIgnoreCase("THR") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            aName = "HG2";
                            cs = (Double)aMap.get(aName);
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit + methylCorrection) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        } else {
                            aName = atomName;
                            cs = -999.99;
                            coordB = cc.getXYZ();
                            distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                            if ((distance = Math.sqrt(distance)) <= noeLimit) {
                                pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                            }
                        }
                    } else {
                        aName = atomName.equalsIgnoreCase("H") ? "HN" : atomName;
                        cs = (Double)aMap.get(aName);
                        coordB = cc.getXYZ();
                        distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
                        if ((distance = Math.sqrt(distance)) <= noeLimit) {
                            pkVec.add(new Peak(String.valueOf(resid) + no + "-" + aName, cs, distance));
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return pkVec;
    }

    public void noeBackCompute(Vector pdbVec, Vector asgVec) {
        Cartesian cc = null;
        String atomName = "";
        String atomName2 = "";
        Vector atoms = new Vector();
        Vector<Object> atomVec = new Vector();
        Vector pkVec = new Vector();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        double[] hnCoord = new double[]{0.0, 0.0, 0.0};
        double noeLimits = 5.0;
        Collections.sort(asgVec, new Assign.assignComparator());
        int i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            System.out.println();
            String resid = pp.getResidue().trim();
            atomVec = pp.getAtomVec();
            System.out.println(String.valueOf(no) + "  " + resid);
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atomName = cc.getAtom();
                if (atomName.equalsIgnoreCase("H")) {
                    hnCoord = cc.getXYZ();
                    pkVec = this.allNoes(pdbVec, asgVec, hnCoord, noeLimits, 2.5);
                }
                ++j;
            }
            Collections.sort(pkVec, new csComparator());
            int k = 0;
            while (k < pkVec.size()) {
                System.out.println((Peak)pkVec.elementAt(k));
                ++k;
            }
            System.out.println();
            ++i;
        }
    }

    public boolean noeSearch(Vector h1Vec, Vector asgVec, int no1, String nucleus1, int no2, String nucleus2, double[] noe) {
        String nucleus;
        String res;
        int resNo2;
        String resId;
        double h1Err = 0.04;
        boolean i = false;
        int j = 0;
        int k = 0;
        double inten = -1.0;
        int index1 = Collections.binarySearch(asgVec, new Assign(no1), new Assign.assignComparator());
        if (index1 < 0) {
            return false;
        }
        Assign asg = (Assign)asgVec.elementAt(index1);
        Map asgMap = asg.getMap();
        if (asgMap.get(nucleus1) == null) {
            return false;
        }
        double cs1 = (Double)asgMap.get(nucleus1);
        Vector hnNoeVec = asg.getHnNoeVec();
        HnNoe hnNoe = new HnNoe();
        Assign asg2 = new Assign();
        Map asgMap2 = new TreeMap();
        if (no1 == no2) {
            asgMap2 = asgMap;
        } else {
            index1 = Collections.binarySearch(asgVec, new Assign(no2), new Assign.assignComparator());
            if (index1 < 0) {
                return false;
            }
            asg2 = (Assign)asgVec.elementAt(index1);
            asgMap2 = asg2.getMap();
        }
        if (asgMap2.get(nucleus2) == null) {
            return false;
        }
        double cs2 = (Double)asgMap2.get(nucleus2);
        if (Math.abs(cs1 - -999.9) < 1.0E-4 || Math.abs(cs2 - -999.9) < 1.0E-4) {
            return false;
        }
        double csOfB = 0.0;
        Vector<Object> bVec = new Vector();
        Peak pk = new Peak();
        int index = -1;
        double intenTmp = -1.0;
        if (nucleus1.equalsIgnoreCase("HN")) {
            j = 0;
            while (j < hnNoeVec.size()) {
                hnNoe = (HnNoe)hnNoeVec.elementAt(j);
                csOfB = hnNoe.getH1();
                if (Math.abs(csOfB - cs2) <= h1Err) {
                    bVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                    k = 0;
                    while (k < bVec.size()) {
                        pk = (Peak)bVec.elementAt(k);
                        resId = pk.getNucleus();
                        index = resId.indexOf("-");
                        resNo2 = Integer.parseInt(resId.substring(3, index));
                        res = resId.substring(0, 3);
                        nucleus = resId.substring(index + 1);
                        if (resNo2 == no2 && nucleus.equalsIgnoreCase(nucleus2) && (intenTmp = hnNoe.getIntensity()) > inten) {
                            inten = intenTmp;
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        double inten1 = -1.0;
        if (nucleus2.equalsIgnoreCase("HN")) {
            hnNoeVec = asg2.getHnNoeVec();
            j = 0;
            while (j < hnNoeVec.size()) {
                hnNoe = (HnNoe)hnNoeVec.elementAt(j);
                csOfB = hnNoe.getH1();
                if (Math.abs(csOfB - cs1) <= h1Err) {
                    bVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                    k = 0;
                    while (k < bVec.size()) {
                        pk = (Peak)bVec.elementAt(k);
                        resId = pk.getNucleus();
                        index = resId.indexOf("-");
                        resNo2 = Integer.parseInt(resId.substring(3, index));
                        res = resId.substring(0, 3);
                        nucleus = resId.substring(index + 1);
                        if (resNo2 == no1 && nucleus.equalsIgnoreCase(nucleus1) && (intenTmp = hnNoe.getIntensity()) > inten1) {
                            inten1 = intenTmp;
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        if (inten < inten1) {
            inten = inten1;
        }
        noe[0] = inten;
        return true;
    }

    public void intensityVsDistance(Vector h1Vec, Vector asgVec, Vector pdbVec) {
        int i = 0;
        int j = 0;
        int k = 0;
        Vector oneHnVec = new Vector();
        Vector oneHaVec = new Vector();
        Vector oneH1Vec = new Vector();
        Assign asg = new Assign();
        Peak pk = new Peak();
        Pdb pp = new Pdb();
        double h1Err = 0.04;
        double csOfB = 0.0;
        HnNoe hnNoe = new HnNoe();
        int resNo1 = 0;
        int resNo2 = 0;
        boolean resNo3 = false;
        Vector<Object> bVec = new Vector();
        Vector cVec = new Vector();
        String resId = "";
        String aaType = "";
        String res = "";
        int index = 0;
        HcchTocsy hcch = new HcchTocsy();
        double[] dis1 = new double[1];
        boolean hasNOE = false;
        double dis2 = 0.0;
        double a1 = -1.10764563682241;
        double a2 = 1442.04217588463;
        double inten1 = 0.0;
        System.out.println();
        i = 0;
        while (i < asgVec.size()) {
            asg = (Assign)asgVec.elementAt(i);
            oneHnVec = asg.getHnNoeVec();
            resNo1 = asg.getResidueNo();
            aaType = asg.getResidueType();
            System.out.println(String.valueOf(resNo1) + "  " + aaType);
            bVec = new Vector();
            j = 0;
            while (j < oneHnVec.size()) {
                hnNoe = (HnNoe)oneHnVec.elementAt(j);
                System.out.println(hnNoe);
                csOfB = hnNoe.getH1();
                if (csOfB > 3.0) {
                    bVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                    if (bVec.isEmpty()) {
                        System.out.println("NO Assign:  " + hnNoe);
                        break;
                    }
                    k = 0;
                    while (k < bVec.size()) {
                        pk = (Peak)bVec.elementAt(k);
                        System.out.println(pk);
                        resId = pk.getNucleus();
                        index = resId.indexOf("-");
                        resNo2 = Integer.parseInt(resId.substring(3, index));
                        res = resId.substring(0, 3);
                        String nucleus = resId.substring(index + 1);
                        hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
                        inten1 = hnNoe.getIntensity();
                        dis2 = Math.pow(a2 / (inten1 - a1), 0.25);
                        System.out.println(String.valueOf(dis1[0]) + "  " + inten1 + "  " + dis2);
                        if (Math.abs(dis1[0]) > 0.001 && Math.abs(dis1[0]) < 5.01 && Math.abs(dis1[0] - dis2) < 2.0) {
                            if (resNo2 == resNo1) {
                                System.out.println("Intra NOEs:");
                            } else if (Math.abs(resNo2 - resNo1) == 1) {
                                System.out.print("Seq NOEs:  ");
                            } else if (Math.abs(resNo2 - resNo1) > 1 && Math.abs(resNo2 - resNo1) <= 3) {
                                System.out.print("Med NOEs:  ");
                            } else {
                                System.out.print("Long NOEs:  ");
                            }
                        } else if (Math.abs(dis1[0]) <= 0.001) {
                            System.out.println("NO such nuclei in PDB file");
                        } else if (Math.abs(dis1[0]) > 5.01 || Math.abs(dis1[0] - dis2) >= 2.0) {
                            System.out.println("Filtered by RDCs:  " + dis1[0] + "   " + Math.abs(dis1[0] - dis2));
                        }
                        System.out.println();
                        ++k;
                    }
                    System.out.println();
                    System.out.println();
                }
                ++j;
            }
            ++i;
        }
    }

    public Matrix noeAssignMat(Vector h1Vec, Vector asgVec) {
        int i = 0;
        int j = 0;
        int k = 0;
        Vector oneHnVec = new Vector();
        Vector oneHaVec = new Vector();
        Vector oneH1Vec = new Vector();
        Assign asg = new Assign();
        Peak pk = new Peak();
        double h1Err = 0.04;
        double csOfB = 0.0;
        HnNoe hnNoe = new HnNoe();
        int resNo1 = 0;
        int resNo2 = 0;
        int resNo3 = 0;
        Vector<Object> bVec = new Vector();
        Vector<Object> cVec = new Vector();
        String resId = "";
        String aaType = "";
        int index = 0;
        HcchTocsy hcch = new HcchTocsy();
        Matrix closeMat = Matrix.identity(73, 73);
        i = 0;
        while (i < asgVec.size()) {
            asg = (Assign)asgVec.elementAt(i);
            oneHnVec = asg.getHnNoeVec();
            oneHaVec = asg.getHaNoeVec();
            resNo1 = asg.getResidueNo();
            aaType = asg.getResidueType();
            j = 0;
            while (j < oneHnVec.size()) {
                hnNoe = (HnNoe)oneHnVec.elementAt(j);
                csOfB = hnNoe.getH1();
                if (csOfB > 3.3) {
                    bVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                    k = 0;
                    while (k < bVec.size()) {
                        pk = (Peak)bVec.elementAt(k);
                        resId = pk.getNucleus();
                        index = resId.indexOf("-");
                        resNo2 = Integer.parseInt(resId.substring(3, index));
                        closeMat.set(resNo1, resNo2, 1.0);
                        ++k;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < oneHaVec.size()) {
                hcch = (HcchTocsy)oneHaVec.elementAt(j);
                csOfB = hcch.getH1();
                if (csOfB > 3.3) {
                    cVec = this.rangeSearch(h1Vec, csOfB, h1Err);
                    k = 0;
                    while (k < cVec.size()) {
                        pk = (Peak)cVec.elementAt(k);
                        resId = pk.getNucleus();
                        index = resId.indexOf("-");
                        resNo3 = Integer.parseInt(resId.substring(3, index));
                        closeMat.set(resNo1, resNo3, 1.0);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return closeMat;
    }

    public static class csComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            double d2;
            Peak n1 = (Peak)o1;
            Peak n2 = (Peak)o2;
            double d1 = n1.getCS();
            if (d1 < (d2 = n2.getCS())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

