/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.Z1;
import Jampack.Zdiagmat;
import Jampack.Zmat;

public class Norm {
    public static double fro(Zmat A, int ii1, int ii2, int jj1, int jj2) {
        int j;
        int i1 = ii1 - A.basex;
        int i2 = ii2 - A.basex;
        int j1 = jj1 - A.basex;
        int j2 = jj2 - A.basex;
        double scale = 0.0;
        int i = i1;
        while (i <= i2) {
            j = j1;
            while (j <= j2) {
                scale = Math.max(scale, Math.abs(A.re[i][j]) + Math.abs(A.im[i][j]));
                ++j;
            }
            ++i;
        }
        if (scale == 0.0) {
            return 0.0;
        }
        if (scale < 1.0) {
            scale *= 1.0E20;
        }
        scale = 1.0 / scale;
        double nrm = 0.0;
        i = i1;
        while (i <= i2) {
            j = j1;
            while (j <= j2) {
                double fac = scale * A.re[i][j];
                nrm += fac * fac;
                fac = scale * A.im[i][j];
                nrm += fac * fac;
                ++j;
            }
            ++i;
        }
        return Math.sqrt(nrm) / scale;
    }

    public static double fro(Zmat A) {
        A.getProperties();
        return Norm.fro(A, A.bx, A.rx, A.bx, A.cx);
    }

    public static double fro(Z1 u) {
        int n = u.n;
        double scale = 0.0;
        int i = 0;
        while (i < n) {
            scale = Math.max(scale, Math.abs(u.re[i]) + Math.abs(u.im[i]));
            ++i;
        }
        if (scale == 0.0) {
            return 0.0;
        }
        if (scale < 1.0) {
            scale *= 1.0E20;
        }
        scale = 1.0 / scale;
        double nrm = 0.0;
        i = 0;
        while (i < n) {
            double fac = scale * u.re[i];
            nrm += fac * fac;
            fac = scale * u.im[i];
            nrm += fac * fac;
            ++i;
        }
        return Math.sqrt(nrm) / scale;
    }

    public static double fro(Zdiagmat D) {
        int n = D.order;
        double scale = 0.0;
        int i = 0;
        while (i < n) {
            scale = Math.max(scale, Math.abs(D.re[i]) + Math.abs(D.im[i]));
            ++i;
        }
        if (scale == 0.0) {
            return 0.0;
        }
        if (scale < 1.0) {
            scale *= 1.0E20;
        }
        scale = 1.0 / scale;
        double nrm = 0.0;
        i = 0;
        while (i < n) {
            double fac = scale * D.re[i];
            nrm += fac * fac;
            fac = scale * D.im[i];
            nrm += fac * fac;
            ++i;
        }
        return Math.sqrt(nrm) / scale;
    }
}

