/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.Zmat;

public class Rot {
    protected double c;
    public double sr;
    public double si;
    public double zr;
    public double zi;

    public static Rot genc(double xr, double xi, double yr, double yi) {
        Rot P = new Rot();
        if (xr == 0.0 && xi == 0.0) {
            P.c = 0.0;
            P.sr = 1.0;
            P.si = 0.0;
            P.zr = yr;
            P.zi = yi;
            return P;
        }
        double s = Math.abs(xr) + Math.abs(xi);
        double absx = s * Math.sqrt(xr / s * (xr / s) + xi / s * (xi / s));
        s = Math.abs(s) + Math.abs(yr) + Math.abs(yi);
        double absxy = s * Math.sqrt(absx / s * (absx / s) + yr / s * (yr / s) + yi / s * (yi / s));
        P.c = absx / absxy;
        P.sr = ((xr /= absx) * yr + (xi /= absx) * yi) / absxy;
        P.si = (xi * yr - xr * yi) / absxy;
        P.zr = xr * absxy;
        P.zi = xi * absxy;
        return P;
    }

    public static void genc(double xr, double xi, double yr, double yi, Rot P) {
        if (xr == 0.0 && xi == 0.0) {
            P.c = 0.0;
            P.sr = 1.0;
            P.si = 0.0;
            P.zr = yr;
            P.zi = yi;
            return;
        }
        double s = Math.abs(xr) + Math.abs(xi);
        double absx = s * Math.sqrt(xr / s * (xr / s) + xi / s * (xi / s));
        s = Math.abs(s) + Math.abs(yr) + Math.abs(yi);
        double absxy = s * Math.sqrt(absx / s * (absx / s) + yr / s * (yr / s) + yi / s * (yi / s));
        P.c = absx / absxy;
        P.sr = ((xr /= absx) * yr + (xi /= absx) * yi) / absxy;
        P.si = (xi * yr - xr * yi) / absxy;
        P.zr = xr * absxy;
        P.zi = xi * absxy;
    }

    public static Rot genc(double x, double y) {
        Rot P = new Rot();
        P.si = 0.0;
        P.zi = 0.0;
        if (x == 0.0 & y == 0.0) {
            P.c = 1.0;
            P.sr = 0.0;
            P.zr = 0.0;
            return P;
        }
        double s = Math.abs(x) + Math.abs(y);
        P.zr = s * Math.sqrt(x / s * (x / s) + y / s * (y / s));
        P.c = x / P.zr;
        P.sr = y / P.zr;
        return P;
    }

    public static void genc(double x, double y, Rot P) {
        P.si = 0.0;
        P.zi = 0.0;
        if (x == 0.0 & y == 0.0) {
            P.c = 1.0;
            P.sr = 0.0;
            P.zr = 0.0;
            return;
        }
        double s = Math.abs(x) + Math.abs(y);
        P.zr = s * Math.sqrt(x / s * (x / s) + y / s * (y / s));
        P.c = x / P.zr;
        P.sr = y / P.zr;
    }

    public static Rot genc(Zmat A, int ii1, int ii2, int jj) {
        A.dirty = true;
        int i1 = ii1 - A.basex;
        int i2 = ii2 - A.basex;
        int j = jj - A.basex;
        Rot P = Rot.genc(A.re[i1][j], A.im[i1][j], A.re[i2][j], A.im[i2][j]);
        A.re[i1][j] = P.zr;
        A.im[i1][j] = P.zi;
        A.re[i2][j] = 0.0;
        A.im[i2][j] = 0.0;
        return P;
    }

    public static void genc(Zmat A, int ii1, int ii2, int jj, Rot P) {
        A.dirty = true;
        int i1 = ii1 - A.basex;
        int i2 = ii2 - A.basex;
        int j = jj - A.basex;
        Rot.genc(A.re[i1][j], A.im[i1][j], A.re[i2][j], A.im[i2][j], P);
        A.re[i1][j] = P.zr;
        A.im[i1][j] = P.zi;
        A.re[i2][j] = 0.0;
        A.im[i2][j] = 0.0;
    }

    public static Rot genr(double xr, double xi, double yr, double yi) {
        Rot P = new Rot();
        if (xr == 0.0 && xi == 0.0) {
            P.c = 0.0;
            P.sr = 1.0;
            P.si = 0.0;
            P.zr = yr;
            P.zi = yi;
            return P;
        }
        double s = Math.abs(xr) + Math.abs(xi);
        double absx = s * Math.sqrt(xr / s * (xr / s) + xi / s * (xi / s));
        s = Math.abs(s) + Math.abs(yr) + Math.abs(yi);
        double absxy = s * Math.sqrt(absx / s * (absx / s) + yr / s * (yr / s) + yi / s * (yi / s));
        P.c = absx / absxy;
        P.sr = -((xr /= absx) * yr + (xi /= absx) * yi) / absxy;
        P.si = (xi * yr - xr * yi) / absxy;
        P.zr = xr * absxy;
        P.zi = xi * absxy;
        return P;
    }

    public static void genr(double xr, double xi, double yr, double yi, Rot P) {
        if (xr == 0.0 && xi == 0.0) {
            P.c = 0.0;
            P.sr = 1.0;
            P.si = 0.0;
            P.zr = yr;
            P.zi = yi;
            return;
        }
        double s = Math.abs(xr) + Math.abs(xi);
        double absx = s * Math.sqrt(xr / s * (xr / s) + xi / s * (xi / s));
        s = Math.abs(s) + Math.abs(yr) + Math.abs(yi);
        double absxy = s * Math.sqrt(absx / s * (absx / s) + yr / s * (yr / s) + yi / s * (yi / s));
        P.c = absx / absxy;
        P.sr = -((xr /= absx) * yr + (xi /= absx) * yi) / absxy;
        P.si = (xi * yr - xr * yi) / absxy;
        P.zr = xr * absxy;
        P.zi = xi * absxy;
    }

    public static Rot genr(Zmat A, int ii, int jj1, int jj2) {
        A.dirty = true;
        int i = ii - A.basex;
        int j1 = jj1 - A.basex;
        int j2 = jj2 - A.basex;
        Rot P = Rot.genr(A.re[i][j1], A.im[i][j1], A.re[i][j2], A.im[i][j2]);
        A.re[i][j1] = P.zr;
        A.im[i][j1] = P.zi;
        A.re[i][j2] = 0.0;
        A.im[i][j2] = 0.0;
        return P;
    }

    public static void genr(Zmat A, int ii, int jj1, int jj2, Rot P) {
        A.dirty = true;
        int i = ii - A.basex;
        int j1 = jj1 - A.basex;
        int j2 = jj2 - A.basex;
        Rot.genr(A.re[i][j1], A.im[i][j1], A.re[i][j2], A.im[i][j2], P);
        A.re[i][j1] = P.zr;
        A.im[i][j1] = P.zi;
        A.re[i][j2] = 0.0;
        A.im[i][j2] = 0.0;
    }

    public static Rot genr(double x, double y) {
        Rot P = new Rot();
        P.si = 0.0;
        P.zi = 0.0;
        double s = Math.abs(x) + Math.abs(y);
        if (s == 0.0) {
            P.c = 1.0;
            P.sr = 0.0;
            P.zr = 0.0;
            return P;
        }
        P.zr = s * Math.sqrt(x / s * (x / s) + y / s * (y / s));
        P.c = x / P.zr;
        P.sr = -y / P.zr;
        return P;
    }

    public static void genr(double x, double y, Rot P) {
        P.si = 0.0;
        P.zi = 0.0;
        double s = Math.abs(x) + Math.abs(y);
        if (s == 0.0) {
            P.c = 1.0;
            P.sr = 0.0;
            P.zr = 0.0;
            return;
        }
        P.zr = s * Math.sqrt(x / s * (x / s) + y / s * (y / s));
        P.c = x / P.zr;
        P.sr = -y / P.zr;
    }

    public static void pa(Rot P, Zmat A, int ii1, int ii2, int jj1, int jj2) {
        A.dirty = true;
        int i1 = ii1 - A.basex;
        int i2 = ii2 - A.basex;
        int j1 = jj1 - A.basex;
        int j2 = jj2 - A.basex;
        int j = j1;
        while (j <= j2) {
            double t1r = P.c * A.re[i1][j] + P.sr * A.re[i2][j] - P.si * A.im[i2][j];
            double t1i = P.c * A.im[i1][j] + P.sr * A.im[i2][j] + P.si * A.re[i2][j];
            double t2r = P.c * A.re[i2][j] - P.sr * A.re[i1][j] - P.si * A.im[i1][j];
            double t2i = P.c * A.im[i2][j] - P.sr * A.im[i1][j] + P.si * A.re[i1][j];
            A.re[i1][j] = t1r;
            A.im[i1][j] = t1i;
            A.re[i2][j] = t2r;
            A.im[i2][j] = t2i;
            ++j;
        }
    }

    public static void pha(Rot P, Zmat A, int ii1, int ii2, int jj1, int jj2) {
        A.dirty = true;
        int i1 = ii1 - A.basex;
        int i2 = ii2 - A.basex;
        int j1 = jj1 - A.basex;
        int j2 = jj2 - A.basex;
        int j = j1;
        while (j <= j2) {
            double t1r = P.c * A.re[i1][j] - P.sr * A.re[i2][j] + P.si * A.im[i2][j];
            double t1i = P.c * A.im[i1][j] - P.sr * A.im[i2][j] - P.si * A.re[i2][j];
            double t2r = P.c * A.re[i2][j] + P.sr * A.re[i1][j] + P.si * A.im[i1][j];
            double t2i = P.c * A.im[i2][j] + P.sr * A.im[i1][j] - P.si * A.re[i1][j];
            A.re[i1][j] = t1r;
            A.im[i1][j] = t1i;
            A.re[i2][j] = t2r;
            A.im[i2][j] = t2i;
            ++j;
        }
    }

    public static void ap(Zmat A, Rot P, int ii1, int ii2, int jj1, int jj2) {
        A.dirty = true;
        int i1 = ii1 - A.basex;
        int i2 = ii2 - A.basex;
        int j1 = jj1 - A.basex;
        int j2 = jj2 - A.basex;
        int i = i1;
        while (i <= i2) {
            double t1r = P.c * A.re[i][j1] - P.sr * A.re[i][j2] - P.si * A.im[i][j2];
            double t1i = P.c * A.im[i][j1] - P.sr * A.im[i][j2] + P.si * A.re[i][j2];
            double t2r = P.c * A.re[i][j2] + P.sr * A.re[i][j1] - P.si * A.im[i][j1];
            double t2i = P.c * A.im[i][j2] + P.sr * A.im[i][j1] + P.si * A.re[i][j1];
            A.re[i][j1] = t1r;
            A.im[i][j1] = t1i;
            A.re[i][j2] = t2r;
            A.im[i][j2] = t2i;
            ++i;
        }
    }

    public static void aph(Zmat A, Rot P, int ii1, int ii2, int jj1, int jj2) {
        A.dirty = true;
        int i1 = ii1 - A.basex;
        int i2 = ii2 - A.basex;
        int j1 = jj1 - A.basex;
        int j2 = jj2 - A.basex;
        int i = i1;
        while (i <= i2) {
            double t1r = P.c * A.re[i][j1] + P.sr * A.re[i][j2] + P.si * A.im[i][j2];
            double t1i = P.c * A.im[i][j1] + P.sr * A.im[i][j2] - P.si * A.re[i][j2];
            double t2r = P.c * A.re[i][j2] - P.sr * A.re[i][j1] + P.si * A.im[i][j1];
            double t2i = P.c * A.im[i][j2] - P.sr * A.im[i][j1] - P.si * A.re[i][j1];
            A.re[i][j1] = t1r;
            A.im[i][j1] = t1i;
            A.re[i][j2] = t2r;
            A.im[i][j2] = t2i;
            ++i;
        }
    }
}

