/*
 * Decompiled with CFR 0.152.
 */
package Nasca;

import Jampack.JampackException;
import Nasca.NascaNew;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.H1CS;
import rdcPanda.Hsqc;
import rdcPanda.ModelRdc;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.Peak;

public class ILVTest {
    public Vector<H1CS> extractILVChemicalShifts(Vector<H1CS> vecRefChemShifts) {
        Vector<H1CS> vecILVResons = new Vector<H1CS>();
        int i = 0;
        while (i < vecRefChemShifts.size()) {
            H1CS h1cs = vecRefChemShifts.elementAt(i);
            String atom = h1cs.getAtomName();
            String res = h1cs.getResidueType();
            if (atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("N")) {
                vecILVResons.add(h1cs);
            }
            if (res.equalsIgnoreCase("ILE") && (atom.equalsIgnoreCase("HD1") || atom.equalsIgnoreCase("CD1"))) {
                vecILVResons.add(h1cs);
            }
            if (res.equalsIgnoreCase("LEU") && (atom.equalsIgnoreCase("HD1") || atom.equalsIgnoreCase("CD1"))) {
                vecILVResons.add(h1cs);
            }
            if (res.equalsIgnoreCase("VAL") && (atom.equalsIgnoreCase("HD1") || atom.equalsIgnoreCase("CD1"))) {
                vecILVResons.add(h1cs);
            }
            ++i;
        }
        return vecILVResons;
    }

    public Vector<Noesy> extractILVNoesyPeaks(Vector<Noesy> vecOrigNoesy, Vector<H1CS> vecILVResons) {
        Peak pk = new Peak();
        double errWin_h1 = 0.05;
        double errWin_heavy = 0.5;
        double errWin_h2 = 0.05;
        Vector<Noesy> vecILVNoesy = new Vector<Noesy>();
        int i = 0;
        while (i < vecOrigNoesy.size()) {
            double cs_proton;
            H1CS h1cs;
            Noesy noesy = vecOrigNoesy.elementAt(i);
            double csH1 = noesy.getH1();
            double csHeavy = noesy.getHeavy();
            double csH2 = noesy.getH2();
            boolean isFirstProtonIn = false;
            boolean isSecondProtonIn = false;
            int j = 0;
            while (j < vecILVResons.size()) {
                h1cs = vecILVResons.elementAt(j);
                cs_proton = h1cs.getH1CS();
                int resNo = h1cs.getResidueNo();
                String atom = h1cs.getAtomName();
                String res = h1cs.getResidueType();
                String heavyName = pk.GetHeavyAtomFromProton(res, atom);
                double cs_heavy = -999.9;
                int t = 0;
                while (t < vecILVResons.size()) {
                    H1CS h1csHeavy = vecILVResons.elementAt(t);
                    double cs_Temp = h1csHeavy.getH1CS();
                    String atomT = h1csHeavy.getAtomName();
                    int resNoT = h1csHeavy.getResidueNo();
                    if (resNoT == resNo && atomT.equalsIgnoreCase(heavyName)) {
                        cs_heavy = cs_Temp;
                    }
                    ++t;
                }
                if (Math.abs(csH1 - cs_proton) < errWin_h1 && Math.abs(csHeavy - cs_heavy) < errWin_heavy) {
                    isFirstProtonIn = true;
                    break;
                }
                ++j;
            }
            j = 0;
            while (j < vecILVResons.size()) {
                h1cs = vecILVResons.elementAt(j);
                cs_proton = h1cs.getH1CS();
                if (Math.abs(csH2 - cs_proton) < errWin_h2) {
                    isSecondProtonIn = true;
                    break;
                }
                ++j;
            }
            if (isFirstProtonIn && isSecondProtonIn) {
                vecILVNoesy.add(noesy);
            }
            ++i;
        }
        return vecILVNoesy;
    }

    public static void main(String[] args) throws JampackException {
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String strOut = String.valueOf(userDir) + "/outFiles/";
        String strParametersFileName = "Nasca.input";
        ILVTest test = new ILVTest();
        test.doILVTest(src, strOut, strParametersFileName);
    }

    public void doILVTest(String src, String strOut, String strInput) throws JampackException {
        boolean isDebug = false;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        NascaNew nasca = new NascaNew();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        int nIs4DNoesy = 0;
        String strReson = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strResNameScheme = "";
        String strIsCheckLongAA = "";
        String strHaNoesy3D = "";
        String strResFormat = "";
        String strBB = "";
        String stroutName = "";
        String strNoesyFormat = "";
        String strOutOrFormat = "";
        String strIsCheck = "";
        String strRefPdb = "";
        String strRefNameSchem = "";
        String strIsWholeStr = "";
        String strPdbNameScheme = "";
        String str4DNoesy = "";
        String stroutResonName = "";
        String strOutResonFormat = "";
        int nIsoriginalUp = 0;
        double noeLimit = 0.0;
        double metCor = 0.0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("PDBNAMESCHEME")) {
                strPdbNameScheme = paraMap.get("PDBNAMESCHEME");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("NOELIMIT")) {
                noeLimit = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("IS4DNOESY")) {
                nIs4DNoesy = Integer.parseInt(paraMap.get("IS4DNOESY"));
            }
            if (paraMap.containsKey("4D-NOESY")) {
                str4DNoesy = paraMap.get("4D-NOESY");
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            if (paraMap.containsKey("RESNAMESCHEME")) {
                strResNameScheme = paraMap.get("RESNAMESCHEME");
            }
            if (paraMap.containsKey("NOESY-FORMAT")) {
                strNoesyFormat = paraMap.get("NOESY-FORMAT");
            }
            if (paraMap.containsKey("ISCHECKLONGAA")) {
                strIsCheckLongAA = paraMap.get("ISCHECKLONGAA");
            }
            if (paraMap.containsKey("ISCHECK")) {
                strIsCheck = paraMap.get("ISCHECK");
            }
            if (paraMap.containsKey("REFPDB")) {
                strRefPdb = paraMap.get("REFPDB");
            }
            if (paraMap.containsKey("METHYL-CORRECTION")) {
                metCor = Double.parseDouble(paraMap.get("METHYL-CORRECTION"));
            }
            if (paraMap.containsKey("REFNAMESCHEME")) {
                strRefNameSchem = paraMap.get("REFNAMESCHEME");
            }
            if (paraMap.containsKey("ISWHOLESTRUCTURE")) {
                strIsWholeStr = paraMap.get("ISWHOLESTRUCTURE");
            }
            if (paraMap.containsKey("ISOUTORFORMAT")) {
                strOutOrFormat = paraMap.get("ISOUTORFORMAT");
            }
            if (paraMap.containsKey("OUTRESONANCENAME")) {
                stroutResonName = paraMap.get("OUTRESONANCENAME");
            }
            if (paraMap.containsKey("OUTRESONANCEFORMAT")) {
                strOutResonFormat = paraMap.get("OUTRESONANCEFORMAT");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<H1CS> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        Vector<Object> Noe4DVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!str4DNoesy.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + str4DNoesy;
            Noe4DVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView4D(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNoesy4D = new Vector<Noesy>();
        vecNoesy4D.addAll(Noe4DVec);
        Vector<Object> vecNewNoesy = new Vector();
        if (vecNoesy.size() > 0) {
            vecNewNoesy = noesy.SetCalibration(vecNoesy);
        }
        Vector<Object> vecNewNoesy4D = new Vector();
        if (vecNoesy4D.size() > 0) {
            vecNewNoesy4D = noesy.SetCalibration(vecNoesy4D);
        }
        double[] constant = new double[1];
        Vector<Pdb> vecSSE = new Vector<Pdb>();
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        String pdbFile = String.valueOf(src) + strBB;
        Vector<Pdb> pdbVecBB = pp.readPdb(pdbFile);
        Vector<Pdb> pdbVecNew = new Vector();
        pdbVecNew = strIsWholeStr.equalsIgnoreCase("1") ? pp.residueNameUpdateNoStr(vecSeq, pdbVecBB) : pp.residueNameUpdate(vecSeq, pdbVecBB);
        Vector<Object> pdbVecNewSec = new Vector();
        if (strPdbNameScheme.equalsIgnoreCase("PDB-OLD")) {
            pdbVecNewSec = pp.nameConvertOrder(pdbVecNew);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecNew);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-OLD")) {
            Vector<Pdb> pdbVecSSE22 = pp.nameConvertOrder(pdbVecNew);
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecSSE22);
        } else {
            pdbVecNewSec.addAll(pdbVecNew);
        }
        Vector<Object> vecStructureAll = new Vector<Object>();
        vecStructureAll.addAll(pdbVecNewSec);
        Vector<Pdb> vecBBTemp = pp.OutputBackbone(pdbVecNewSec);
        pdbVecNewSec = new Vector();
        pdbVecNewSec.addAll(vecBBTemp);
        Vector<H1CS> vecILVResons = this.extractILVChemicalShifts(assignVec);
        stroutName = "/outFiles/ILV_CS.prot";
        String userDir = System.getProperty("user.dir");
        H1CS h1cs = new H1CS();
        String outResFileName = String.valueOf(userDir) + stroutName;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outResFileName)));
            if (strOutResonFormat.equalsIgnoreCase("CYANA")) {
                h1cs.PrintAllAssignmentToFileCyana(vecILVResons, out);
            } else {
                h1cs.PrintAllAssignmentToFileBMRB(vecILVResons, out);
            }
            out.close();
            System.out.println("The NOE assignment table has been generated in " + outResFileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + outResFileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Vector<Noesy> vecILVNoesy = this.extractILVNoesyPeaks(vecNoesy, vecILVResons);
        String strOutNoesyName = "";
        strOutNoesyName = strNoesyFormat.equalsIgnoreCase("XEASY") ? "/outFiles/ILV_Noesy.PEAKS" : "/outFiles/ILV_Noesy.XPK";
        String outNoesyFileName = String.valueOf(userDir) + strOutNoesyName;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outNoesyFileName)));
            if (strNoesyFormat.equalsIgnoreCase("XEASY")) {
                noesy.PrintAllNoesyToFileXEASY(vecILVNoesy, out);
            } else {
                noesy.PrintAllNoesyToFileNMRView(vecILVNoesy, out);
            }
            out.close();
            System.out.println("The NOE assignment table has been generated in " + outNoesyFileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + outResFileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }
}

