/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Cartesian;
import rdcPanda.Model;
import rdcPanda.Pdb;
import rdcPanda.RotaPattern;

public class GraphCut {
    private int MAX_ROT_NUM = 35;
    private int MAX_DEGREE = 35;
    private String resName = "";
    private int resNo = -1;
    private boolean[] isRemained = new boolean[this.MAX_ROT_NUM];
    private double[] homoScore = new double[this.MAX_ROT_NUM];
    private double[][][] pairScore = new double[this.MAX_ROT_NUM][this.MAX_DEGREE][this.MAX_ROT_NUM];
    private int nLabel = -1;
    private Vector vecAllRot = new Vector();
    private Vector vecNeighbors = new Vector();
    Vector vecRotScore = new Vector();

    public GraphCut() {
        this.resName = null;
        this.resNo = 0;
        this.nLabel = 0;
        this.vecAllRot = null;
        this.vecNeighbors = null;
        int i = 0;
        while (i < this.MAX_ROT_NUM) {
            this.isRemained[i] = true;
            ++i;
        }
    }

    public GraphCut(int resNO) {
        this.resName = null;
        this.resNo = resNO;
        this.nLabel = 0;
        this.vecAllRot = null;
        this.vecNeighbors = null;
        int i = 0;
        while (i < this.MAX_ROT_NUM) {
            this.isRemained[i] = true;
            ++i;
        }
    }

    public GraphCut(String res, int res_no, int label, Vector vecAllRots) {
        this.resName = res;
        this.resNo = res_no;
        this.nLabel = label;
        this.vecAllRot = vecAllRots;
        this.vecNeighbors = new Vector();
        int i = 0;
        while (i < vecAllRots.size()) {
            this.isRemained[i] = true;
            ++i;
        }
    }

    public GraphCut(String res, int res_no, int label, Vector vecAllRots, Vector vecNearPdbs) {
        this.resName = res;
        this.resNo = res_no;
        this.nLabel = label;
        this.vecAllRot = new Vector();
        this.vecAllRot = vecAllRots;
        this.vecNeighbors = new Vector();
        this.vecNeighbors.addAll(vecNearPdbs);
        int i = 0;
        while (i < vecAllRots.size()) {
            this.isRemained[i] = true;
            ++i;
        }
    }

    public int getResidueNo() {
        return this.resNo;
    }

    public String getResidueName() {
        return this.resName;
    }

    public int getRotLabel() {
        return this.nLabel;
    }

    public Vector getAllRotVec() {
        return this.vecAllRot;
    }

    public Vector getNeighborVec() {
        return this.vecNeighbors;
    }

    public double getHomoScore(int nRotLabel) {
        return this.homoScore[nRotLabel];
    }

    public double getPairScore(int rotID, int neighID, int neighRotID) {
        return this.pairScore[rotID][neighID][neighRotID];
    }

    public boolean getIsRemainedLabel(int nID) {
        return this.isRemained[nID];
    }

    public Vector getRotScoreVec() {
        return this.vecRotScore;
    }

    public Vector getTopScoreRots(int pickNum) {
        Vector<Pdb> vecPdbRots = new Vector<Pdb>();
        int i = 0;
        while (i < Math.min(pickNum, this.vecRotScore.size())) {
            RotScore rotSc = (RotScore)this.vecRotScore.elementAt(i);
            Pdb pp = rotSc.getRotPdb();
            vecPdbRots.add(pp);
            ++i;
        }
        return vecPdbRots;
    }

    public void setRotlabel(int label) {
        this.nLabel = label;
    }

    public void setHomoScore(double sc, int nRotID) {
        this.homoScore[nRotID] = sc;
    }

    public void setPairScore(double sc, int nRotID, int nNeighborID, int nNeighborRotID) {
        this.pairScore[nRotID][nNeighborID][nNeighborRotID] = sc;
    }

    public void setPrunedLabel(int nRotLabl) {
        this.isRemained[nRotLabl] = false;
    }

    public void setNeighbors(Vector vecNeigh) {
        this.vecNeighbors.addAll(vecNeigh);
    }

    public void setInitialRotScore() {
        this.vecRotScore = new Vector();
        int i = 0;
        while (i < this.vecAllRot.size()) {
            Pdb pdbRotamer = (Pdb)this.vecAllRot.elementAt(i);
            double dbHomoSc = this.getHomoScore(i);
            this.vecRotScore.add(new RotScore(i, pdbRotamer, dbHomoSc));
            ++i;
        }
        Collections.sort(this.vecRotScore, new RotScoreComparator());
    }

    public void sortRotScore() {
        Collections.sort(this.vecRotScore, new RotScoreComparator());
    }

    public void addRotScore(int no, double sc) {
        RotScore rtSc = (RotScore)this.vecRotScore.elementAt(no);
        rtSc.addScore(sc);
    }

    public int RandomSelectRot(Vector vecRotScore) {
        long seed = 1222L;
        Random r = new Random(seed);
        int pkNo = 0;
        double sumTemp = 0.0;
        int i = 0;
        while (i < vecRotScore.size()) {
            RotScore rotSc = (RotScore)vecRotScore.elementAt(i);
            sumTemp += rotSc.getRotScore();
            ++i;
        }
        double dbRand = r.nextDouble() * sumTemp;
        double tempPre = 0.0;
        double tempAfter = 0.0;
        int i2 = 0;
        while (i2 < vecRotScore.size()) {
            RotScore rotSc = (RotScore)vecRotScore.elementAt(i2);
            double dbSc = rotSc.getRotScore();
            tempAfter = tempPre + dbSc;
            if (tempPre < dbRand && dbRand < tempAfter) {
                pkNo = i2;
                break;
            }
            tempPre = tempAfter;
            ++i2;
        }
        pkNo = 0;
        return pkNo;
    }

    public Vector GraphConstruction(Vector vecPdbBB, String srcRotFile, double noeLimit) throws JampackException {
        Vector<GraphCut> vecResGraph = new Vector<GraphCut>();
        Pdb pp = new Pdb();
        Model md = new Model();
        int i = 0;
        while (i < vecPdbBB.size()) {
            Pdb pdb = (Pdb)vecPdbBB.elementAt(i);
            Vector<Pdb> vecOriginPdb = new Vector<Pdb>();
            vecOriginPdb.add(pdb);
            String resName = pdb.getResidue();
            int resNo = pdb.getResidueNo();
            Vector<Pdb> pdbRotVec = new Vector<Pdb>();
            if (resName.equalsIgnoreCase("GLY")) {
                pdbRotVec.add(pdb);
            } else {
                Vector<Object> pdbRotam = new Vector();
                Vector pdbRotamNewStr = new Vector();
                String rotamFile = String.valueOf(srcRotFile) + resName.toLowerCase() + ".pdb";
                pdbRotam = pp.readPdb(rotamFile);
                pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
                pdbRotVec.addAll(pdbRotamNewStr);
            }
            Vector vecPdbRotNew = md.BackonbeRotation(pdbRotVec, vecOriginPdb);
            vecResGraph.add(new GraphCut(resName, resNo, 0, vecPdbRotNew));
            ++i;
        }
        Cartesian cc = new Cartesian();
        Cartesian cc2 = new Cartesian();
        String atom = "";
        String atom2 = "";
        double[] proton = new double[3];
        double[] proton2 = new double[3];
        int i2 = 0;
        while (i2 < vecResGraph.size()) {
            GraphCut gc = (GraphCut)vecResGraph.elementAt(i2);
            Vector vecPdb = gc.getAllRotVec();
            Vector<GraphCut> vecNeighbors = new Vector<GraphCut>();
            int i22 = 0;
            while (i22 < vecResGraph.size()) {
                boolean isFound = false;
                if (i22 != i2) {
                    GraphCut gc2 = (GraphCut)vecResGraph.elementAt(i22);
                    Vector vecPdb2 = gc2.getAllRotVec();
                    int j = 0;
                    while (j < vecPdb.size()) {
                        Pdb pdb = (Pdb)vecPdb.elementAt(j);
                        Vector<Cartesian> vecAtom = pdb.getAtomVec();
                        int k = 0;
                        while (k < vecAtom.size()) {
                            cc = vecAtom.elementAt(k);
                            atom = cc.getAtom();
                            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                                proton = cc.getXYZ();
                                int j2 = 0;
                                while (j2 < vecPdb2.size()) {
                                    Pdb pdb2 = (Pdb)vecPdb2.elementAt(j2);
                                    Vector<Cartesian> vecAtom2 = pdb2.getAtomVec();
                                    int k2 = 0;
                                    while (k2 < vecAtom2.size()) {
                                        double disTemp;
                                        cc2 = vecAtom2.elementAt(k2);
                                        atom2 = cc2.getAtom();
                                        if (atom2.substring(0, 1).equalsIgnoreCase("H") && (disTemp = Math.sqrt((proton[0] - (proton2 = cc2.getXYZ())[0]) * (proton[0] - proton2[0]) + (proton[1] - proton2[1]) * (proton[1] - proton2[1]) + (proton[2] - proton2[2]) * (proton[2] - proton2[2]))) < noeLimit) {
                                            isFound = true;
                                            break;
                                        }
                                        ++k2;
                                    }
                                    if (isFound) break;
                                    ++j2;
                                }
                                if (isFound) break;
                            }
                            ++k;
                        }
                        if (isFound) break;
                        ++j;
                    }
                    if (isFound) {
                        vecNeighbors.add(gc2);
                    }
                }
                ++i22;
            }
            gc.setNeighbors(vecNeighbors);
            ++i2;
        }
        return vecResGraph;
    }

    public Vector ComputeScoringFunction(Vector vecGraphCut, Vector vecBB, Vector assignVec, Vector NoesyVec, double csErrH, double csErrN, double csErrCA, double distBound) {
        Vector vecGraphCutNew = new Vector();
        vecGraphCutNew.addAll(vecGraphCut);
        Pdb pp = new Pdb();
        Assign asg = new Assign();
        RotaPattern rotPattern = new RotaPattern();
        int i = 0;
        while (i < vecGraphCutNew.size()) {
            System.out.println("i=" + i);
            GraphCut gc = (GraphCut)vecGraphCutNew.elementAt(i);
            Vector vecRotPdbs = gc.getAllRotVec();
            int residueNO = gc.getResidueNo();
            String rotamResName = gc.getResidueName();
            Vector vecBackNoe = new Vector();
            Vector vecHdist = new Vector();
            Pdb pdbRotamer = new Pdb();
            double dbScore = 0.0;
            int j = 0;
            while (j < vecRotPdbs.size()) {
                vecHdist = new Vector();
                vecBackNoe = new Vector();
                Vector<Pdb> vecRotamer = new Vector<Pdb>();
                pdbRotamer = (Pdb)vecRotPdbs.elementAt(j);
                vecRotamer.add(pdbRotamer);
                vecHdist = pp.compDistPatternForRotam(vecRotamer, residueNO, vecBB, distBound);
                vecBackNoe = rotPattern.BackCompNoePattern(assignVec, residueNO, rotamResName, vecHdist);
                int[] numPeaks = new int[1];
                dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoe, NoesyVec, numPeaks, false);
                dbScore = -Math.log(dbScore);
                gc.setHomoScore(dbScore, j);
                ++j;
            }
            dbScore = 0.0;
            Vector vecNeighs = gc.getNeighborVec();
            System.out.println("here we consider pairwise: i=" + i + " neighbor size=" + vecNeighs.size());
            int j2 = 0;
            while (j2 < vecRotPdbs.size()) {
                Pdb pdbA = (Pdb)vecRotPdbs.elementAt(j2);
                int k = 0;
                while (k < vecNeighs.size()) {
                    GraphCut gcB = (GraphCut)vecNeighs.elementAt(k);
                    Vector vecRotPdbsB = gcB.getAllRotVec();
                    int resNOB = gcB.getResidueNo();
                    int h = 0;
                    while (h < vecRotPdbsB.size()) {
                        Pdb pdbB = (Pdb)vecRotPdbsB.elementAt(h);
                        vecHdist = new Vector();
                        vecBackNoe = new Vector();
                        vecHdist = pp.compDistPatternFromPairRotams(residueNO, resNOB, pdbA, pdbB, distBound);
                        vecBackNoe = rotPattern.BackCompNoePattern(assignVec, residueNO, rotamResName, vecHdist);
                        int[] numPeaks = new int[1];
                        dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoe, NoesyVec, numPeaks, false);
                        dbScore = -Math.log(dbScore);
                        gc.setPairScore(dbScore, j2, k, h);
                        ++h;
                    }
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        return vecGraphCutNew;
    }

    public Vector DEECut(Vector vecGraphCutPre) {
        Vector vecGraphCut = new Vector();
        vecGraphCut.addAll(vecGraphCutPre);
        int i = 0;
        while (i < vecGraphCut.size()) {
            GraphCut gc = (GraphCut)vecGraphCut.elementAt(i);
            Vector vecRots = gc.getAllRotVec();
            Vector vecNeighs = gc.getNeighborVec();
            int j = 0;
            while (j < vecRots.size()) {
                double homoSc;
                double allSc = homoSc = gc.getHomoScore(j);
                boolean isPruned = false;
                int k = 0;
                while (k < vecNeighs.size()) {
                    GraphCut gcNeigh = (GraphCut)vecNeighs.elementAt(k);
                    Vector vecRotsNeigh = gcNeigh.getAllRotVec();
                    double pairMinSc = 1000.0;
                    int inMinRotID = 0;
                    int h = 0;
                    while (h < vecRotsNeigh.size()) {
                        double pairSc = gc.getPairScore(j, k, h);
                        if (pairSc < pairMinSc) {
                            pairMinSc = pairSc;
                            inMinRotID = h;
                        }
                        ++h;
                    }
                    allSc += pairMinSc;
                    ++k;
                }
                int j2 = 0;
                while (j2 < vecRots.size()) {
                    if (j2 != j) {
                        double allScOther = gc.getHomoScore(j2);
                        int k2 = 0;
                        while (k2 < vecNeighs.size()) {
                            GraphCut gcNeigh = (GraphCut)vecNeighs.elementAt(k2);
                            Vector vecRotsNeigh = gcNeigh.getAllRotVec();
                            double pairMaxSc = -1000.0;
                            int inMaxRotID = 0;
                            int h = 0;
                            while (h < vecRotsNeigh.size()) {
                                double pairSc = gc.getPairScore(j2, k2, h);
                                if (pairSc > pairMaxSc) {
                                    pairMaxSc = pairSc;
                                    inMaxRotID = h;
                                }
                                ++h;
                            }
                            allScOther += pairMaxSc;
                            ++k2;
                        }
                        if (allSc > allScOther) {
                            isPruned = true;
                            break;
                        }
                    }
                    ++j2;
                }
                if (isPruned) {
                    gc.setPrunedLabel(j);
                }
                ++j;
            }
            ++i;
        }
        Vector<GraphCut> vecGraphCutNew = new Vector<GraphCut>();
        int i2 = 0;
        while (i2 < vecGraphCut.size()) {
            GraphCut gc = (GraphCut)vecGraphCut.elementAt(i2);
            String residueName = gc.getResidueName();
            int residueNo = gc.getResidueNo();
            Vector vecAllRots = gc.getAllRotVec();
            Vector vecNeighsRots = gc.getNeighborVec();
            Vector<Pdb> vecAllRotsNew = new Vector<Pdb>();
            int j = 0;
            while (j < vecAllRots.size()) {
                Pdb pp = (Pdb)vecAllRots.elementAt(j);
                if (gc.getIsRemainedLabel(j)) {
                    vecAllRotsNew.add(pp);
                }
                ++j;
            }
            vecGraphCutNew.add(new GraphCut(residueName, residueNo, 0, vecAllRotsNew, vecNeighsRots));
            ++i2;
        }
        return vecGraphCutNew;
    }

    public Vector ShufflingCut(Vector vecGraphCutPre) {
        Vector vecRots;
        GraphCut gc;
        Vector vecGraphCut = new Vector();
        vecGraphCut.addAll(vecGraphCutPre);
        int i = 0;
        while (i < vecGraphCut.size()) {
            gc = (GraphCut)vecGraphCut.elementAt(i);
            vecRots = gc.getAllRotVec();
            int rotSize = vecRots.size();
            Random randGen = new Random();
            int nLabelPk = randGen.nextInt(rotSize);
            while (!gc.getIsRemainedLabel(nLabelPk)) {
                nLabelPk = randGen.nextInt(rotSize);
            }
            gc.setRotlabel(nLabelPk);
            ++i;
        }
        i = 0;
        while (i < vecGraphCut.size()) {
            gc = (GraphCut)vecGraphCut.elementAt(i);
            vecRots = gc.getAllRotVec();
            Vector vecNeighs = gc.getNeighborVec();
            int nRotLabl = gc.getRotLabel();
            int j = 0;
            while (j < vecRots.size()) {
                double allScore = gc.getHomoScore(j);
                Vector vecGCTemp = new Vector();
                vecGCTemp.addAll(vecGraphCut);
                int k = 0;
                while (k < vecNeighs.size()) {
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return vecGraphCut;
    }

    public Vector RotamerSelection(Vector pdbBBVec, Vector vecGraphCut, int pickNum) {
        Pdb pp = new Pdb();
        Vector<Pdb> vecGrowPdb = new Vector<Pdb>();
        vecGrowPdb = pdbBBVec;
        Vector pdbRotamNewRef = new Vector();
        int j = 0;
        while (j < pdbBBVec.size()) {
            Vector<Pdb> vecTemp;
            Pdb pdb = (Pdb)vecGrowPdb.elementAt(j);
            String residueName = pdb.getResidue();
            int residueNo = pdb.getResidueNo();
            pdbRotamNewRef = new Vector();
            GraphCut gc = new GraphCut();
            int ind1 = Collections.binarySearch(vecGraphCut, new GraphCut(residueNo), new ResNoComparator());
            gc = (GraphCut)vecGraphCut.elementAt(ind1);
            int indRef = Collections.binarySearch(vecGrowPdb, new Pdb(residueNo), new Pdb.PdbComparator());
            if (indRef >= 0) {
                pdbRotamNewRef = gc.getTopScoreRots(pickNum);
            }
            vecGrowPdb = vecTemp = pp.CombinRotBB(pdbRotamNewRef, vecGrowPdb, residueNo);
            ++j;
        }
        return vecGrowPdb;
    }

    public Vector RandomVotingUpdate(Vector vecGraphCut) {
        GraphCut gc;
        Vector vecGraphCutNew = new Vector();
        vecGraphCutNew.addAll(vecGraphCut);
        int i = 0;
        while (i < vecGraphCutNew.size()) {
            gc = (GraphCut)vecGraphCutNew.elementAt(i);
            gc.setInitialRotScore();
            ++i;
        }
        i = 0;
        while (i < vecGraphCutNew.size()) {
            gc = (GraphCut)vecGraphCutNew.elementAt(i);
            Vector vecRotScore = gc.getRotScoreVec();
            Vector vecNeighs = gc.getNeighborVec();
            int j = 0;
            while (j < vecNeighs.size()) {
                GraphCut gcNeigh = (GraphCut)vecNeighs.elementAt(j);
                Vector vecNeighRotSc = gcNeigh.getRotScoreVec();
                int pkNo = this.RandomSelectRot(vecNeighRotSc);
                RotScore rtScore = (RotScore)vecNeighRotSc.elementAt(pkNo);
                int pkOrignNo = rtScore.getOriginID();
                int k = 0;
                while (k < vecRotScore.size()) {
                    RotScore rtScoreTemp = (RotScore)vecRotScore.elementAt(k);
                    int curRotId = rtScoreTemp.getOriginID();
                    double dbTemp = gc.getPairScore(curRotId, j, pkOrignNo);
                    gc.addRotScore(k, dbTemp);
                    ++k;
                }
                ++j;
            }
            gc.sortRotScore();
            ++i;
        }
        return vecGraphCutNew;
    }

    public static class ResNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            GraphCut n1 = (GraphCut)o1;
            GraphCut n2 = (GraphCut)o2;
            int d1 = n1.getResidueNo();
            if (d1 < (d2 = n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public class RotScore {
        Pdb pdbRot = new Pdb();
        double dbMatchSc = 0.0;
        int nOrignID = 0;

        public RotScore() {
            this.pdbRot = new Pdb();
            this.dbMatchSc = 0.0;
            this.nOrignID = 0;
        }

        public RotScore(int ID, Pdb pdb, double sc) {
            this.nOrignID = ID;
            this.pdbRot = pdb;
            this.dbMatchSc = sc;
        }

        public RotScore(Pdb pdb, double sc) {
            this.nOrignID = 0;
            this.pdbRot = pdb;
            this.dbMatchSc = sc;
        }

        public double getRotScore() {
            return this.dbMatchSc;
        }

        public Pdb getRotPdb() {
            return this.pdbRot;
        }

        public int getOriginID() {
            return this.nOrignID;
        }

        public void setScore(double sc) {
            this.dbMatchSc = sc;
        }

        public void addScore(double sc) {
            this.dbMatchSc += sc;
        }

        public void setOriginID(int id) {
            this.nOrignID = id;
        }
    }

    public static class RotScoreComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            RotScore n1 = (RotScore)o1;
            RotScore n2 = (RotScore)o2;
            double d1 = n1.getRotScore();
            if (d1 < (d2 = n2.getRotScore())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

