/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Nasca;
import rdcPanda.Noe;
import rdcPanda.Pdb;
import rdcPanda.Peak;

public class H1CS {
    private int residueNo;
    private String atomName;
    private String residue;
    private double csH1;
    private double csLower = -99.9;
    private double csUpper = -99.9;
    private double csAverage = -99.9;
    private double csSigma = -99.9;
    public int protonID = -1;
    public int resonID = -1;

    public H1CS() {
        this.residueNo = 0;
        this.residue = null;
        this.atomName = null;
        this.csH1 = 0.0;
    }

    public H1CS(int no) {
        this.residueNo = no;
        this.residue = null;
        this.atomName = null;
        this.csH1 = 0.0;
    }

    public H1CS(int no, String resid, String atomid) {
        this.residueNo = no;
        this.residue = resid;
        this.atomName = atomid;
        this.csH1 = 0.0;
    }

    public H1CS(int no, String resid, String atomid, double cs, int proton_id, int reson_id) {
        this.residueNo = no;
        this.residue = resid;
        this.atomName = atomid;
        this.csH1 = cs;
        this.protonID = proton_id;
        this.resonID = reson_id;
    }

    public H1CS(int no, String resid, String atomid, double cs) {
        this.residueNo = no;
        this.residue = resid;
        this.atomName = atomid;
        this.csH1 = cs;
    }

    public H1CS(int no, String resid, String atomid, double csL, double csU) {
        this.residueNo = no;
        this.residue = resid;
        this.atomName = atomid;
        this.csLower = csL;
        this.csUpper = csU;
    }

    public H1CS(int no, String resid, String atomid, double csL, double csU, double cs_ave, double cs_sigma) {
        this.residueNo = no;
        this.residue = resid;
        this.atomName = atomid;
        this.csLower = csL;
        this.csUpper = csU;
        this.csAverage = cs_ave;
        this.csSigma = cs_sigma;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidueType() {
        return this.residue;
    }

    public String getAtomName() {
        return this.atomName;
    }

    public double getH1CS() {
        return this.csH1;
    }

    public double getCSLower() {
        return this.csLower;
    }

    public double getCSAverage() {
        return this.csAverage;
    }

    public double getCSSigma() {
        return this.csSigma;
    }

    public double getCSUpper() {
        return this.csUpper;
    }

    public void setResidueNo(int R) {
        this.residueNo = R;
    }

    public void setResidueType(String R) {
        this.residue = R;
    }

    public void setAtomName(String R) {
        this.atomName = R;
    }

    public void setCS(double cs) {
        this.csH1 = cs;
    }

    public void PrintAllAssignmentToFileCyana(Vector vecH1CS, PrintWriter out) {
        int preNo = -99;
        int i = 0;
        while (i < vecH1CS.size()) {
            H1CS h1cs = (H1CS)vecH1CS.elementAt(i);
            int resNo = h1cs.getResidueNo();
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            double cs_h = h1cs.getH1CS();
            String strCS = String.format("%.3f", cs_h);
            out.println(String.valueOf(i) + "\t\t" + strCS + "\t\t" + 0.0 + "\t\t" + atom + "\t\t" + resNo);
            ++i;
        }
    }

    public void PrintAllAssignmentCyana(Vector vecH1CS) {
        System.out.println("The computed resonance assignments in CYANA format are:");
        int preNo = -99;
        int i = 0;
        while (i < vecH1CS.size()) {
            H1CS h1cs = (H1CS)vecH1CS.elementAt(i);
            int resNo = h1cs.getResidueNo();
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            double cs_h = h1cs.getH1CS();
            System.out.println(String.valueOf(i) + "\t\t" + cs_h + "\t\t" + 0.0 + "\t\t" + atom + "\t\t" + resNo);
            ++i;
        }
    }

    public void PrintAllAssignmentToFileBMRB(Vector vecH1CS, PrintWriter out) {
        int preNo = -99;
        int counter = 1;
        int i = 0;
        while (i < vecH1CS.size()) {
            H1CS h1cs = (H1CS)vecH1CS.elementAt(i);
            int resNo = h1cs.getResidueNo();
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            double cs_h = h1cs.getH1CS();
            String strCS = String.format("%.3f", cs_h);
            out.println(String.valueOf(counter) + "\t\t" + resNo + "\t\t" + res + "\t\t" + atom + "\t" + atom.substring(0, 1) + "  " + strCS + "  " + 0.0 + "\t\t" + 1);
            ++counter;
            ++i;
        }
    }

    public void PrintAllAssignmentToFileBMRB(Vector vecH1CS, String fileName) {
        int counter = 1;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int i = 0;
            while (i < vecH1CS.size()) {
                H1CS h1cs = (H1CS)vecH1CS.elementAt(i);
                int resNo = h1cs.getResidueNo();
                String res = h1cs.getResidueType();
                String atom = h1cs.getAtomName();
                double cs_h = h1cs.getH1CS();
                if (!(cs_h < -200.0)) {
                    String strCS = String.format("%.3f", cs_h);
                    out.println(String.valueOf(counter) + "\t\t" + resNo + "\t\t" + res + "\t\t" + atom + "\t" + atom.substring(0, 1) + "  " + strCS + "  " + 0.0 + "\t\t" + 1);
                    ++counter;
                }
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public void PrintAllAssignment(Vector vecH1CS) {
        System.out.println("The exact assignments are:");
        int preNo = -99;
        int i = 0;
        while (i < vecH1CS.size()) {
            H1CS h1cs = (H1CS)vecH1CS.elementAt(i);
            int resNo = h1cs.getResidueNo();
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            double cs_h = h1cs.getH1CS();
            if (resNo == preNo) {
                System.out.println("        " + atom + " : " + cs_h);
            } else {
                System.out.println(String.valueOf(resNo) + "-" + res + " : ");
                System.out.println("        " + atom + " : " + cs_h);
            }
            preNo = resNo;
            ++i;
        }
    }

    public Vector<H1CS> h1CSReader(String filename, Vector vecSeq) {
        Vector<H1CS> inputs = new Vector<H1CS>();
        double csH1 = 0.0;
        double csSigma = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String aaType = "";
        String ss = "";
        String atomName = "";
        String resName = "";
        int resNo = 0;
        int csID = 0;
        Noe noe = new Noe();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            while (true) {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    csID = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens() && ((csH1 = new Double(st.nextToken()).doubleValue()) > 300.0 || csH1 < -300.0)) {
                    ss = in.readLine();
                    if (ss != null && (!ss.equalsIgnoreCase("") || (ss = in.readLine()) != null)) continue;
                    break;
                }
                if (st.hasMoreTokens()) {
                    csSigma = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    resNo = Integer.parseInt(st.nextToken());
                }
                if (atomName.substring(0, 1).equalsIgnoreCase("Q")) {
                    atomName = "H" + atomName.substring(1, atomName.length());
                }
                resName = "";
                int i = 0;
                while (i < vecSeq.size()) {
                    Assign assign = (Assign)vecSeq.elementAt(i);
                    if (resNo == assign.getResidueNo()) {
                        resName = assign.getResidueType();
                    }
                    ++i;
                }
                if (!resName.trim().equalsIgnoreCase("")) {
                    atomName = noe.UpdateNOEAtomName2(resName, atomName);
                }
                inputs.add(new H1CS(resNo, resName, atomName, csH1));
                ss = in.readLine();
                if (ss == null || ss.equalsIgnoreCase("") && (ss = in.readLine()) == null) break;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector<H1CS> h1CSReaderWQ(String filename, Vector vecSeq) {
        Vector<H1CS> inputs = new Vector<H1CS>();
        double csH1 = 0.0;
        double csSigma = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String aaType = "";
        String ss = "";
        String atomName = "";
        String resName = "";
        int resNo = 0;
        int csID = 0;
        Noe noe = new Noe();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            while (true) {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    csID = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens() && ((csH1 = new Double(st.nextToken()).doubleValue()) > 300.0 || csH1 < -300.0)) {
                    ss = in.readLine();
                    if (ss != null && (!ss.equalsIgnoreCase("") || (ss = in.readLine()) != null)) continue;
                    break;
                }
                if (st.hasMoreTokens()) {
                    csSigma = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    resNo = Integer.parseInt(st.nextToken());
                }
                resName = "";
                int i = 0;
                while (i < vecSeq.size()) {
                    Assign assign = (Assign)vecSeq.elementAt(i);
                    if (resNo == assign.getResidueNo()) {
                        resName = assign.getResidueType();
                    }
                    ++i;
                }
                atomName = noe.UpdateNOEAtomName2(resName, atomName);
                inputs.add(new H1CS(resNo, resName, atomName, csH1));
                ss = in.readLine();
                if (ss == null || ss.equalsIgnoreCase("") && (ss = in.readLine()) == null) break;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector<H1CS> DeleteRepeatAsg(Vector<H1CS> vecAsg) {
        Vector<H1CS> vecAsgNew = new Vector<H1CS>();
        int i = 0;
        while (i < vecAsg.size()) {
            H1CS h1cs = vecAsg.elementAt(i);
            int resNo = h1cs.getResidueNo();
            String atom = h1cs.getAtomName();
            boolean isExist = false;
            int j = 0;
            while (j < vecAsgNew.size()) {
                H1CS h1csNew = vecAsgNew.elementAt(j);
                int resNoNew = h1csNew.getResidueNo();
                String atomNew = h1csNew.getAtomName();
                if (resNo == resNoNew && atom.equalsIgnoreCase(atomNew)) {
                    isExist = true;
                }
                ++j;
            }
            if (!isExist) {
                vecAsgNew.add(h1cs);
            }
            ++i;
        }
        return vecAsgNew;
    }

    public Vector GenerateStereoAsg(Vector vecSrcAsg) {
        int k = 0;
        while (k < vecSrcAsg.size()) {
            H1CS h1cs = (H1CS)vecSrcAsg.elementAt(k);
            int resRefNo = h1cs.getResidueNo();
            String resRef = h1cs.getResidueType();
            String atomRef = h1cs.getAtomName();
            double csRef = h1cs.getH1CS();
            String subAtomTwo = "";
            subAtomTwo = atomRef.length() > 2 ? atomRef.substring(0, 2) : atomRef;
            String atomRefStereo = "";
            if (subAtomTwo.equalsIgnoreCase("HB") && (resRef.equalsIgnoreCase("CYS") || resRef.equalsIgnoreCase("ASP") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("HIS") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("LEU") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("ASN") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("SER") || resRef.equalsIgnoreCase("TRP") || resRef.equalsIgnoreCase("TYR"))) {
                if (atomRef.equalsIgnoreCase("HB1")) {
                    atomRefStereo = "HB2";
                } else if (atomRef.equalsIgnoreCase("HB2")) {
                    atomRefStereo = "HB1";
                }
            }
            if (subAtomTwo.equalsIgnoreCase("HA") && resRef.equalsIgnoreCase("GLY")) {
                if (atomRef.equalsIgnoreCase("HA1")) {
                    atomRefStereo = "HA2";
                } else if (atomRef.equalsIgnoreCase("HA2")) {
                    atomRefStereo = "HA1";
                }
            }
            if ((subAtomTwo.equalsIgnoreCase("HG") || subAtomTwo.equalsIgnoreCase("CG")) && resRef.equalsIgnoreCase("VAL")) {
                if (atomRef.equalsIgnoreCase("HG1")) {
                    atomRefStereo = "HG2";
                } else if (atomRef.equalsIgnoreCase("HG2")) {
                    atomRefStereo = "HG1";
                } else if (atomRef.equalsIgnoreCase("CG1")) {
                    atomRefStereo = "CG2";
                } else if (atomRef.equalsIgnoreCase("CG2")) {
                    atomRefStereo = "CG1";
                }
            }
            if ((subAtomTwo.equalsIgnoreCase("HD") || subAtomTwo.equalsIgnoreCase("CD")) && resRef.equalsIgnoreCase("LEU")) {
                if (atomRef.equalsIgnoreCase("HD1")) {
                    atomRefStereo = "HD2";
                } else if (atomRef.equalsIgnoreCase("HD2")) {
                    atomRefStereo = "HD1";
                } else if (atomRef.equalsIgnoreCase("CD1")) {
                    atomRefStereo = "CD2";
                } else if (atomRef.equalsIgnoreCase("CD2")) {
                    atomRefStereo = "CD1";
                }
            }
            if (subAtomTwo.equalsIgnoreCase("HG") && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG"))) {
                if (atomRef.equalsIgnoreCase("HG1")) {
                    atomRefStereo = "HG2";
                } else if (atomRef.equalsIgnoreCase("HG2")) {
                    atomRefStereo = "HG1";
                }
            }
            if (subAtomTwo.equalsIgnoreCase("HD") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR"))) {
                if (atomRef.equalsIgnoreCase("HD1")) {
                    atomRefStereo = "HD2";
                } else if (atomRef.equalsIgnoreCase("HD2")) {
                    atomRefStereo = "HD1";
                }
            }
            if (subAtomTwo.equalsIgnoreCase("HE") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR"))) {
                if (atomRef.equalsIgnoreCase("HE1")) {
                    atomRefStereo = "HE2";
                } else if (atomRef.equalsIgnoreCase("HE2")) {
                    atomRefStereo = "HE1";
                }
            }
            if (atomRef.length() >= 3) {
                if (atomRef.substring(0, 3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE")) {
                    if (atomRef.equalsIgnoreCase("HG11")) {
                        atomRefStereo = "HG12";
                    } else if (atomRef.equalsIgnoreCase("HG12")) {
                        atomRefStereo = "HG11";
                    }
                }
                if (atomRef.substring(0, 3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN")) {
                    if (atomRef.equalsIgnoreCase("HD21")) {
                        atomRefStereo = "HD22";
                    } else if (atomRef.equalsIgnoreCase("HD22")) {
                        atomRefStereo = "HD21";
                    }
                }
                if (atomRef.substring(0, 3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN")) {
                    if (atomRef.equalsIgnoreCase("HE21")) {
                        atomRefStereo = "HE22";
                    } else if (atomRef.equalsIgnoreCase("HE22")) {
                        atomRefStereo = "HE21";
                    }
                }
                if (atomRef.substring(0, 3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG")) {
                    if (atomRef.equalsIgnoreCase("HH11")) {
                        atomRefStereo = "HH12";
                    } else if (atomRef.equalsIgnoreCase("HH12")) {
                        atomRefStereo = "HH11";
                    }
                }
                if (atomRef.substring(0, 3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG")) {
                    if (atomRef.equalsIgnoreCase("HH21")) {
                        atomRefStereo = "HH22";
                    } else if (atomRef.equalsIgnoreCase("HH22")) {
                        atomRefStereo = "HH21";
                    }
                }
            }
            if (subAtomTwo.equalsIgnoreCase("HH") && resRef.equalsIgnoreCase("ARG")) {
                if (atomRef.equalsIgnoreCase("HH1")) {
                    atomRefStereo = "HH2";
                } else if (atomRef.equalsIgnoreCase("HH2")) {
                    atomRefStereo = "HH1";
                }
            }
            if (atomRef.substring(0, 1).equalsIgnoreCase("H") || atomRef.substring(0, 1).equalsIgnoreCase("C") || !atomRef.substring(0, 1).equalsIgnoreCase("N")) {
                // empty if block
            }
            ++k;
        }
        return null;
    }

    public void CompareSCAsgsWRefAsgsNew(Vector vecSrcAsg, Vector vecRefAsg, Vector vecBBAsg) {
        double csErrH = 0.05;
        double csErrHeavy = 0.5;
        Peak pk = new Peak();
        int totalScH = 0;
        int missing = 0;
        double wrong = 0.0;
        double correct = 0.0;
        double correctI = 0.0;
        double correctII = 0.0;
        Assign asg = new Assign();
        double nTotalAsgs = 0.0;
        double nTotalClassI = 0.0;
        double nTotalClassII = 0.0;
        int k = 0;
        while (k < vecSrcAsg.size()) {
            H1CS h1cs = (H1CS)vecSrcAsg.elementAt(k);
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                nTotalAsgs += 1.0;
                if (res.equalsIgnoreCase("VAL") || res.equalsIgnoreCase("ILE") || res.equalsIgnoreCase("LEU") || res.equalsIgnoreCase("MET") || res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("CYS")) {
                    nTotalClassI += 1.0;
                } else if (!res.equalsIgnoreCase("ALA") && !res.equalsIgnoreCase("GLY")) {
                    nTotalClassII += 1.0;
                }
            }
            ++k;
        }
        double nTotalBBAsgs = 0.0;
        int k2 = 0;
        while (k2 < vecBBAsg.size()) {
            H1CS h1cs = (H1CS)vecBBAsg.elementAt(k2);
            String atom = h1cs.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                nTotalBBAsgs += 1.0;
            }
            ++k2;
        }
        int j = 0;
        while (j < vecSrcAsg.size()) {
            H1CS h1csA = (H1CS)vecSrcAsg.elementAt(j);
            int resNoA = h1csA.getResidueNo();
            String resA = h1csA.getResidueType();
            String atomA = h1csA.getAtomName();
            double cs_hA = h1csA.getH1CS();
            if (atomA.substring(0, 1).equalsIgnoreCase("H")) {
                boolean isFound = false;
                boolean isCorrect = false;
                int k3 = 0;
                while (k3 < vecRefAsg.size()) {
                    H1CS h1cs = (H1CS)vecRefAsg.elementAt(k3);
                    int resRefNo = h1cs.getResidueNo();
                    String resRef = h1cs.getResidueType();
                    String atomRef = h1cs.getAtomName();
                    double csRef = h1cs.getH1CS();
                    String subAtomTwo = "";
                    subAtomTwo = atomRef.length() > 2 ? atomRef.substring(0, 2) : atomRef;
                    String atomRefStereo = "";
                    if (subAtomTwo.equalsIgnoreCase("HB") && (resRef.equalsIgnoreCase("CYS") || resRef.equalsIgnoreCase("ASP") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("HIS") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("LEU") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("ASN") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("SER") || resRef.equalsIgnoreCase("TRP") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HB1")) {
                            atomRefStereo = "HB2";
                        } else if (atomRef.equalsIgnoreCase("HB2")) {
                            atomRefStereo = "HB1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HA") && resRef.equalsIgnoreCase("GLY")) {
                        if (atomRef.equalsIgnoreCase("HA1")) {
                            atomRefStereo = "HA2";
                        } else if (atomRef.equalsIgnoreCase("HA2")) {
                            atomRefStereo = "HA1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HG") || subAtomTwo.equalsIgnoreCase("CG")) && resRef.equalsIgnoreCase("VAL")) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        } else if (atomRef.equalsIgnoreCase("CG1")) {
                            atomRefStereo = "CG2";
                        } else if (atomRef.equalsIgnoreCase("CG2")) {
                            atomRefStereo = "CG1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HD") || subAtomTwo.equalsIgnoreCase("CD")) && resRef.equalsIgnoreCase("LEU")) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        } else if (atomRef.equalsIgnoreCase("CD1")) {
                            atomRefStereo = "CD2";
                        } else if (atomRef.equalsIgnoreCase("CD2")) {
                            atomRefStereo = "CD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HG") && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG"))) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HD") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HE") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HE1")) {
                            atomRefStereo = "HE2";
                        } else if (atomRef.equalsIgnoreCase("HE2")) {
                            atomRefStereo = "HE1";
                        }
                    }
                    if (atomRef.length() >= 3) {
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE")) {
                            if (atomRef.equalsIgnoreCase("HG11")) {
                                atomRefStereo = "HG12";
                            } else if (atomRef.equalsIgnoreCase("HG12")) {
                                atomRefStereo = "HG11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN")) {
                            if (atomRef.equalsIgnoreCase("HD21")) {
                                atomRefStereo = "HD22";
                            } else if (atomRef.equalsIgnoreCase("HD22")) {
                                atomRefStereo = "HD21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN")) {
                            if (atomRef.equalsIgnoreCase("HE21")) {
                                atomRefStereo = "HE22";
                            } else if (atomRef.equalsIgnoreCase("HE22")) {
                                atomRefStereo = "HE21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH11")) {
                                atomRefStereo = "HH12";
                            } else if (atomRef.equalsIgnoreCase("HH12")) {
                                atomRefStereo = "HH11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH21")) {
                                atomRefStereo = "HH22";
                            } else if (atomRef.equalsIgnoreCase("HH22")) {
                                atomRefStereo = "HH21";
                            }
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HH") && resRef.equalsIgnoreCase("ARG")) {
                        if (atomRef.equalsIgnoreCase("HH1")) {
                            atomRefStereo = "HH2";
                        } else if (atomRef.equalsIgnoreCase("HH2")) {
                            atomRefStereo = "HH1";
                        }
                    }
                    if (atomRef.substring(0, 1).equalsIgnoreCase("H") || atomRef.substring(0, 1).equalsIgnoreCase("C") || atomRef.substring(0, 1).equalsIgnoreCase("N")) {
                        String subAtom = atomA;
                        double csErr = 0.0;
                        csErr = atomRef.substring(0, 1).equalsIgnoreCase("H") ? csErrH : csErrHeavy;
                        if (atomA.length() > atomRef.length()) {
                            subAtom = atomA.substring(0, atomRef.length());
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                    }
                    ++k3;
                }
                if (!isFound) {
                    System.out.println("Missing resonance assignment: " + resNoA + " " + resA + " - " + atomA);
                    ++missing;
                } else if (!isCorrect) {
                    System.out.println("...Wrong resonance assignment: " + resNoA + " " + resA + " - " + atomA);
                    wrong += 1.0;
                } else {
                    correct += 1.0;
                    if (resA.equalsIgnoreCase("VAL") || resA.equalsIgnoreCase("ILE") || resA.equalsIgnoreCase("LEU") || resA.equalsIgnoreCase("MET") || resA.equalsIgnoreCase("PHE") || resA.equalsIgnoreCase("TRP") || resA.equalsIgnoreCase("CYS")) {
                        correctI += 1.0;
                    } else if (!resA.equalsIgnoreCase("ALA") && !resA.equalsIgnoreCase("GLY")) {
                        correctII += 1.0;
                    }
                }
                ++totalScH;
            }
            ++j;
        }
        System.out.println("Total number of protons (including both bb and sc protons): " + totalScH);
        System.out.println("Total number of missing sidechain assignments: " + missing);
        System.out.println("Total number of wrong sidechain assignments: " + wrong);
        System.out.println("Total number of correct resonance assignments: " + correct);
        System.out.println("Total number of side chain proton resonance assignments: " + (nTotalAsgs - nTotalBBAsgs));
        System.out.println("Percentage of correct proton resonance assignments (including both bb and sc resonances): " + correct / nTotalAsgs);
        System.out.println("Percentage of correct proton resonance assignments for class I residues: " + correctI / nTotalClassI);
        System.out.println("Percentage of correct proton resonance assignments for class II residues: " + correctII / nTotalClassII);
    }

    public void CompareSCAsgsWRefAsgs(Vector vecSrcAsg, Vector vecRefAsg, Vector vecBBAsg) {
        double csErrH = 0.05;
        double csErrHeavy = 0.5;
        Peak pk = new Peak();
        int totalScH = 0;
        int missing = 0;
        double wrong = 0.0;
        double correct = 0.0;
        double correctI = 0.0;
        double correctII = 0.0;
        Assign asg = new Assign();
        double nTotalAsgs = 0.0;
        double nTotalClassI = 0.0;
        double nTotalClassII = 0.0;
        int k = 0;
        while (k < vecSrcAsg.size()) {
            H1CS h1cs = (H1CS)vecSrcAsg.elementAt(k);
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                nTotalAsgs += 1.0;
                if (res.equalsIgnoreCase("VAL") || res.equalsIgnoreCase("ILE") || res.equalsIgnoreCase("LEU") || res.equalsIgnoreCase("MET") || res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("CYS")) {
                    nTotalClassI += 1.0;
                } else if (!res.equalsIgnoreCase("ALA") && !res.equalsIgnoreCase("GLY")) {
                    nTotalClassII += 1.0;
                }
            }
            ++k;
        }
        double nTotalBBAsgs = 0.0;
        int k2 = 0;
        while (k2 < vecBBAsg.size()) {
            H1CS h1cs = (H1CS)vecBBAsg.elementAt(k2);
            String atom = h1cs.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                nTotalBBAsgs += 1.0;
            }
            ++k2;
        }
        int j = 0;
        while (j < vecSrcAsg.size()) {
            H1CS h1csA = (H1CS)vecSrcAsg.elementAt(j);
            int resNoA = h1csA.getResidueNo();
            String resA = h1csA.getResidueType();
            String atomA = h1csA.getAtomName();
            double cs_hA = h1csA.getH1CS();
            if (atomA.substring(0, 1).equalsIgnoreCase("H")) {
                boolean isFound = false;
                boolean isCorrect = false;
                int k3 = 0;
                while (k3 < vecRefAsg.size()) {
                    H1CS h1cs = (H1CS)vecRefAsg.elementAt(k3);
                    int resRefNo = h1cs.getResidueNo();
                    String resRef = h1cs.getResidueType();
                    String atomRef = h1cs.getAtomName();
                    double csRef = h1cs.getH1CS();
                    String subAtomTwo = "";
                    subAtomTwo = atomRef.length() > 2 ? atomRef.substring(0, 2) : atomRef;
                    String atomRefStereo = "";
                    if (subAtomTwo.equalsIgnoreCase("HB") && (resRef.equalsIgnoreCase("CYS") || resRef.equalsIgnoreCase("ASP") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("HIS") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("LEU") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("ASN") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("SER") || resRef.equalsIgnoreCase("TRP") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HB1")) {
                            atomRefStereo = "HB2";
                        } else if (atomRef.equalsIgnoreCase("HB2")) {
                            atomRefStereo = "HB1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HA") && resRef.equalsIgnoreCase("GLY")) {
                        if (atomRef.equalsIgnoreCase("HA1")) {
                            atomRefStereo = "HA2";
                        } else if (atomRef.equalsIgnoreCase("HA2")) {
                            atomRefStereo = "HA1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HG") || subAtomTwo.equalsIgnoreCase("CG")) && resRef.equalsIgnoreCase("VAL")) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        } else if (atomRef.equalsIgnoreCase("CG1")) {
                            atomRefStereo = "CG2";
                        } else if (atomRef.equalsIgnoreCase("CG2")) {
                            atomRefStereo = "CG1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HD") || subAtomTwo.equalsIgnoreCase("CD")) && resRef.equalsIgnoreCase("LEU")) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        } else if (atomRef.equalsIgnoreCase("CD1")) {
                            atomRefStereo = "CD2";
                        } else if (atomRef.equalsIgnoreCase("CD2")) {
                            atomRefStereo = "CD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HG") && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG"))) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HD") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HE") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HE1")) {
                            atomRefStereo = "HE2";
                        } else if (atomRef.equalsIgnoreCase("HE2")) {
                            atomRefStereo = "HE1";
                        }
                    }
                    if (atomRef.length() >= 3) {
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE")) {
                            if (atomRef.equalsIgnoreCase("HG11")) {
                                atomRefStereo = "HG12";
                            } else if (atomRef.equalsIgnoreCase("HG12")) {
                                atomRefStereo = "HG11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN")) {
                            if (atomRef.equalsIgnoreCase("HD21")) {
                                atomRefStereo = "HD22";
                            } else if (atomRef.equalsIgnoreCase("HD22")) {
                                atomRefStereo = "HD21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN")) {
                            if (atomRef.equalsIgnoreCase("HE21")) {
                                atomRefStereo = "HE22";
                            } else if (atomRef.equalsIgnoreCase("HE22")) {
                                atomRefStereo = "HE21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH11")) {
                                atomRefStereo = "HH12";
                            } else if (atomRef.equalsIgnoreCase("HH12")) {
                                atomRefStereo = "HH11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH21")) {
                                atomRefStereo = "HH22";
                            } else if (atomRef.equalsIgnoreCase("HH22")) {
                                atomRefStereo = "HH21";
                            }
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HH") && resRef.equalsIgnoreCase("ARG")) {
                        if (atomRef.equalsIgnoreCase("HH1")) {
                            atomRefStereo = "HH2";
                        } else if (atomRef.equalsIgnoreCase("HH2")) {
                            atomRefStereo = "HH1";
                        }
                    }
                    if (atomRef.substring(0, 1).equalsIgnoreCase("H") || atomRef.substring(0, 1).equalsIgnoreCase("C") || atomRef.substring(0, 1).equalsIgnoreCase("N")) {
                        String subAtom = atomA;
                        double csErr = 0.0;
                        csErr = atomRef.substring(0, 1).equalsIgnoreCase("H") ? csErrH : csErrHeavy;
                        if (atomA.length() > atomRef.length()) {
                            subAtom = atomA.substring(0, atomRef.length());
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                    }
                    ++k3;
                }
                if (!isFound) {
                    System.out.println("Missing resonance assignment: " + resNoA + " " + resA + " - " + atomA);
                    ++missing;
                } else if (!isCorrect) {
                    System.out.println("...Wrong resonance assignment: " + resNoA + " " + resA + " - " + atomA);
                    wrong += 1.0;
                } else {
                    correct += 1.0;
                    if (resA.equalsIgnoreCase("VAL") || resA.equalsIgnoreCase("ILE") || resA.equalsIgnoreCase("LEU") || resA.equalsIgnoreCase("MET") || resA.equalsIgnoreCase("PHE") || resA.equalsIgnoreCase("TRP") || resA.equalsIgnoreCase("CYS")) {
                        correctI += 1.0;
                    } else if (!resA.equalsIgnoreCase("ALA") && !resA.equalsIgnoreCase("GLY")) {
                        correctII += 1.0;
                    }
                }
                ++totalScH;
            }
            ++j;
        }
        System.out.println("Total number of assignments (including both bb and sc protons): " + totalScH);
        System.out.println("Total number of missing sidechain assignments: " + missing);
        System.out.println("Total number of wrong sidechain assignments: " + wrong);
        System.out.println("Total number of correct resonance assignments: " + correct);
        System.out.println("Total number of side chain proton resonance assignments: " + (nTotalAsgs - nTotalBBAsgs));
        System.out.println("Percentage of correct proton resonance assignments (including both bb and sc resonances): " + correct / nTotalAsgs);
        System.out.println("Percentage of correct proton resonance assignments for class I residues: " + correctI / nTotalClassI);
        System.out.println("Percentage of correct proton resonance assignments for class II residues: " + correctII / nTotalClassII);
    }

    public boolean checkCSBMRBOrder(Vector vecOneResidue) {
        if (vecOneResidue.size() < 1) {
            return false;
        }
        double aveCS_ha = 0.0;
        double n_ha = 0.0;
        double aveCS_hb = 0.0;
        double n_hb = 0.0;
        double aveCS_hg = 0.0;
        double n_hg = 0.0;
        double aveCS_hd = 0.0;
        double n_hd = 0.0;
        double aveCS_he = 0.0;
        double n_he = 0.0;
        double aveCS_hg2Ile = 0.0;
        double n_hg2Ile = 0.0;
        double aveCS_hg1Ile = 0.0;
        double n_hg1Ile = 0.0;
        double CS_hzPhe = -999.9;
        double CS_he3Trp = -999.9;
        double CS_hz2Trp = -999.9;
        double CS_hz3Trp = -999.9;
        double CS_hh2Trp = -999.9;
        double CS_he1His = -999.9;
        double CS_hd2His = -999.9;
        H1CS h1cs0 = (H1CS)vecOneResidue.elementAt(0);
        String res = h1cs0.getResidueType();
        int i = 0;
        while (i < vecOneResidue.size()) {
            String atom;
            H1CS h1cs = (H1CS)vecOneResidue.elementAt(i);
            String subAtomTwo = atom = h1cs.getAtomName();
            String subAtomThree = atom;
            if (atom.length() >= 2) {
                subAtomTwo = atom.substring(0, 2);
            }
            if (atom.length() >= 3) {
                subAtomThree = atom.substring(0, 3);
            }
            if (subAtomTwo.equalsIgnoreCase("HA")) {
                aveCS_ha += h1cs.getH1CS();
                n_ha += 1.0;
            }
            if (subAtomTwo.equalsIgnoreCase("HB")) {
                aveCS_hb += h1cs.getH1CS();
                n_hb += 1.0;
            }
            if (subAtomTwo.equalsIgnoreCase("HG")) {
                aveCS_hg += h1cs.getH1CS();
                n_hg += 1.0;
            }
            if (subAtomTwo.equalsIgnoreCase("HD")) {
                aveCS_hd += h1cs.getH1CS();
                n_hd += 1.0;
            }
            if (subAtomTwo.equalsIgnoreCase("HE")) {
                aveCS_he += h1cs.getH1CS();
                n_he += 1.0;
            }
            if (subAtomThree.equalsIgnoreCase("HG2")) {
                aveCS_hg2Ile += h1cs.getH1CS();
                n_hg2Ile += 1.0;
            }
            if (subAtomThree.equalsIgnoreCase("HG1")) {
                aveCS_hg1Ile += h1cs.getH1CS();
                n_hg1Ile += 1.0;
            }
            if (subAtomThree.equalsIgnoreCase("HE1") && res.equalsIgnoreCase("HIS")) {
                CS_he1His = h1cs.getH1CS();
            }
            if (subAtomThree.equalsIgnoreCase("HD1") && res.equalsIgnoreCase("HIS")) {
                CS_hd2His = h1cs.getH1CS();
            }
            ++i;
        }
        if (n_ha > 0.0) {
            aveCS_ha /= n_ha;
        }
        if (n_hb > 0.0) {
            aveCS_hb /= n_hb;
        }
        if (n_hg > 0.0) {
            aveCS_hg /= n_hg;
        }
        if (n_hd > 0.0) {
            aveCS_hd /= n_hd;
        }
        if (n_he > 0.0) {
            aveCS_he /= n_he;
        }
        if (n_hg2Ile > 0.0) {
            aveCS_hg2Ile /= n_hg2Ile;
        }
        if (n_hg1Ile > 0.0) {
            aveCS_hg1Ile /= n_hg1Ile;
        }
        boolean isSuccess = true;
        if (res.equalsIgnoreCase("ALA") || res.equalsIgnoreCase("SER") || res.equalsIgnoreCase("CYS") || res.equalsIgnoreCase("ASP") || res.equalsIgnoreCase("ASN") || res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("TYR") || res.equalsIgnoreCase("HIS") || res.equalsIgnoreCase("TRP")) {
            boolean bl = isSuccess = aveCS_ha > aveCS_hb;
        }
        if (res.equalsIgnoreCase("VAL") || res.equalsIgnoreCase("THR")) {
            boolean bl = isSuccess = aveCS_ha > aveCS_hb && aveCS_hb > aveCS_hg;
        }
        if (res.equalsIgnoreCase("LEU")) {
            boolean bl = isSuccess = aveCS_ha > aveCS_hb && aveCS_hb > aveCS_hg && aveCS_hg > aveCS_hd;
        }
        if (res.equalsIgnoreCase("ILE")) {
            boolean bl = isSuccess = aveCS_ha > aveCS_hb && aveCS_hb > aveCS_hg1Ile && aveCS_hg1Ile > aveCS_hg2Ile && aveCS_hg2Ile > aveCS_hd;
        }
        if (res.equalsIgnoreCase("GLN") || res.equalsIgnoreCase("GLU") || res.equalsIgnoreCase("MET")) {
            boolean bl = isSuccess = aveCS_ha > aveCS_hg && aveCS_hg > aveCS_hb;
        }
        if (res.equalsIgnoreCase("PRO") || res.equalsIgnoreCase("ARG")) {
            boolean bl = isSuccess = aveCS_ha > aveCS_hd && aveCS_hd > aveCS_hb && aveCS_hb > aveCS_hg;
        }
        if (res.equalsIgnoreCase("LYS")) {
            boolean bl = isSuccess = aveCS_ha > aveCS_he && aveCS_he > aveCS_hb && aveCS_hb > aveCS_hd && aveCS_hd > aveCS_hg;
        }
        if (res.equalsIgnoreCase("HIS")) {
            boolean bl = isSuccess = isSuccess && CS_he1His > CS_hd2His;
        }
        if (res.equalsIgnoreCase("TYR")) {
            isSuccess = isSuccess && aveCS_hd > aveCS_he;
        }
        return isSuccess;
    }

    public void CompareSCAsgsWRefAsgsOld(Vector vecSrcAsg, Vector vecRefAsg) {
        double csErrH = 0.04;
        double csErrHeavy = 0.4;
        Peak pk = new Peak();
        int totalScH = 0;
        int wrong = 0;
        int correct = 0;
        Assign asg = new Assign();
        int j = 0;
        while (j < vecSrcAsg.size()) {
            H1CS h1csA = (H1CS)vecSrcAsg.elementAt(j);
            int resNoA = h1csA.getResidueNo();
            String resA = h1csA.getResidueType();
            String atomA = h1csA.getAtomName();
            double cs_hA = h1csA.getH1CS();
            boolean isAtomInRefAsg = false;
            if (!(atomA.equalsIgnoreCase("CA") || atomA.equalsIgnoreCase("N") || atomA.equalsIgnoreCase("HN") || atomA.equalsIgnoreCase("H") || atomA.equalsIgnoreCase("HA") || atomA.equalsIgnoreCase("HA1") || atomA.equalsIgnoreCase("HA2") || atomA.equalsIgnoreCase("HA3") || atomA.equalsIgnoreCase("C") || atomA.equalsIgnoreCase("CO") || atomA.equalsIgnoreCase("CB"))) {
                int k = 0;
                while (k < vecRefAsg.size()) {
                    H1CS h1cs = (H1CS)vecRefAsg.elementAt(k);
                    int resRefNo = h1cs.getResidueNo();
                    String atomRef = h1cs.getAtomName();
                    String subAtom = atomA;
                    if (atomA.length() > atomRef.length()) {
                        subAtom = atomA.substring(0, atomRef.length());
                    }
                    if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                        isAtomInRefAsg = true;
                    }
                    ++k;
                }
                if (isAtomInRefAsg) {
                    double csRef;
                    double csErr;
                    String subAtom;
                    String atomRef;
                    H1CS h1cs;
                    Vector vecRefAsgStereo = asg.SwapStereoAsg(vecRefAsg, resNoA);
                    boolean isCorrect = false;
                    int k2 = 0;
                    while (k2 < vecRefAsg.size()) {
                        h1cs = (H1CS)vecRefAsg.elementAt(k2);
                        int resRefNo = h1cs.getResidueNo();
                        atomRef = h1cs.getAtomName();
                        subAtom = atomA;
                        csErr = 0.0;
                        csErr = atomRef.substring(0, 1).equalsIgnoreCase("H") ? csErrH : csErrHeavy;
                        csRef = h1cs.getH1CS();
                        if (atomA.length() > atomRef.length()) {
                            subAtom = atomA.substring(0, atomRef.length());
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                        ++k2;
                    }
                    k2 = 0;
                    while (k2 < vecRefAsgStereo.size()) {
                        h1cs = (H1CS)vecRefAsgStereo.elementAt(k2);
                        int resRefNo = h1cs.getResidueNo();
                        atomRef = h1cs.getAtomName();
                        subAtom = atomA;
                        csErr = 0.0;
                        csErr = atomRef.substring(0, 1).equalsIgnoreCase("H") ? csErrH : csErrHeavy;
                        csRef = h1cs.getH1CS();
                        if (atomA.length() > atomRef.length()) {
                            subAtom = atomA.substring(0, atomRef.length());
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                        ++k2;
                    }
                    if (isCorrect) {
                        ++correct;
                    } else {
                        ++wrong;
                        System.out.println("Wrong sidechain assignment: " + resNoA + " " + resA + " - " + atomA);
                    }
                    ++totalScH;
                }
            }
            ++j;
        }
        System.out.println("Total number of sidechain atoms: " + totalScH);
        System.out.println("Total number of wrong sidechain assignments: " + wrong);
        System.out.println("Total number of correct side chain resonance assignments: " + correct);
    }

    public Vector<H1CS> h1CSReader_BMRB(String filename) {
        Vector<H1CS> inputs = new Vector<H1CS>();
        double csHN = 0.0;
        double csN15 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String aaType = "";
        String ss = "";
        String atomName = "";
        String resName = "";
        int resNo = 0;
        int csID = 0;
        Noe noe = new Noe();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            while (true) {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    csID = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resNo = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    atomName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    aaType = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (csH1 > 300.0 || csH1 < -300.0) {
                    ss = in.readLine();
                    if (ss != null && (!ss.equalsIgnoreCase("") || (ss = in.readLine()) != null)) continue;
                    break;
                }
                atomName = noe.UpdateNOEAtomName2(resName, atomName);
                inputs.add(new H1CS(resNo, resName, atomName, csH1));
                ss = in.readLine();
                if (ss == null || ss.equalsIgnoreCase("") && (ss = in.readLine()) == null) break;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector<H1CS> h1CSReader_CYANA(String filename) {
        Vector<H1CS> inputs = new Vector<H1CS>();
        double csHN = 0.0;
        double csN15 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        double csErr = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String aaType = "";
        String ss = "";
        String atomName = "";
        String resName = "";
        int resNo = 0;
        int csID = 0;
        Noe noe = new Noe();
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            while (true) {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    csID = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csErr = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    atomName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    resNo = Integer.parseInt(st.nextToken());
                }
                if (csH1 > 300.0 || csH1 < -300.0) {
                    ss = in.readLine();
                    if (ss != null && (!ss.equalsIgnoreCase("") || (ss = in.readLine()) != null)) continue;
                    break;
                }
                inputs.add(new H1CS(resNo, resName, atomName, csH1));
                ss = in.readLine();
                if (ss == null || ss.equalsIgnoreCase("") && (ss = in.readLine()) == null) break;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector<H1CS> h1CSReader_TALOS(String filename) {
        Vector<H1CS> inputs = new Vector<H1CS>();
        double csHN = 0.0;
        double csN15 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String aaType = "";
        String ss = "";
        String atomName = "";
        String resName = "";
        int resNo = 0;
        boolean csID = false;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            while (true) {
                st = new StringTokenizer(ss);
                String strFirst = "";
                if (st.hasMoreTokens()) {
                    strFirst = st.nextToken();
                    if (this.isIntNumber(strFirst)) {
                        resNo = Integer.parseInt(strFirst);
                    } else {
                        ss = in.readLine();
                        if (ss != null) continue;
                        break;
                    }
                }
                if (st.hasMoreTokens()) {
                    resName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    atomName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (csH1 > 300.0 || csH1 < -300.0) {
                    ss = in.readLine();
                    if (ss != null && (!ss.equalsIgnoreCase("") || (ss = in.readLine()) != null)) continue;
                    break;
                }
                inputs.add(new H1CS(resNo, resName, atomName, csH1));
                ss = in.readLine();
                if (ss == null || ss.equalsIgnoreCase("") && (ss = in.readLine()) == null) break;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public boolean isIntNumber(String num) {
        try {
            Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public double BMRBSatisticsScore(Vector vecSrcAsg, Vector vecBMRB) {
        double counter = 0.0;
        double sum_dist = 0.0;
        double sum_score = 0.0;
        int i = 0;
        while (i < vecSrcAsg.size()) {
            H1CS h1cs = (H1CS)vecSrcAsg.elementAt(i);
            int resNo = h1cs.getResidueNo();
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            double csH = h1cs.getH1CS();
            double cs_ave = 0.0;
            double cs_signma = 0.0;
            boolean isFoundInBMRB = false;
            int j = 0;
            while (j < vecBMRB.size()) {
                H1CS h1csBMRB = (H1CS)vecBMRB.elementAt(j);
                String resBMRB = h1csBMRB.getResidueType();
                String atomBMRB = h1csBMRB.getAtomName();
                if (res.equalsIgnoreCase(resBMRB) && atom.equalsIgnoreCase(atomBMRB)) {
                    cs_ave = h1csBMRB.getCSAverage();
                    cs_signma = atomBMRB.substring(0, 1).equalsIgnoreCase("H") ? 1.0 * h1csBMRB.getCSSigma() : 1.0 * h1csBMRB.getCSSigma();
                    isFoundInBMRB = true;
                }
                ++j;
            }
            if (!isFoundInBMRB) {
                System.out.println("Not found match in BMRB: " + resNo + res + "-" + atom);
            } else {
                double cs_dist = (csH - cs_ave) * (csH - cs_ave) / (cs_signma * cs_signma);
                if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                    sum_dist += cs_dist;
                    counter += 1.0;
                } else {
                    sum_dist += 1.0 * cs_dist;
                    counter += 1.0;
                }
            }
            ++i;
        }
        double ave_dist = sum_dist / counter;
        double score = Math.exp(-0.5 * ave_dist);
        return score;
    }

    public Vector<H1CS> ReadBMRBSatistics(String filename) {
        Vector<H1CS> inputs = new Vector<H1CS>();
        double csHN = 0.0;
        double csN15 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        double csL = 0.0;
        double csU = 0.0;
        double csAve = 0.0;
        double csSigma = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String aaType = "";
        String ss = "";
        String atomName = "";
        String resName = "";
        boolean resNo = false;
        boolean csID = false;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    resName = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    atomName = st.nextToken();
                }
                String subAtomName = atomName;
                if (atomName.length() > 2) {
                    subAtomName = atomName.substring(0, 2);
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csL = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csU = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csAve = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csSigma = new Double(st.nextToken());
                }
                if ((atomName.equalsIgnoreCase("CD") || atomName.equalsIgnoreCase("CG")) && (resName.equalsIgnoreCase("LYS") || resName.equalsIgnoreCase("ARG"))) {
                    inputs.add(new H1CS(0, resName, atomName, csAve - csSigma, csAve + csSigma, csAve, csSigma));
                    continue;
                }
                inputs.add(new H1CS(0, resName, atomName, csAve - 2.0 * csSigma, csAve + 2.0 * csSigma, csAve, csSigma));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector<H1CS> CSNameConvertFromBMRBNewToPDBNew(Vector<H1CS> vecAsg) {
        Object atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector atoms = new Vector();
        Vector atomVec = new Vector();
        Pdb pp = new Pdb();
        H1CS h1cs = new H1CS();
        Vector<H1CS> vecAsgOld = new Vector<H1CS>();
        vecAsgOld.addAll(vecAsg);
        Vector<H1CS> vecAsgNew = new Vector<H1CS>();
        int i = 0;
        while (i < vecAsgOld.size()) {
            h1cs = (H1CS)vecAsgOld.elementAt(i);
            String res = h1cs.getResidueType();
            atomName = h1cs.getAtomName();
            String atomNew = pp.NameFromBMRBToPDB(res, atomName);
            h1cs.setAtomName(atomNew);
            vecAsgNew.add(h1cs);
            ++i;
        }
        return vecAsgNew;
    }

    public Vector CSNameConvertFromPDBNewToBMRBNew(Vector vecAsg) {
        Object atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector atoms = new Vector();
        Vector atomVec = new Vector();
        Pdb pp = new Pdb();
        H1CS h1cs = new H1CS();
        Vector vecAsgOld = new Vector();
        vecAsgOld.addAll(vecAsg);
        Vector<H1CS> vecAsgNew = new Vector<H1CS>();
        int i = 0;
        while (i < vecAsgOld.size()) {
            h1cs = (H1CS)vecAsgOld.elementAt(i);
            String res = h1cs.getResidueType();
            atomName = h1cs.getAtomName();
            String atomNew = pp.NameFromPdbToBMRB(res, atomName);
            h1cs.setAtomName(atomNew);
            vecAsgNew.add(h1cs);
            ++i;
        }
        return vecAsgNew;
    }

    public static void main0(String[] argv) {
        Assign asg = new Assign();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String assignFile = String.valueOf(src) + "ff2_cs_different_format.txt";
        String seqFile = String.valueOf(src) + "ff2.seq";
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        Vector<Object> assignVec = new Vector();
        assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        Vector assignNew = h1CS.CSNameConvertFromPDBNewToBMRBNew(assignVec);
        int counter = 1;
        System.out.println("The chemical shift in the BMRB-NEW format:");
        int i = 0;
        while (i < assignNew.size()) {
            H1CS h1csTemp = (H1CS)assignNew.elementAt(i);
            int no = h1csTemp.getResidueNo();
            String res = h1csTemp.getResidueType();
            String atom = h1csTemp.getAtomName();
            double cs = h1csTemp.getH1CS();
            System.out.println(String.valueOf(counter) + "   " + cs + "   " + 0.0 + "   " + atom + "   " + no);
            ++counter;
            ++i;
        }
    }

    public void addH1CS(Vector vecOldAsg, H1CS h1csNew) {
        boolean isIn = false;
        int i = 0;
        while (i < vecOldAsg.size()) {
            H1CS h1cs = (H1CS)vecOldAsg.elementAt(i);
            String atom = h1cs.getAtomName();
            int resNo = h1cs.getResidueNo();
            if (resNo == h1csNew.getResidueNo() && atom.equalsIgnoreCase(h1csNew.getAtomName())) {
                isIn = true;
            }
            ++i;
        }
        if (!isIn) {
            vecOldAsg.add(h1csNew);
        }
    }

    public static void main4(String[] argv) {
        Assign asg = new Assign();
        Peak pk = new Peak();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String assignFile = String.valueOf(src) + "Cycle1_3_ff2_n15_noe.prot";
        String asgFileAli = String.valueOf(src) + "Cycle1_2_ff2_c13_ali.prot";
        String asgFileAro = String.valueOf(src) + "Cycle1_1_ff2_c13_aro_CT_noe.prot";
        String seqFile = String.valueOf(src) + "ff2.seq";
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String outResFileName = String.valueOf(src) + "final_combined.prot";
        Vector<Object> assignVec = new Vector();
        H1CS h1CS = new H1CS();
        assignVec = h1CS.h1CSReaderWQ(assignFile, vecSeq);
        Nasca nasca = new Nasca();
        Vector<H1CS> vecFinalCSs = new Vector<H1CS>();
        int i = 0;
        while (i < assignVec.size()) {
            H1CS h1cs = (H1CS)assignVec.elementAt(i);
            String atom = h1cs.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("Q")) {
                atom = "H" + atom.substring(1, atom.length());
            }
            if (atom.substring(0, 1).equalsIgnoreCase("N")) {
                vecFinalCSs.add(h1cs);
            } else {
                String res = h1cs.getResidueType();
                String atomHeavy = pk.GetHeavyAtomFromProton(res, atom);
                if (atomHeavy.substring(0, 1).equalsIgnoreCase("N")) {
                    vecFinalCSs.add(h1cs);
                }
            }
            ++i;
        }
        Vector<H1CS> vecAsgAli = h1CS.h1CSReaderWQ(asgFileAli, vecSeq);
        int i2 = 0;
        while (i2 < vecAsgAli.size()) {
            H1CS h1cs = vecAsgAli.elementAt(i2);
            String atom = h1cs.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("Q")) {
                atom = "H" + atom.substring(1, atom.length());
            }
            if (atom.substring(0, 1).equalsIgnoreCase("C")) {
                vecFinalCSs.add(h1cs);
            } else {
                String res = h1cs.getResidueType();
                String atomHeavy = pk.GetHeavyAtomFromProton(res, atom);
                if (atomHeavy.substring(0, 1).equalsIgnoreCase("C") && (!res.equalsIgnoreCase("PHE") && !res.equalsIgnoreCase("HIS") && !res.equalsIgnoreCase("TRP") && !res.equalsIgnoreCase("TYR") || atomHeavy.length() < 2 || atomHeavy.substring(0, 2).equalsIgnoreCase("CA") || atomHeavy.substring(0, 2).equalsIgnoreCase("CB"))) {
                    vecFinalCSs.add(h1cs);
                }
            }
            ++i2;
        }
        Vector<H1CS> vecAsgAro = h1CS.h1CSReaderWQ(asgFileAro, vecSeq);
        int i3 = 0;
        while (i3 < vecAsgAro.size()) {
            H1CS h1cs = vecAsgAro.elementAt(i3);
            String atom = h1cs.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("Q")) {
                atom = "H" + atom.substring(1, atom.length());
            }
            if (atom.substring(0, 1).equalsIgnoreCase("C")) {
                vecFinalCSs.add(h1cs);
            } else {
                String res = h1cs.getResidueType();
                String atomHeavy = pk.GetHeavyAtomFromProton(res, atom);
                if (atomHeavy.substring(0, 1).equalsIgnoreCase("C") && (res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("HIS") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("TYR")) && (atomHeavy.length() < 2 || !atomHeavy.substring(0, 2).equalsIgnoreCase("CA") && !atomHeavy.substring(0, 2).equalsIgnoreCase("CB"))) {
                    vecFinalCSs.add(h1cs);
                }
            }
            ++i3;
        }
        Collections.sort(vecFinalCSs, new resNoComparator());
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outResFileName)));
            h1CS.PrintAllAssignmentToFileCyana(vecFinalCSs, out);
            out.close();
            System.out.println("The NOE assignment table has been generated in " + outResFileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + outResFileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        H1CS h1cs_new;
        Assign asg = new Assign();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String assignFile = String.valueOf(src) + "ff2.prot";
        String assignFileOld = String.valueOf(src) + "ff2temp.prot";
        String seqFile = String.valueOf(src) + "ff2.seq";
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        Vector<Object> assignVec = new Vector();
        Vector<Object> assignVecOld = new Vector();
        assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        assignVecOld = h1CS.h1CSReader(assignFileOld, vecSeq);
        double errH = 0.03;
        double errHeavy = 0.3;
        System.out.println("----------Print out the missing resonances:---------------");
        int i = 1;
        while (i < assignVec.size()) {
            h1cs_new = (H1CS)assignVec.elementAt(i);
            boolean isIn = false;
            String res_new = h1cs_new.getResidueType();
            String atom_new = h1cs_new.getAtomName();
            int no_new = h1cs_new.getResidueNo();
            int j = 0;
            while (j < assignVecOld.size()) {
                H1CS h1cs_old = (H1CS)assignVecOld.elementAt(j);
                String res_old = h1cs_old.getResidueType();
                String atom_old = h1cs_old.getAtomName();
                int no_old = h1cs_old.getResidueNo();
                if (no_new == no_old && atom_new.equalsIgnoreCase(atom_old)) {
                    isIn = true;
                    break;
                }
                ++j;
            }
            if (!isIn) {
                System.out.println("...Missing..." + no_new + " - " + res_new + " : " + atom_new);
            }
            ++i;
        }
        System.out.println("----------Print out the different resonances:---------------");
        i = 1;
        while (i < assignVec.size()) {
            h1cs_new = (H1CS)assignVec.elementAt(i);
            String res_new = h1cs_new.getResidueType();
            String atom_new = h1cs_new.getAtomName();
            int no_new = h1cs_new.getResidueNo();
            double cs_new = h1cs_new.getH1CS();
            double err = 0.0;
            err = atom_new.substring(0, 1).equalsIgnoreCase("H") ? errH : errHeavy;
            int j = 0;
            while (j < assignVecOld.size()) {
                H1CS h1cs_old = (H1CS)assignVecOld.elementAt(j);
                String res_old = h1cs_old.getResidueType();
                String atom_old = h1cs_old.getAtomName();
                double cs_old = h1cs_old.getH1CS();
                int no_old = h1cs_old.getResidueNo();
                if (no_new == no_old && atom_new.equalsIgnoreCase(atom_old) && Math.abs(cs_new - cs_old) > err) {
                    System.out.println("Different..." + no_new + "-" + res_new + "-" + atom_new + "...Old:" + cs_old + " New: " + cs_new);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void main2(String[] argv) {
        Assign asg = new Assign();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String assignFile = String.valueOf(src) + "eta_bmrb.prot";
        String seqFile = String.valueOf(src) + "eta.seq";
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String outResFileName = String.valueOf(src) + "eta_bb_bmrb.prot";
        Vector<Object> assignVec = new Vector();
        H1CS h1CS = new H1CS();
        assignVec = h1CS.h1CSReader_BMRB(assignFile);
        Nasca nasca = new Nasca();
        Vector vecBBReson = nasca.ExtractBackboneAsignment(assignVec);
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outResFileName)));
            h1CS.PrintAllAssignmentToFileBMRB(vecBBReson, out);
            out.close();
            System.out.println("The NOE assignment table has been generated in " + outResFileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + outResFileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public String obtainChemicalShiftFileFormat(String fileName) {
        String fileFormat = "BMRB";
        double csHN = 0.0;
        double csN15 = 0.0;
        double intensity = 0.0;
        double csErr = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String aaType = "";
        String ss = "";
        String atomName = "";
        String resName = "";
        boolean resNo = false;
        String csID = "";
        String csH1 = "";
        Noe noe = new Noe();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    csID = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csH1 = st.nextToken();
                }
                if (!st.hasMoreTokens()) continue;
                boolean isNum = H1CS.isNumeric(st.nextToken());
                fileFormat = isNum ? "CYANA" : "BMRB";
                return fileFormat;
            } while ((ss = in.readLine()) != null && (!ss.equalsIgnoreCase("") || (ss = in.readLine()) != null));
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return fileFormat;
    }

    public static boolean isNumeric(String str) {
        try {
            double d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static class csComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            H1CS n1 = (H1CS)o1;
            H1CS n2 = (H1CS)o2;
            double d1 = n1.getH1CS();
            if (d1 < (d2 = n2.getH1CS())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class resNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            H1CS n1 = (H1CS)o1;
            H1CS n2 = (H1CS)o2;
            double d1 = n1.getResidueNo();
            if (d1 < (d2 = (double)n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

