/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Comparator;
import java.util.Vector;

public class Hbond
implements Cloneable {
    private int residueNoA;
    private int residueNoB;
    private String atomA;
    private String atomB;
    private String id;
    private String type;

    public Hbond() {
        this.residueNoA = 0;
        this.residueNoB = 0;
        this.atomA = null;
        this.atomB = null;
        this.id = null;
        this.type = null;
    }

    public Hbond(int Ano, String A, int Bno, String B, String id, String t) {
        this.residueNoA = Ano;
        this.residueNoB = Bno;
        this.atomA = A;
        this.atomB = B;
        this.id = id;
        this.type = t;
    }

    public int getResidueNoA() {
        return this.residueNoA;
    }

    public int getResidueNoB() {
        return this.residueNoB;
    }

    public String getAtomA() {
        return this.atomA;
    }

    public String getAtomB() {
        return this.atomB;
    }

    public String getID() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        String desc = String.valueOf(this.residueNoA) + this.atomA + "__" + this.residueNoB + this.atomB + "  " + this.id + "   " + this.type;
        return desc;
    }

    protected Object clone() {
        try {
            Object s = super.clone();
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Vector HbondReader(String hbFile) {
        Vector<Hbond> inputs = new Vector<Hbond>();
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(hbFile));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int noA = (int)in.nval;
                in.nextToken();
                String atomA = in.sval;
                in.nextToken();
                int noB = (int)in.nval;
                in.nextToken();
                String atomB = in.sval;
                in.nextToken();
                String id = in.sval;
                in.nextToken();
                String type = in.sval;
                inputs.add(new Hbond(noA, atomA, noB, atomB, id, type));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + hbFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector hbOfTwoStrands(Vector hbVec, String ids) {
        Hbond hb = new Hbond();
        Vector<Hbond> hb2Strands = new Vector<Hbond>();
        int i = 0;
        while (i < hbVec.size()) {
            hb = (Hbond)hbVec.elementAt(i);
            if (hb.getID().equals(ids)) {
                hb2Strands.add(hb);
            }
            ++i;
        }
        return hb2Strands;
    }

    public static class HbondComparatorA
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            Hbond n1 = (Hbond)o1;
            Hbond n2 = (Hbond)o2;
            int d1 = n1.getResidueNoA();
            if (d1 < (d2 = n2.getResidueNoA())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class HbondComparatorB
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            Hbond n1 = (Hbond)o1;
            Hbond n2 = (Hbond)o2;
            int d1 = n1.getResidueNoB();
            if (d1 < (d2 = n2.getResidueNoB())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

