/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Vector;
import rdcPanda.Cartesian;
import rdcPanda.Const;
import rdcPanda.Dipolar;
import rdcPanda.EigenvalueDecomposition;
import rdcPanda.Matrix;
import rdcPanda.ModelRdc;
import rdcPanda.Pdb;
import rdcPanda.PdbRmsd;
import rdcPanda.PhiPsi;
import rdcPanda.SingularValueDecomposition;

public class PdbRdc {
    private Pdb pdbCoord;
    private double rdcVal;

    public PdbRdc() {
        this.pdbCoord = null;
        this.rdcVal = 0.0;
    }

    public PdbRdc(Pdb pp, double rdc) {
        this.pdbCoord = pp;
        this.rdcVal = rdc;
    }

    public Pdb getPdb() {
        return this.pdbCoord;
    }

    public double getRdc() {
        return this.rdcVal;
    }

    public double[] dirCos(double[] vec) {
        double len = 0.0;
        double[] dirs = new double[vec.length];
        int i = 0;
        while (i < vec.length) {
            len += vec[i] * vec[i];
            ++i;
        }
        int j = 0;
        while (j < vec.length) {
            dirs[j] = vec[j] / Math.sqrt(len);
            ++j;
        }
        return dirs;
    }

    public double[] internuclearVec(double[] n1, double[] n2) {
        return new double[]{n2[0] - n1[0], n2[1] - n1[1], n2[2] - n1[2]};
    }

    public double[] newVecByTranslation(double[] n1, double[] vT) {
        return new double[]{n1[0] + vT[0], n1[1] + vT[1], n1[2] + vT[2]};
    }

    public boolean bestFit(Vector pdbVec, Vector rdcVec, String atom1, String atom2, double[] rmsdArr, boolean printResults) {
        int j;
        Pdb pp = new Pdb();
        Dipolar dd = new Dipolar();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        Cartesian cc = new Cartesian();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = (Dipolar)rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc((Pdb)pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        int m = pdbRdcVec.size();
        int n = 5;
        double[][] equ = new double[m][n];
        double[] b = new double[m];
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = this.dirCos(nToNHVec);
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            equ[i][0] = cosY * cosY - cosX * cosX;
            equ[i][1] = cosZ * cosZ - cosX * cosX;
            equ[i][2] = 2.0 * cosX * cosY;
            equ[i][3] = 2.0 * cosX * cosZ;
            equ[i][4] = 2.0 * cosY * cosZ;
            b[i] = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            ++i;
        }
        Matrix A = new Matrix(equ, m, n);
        SingularValueDecomposition SVD = A.svd();
        double[] singularvalues = SVD.getSingularValues();
        double[] singulars = new double[6];
        int k = 0;
        while (k < singularvalues.length) {
            if (singularvalues[k] == 0.0) {
                return false;
            }
            singulars[k] = 1.0 / singularvalues[k];
            ++k;
        }
        double[][] ArrS = new double[][]{{singulars[0], 0.0, 0.0, 0.0, 0.0}, {0.0, singulars[1], 0.0, 0.0, 0.0}, {0.0, 0.0, singulars[2], 0.0, 0.0}, {0.0, 0.0, 0.0, singulars[3], 0.0}, {0.0, 0.0, 0.0, 0.0, singulars[4]}};
        Matrix U = SVD.getU();
        Matrix V = SVD.getV();
        Matrix S = SVD.getS();
        Matrix invS = new Matrix(ArrS, n, n);
        int errorCount = 0;
        try {
            PdbRdc.check(A, SVD.getU().times(SVD.getS().times(SVD.getV().transpose())));
            PdbRdc.try_success("SingularValueDecomposition...", "");
        }
        catch (RuntimeException e) {
            errorCount = PdbRdc.try_failure(errorCount, "SingularValueDecomposition...", "incorrect singular value decomposition calculation");
        }
        double[] saupe = V.times(invS.times(U.transpose().times(b)));
        double Syy = saupe[0];
        double Szz = saupe[1];
        double Sxy = saupe[2];
        double Sxz = saupe[3];
        double Syz = saupe[4];
        double r = 0.0;
        double rdcCal = 0.0;
        if (printResults) {
            System.out.println("ResidueNO,   back-computed RDC,   measured RDC,  difference");
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = this.dirCos(nToNHVec);
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosY * cosY - cosX * cosX) * Syy + (cosZ * cosZ - cosX * cosX) * Szz + 2.0 * cosX * cosY * Sxy + 2.0 * cosX * cosZ * Sxz + 2.0 * cosY * cosZ * Syz;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            if (printResults) {
                System.out.println(String.valueOf(pp.getResidueNo()) + "  " + rdcCal + "  " + rdcExp + "  " + (rdcCal - rdcExp));
            }
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in bestFit method, possible reason: either Pdb or RDC file is not read properly");
            System.exit(1);
        }
        if (printResults) {
            System.out.println("rmsd :" + Math.sqrt(r / (double)pdbRdcVec.size()));
        }
        k = 0;
        while (k < saupe.length) {
            rmsdArr[k] = saupe[k];
            ++k;
        }
        rmsdArr[5] = Math.sqrt(r / (double)pdbRdcVec.size());
        return true;
    }

    public boolean bestFit(Vector pdbVec, Vector rdcVec, String atom1, String atom2, double[] rmsdArr, double[] rdcArrN, boolean printResults) {
        int j;
        int index;
        int no;
        Pdb pp = new Pdb();
        Dipolar dd = new Dipolar();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        Cartesian cc = new Cartesian();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = (Dipolar)rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc((Pdb)pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        int m = pdbRdcVec.size();
        int n = 5;
        double[][] equ = new double[m][n];
        double[] b = new double[m];
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = this.dirCos(nToNHVec);
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            equ[i][0] = cosY * cosY - cosX * cosX;
            equ[i][1] = cosZ * cosZ - cosX * cosX;
            equ[i][2] = 2.0 * cosX * cosY;
            equ[i][3] = 2.0 * cosX * cosZ;
            equ[i][4] = 2.0 * cosY * cosZ;
            b[i] = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            ++i;
        }
        Matrix A = new Matrix(equ, m, n);
        SingularValueDecomposition SVD = A.svd();
        double[] singularvalues = SVD.getSingularValues();
        double[] singulars = new double[6];
        int k = 0;
        while (k < singularvalues.length) {
            if (singularvalues[k] == 0.0) {
                return false;
            }
            singulars[k] = 1.0 / singularvalues[k];
            ++k;
        }
        double[][] ArrS = new double[][]{{singulars[0], 0.0, 0.0, 0.0, 0.0}, {0.0, singulars[1], 0.0, 0.0, 0.0}, {0.0, 0.0, singulars[2], 0.0, 0.0}, {0.0, 0.0, 0.0, singulars[3], 0.0}, {0.0, 0.0, 0.0, 0.0, singulars[4]}};
        Matrix U = SVD.getU();
        Matrix V = SVD.getV();
        Matrix S = SVD.getS();
        Matrix invS = new Matrix(ArrS, n, n);
        int errorCount = 0;
        try {
            PdbRdc.check(A, SVD.getU().times(SVD.getS().times(SVD.getV().transpose())));
            PdbRdc.try_success("SingularValueDecomposition...", "");
        }
        catch (RuntimeException e) {
            errorCount = PdbRdc.try_failure(errorCount, "SingularValueDecomposition...", "incorrect singular value decomposition calculation");
        }
        double[] saupe = V.times(invS.times(U.transpose().times(b)));
        double Syy = saupe[0];
        double Szz = saupe[1];
        double Sxy = saupe[2];
        double Sxz = saupe[3];
        double Syz = saupe[4];
        double r = 0.0;
        double rdcCal = 0.0;
        if (printResults) {
            System.out.println("ResidueNO,   back-computed RDC,   measured RDC,  difference");
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            no = pp.getResidueNo();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = this.dirCos(nToNHVec);
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosY * cosY - cosX * cosX) * Syy + (cosZ * cosZ - cosX * cosX) * Szz + 2.0 * cosX * cosY * Sxy + 2.0 * cosX * cosZ * Sxz + 2.0 * cosY * cosZ * Syz;
            index = Collections.binarySearch(rdcVec, new Dipolar(no), new Dipolar.rdcComparator());
            rdcExp = index > -1 ? ((Dipolar)rdcVec.elementAt(index)).getRdc() : rdcCal;
            rdcArrN[i] = rdcCal;
            if (printResults) {
                System.out.println(String.valueOf(pp.getResidueNo()) + "   " + rdcCal + "   " + rdcExp + "   " + (rdcCal - rdcExp));
            }
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in bestFit method, possible reason: either Pdb or RDC file is not read properly");
            System.exit(1);
        }
        if (printResults) {
            System.out.println("rmsd :" + Math.sqrt(r / (double)pdbRdcVec.size()));
        }
        k = 0;
        while (k < saupe.length) {
            rmsdArr[k] = saupe[k];
            ++k;
        }
        rmsdArr[5] = Math.sqrt(r / (double)pdbRdcVec.size());
        return true;
    }

    public double[][] equGenerate(Vector pdbVec, Vector rdcVec, String atom1, String atom2, double rdcRatio) {
        int index;
        if (atom2.equalsIgnoreCase("H")) {
            atom2 = "HN";
        }
        if (atom1.equalsIgnoreCase("H")) {
            atom1 = "HN";
        }
        Pdb pp = new Pdb();
        Dipolar dd = new Dipolar();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        Cartesian cc = new Cartesian();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = (Dipolar)rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc((Pdb)pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        int m = pdbRdcVec.size();
        int n = 6;
        double[][] equ = new double[m][n];
        double[] b = new double[m];
        int N = 0;
        N = pdbRdcVec.size();
        i = 0;
        while (i < N) {
            int j;
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            if (atom1.equalsIgnoreCase("CO") && atom2.equalsIgnoreCase("N")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("H")) {
                        atom = "HN";
                    }
                    if (atom.equalsIgnoreCase(atom1)) {
                        amide = cc.getXYZ();
                    }
                    ++j;
                }
                int resCurNo = pp.getResidueNo();
                index = Collections.binarySearch(pdbVec, new Pdb(resCurNo + 1), new Pdb.PdbComparator());
                if (index <= -1) {
                    System.out.println("Error in finding co-N RDC.");
                    System.exit(1);
                }
                Pdb pp2 = (Pdb)pdbVec.elementAt(index);
                atomVec = pp2.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("H")) {
                        atom = "HN";
                    }
                    if (atom.equalsIgnoreCase(atom2)) {
                        nh = cc.getXYZ();
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("H")) {
                        atom = "HN";
                    }
                    if (atom.equalsIgnoreCase(atom1)) {
                        amide = cc.getXYZ();
                    } else if (atom.equalsIgnoreCase(atom2)) {
                        nh = cc.getXYZ();
                    }
                    ++j;
                }
            }
            nToNHVec[0] = nh[0] - amide[0];
            nToNHVec[1] = nh[1] - amide[1];
            nToNHVec[2] = nh[2] - amide[2];
            nToNHVec = this.dirCos(nToNHVec);
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            equ[i][0] = cosY * cosY - cosX * cosX;
            equ[i][1] = cosZ * cosZ - cosX * cosX;
            equ[i][2] = 2.0 * cosX * cosY;
            equ[i][3] = 2.0 * cosX * cosZ;
            equ[i][4] = 2.0 * cosY * cosZ;
            equ[i][5] = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc() / rdcRatio;
            ++i;
        }
        return equ;
    }

    public Matrix bestFit(Vector<Pdb> pdbVec, Vector nhRdc, Vector<Dipolar> cahaRdc, double[] rdc1Cal, double[] rdc2Cal, double[] eigenValues) {
        int j;
        Pdb pp = new Pdb();
        Dipolar dd = new Dipolar();
        Vector atomVec = new Vector();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Cartesian cc = new Cartesian();
        String atom = "";
        double[][] nhArr = this.equGenerate(pdbVec, nhRdc, "N", "H", 1.0);
        double[][] cahaArr = this.equGenerate(pdbVec, cahaRdc, "CA", "HA", 1.0);
        int nhNO = nhArr.length;
        int cahaNO = cahaArr.length;
        Matrix nhMat = new Matrix(nhArr, nhNO, 5);
        Matrix chMat = new Matrix(cahaArr, cahaNO, 5);
        int m = nhNO + cahaNO;
        double[][] equ = new double[m][5];
        double[] b = new double[m];
        int i = 0;
        while (i < nhNO) {
            j = 0;
            while (j < 5) {
                equ[i][j] = nhArr[i][j];
                ++j;
            }
            b[i] = nhArr[i][5];
            ++i;
        }
        i = nhNO;
        while (i < nhNO + cahaNO) {
            j = 0;
            while (j < 5) {
                equ[i][j] = cahaArr[i - nhNO][j];
                ++j;
            }
            b[i] = cahaArr[i - nhNO][5];
            ++i;
        }
        int n = 5;
        Matrix A = new Matrix(equ, m, n);
        SingularValueDecomposition SVD = A.svd();
        double[] singularvalues = SVD.getSingularValues();
        double[] singulars = new double[6];
        int k = 0;
        while (k < singularvalues.length) {
            if (singularvalues[k] != 0.0) {
                singulars[k] = 1.0 / singularvalues[k];
            } else {
                System.out.println("Zero singluar values");
                System.exit(1);
            }
            ++k;
        }
        double[][] ArrS = new double[][]{{singulars[0], 0.0, 0.0, 0.0, 0.0}, {0.0, singulars[1], 0.0, 0.0, 0.0}, {0.0, 0.0, singulars[2], 0.0, 0.0}, {0.0, 0.0, 0.0, singulars[3], 0.0}, {0.0, 0.0, 0.0, 0.0, singulars[4]}};
        Matrix U = SVD.getU();
        Matrix V = SVD.getV();
        Matrix S = SVD.getS();
        Matrix invS = new Matrix(ArrS, 5, 5);
        int errorCount = 0;
        try {
            PdbRdc.check(A, SVD.getU().times(SVD.getS().times(SVD.getV().transpose())));
            PdbRdc.try_success("SingularValueDecomposition...", "");
        }
        catch (RuntimeException e) {
            errorCount = PdbRdc.try_failure(errorCount, "SingularValueDecomposition...", "incorrect singular value decomposition calculation");
        }
        double[] saupe = V.times(invS.times(U.transpose().times(b)));
        double Syy = saupe[0];
        double Szz = saupe[1];
        double Sxy = saupe[2];
        double Sxz = saupe[3];
        double Syz = saupe[4];
        double[][] mArr = new double[][]{{-Syy - Szz, Sxy, Sxz}, {Sxy, Syy, Syz}, {Sxz, Syz, Szz}};
        Matrix mm = new Matrix(mArr);
        System.out.println(" The following is the 3*3 matrix of alignment tensor ");
        System.out.println(" mm(1,1)= " + (-Syy - Szz));
        System.out.println(" mm(1,2)= " + Sxy);
        System.out.println(" mm(1,3)=" + Sxz);
        System.out.println(" mm(2,1)=" + Sxy);
        System.out.println(" mm(2,2)=" + Syy);
        System.out.println(" mm(2,3)=" + Syz);
        System.out.println(" mm(3,1)=" + Sxz);
        System.out.println(" mm(3,2)=" + Syz);
        System.out.println(" mm(3,3)=" + Szz);
        EigenvalueDecomposition eigs = new EigenvalueDecomposition(mm, true);
        Matrix VV = eigs.getV();
        Matrix DD = eigs.getD();
        double Sxx = DD.get(0, 0);
        Syy = DD.get(1, 1);
        Szz = DD.get(2, 2);
        eigenValues[0] = Syy;
        eigenValues[1] = Szz;
        Vector<Pdb> pdbVecN = pp.newPdb(pdbVec, VV.transpose());
        ModelRdc mr = new ModelRdc();
        Vector phiPsiVec1 = pp.PhiPsiTotalPdb(pdbVec);
        Vector phiPsiVec2 = pp.PhiPsiTotalPdb(pdbVecN);
        double eps = 1.0E-10;
        eigenValues[2] = 0.0;
        eigenValues[3] = 0.0;
        if (cahaRdc.size() > 1) {
            double chRms;
            eigenValues[2] = chRms = this.BackCal(pdbVec, cahaRdc, "CA", "HA", VV.transpose(), Sxx, Syy, Szz, 1.0, rdc2Cal);
        }
        if (nhRdc.size() > 1) {
            double nhRms;
            eigenValues[3] = nhRms = this.BackCalNH(pdbVec, nhRdc, "N", "H", VV.transpose(), Sxx, Syy, Szz, 1.0, rdc1Cal);
        }
        if (Math.abs(((PhiPsi)phiPsiVec1.elementAt(0)).getPsi() - ((PhiPsi)phiPsiVec2.elementAt(0)).getPsi()) < eps) {
            return VV.transpose();
        }
        return Const.mLeftHand.times(VV.transpose());
    }

    public Matrix bestFit4RDCs(Vector pdbVec, Vector nhRdc, Vector cahaRdc, Vector cacoRdc, Vector conRdc, double[] rdc1Cal, double[] rdc2Cal, double[] eigenValues) {
        double nhRms;
        double chRms;
        int j;
        Pdb pp = new Pdb();
        Dipolar dd = new Dipolar();
        Vector atomVec = new Vector();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Cartesian cc = new Cartesian();
        String atom = "";
        double[][] nhArr = this.equGenerate(pdbVec, nhRdc, "N", "H", 1.0);
        double[][] cahaArr = this.equGenerate(pdbVec, cahaRdc, "CA", "HA", 1.0);
        double[][] cacoArr = this.equGenerate(pdbVec, cacoRdc, "CA", "CO", Const.cacoRatio);
        double[][] conArr = this.equGenerate(pdbVec, conRdc, "CO", "N", Const.conRatio);
        int nhNO = nhArr.length;
        int cahaNO = cahaArr.length;
        int cacoNO = cacoArr.length;
        int conNO = conArr.length;
        int m = nhNO + cahaNO + cacoNO + conNO;
        double[][] equ = new double[m][5];
        double[] b = new double[m];
        int i = 0;
        while (i < nhNO) {
            j = 0;
            while (j < 5) {
                equ[i][j] = nhArr[i][j];
                ++j;
            }
            b[i] = nhArr[i][5];
            ++i;
        }
        i = nhNO;
        while (i < nhNO + cahaNO) {
            j = 0;
            while (j < 5) {
                equ[i][j] = cahaArr[i - nhNO][j];
                ++j;
            }
            b[i] = cahaArr[i - nhNO][5];
            ++i;
        }
        i = nhNO + cahaNO;
        while (i < nhNO + cahaNO + cacoNO) {
            j = 0;
            while (j < 5) {
                equ[i][j] = cacoArr[i - nhNO - cahaNO][j];
                ++j;
            }
            b[i] = cacoArr[i - nhNO - cahaNO][5];
            ++i;
        }
        i = nhNO + cahaNO + cacoNO;
        while (i < nhNO + cahaNO + cacoNO + conNO) {
            j = 0;
            while (j < 5) {
                equ[i][j] = conArr[i - nhNO - cahaNO - cacoNO][j];
                ++j;
            }
            b[i] = conArr[i - nhNO - cahaNO - cacoNO][5];
            ++i;
        }
        int n = 5;
        Matrix A = new Matrix(equ, m, n);
        SingularValueDecomposition SVD = A.svd();
        double[] singularvalues = SVD.getSingularValues();
        double[] singulars = new double[6];
        int k = 0;
        while (k < singularvalues.length) {
            if (singularvalues[k] != 0.0) {
                singulars[k] = 1.0 / singularvalues[k];
            } else {
                System.out.println("Zero singluar values");
                System.exit(1);
            }
            ++k;
        }
        double[][] ArrS = new double[][]{{singulars[0], 0.0, 0.0, 0.0, 0.0}, {0.0, singulars[1], 0.0, 0.0, 0.0}, {0.0, 0.0, singulars[2], 0.0, 0.0}, {0.0, 0.0, 0.0, singulars[3], 0.0}, {0.0, 0.0, 0.0, 0.0, singulars[4]}};
        Matrix U = SVD.getU();
        Matrix V = SVD.getV();
        Matrix S = SVD.getS();
        Matrix invS = new Matrix(ArrS, 5, 5);
        int errorCount = 0;
        try {
            PdbRdc.check(A, SVD.getU().times(SVD.getS().times(SVD.getV().transpose())));
            PdbRdc.try_success("SingularValueDecomposition...", "");
        }
        catch (RuntimeException e) {
            errorCount = PdbRdc.try_failure(errorCount, "SingularValueDecomposition...", "incorrect singular value decomposition calculation");
        }
        double[] saupe = V.times(invS.times(U.transpose().times(b)));
        double Syy = saupe[0];
        double Szz = saupe[1];
        double Sxy = saupe[2];
        double Sxz = saupe[3];
        double Syz = saupe[4];
        double[][] mArr = new double[][]{{-Syy - Szz, Sxy, Sxz}, {Sxy, Syy, Syz}, {Sxz, Syz, Szz}};
        Matrix mm = new Matrix(mArr);
        EigenvalueDecomposition eigs = new EigenvalueDecomposition(mm, true);
        Matrix VV = eigs.getV();
        Matrix DD = eigs.getD();
        VV.print(5, 12);
        DD.print(5, 12);
        double Sxx = DD.get(0, 0);
        Syy = DD.get(1, 1);
        Szz = DD.get(2, 2);
        eigenValues[0] = Syy;
        eigenValues[1] = Szz;
        Vector<Pdb> pdbVecN = pp.newPdb(pdbVec, VV.transpose());
        ModelRdc mr = new ModelRdc();
        Vector phiPsiVec1 = pp.PhiPsiTotalPdb(pdbVec);
        Vector phiPsiVec2 = pp.PhiPsiTotalPdb(pdbVecN);
        double eps = 1.0E-10;
        System.out.println(" CH ");
        eigenValues[2] = chRms = this.BackCal(pdbVec, cahaRdc, "CA", "HA", VV.transpose(), Sxx, Syy, Szz, 1.0, rdc2Cal);
        System.out.println(" CH " + chRms);
        System.out.println(" NH ");
        eigenValues[3] = nhRms = this.BackCal(pdbVec, nhRdc, "N", "H", VV.transpose(), Sxx, Syy, Szz, 1.0, rdc1Cal);
        System.out.println(" NH " + nhRms);
        if (Math.abs(((PhiPsi)phiPsiVec1.elementAt(0)).getPsi() - ((PhiPsi)phiPsiVec2.elementAt(0)).getPsi()) < eps) {
            System.out.println(" The same ");
            return VV.transpose();
        }
        System.out.println(" Differ ");
        return Const.mLeftHand.times(VV.transpose());
    }

    public double BackCalNH(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio, double[] rdcBc, double[] squareRmsd, int[] size) {
        int j;
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 1;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in file Size 1401: " + pdbRdcVec.size());
            System.exit(1);
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcBc[i] = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            ++i;
        }
        squareRmsd[0] = r;
        size[0] = pdbRdcVec.size();
        return Math.sqrt(r / (double)pdbRdcVec.size());
    }

    public double BackCalNHOne(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio, double[] rdcBc, double[] squareRmsd, int[] size) {
        int j;
        if (atom1.equalsIgnoreCase("H")) {
            atom1 = "HN";
        }
        if (atom2.equalsIgnoreCase("H")) {
            atom2 = "HN";
        }
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("H")) {
                    atom = "HN";
                }
                if (atom.equalsIgnoreCase(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equalsIgnoreCase(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcBc[i] = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            ++i;
        }
        squareRmsd[0] = r;
        size[0] = pdbRdcVec.size();
        return Math.sqrt(r);
    }

    public double BackCal(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio, double[] rdcBc, double[] squareRmsd, int[] size) {
        int j;
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in file Size 1401: " + pdbRdcVec.size());
            System.exit(1);
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcBc[i] = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            ++i;
        }
        squareRmsd[0] = r;
        size[0] = pdbRdcVec.size();
        return Math.sqrt(r / (double)pdbRdcVec.size());
    }

    public double BackCalOne(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio, double[] rdcBc, double[] squareRmsd, int[] size) {
        int j;
        if (atom1.equalsIgnoreCase("H")) {
            atom1 = "HN";
        }
        if (atom2.equalsIgnoreCase("H")) {
            atom2 = "HN";
        }
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcBc[i] = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            ++i;
        }
        squareRmsd[0] = r;
        size[0] = pdbRdcVec.size();
        return Math.sqrt(r);
    }

    public double BackCalOnePdb(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio) {
        if (atom1.equalsIgnoreCase("H")) {
            atom1 = "HN";
        }
        if (atom2.equalsIgnoreCase("H")) {
            atom2 = "HN";
        }
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("H")) {
                    atom = "HN";
                }
                if (atom.equalsIgnoreCase(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equalsIgnoreCase(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        return Math.sqrt(r / (double)pdbRdcVec.size());
    }

    public double BackCalCACO(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio, double[] rdcBc, double[] squareRmsd, int[] size, boolean isPrint) {
        int j;
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equalsIgnoreCase(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            if (isPrint) {
                System.out.println(String.valueOf(pp.getResidueNo()) + "   " + rdcCal + "   " + rdcExp + "   " + (rdcCal - rdcExp));
            }
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in file Size 1401: " + pdbRdcVec.size());
            System.exit(1);
        }
        i = 0;
        while (i < pdbVec.size() - 1) {
            pp = pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equalsIgnoreCase(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcBc[i] = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            ++i;
        }
        squareRmsd[0] = r;
        size[0] = pdbRdcVec.size();
        return Math.sqrt(r / (double)pdbRdcVec.size());
    }

    public double BackCalCACOOnePdb(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio) {
        if (pdbVec.size() < 1 || rdcVec.size() < 1) {
            return 0.0;
        }
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equalsIgnoreCase(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        return Math.sqrt(r / (double)pdbRdcVec.size());
    }

    public double BackCalCON(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio, double[] rdcBc, double[] squareRmsd, int[] size, boolean isPrint) {
        int no_next;
        int j;
        int no;
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] co = new double[3];
        double[] n_next = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase(atom1)) {
                    co = cc.getXYZ();
                }
                ++j;
            }
            no = pp.getResidueNo();
            no_next = no + 1;
            index = Collections.binarySearch(pdbVec, new Pdb(no_next), new Pdb.PdbComparator());
            if (index > -1) {
                pp = pdbVec.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase(atom2)) {
                        n_next = cc.getXYZ();
                    }
                    ++j;
                }
                nToNHVec = this.internuclearVec(co, n_next);
                nToNHVec = mm.times(this.dirCos(nToNHVec));
                cosX = nToNHVec[0];
                cosY = nToNHVec[1];
                cosZ = nToNHVec[2];
                rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
                rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
                if (isPrint) {
                    System.out.println(String.valueOf(pp.getResidueNo()) + "   " + rdcCal + "   " + rdcExp + "   " + (rdcCal - rdcExp));
                }
                r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            }
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in file Size 1401: " + pdbRdcVec.size());
            System.exit(1);
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase(atom1)) {
                    co = cc.getXYZ();
                }
                ++j;
            }
            no = pp.getResidueNo();
            no_next = no + 1;
            index = Collections.binarySearch(pdbVec, new Pdb(no_next), new Pdb.PdbComparator());
            if (index > -1) {
                pp = pdbVec.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase(atom2)) {
                        n_next = cc.getXYZ();
                    }
                    ++j;
                }
                nToNHVec = this.internuclearVec(co, n_next);
                nToNHVec = mm.times(this.dirCos(nToNHVec));
                cosX = nToNHVec[0];
                cosY = nToNHVec[1];
                cosZ = nToNHVec[2];
                rdcBc[i] = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            }
            ++i;
        }
        squareRmsd[0] = r;
        size[0] = pdbRdcVec.size();
        return Math.sqrt(r / (double)pdbRdcVec.size());
    }

    public double BackCalCONOnePdb(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio) {
        int no;
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] co = new double[3];
        double[] n_next = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase(atom1)) {
                    co = cc.getXYZ();
                }
                ++j;
            }
            no = pp.getResidueNo();
            int no_next = no + 1;
            index = Collections.binarySearch(pdbVec, new Pdb(no_next), new Pdb.PdbComparator());
            if (index > -1) {
                pp = pdbVec.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase(atom2)) {
                        n_next = cc.getXYZ();
                    }
                    ++j;
                }
                nToNHVec = this.internuclearVec(co, n_next);
                nToNHVec = mm.times(this.dirCos(nToNHVec));
                cosX = nToNHVec[0];
                cosY = nToNHVec[1];
                cosZ = nToNHVec[2];
                rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
                rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
                r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            }
            ++i;
        }
        return r;
    }

    public double BackCal(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio, double[] rdcBc) {
        int j;
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            System.out.println(String.valueOf(pp.getResidueNo()) + " CH  " + rdcCal + "   " + rdcExp + "   " + (rdcCal - rdcExp));
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in file Size 1401: " + pdbRdcVec.size());
            System.exit(1);
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcBc[i] = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            ++i;
        }
        return Math.sqrt(r / (double)pdbRdcVec.size());
    }

    public double BackCalNH(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz, double rdcRatio, double[] rdcBc) {
        int j;
        if (atom2.equalsIgnoreCase("H")) {
            atom2 = "HN";
        }
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("H")) {
                    atom = "HN";
                }
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            System.out.println(String.valueOf(pp.getResidueNo()) + " NH  " + rdcCal + "   " + rdcExp + "   " + (rdcCal - rdcExp));
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in file Size 1401: " + pdbRdcVec.size());
            System.exit(1);
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("H")) {
                    atom = "HN";
                }
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcBc[i] = (cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz) * rdcRatio;
            ++i;
        }
        return Math.sqrt(r / (double)pdbRdcVec.size());
    }

    public double[] BackCalRdcs(Vector pdbVec, Vector rdcVec, String atom1, String atom2, Matrix mm, double Sxx, double Syy, double Szz) {
        int j;
        int index = 0;
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double[] nToNHVec = new double[3];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] rdcArr = new double[pdbVec.size()];
        double r = 0.0;
        double rdcCal = 0.0;
        Dipolar dd = new Dipolar();
        Pdb pp = new Pdb();
        double cosX = 0.0;
        double cosY = 0.0;
        double cosZ = 0.0;
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbRdcVec = new Vector<PdbRdc>();
        String atom = "";
        int i = 0;
        while (i < rdcVec.size()) {
            dd = (Dipolar)rdcVec.elementAt(i);
            rdcExp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbRdcVec.add(new PdbRdc((Pdb)pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < pdbRdcVec.size()) {
            pp = ((PdbRdc)pdbRdcVec.elementAt(i)).getPdb();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcCal = cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz;
            rdcExp = ((PdbRdc)pdbRdcVec.elementAt(i)).getRdc();
            r += (rdcCal - rdcExp) * (rdcCal - rdcExp);
            ++i;
        }
        if (pdbRdcVec.size() < 2) {
            System.out.println("Error in file Size 1401: " + pdbRdcVec.size());
            System.exit(1);
        }
        i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals(atom1)) {
                    amide = cc.getXYZ();
                } else if (atom.equals(atom2)) {
                    nh = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide, nh);
            nToNHVec = mm.times(this.dirCos(nToNHVec));
            cosX = nToNHVec[0];
            cosY = nToNHVec[1];
            cosZ = nToNHVec[2];
            rdcArr[i] = rdcCal = cosX * cosX * Sxx + cosY * cosY * Syy + cosZ * cosZ * Szz;
            ++i;
        }
        return rdcArr;
    }

    public Matrix eulerFitPrintEnsemble(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec1, Vector<Dipolar> rdcVec2, double Syy, double Szz, double[] rmsds, double resolution, boolean debug, double RdcRmsdThreshold) {
        int j;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        int index = 0;
        int N = rdcVec2.size();
        Vector<Dipolar> nhRdc = rdcVec1;
        Vector<Dipolar> cahaRdc = rdcVec2;
        double Sxx = -Syy - Szz;
        double[] sRmsdCH = new double[1];
        int[] sizeCH = new int[1];
        double[] sRmsdNH = new double[1];
        int[] sizeNH = new int[1];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        Dipolar dd = rdcVec1.elementAt(0);
        int no = dd.getResidueNo();
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbNHRdcVec = new Vector<PdbRdc>();
        Vector<PdbRdc> pdbCHRdcVec = new Vector<PdbRdc>();
        String atom = "";
        String resid = "";
        int i = 0;
        while (i < rdcVec1.size()) {
            dd = rdcVec1.elementAt(i);
            rdcExp = dd.getRdc();
            no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbNHRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        i = 0;
        while (i < rdcVec2.size()) {
            dd = rdcVec2.elementAt(i);
            rdcExp = dd.getRdc();
            no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbCHRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcArr1S = new double[N];
        double[] rdcArr2S = new double[N];
        double[] rdc1Cal = new double[pdbVec.size()];
        double[] rdc2Cal = new double[pdbVec.size()];
        double[] chArr = new double[3 * N];
        double[] nhArr = new double[3 * N];
        Matrix A = new Matrix(3, 3);
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        Pdb pp = new Pdb();
        double nhRms = 0.0;
        double chRms = 0.0;
        double rdc1Rms = 0.0;
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ch = new double[3];
        double[] ha = new double[3];
        double[] nToNHVec = new double[3];
        double[] caToHAVec = new double[3];
        double[][] mat = new double[3][3];
        double r = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double r1s = 0.0;
        double r2s = 0.0;
        double rT = 10000.0;
        double rT1 = 10000.0;
        double rT2 = 10000.0;
        double eps = 1.0E-10;
        i = 0;
        while (i < N) {
            pp = pdbVec.elementAt(i);
            no = pp.getResidueNo();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide = cc.getXYZ();
                } else if (atom.equals("H")) {
                    nh = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca = cc.getXYZ();
                } else if (atom.equals("HA")) {
                    ha = cc.getXYZ();
                }
                ++j;
            }
            nhArr[3 * i] = (nh[0] - amide[0]) / 1.02;
            nhArr[3 * i + 1] = (nh[1] - amide[1]) / 1.02;
            nhArr[3 * i + 2] = (nh[2] - amide[2]) / 1.02;
            chArr[3 * i] = (ha[0] - ca[0]) / 1.09;
            chArr[3 * i + 1] = (ha[1] - ca[1]) / 1.09;
            chArr[3 * i + 2] = (ha[2] - ca[2]) / 1.09;
            ++i;
        }
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String H3fileName = String.valueOf(src) + "H3New.pdb";
        Vector<Pdb> vecH3 = pp.readPdb(H3fileName);
        Vector<Pdb> vecH3BB = pp.OutputBackbone(vecH3);
        String fileName = String.valueOf(src) + "H5AllGoodRdcRMSD.pdb";
        boolean counter = false;
        boolean nTemp = false;
        Vector vecEnsemblePdbs = new Vector();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            i = 0;
            while ((double)i < 180.0 / resolution) {
                alpha = (double)i * resolution * Math.PI / 180.0;
                j = 0;
                while ((double)j < 180.0 / resolution) {
                    beta = (double)j * resolution * Math.PI / 180.0;
                    int k = 0;
                    while ((double)k < 180.0 / resolution) {
                        block28: {
                            block27: {
                                gamma = (double)k * resolution * Math.PI / 180.0;
                                mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                                mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                                mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                                mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                                mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                                mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                                mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                                mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                                mat[2][2] = Math.cos(beta);
                                A = new Matrix(mat);
                                r = 0.0;
                                r1 = 0.0;
                                r2 = 0.0;
                                nhRms = 0.0;
                                chRms = 0.0;
                                r1 = nhRms = this.BackCalNH(pdbVec, nhRdc, "N", "H", A, Sxx, Syy, Szz, 1.0, rdc1Cal, sRmsdNH, sizeNH);
                                r2 = chRms = this.BackCal(pdbVec, cahaRdc, "CA", "HA", A, Sxx, Syy, Szz, 1.0, rdc2Cal, sRmsdCH, sizeCH);
                                r = r1 + r2;
                                if (!(r1 < 1.0) || !(r2 < 1.0)) break block27;
                                Matrix mm_temp = A.eulerMat(alpha, beta, gamma);
                                Vector<Object> vecHelixNew = new Vector();
                                vecHelixNew = pp.newPdb(pdbVec, mm_temp);
                                boolean isInPreClusters = pp.isInPdbClusters(vecEnsemblePdbs, vecHelixNew, 0.8);
                                if (isInPreClusters) break block28;
                                System.out.println("MODEL" + i + j + k);
                                out.println("MODEL" + i + " " + j + " " + k);
                                out.println("REMARK  Euler angles:  alpha=" + alpha + " beta=" + beta + " gamma=" + gamma);
                                out.println("REMARK  overall (ch and nh) RDC RMSD:  OverallRMSD=" + r);
                                out.println("REMARK  HN RDC RMSD:  HnRMSD =" + nhRms);
                                out.println("REMARK  CaHa RDC RMSD:   CaHa RMSD=" + chRms);
                                Vector<Pdb> vecHelixH35 = new Vector<Pdb>();
                                vecHelixH35.addAll(vecH3BB);
                                vecHelixH35.addAll(vecHelixNew);
                                pp.printToFile(vecHelixH35, fileName, out);
                                System.out.println("TER");
                                System.out.println("END");
                                out.println("TER");
                                out.println("ENDMDL");
                                vecEnsemblePdbs.add(vecHelixNew);
                            }
                            if (r <= rT || Math.abs(r - rT) < 1.0E-10) {
                                alphaS = alpha;
                                betaS = beta;
                                gammaS = gamma;
                                rT = r;
                                r1s = r1;
                                r2s = r2;
                                if (debug) {
                                    System.arraycopy(rdc1Cal, 0, rdcArr1S, 0, N);
                                    System.arraycopy(rdc2Cal, 0, rdcArr2S, 0, N);
                                    System.out.println(" rT = " + rT + "  " + r1 + "  " + r2);
                                    rdc1Rms = r1;
                                }
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        if (debug) {
            System.out.println(" Euler " + alphaS + "  " + betaS + "  " + gammaS);
            System.out.println();
            System.out.println("RdcNH: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                ++i;
            }
            System.out.println("RMSD = " + r1s);
            System.out.println();
            System.out.println("RdcCH: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                ++i;
            }
            System.out.println("RMSD = " + r2s);
        }
        rmsds[0] = r1s;
        rmsds[1] = r2s;
        Matrix mm = A.eulerMat(alphaS, betaS, gammaS);
        return mm;
    }

    public Matrix eulerFit4RDCs(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec1, Vector<Dipolar> rdcVec2, Vector<Dipolar> rdcVecCaCo, Vector<Dipolar> rdcVecCoN, double Syy, double Szz, double[] rmsds, double resolution, boolean debug) {
        int j;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        int index = 0;
        int N = rdcVec2.size();
        Vector<Dipolar> nhRdc = rdcVec1;
        Vector<Dipolar> cahaRdc = rdcVec2;
        double Sxx = -Syy - Szz;
        double[] sRmsdCH = new double[1];
        int[] sizeCH = new int[1];
        double[] sRmsdNH = new double[1];
        int[] sizeNH = new int[1];
        double[] sRmsdCaCo = new double[1];
        double[] sRmsdCoN = new double[1];
        int[] sizeCaCo = new int[1];
        int[] sizeCoN = new int[1];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        Dipolar dd = rdcVec1.elementAt(0);
        int no = dd.getResidueNo();
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbNHRdcVec = new Vector<PdbRdc>();
        String atom = "";
        String resid = "";
        int i = 0;
        while (i < rdcVec1.size()) {
            dd = rdcVec1.elementAt(i);
            rdcExp = dd.getRdc();
            no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbNHRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcArr1S = new double[N];
        double[] rdcArr2S = new double[N];
        double[] rdc1Cal = new double[pdbVec.size()];
        double[] rdc2Cal = new double[pdbVec.size()];
        double[] rdcCoNCal = new double[pdbVec.size()];
        double[] rdcCaCoCal = new double[pdbVec.size()];
        double[] chArr = new double[3 * N];
        double[] nhArr = new double[3 * N];
        Matrix A = new Matrix(3, 3);
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        Pdb pp = new Pdb();
        double nhRms = 0.0;
        double chRms = 0.0;
        double rdc1Rms = 0.0;
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ch = new double[3];
        double[] ha = new double[3];
        double[] nToNHVec = new double[3];
        double[] caToHAVec = new double[3];
        double[][] mat = new double[3][3];
        double r = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double r1s = 0.0;
        double r2s = 0.0;
        double rs_caco = 0.0;
        double rs_con = 0.0;
        double r_caco = 0.0;
        double r_con = 0.0;
        double rT = 10000.0;
        double rT1 = 10000.0;
        double rT2 = 10000.0;
        double eps = 1.0E-10;
        i = 0;
        while (i < N) {
            pp = pdbVec.elementAt(i);
            no = pp.getResidueNo();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide = cc.getXYZ();
                } else if (atom.equals("H")) {
                    nh = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca = cc.getXYZ();
                } else if (atom.equals("HA")) {
                    ha = cc.getXYZ();
                }
                ++j;
            }
            nhArr[3 * i] = (nh[0] - amide[0]) / 1.02;
            nhArr[3 * i + 1] = (nh[1] - amide[1]) / 1.02;
            nhArr[3 * i + 2] = (nh[2] - amide[2]) / 1.02;
            chArr[3 * i] = (ha[0] - ca[0]) / 1.09;
            chArr[3 * i + 1] = (ha[1] - ca[1]) / 1.09;
            chArr[3 * i + 2] = (ha[2] - ca[2]) / 1.09;
            ++i;
        }
        i = 0;
        while ((double)i < 180.0 / resolution) {
            alpha = (double)i * resolution * Math.PI / 180.0;
            j = 0;
            while ((double)j < 180.0 / resolution) {
                beta = (double)j * resolution * Math.PI / 180.0;
                int k = 0;
                while ((double)k < 180.0 / resolution) {
                    gamma = (double)k * resolution * Math.PI / 180.0;
                    mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                    mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                    mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                    mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                    mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                    mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                    mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                    mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                    mat[2][2] = Math.cos(beta);
                    A = new Matrix(mat);
                    r = 0.0;
                    r1 = 0.0;
                    r2 = 0.0;
                    nhRms = 0.0;
                    chRms = 0.0;
                    r_caco = 0.0;
                    r_con = 0.0;
                    nhRms = this.BackCalNH(pdbVec, nhRdc, "N", "H", A, Sxx, Syy, Szz, 1.0, rdc1Cal, sRmsdNH, sizeNH);
                    r1 = nhRms;
                    r = r1 + (r2 = (chRms = this.BackCal(pdbVec, cahaRdc, "CA", "HA", A, Sxx, Syy, Szz, 1.0, rdc2Cal, sRmsdCH, sizeCH))) + 1.0 * (r_caco = this.BackCalCACO(pdbVec, nhRdc, "CA", "C", A, Sxx, Syy, Szz, Const.cacoRatio, rdcCaCoCal, sRmsdCaCo, sizeCaCo, false)) + 1.0 * (r_con = this.BackCalCON(pdbVec, nhRdc, "C", "N", A, Sxx, Syy, Szz, Const.conRatio, rdcCoNCal, sRmsdCoN, sizeCoN, false));
                    if (r <= rT || Math.abs(r - rT) < 1.0E-10) {
                        alphaS = alpha;
                        betaS = beta;
                        gammaS = gamma;
                        rT = r;
                        r1s = r1;
                        r2s = r2;
                        rs_caco = r_caco;
                        rs_con = r_con;
                        if (debug) {
                            System.arraycopy(rdcArr1, 0, rdcArr1S, 0, N);
                            System.arraycopy(rdcArr2, 0, rdcArr2S, 0, N);
                            System.out.println(" rT = " + rT + "  " + r1 + "  " + r2);
                            rdc1Rms = r1;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (debug) {
            System.out.println(" Euler " + alphaS + "  " + betaS + "  " + gammaS);
            System.out.println();
            System.out.println("RdcNH: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                System.out.println(String.valueOf(rdcArr1S[i]) + "   " + rdcExp1[i]);
                ++i;
            }
            System.out.println("RMSD = " + r1s);
            System.out.println();
            System.out.println("RdcCH: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                System.out.println(String.valueOf(rdcArr2S[i]) + "   " + rdcExp2[i]);
                ++i;
            }
            System.out.println("RMSD = " + r2s);
        }
        rmsds[0] = r1s;
        rmsds[1] = r2s;
        rmsds[2] = rs_caco;
        rmsds[3] = rs_con;
        Matrix mm = A.eulerMat(alphaS, betaS, gammaS);
        return mm;
    }

    public Matrix eulerFit(Vector<Pdb> pdbVec, Vector<Dipolar> rdcVec1, Vector<Dipolar> rdcVec2, double Syy, double Szz, double[] rmsds, double resolution, boolean debug) {
        int j;
        int no;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        int index = 0;
        int N = pdbVec.size();
        Vector<Dipolar> nhRdc = rdcVec1;
        Vector<Dipolar> cahaRdc = rdcVec2;
        double Sxx = -Syy - Szz;
        double[] sRmsdCH = new double[1];
        int[] sizeCH = new int[1];
        double[] sRmsdNH = new double[1];
        int[] sizeNH = new int[1];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        Dipolar dd = new Dipolar();
        double rdcExp = 0.0;
        Vector<PdbRdc> pdbNHRdcVec = new Vector<PdbRdc>();
        String atom = "";
        String resid = "";
        int i = 0;
        while (i < rdcVec1.size()) {
            dd = rdcVec1.elementAt(i);
            rdcExp = dd.getRdc();
            no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pdbNHRdcVec.add(new PdbRdc(pdbVec.elementAt(index), rdcExp));
            }
            ++i;
        }
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcArr1S = new double[N];
        double[] rdcArr2S = new double[N];
        double[] rdc1Cal = new double[pdbVec.size()];
        double[] rdc2Cal = new double[pdbVec.size()];
        double[] chArr = new double[3 * N];
        double[] nhArr = new double[3 * N];
        Matrix A = new Matrix(3, 3);
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        Pdb pp = new Pdb();
        double nhRms = 0.0;
        double chRms = 0.0;
        double rdc1Rms = 0.0;
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ch = new double[3];
        double[] ha = new double[3];
        double[] nToNHVec = new double[3];
        double[] caToHAVec = new double[3];
        double[][] mat = new double[3][3];
        double r = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double r1s = 0.0;
        double r2s = 0.0;
        double rT = 10000.0;
        double rT1 = 10000.0;
        double rT2 = 10000.0;
        double eps = 1.0E-10;
        i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            no = pp.getResidueNo();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide = cc.getXYZ();
                } else if (atom.equals("H")) {
                    nh = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca = cc.getXYZ();
                } else if (atom.equals("HA")) {
                    ha = cc.getXYZ();
                }
                ++j;
            }
            nhArr[3 * i] = (nh[0] - amide[0]) / 1.02;
            nhArr[3 * i + 1] = (nh[1] - amide[1]) / 1.02;
            nhArr[3 * i + 2] = (nh[2] - amide[2]) / 1.02;
            chArr[3 * i] = (ha[0] - ca[0]) / 1.09;
            chArr[3 * i + 1] = (ha[1] - ca[1]) / 1.09;
            chArr[3 * i + 2] = (ha[2] - ca[2]) / 1.09;
            ++i;
        }
        i = 0;
        while ((double)i < 180.0 / resolution) {
            alpha = (double)i * resolution * Math.PI / 180.0;
            j = 0;
            while ((double)j < 180.0 / resolution) {
                beta = (double)j * resolution * Math.PI / 180.0;
                int k = 0;
                while ((double)k < 180.0 / resolution) {
                    gamma = (double)k * resolution * Math.PI / 180.0;
                    mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                    mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                    mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                    mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                    mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                    mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                    mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                    mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                    mat[2][2] = Math.cos(beta);
                    A = new Matrix(mat);
                    r = 0.0;
                    r1 = 0.0;
                    r2 = 0.0;
                    nhRms = 0.0;
                    chRms = 0.0;
                    nhRms = this.BackCalNH(pdbVec, nhRdc, "N", "H", A, Sxx, Syy, Szz, 1.0, rdc1Cal, sRmsdNH, sizeNH);
                    r1 = nhRms;
                    r = r1 + (r2 = (chRms = this.BackCal(pdbVec, cahaRdc, "CA", "HA", A, Sxx, Syy, Szz, 1.0, rdc2Cal, sRmsdCH, sizeCH)));
                    if (r <= rT || Math.abs(r - rT) < 1.0E-10) {
                        alphaS = alpha;
                        betaS = beta;
                        gammaS = gamma;
                        rT = r;
                        r1s = r1;
                        r2s = r2;
                        if (debug) {
                            System.arraycopy(rdcArr1, 0, rdcArr1S, 0, N);
                            System.arraycopy(rdcArr2, 0, rdcArr2S, 0, N);
                            System.out.println(" rT = " + rT + "  " + r1 + "  " + r2);
                            rdc1Rms = r1;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (debug) {
            System.out.println(" Euler " + alphaS + "  " + betaS + "  " + gammaS);
            System.out.println();
            System.out.println("RdcNH: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                System.out.println(String.valueOf(rdcArr1S[i]) + "   " + rdcExp1[i]);
                ++i;
            }
            System.out.println("RMSD = " + r1s);
            System.out.println();
            System.out.println("RdcCH: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                System.out.println(String.valueOf(rdcArr2S[i]) + "   " + rdcExp2[i]);
                ++i;
            }
            System.out.println("RMSD = " + r2s);
        }
        rmsds[0] = r1s;
        rmsds[1] = r2s;
        Matrix mm = A.eulerMat(alphaS, betaS, gammaS);
        return mm;
    }

    public Matrix eulerFit_old(Vector pdbVec, Vector rdcVec1, Vector rdcVec2, double Syy, double Szz, double[] rmsds, double resolution, boolean debug) {
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        boolean index = false;
        int N = rdcVec1.size();
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        Dipolar dd = (Dipolar)rdcVec1.elementAt(0);
        int no = dd.getResidueNo();
        int j = 0;
        while (j < N) {
            rdcExp1[j] = ((Dipolar)rdcVec1.elementAt(j)).getRdc();
            rdcExp2[j] = ((Dipolar)rdcVec2.elementAt(j)).getRdc();
            ++j;
        }
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcArr1S = new double[N];
        double[] rdcArr2S = new double[N];
        double rdc1Cal = 0.0;
        double rdc2Cal = 0.0;
        double[] chArr = new double[3 * N];
        double[] nhArr = new double[3 * N];
        Matrix A = new Matrix(3, 3);
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        Pdb pp = new Pdb();
        String atom = "";
        String resid = "";
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ch = new double[3];
        double[] ha = new double[3];
        double[] nToNHVec = new double[3];
        double[] caToHAVec = new double[3];
        double[][] mat = new double[3][3];
        double r = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double r1s = 0.0;
        double r2s = 0.0;
        double rT = 10000.0;
        double rT1 = 10000.0;
        double rT2 = 10000.0;
        double eps = 1.0E-10;
        int i = 0;
        while (i < N) {
            pp = (Pdb)pdbVec.elementAt(i);
            no = pp.getResidueNo();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide = cc.getXYZ();
                } else if (atom.equals("H")) {
                    nh = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca = cc.getXYZ();
                } else if (atom.equals("HA")) {
                    ha = cc.getXYZ();
                }
                ++j;
            }
            nhArr[3 * i] = (nh[0] - amide[0]) / 1.02;
            nhArr[3 * i + 1] = (nh[1] - amide[1]) / 1.02;
            nhArr[3 * i + 2] = (nh[2] - amide[2]) / 1.02;
            chArr[3 * i] = (ha[0] - ca[0]) / 1.09;
            chArr[3 * i + 1] = (ha[1] - ca[1]) / 1.09;
            chArr[3 * i + 2] = (ha[2] - ca[2]) / 1.09;
            ++i;
        }
        i = 0;
        while ((double)i < 180.0 / resolution) {
            alpha = (double)i * resolution * Math.PI / 180.0;
            j = 0;
            while ((double)j < 180.0 / resolution) {
                beta = (double)j * resolution * Math.PI / 180.0;
                int k = 0;
                while ((double)k < 180.0 / resolution) {
                    gamma = (double)k * resolution * Math.PI / 180.0;
                    mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                    mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                    mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                    mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                    mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                    mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                    mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                    mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                    mat[2][2] = Math.cos(beta);
                    A = new Matrix(mat);
                    r = 0.0;
                    r1 = 0.0;
                    r2 = 0.0;
                    int m = 0;
                    while (m < N) {
                        nh[0] = nhArr[3 * m];
                        nh[1] = nhArr[3 * m + 1];
                        nh[2] = nhArr[3 * m + 2];
                        nh = A.times(nh);
                        rdc1Cal = ((nh[1] * nh[1] - nh[0] * nh[0]) * Syy + (nh[2] * nh[2] - nh[0] * nh[0]) * Szz) * 1.0;
                        r1 += (rdc1Cal - rdcExp1[m]) * (rdc1Cal - rdcExp1[m]);
                        ch[0] = chArr[3 * m];
                        ch[1] = chArr[3 * m + 1];
                        ch[2] = chArr[3 * m + 2];
                        ch = A.times(ch);
                        rdc2Cal = (ch[1] * ch[1] - ch[0] * ch[0]) * Syy + (ch[2] * ch[2] - ch[0] * ch[0]) * Szz;
                        r2 += (rdc2Cal - rdcExp2[m]) * (rdc2Cal - rdcExp2[m]);
                        rdcArr1[m] = rdc1Cal;
                        rdcArr2[m] = rdc2Cal;
                        ++m;
                    }
                    r = r1 + r2;
                    if (r <= rT || Math.abs(r - rT) < 1.0E-10) {
                        alphaS = alpha;
                        betaS = beta;
                        gammaS = gamma;
                        rT = r;
                        r1s = r1;
                        r2s = r2;
                        if (debug) {
                            System.arraycopy(rdcArr1, 0, rdcArr1S, 0, N);
                            System.arraycopy(rdcArr2, 0, rdcArr2S, 0, N);
                            System.out.println(" rT = " + rT + "  " + r1 + "  " + r2);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (debug) {
            System.out.println(" Euler " + alphaS + "  " + betaS + "  " + gammaS);
            System.out.println();
            System.out.println("RdcNH: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                System.out.println(String.valueOf(rdcArr1S[i]) + "   " + rdcExp1[i]);
                ++i;
            }
            System.out.println("RMSD = " + Math.sqrt(r1s / (double)N));
            System.out.println();
            System.out.println("RdcCH: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                System.out.println(String.valueOf(rdcArr2S[i]) + "   " + rdcExp2[i]);
                ++i;
            }
            System.out.println("RMSD = " + Math.sqrt(r2s / (double)N));
        }
        rmsds[0] = r1s;
        rmsds[1] = r2s;
        Matrix mm = A.eulerMat(alphaS, betaS, gammaS);
        return mm;
    }

    public Matrix fit4MissingRdc(Vector pdbVec, Vector rdcVec1, Vector rdcVec2, double Syy, double Szz, double[] rmsds, double resolution, boolean debug) {
        int j;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        int index = 0;
        int N = pdbVec.size() - 1;
        int N1 = rdcVec1.size();
        int N2 = rdcVec2.size();
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcArr1S = new double[N];
        double[] rdcArr2S = new double[N];
        int[] rdc1MissNo = new int[N];
        int[] rdc2MissNo = new int[N];
        double[] chArr = new double[3 * N];
        double[] nhArr = new double[3 * N];
        PdbRmsd pR = new PdbRmsd();
        Dipolar dd = new Dipolar();
        Matrix A = new Matrix(3, 3);
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        Pdb pp = new Pdb();
        String atom = "";
        String resid = "";
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ch = new double[3];
        double[] ha = new double[3];
        double[] nToNHVec = new double[3];
        double[] caToHAVec = new double[3];
        double[][] mat = new double[3][3];
        double r = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double rT = 10000.0;
        double rT1 = 10000.0;
        double rT2 = 10000.0;
        double eps = 1.0E-10;
        double r1s = 0.0;
        double r2s = 0.0;
        double rdc1Cal = 0.0;
        double rdc2Cal = 0.0;
        double hScore = 0.0;
        double hScoreS = 0.0;
        Vector pdbVecN = new Vector();
        int i = 0;
        while (i < N) {
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                dd = (Dipolar)rdcVec1.elementAt(index);
                rdcExp1[i] = dd.getRdc();
                rdc1MissNo[i] = 1;
            } else {
                rdcExp1[i] = 0.0;
                rdc1MissNo[i] = 0;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                dd = (Dipolar)rdcVec2.elementAt(index);
                rdcExp2[i] = dd.getRdc();
                rdc2MissNo[i] = 1;
            } else {
                rdcExp2[i] = 0.0;
                rdc2MissNo[i] = 0;
            }
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide = cc.getXYZ();
                } else if (atom.equals("H")) {
                    nh = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca = cc.getXYZ();
                } else if (atom.equals("HA")) {
                    ha = cc.getXYZ();
                }
                ++j;
            }
            nhArr[3 * i] = (nh[0] - amide[0]) / 1.02;
            nhArr[3 * i + 1] = (nh[1] - amide[1]) / 1.02;
            nhArr[3 * i + 2] = (nh[2] - amide[2]) / 1.02;
            chArr[3 * i] = (ha[0] - ca[0]) / 1.09;
            chArr[3 * i + 1] = (ha[1] - ca[1]) / 1.09;
            chArr[3 * i + 2] = (ha[2] - ca[2]) / 1.09;
            ++i;
        }
        i = 0;
        while ((double)i < 360.0 / resolution) {
            alpha = (double)i * resolution * Math.PI / 180.0;
            j = 0;
            while ((double)j < 180.0 / resolution) {
                beta = (double)j * resolution * Math.PI / 180.0;
                int k = 0;
                while ((double)k < 360.0 / resolution) {
                    gamma = (double)k * resolution * Math.PI / 180.0;
                    mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                    mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                    mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                    mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                    mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                    mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                    mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                    mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                    mat[2][2] = Math.cos(beta);
                    A = new Matrix(mat);
                    r = 0.0;
                    r1 = 0.0;
                    r2 = 0.0;
                    int m = 0;
                    while (m < N) {
                        nh[0] = nhArr[3 * m];
                        nh[1] = nhArr[3 * m + 1];
                        nh[2] = nhArr[3 * m + 2];
                        nh = A.times(nh);
                        rdc1Cal = ((nh[1] * nh[1] - nh[0] * nh[0]) * Syy + (nh[2] * nh[2] - nh[0] * nh[0]) * Szz) * 1.0;
                        r1 += (rdc1Cal - rdcExp1[m]) * (rdc1Cal - rdcExp1[m]) * (double)rdc1MissNo[m];
                        ch[0] = chArr[3 * m];
                        ch[1] = chArr[3 * m + 1];
                        ch[2] = chArr[3 * m + 2];
                        ch = A.times(ch);
                        rdc2Cal = (ch[1] * ch[1] - ch[0] * ch[0]) * Syy + (ch[2] * ch[2] - ch[0] * ch[0]) * Szz;
                        r2 += (rdc2Cal - rdcExp2[m]) * (rdc2Cal - rdcExp2[m]) * (double)rdc2MissNo[m];
                        rdcArr1[m] = rdc1Cal;
                        rdcArr2[m] = rdc2Cal;
                        ++m;
                    }
                    r = Math.sqrt(r1 / (double)N1) + Math.sqrt(r2 / (double)N2);
                    if (r < rT || Math.abs(r - rT) < 1.0E-4) {
                        alphaS = alpha;
                        betaS = beta;
                        gammaS = gamma;
                        r1s = r1;
                        r2s = r2;
                        rT = r;
                        if (debug) {
                            System.arraycopy(rdcArr1, 0, rdcArr1S, 0, N);
                            System.arraycopy(rdcArr2, 0, rdcArr2S, 0, N);
                            System.out.println(" rT = " + rT + "  " + r1 + "  " + r2);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (debug) {
            System.out.println("RDC1 RMSD = " + Math.sqrt(r1s / (double)rdcVec1.size()));
            System.out.println("RDC2 RMSD = " + Math.sqrt(r2s / (double)rdcVec2.size()));
        }
        rmsds[0] = r1s;
        rmsds[1] = r2s;
        Matrix mm = A.eulerMat(alphaS, betaS, gammaS);
        return mm;
    }

    public Matrix fit4MissingRdcHB(Vector pdbVec, Vector rdcVec1, Vector rdcVec2, double Syy, double Szz, Vector pdbVecA, double[] rmsds, double resolution, double weight4HB, Vector hbVec, boolean debug) {
        int j;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        int index = 0;
        int N = pdbVec.size() - 1;
        int N1 = rdcVec1.size();
        int N2 = rdcVec2.size();
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcArr1S = new double[N];
        double[] rdcArr2S = new double[N];
        int[] rdc1MissNo = new int[N];
        int[] rdc2MissNo = new int[N];
        double[] chArr = new double[3 * N];
        double[] nhArr = new double[3 * N];
        PdbRmsd pR = new PdbRmsd();
        Dipolar dd = new Dipolar();
        Matrix A = new Matrix(3, 3);
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        Pdb pp = new Pdb();
        String atom = "";
        String resid = "";
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ch = new double[3];
        double[] ha = new double[3];
        double[] nToNHVec = new double[3];
        double[] caToHAVec = new double[3];
        double[][] mat = new double[3][3];
        double r = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double rT = 100000.0;
        double rT1 = 10000.0;
        double rT2 = 10000.0;
        double eps = 1.0E-10;
        double r1s = 0.0;
        double r2s = 0.0;
        double rdc1Cal = 0.0;
        double rdc2Cal = 0.0;
        double hScore = 0.0;
        double hScoreS = 0.0;
        Vector<Object> pdbVecN = new Vector();
        int i = 0;
        while (i < N) {
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                dd = (Dipolar)rdcVec1.elementAt(index);
                rdcExp1[i] = dd.getRdc();
                rdc1MissNo[i] = 1;
            } else {
                rdcExp1[i] = 0.0;
                rdc1MissNo[i] = 0;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                dd = (Dipolar)rdcVec2.elementAt(index);
                rdcExp2[i] = dd.getRdc();
                rdc2MissNo[i] = 1;
            } else {
                rdcExp2[i] = 0.0;
                rdc2MissNo[i] = 0;
            }
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide = cc.getXYZ();
                } else if (atom.equals("H")) {
                    nh = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca = cc.getXYZ();
                } else if (atom.equals("HA")) {
                    ha = cc.getXYZ();
                }
                ++j;
            }
            nhArr[3 * i] = (nh[0] - amide[0]) / 1.02;
            nhArr[3 * i + 1] = (nh[1] - amide[1]) / 1.02;
            nhArr[3 * i + 2] = (nh[2] - amide[2]) / 1.02;
            chArr[3 * i] = (ha[0] - ca[0]) / 1.09;
            chArr[3 * i + 1] = (ha[1] - ca[1]) / 1.09;
            chArr[3 * i + 2] = (ha[2] - ca[2]) / 1.09;
            ++i;
        }
        i = 0;
        while ((double)i < 360.0 / resolution) {
            alpha = (double)i * resolution * Math.PI / 180.0;
            j = 0;
            while ((double)j < 180.0 / resolution) {
                beta = (double)j * resolution * Math.PI / 180.0;
                int k = 0;
                while ((double)k < 360.0 / resolution) {
                    gamma = (double)k * resolution * Math.PI / 180.0;
                    mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                    mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                    mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                    mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                    mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                    mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                    mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                    mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                    mat[2][2] = Math.cos(beta);
                    A = new Matrix(mat);
                    r = 0.0;
                    r1 = 0.0;
                    r2 = 0.0;
                    int m = 0;
                    while (m < N) {
                        nh[0] = nhArr[3 * m];
                        nh[1] = nhArr[3 * m + 1];
                        nh[2] = nhArr[3 * m + 2];
                        nh = A.times(nh);
                        rdc1Cal = ((nh[1] * nh[1] - nh[0] * nh[0]) * Syy + (nh[2] * nh[2] - nh[0] * nh[0]) * Szz) * 1.0;
                        r1 += (rdc1Cal - rdcExp1[m]) * (rdc1Cal - rdcExp1[m]) * (double)rdc1MissNo[m];
                        ch[0] = chArr[3 * m];
                        ch[1] = chArr[3 * m + 1];
                        ch[2] = chArr[3 * m + 2];
                        ch = A.times(ch);
                        rdc2Cal = (ch[1] * ch[1] - ch[0] * ch[0]) * Syy + (ch[2] * ch[2] - ch[0] * ch[0]) * Szz;
                        r2 += (rdc2Cal - rdcExp2[m]) * (rdc2Cal - rdcExp2[m]) * (double)rdc2MissNo[m];
                        rdcArr1[m] = rdc1Cal;
                        rdcArr2[m] = rdc2Cal;
                        ++m;
                    }
                    pdbVecN = pp.newPdb(pdbVec, A);
                    hScore = pR.centerFit(pdbVecA, pdbVecN, hbVec, false);
                    r = weight4HB * hScore + Math.sqrt(r1 / (double)N1) + Math.sqrt(r2 / (double)N2);
                    if (r < rT || Math.abs(r - rT) < 1.0E-4) {
                        alphaS = alpha;
                        betaS = beta;
                        gammaS = gamma;
                        r1s = r1;
                        r2s = r2;
                        hScoreS = hScore;
                        rT = r;
                        if (debug) {
                            System.arraycopy(rdcArr1, 0, rdcArr1S, 0, N);
                            System.arraycopy(rdcArr2, 0, rdcArr2S, 0, N);
                            System.out.println(" rT = " + rT + "  " + r1 + "  " + r2 + "  " + hScore);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (debug) {
            System.out.println("RDC1 RMSD = " + Math.sqrt(r1s / (double)rdcVec1.size()));
            System.out.println("RDC2 RMSD = " + Math.sqrt(r2s / (double)rdcVec2.size()));
        }
        rmsds[0] = r1s;
        rmsds[1] = r2s;
        rmsds[2] = hScoreS;
        Matrix mm = A.eulerMat(alphaS, betaS, gammaS);
        return mm;
    }

    public Matrix fit4MissingRdcHB2(Vector pdbVec, Vector rdcVec1, Vector rdcVec2, double Syy, double Szz, Vector pdbVecA1, Vector pdbVecA2, double[] rmsds, double resolution, double weight4HB, Vector hbVec1, Vector hbVec2, boolean debug) {
        int j;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        int index = 0;
        int N = pdbVec.size() - 1;
        int N1 = rdcVec1.size();
        int N2 = rdcVec2.size();
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcArr1S = new double[N];
        double[] rdcArr2S = new double[N];
        int[] rdc1MissNo = new int[N];
        int[] rdc2MissNo = new int[N];
        double[] chArr = new double[3 * N];
        double[] nhArr = new double[3 * N];
        PdbRmsd pR = new PdbRmsd();
        Dipolar dd = new Dipolar();
        Matrix A = new Matrix(3, 3);
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        Pdb pp = new Pdb();
        String atom = "";
        String resid = "";
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ch = new double[3];
        double[] ha = new double[3];
        double[] nToNHVec = new double[3];
        double[] caToHAVec = new double[3];
        double[][] mat = new double[3][3];
        double r = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double rT = 100000.0;
        double rT1 = 10000.0;
        double rT2 = 10000.0;
        double eps = 1.0E-10;
        double r1s = 0.0;
        double r2s = 0.0;
        double rdc1Cal = 0.0;
        double rdc2Cal = 0.0;
        double hScore1 = 0.0;
        double hScore2 = 0.0;
        double hScore = 0.0;
        double hScoreS = 0.0;
        Vector<Object> pdbVecN = new Vector();
        int i = 0;
        while (i < N) {
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                dd = (Dipolar)rdcVec1.elementAt(index);
                rdcExp1[i] = dd.getRdc();
                rdc1MissNo[i] = 1;
            } else {
                rdcExp1[i] = 0.0;
                rdc1MissNo[i] = 0;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                dd = (Dipolar)rdcVec2.elementAt(index);
                rdcExp2[i] = dd.getRdc();
                rdc2MissNo[i] = 1;
            } else {
                rdcExp2[i] = 0.0;
                rdc2MissNo[i] = 0;
            }
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide = cc.getXYZ();
                } else if (atom.equals("H")) {
                    nh = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca = cc.getXYZ();
                } else if (atom.equals("HA")) {
                    ha = cc.getXYZ();
                }
                ++j;
            }
            nhArr[3 * i] = (nh[0] - amide[0]) / 1.02;
            nhArr[3 * i + 1] = (nh[1] - amide[1]) / 1.02;
            nhArr[3 * i + 2] = (nh[2] - amide[2]) / 1.02;
            chArr[3 * i] = (ha[0] - ca[0]) / 1.09;
            chArr[3 * i + 1] = (ha[1] - ca[1]) / 1.09;
            chArr[3 * i + 2] = (ha[2] - ca[2]) / 1.09;
            ++i;
        }
        i = 0;
        while ((double)i < 360.0 / resolution) {
            alpha = (double)i * resolution * Math.PI / 180.0;
            j = 0;
            while ((double)j < 180.0 / resolution) {
                beta = (double)j * resolution * Math.PI / 180.0;
                int k = 0;
                while ((double)k < 360.0 / resolution) {
                    gamma = (double)k * resolution * Math.PI / 180.0;
                    mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                    mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                    mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                    mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                    mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                    mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                    mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                    mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                    mat[2][2] = Math.cos(beta);
                    A = new Matrix(mat);
                    r = 0.0;
                    r1 = 0.0;
                    r2 = 0.0;
                    int m = 0;
                    while (m < N) {
                        nh[0] = nhArr[3 * m];
                        nh[1] = nhArr[3 * m + 1];
                        nh[2] = nhArr[3 * m + 2];
                        nh = A.times(nh);
                        rdc1Cal = ((nh[1] * nh[1] - nh[0] * nh[0]) * Syy + (nh[2] * nh[2] - nh[0] * nh[0]) * Szz) * 1.0;
                        r1 += (rdc1Cal - rdcExp1[m]) * (rdc1Cal - rdcExp1[m]) * (double)rdc1MissNo[m];
                        ch[0] = chArr[3 * m];
                        ch[1] = chArr[3 * m + 1];
                        ch[2] = chArr[3 * m + 2];
                        ch = A.times(ch);
                        rdc2Cal = (ch[1] * ch[1] - ch[0] * ch[0]) * Syy + (ch[2] * ch[2] - ch[0] * ch[0]) * Szz;
                        r2 += (rdc2Cal - rdcExp2[m]) * (rdc2Cal - rdcExp2[m]) * (double)rdc2MissNo[m];
                        rdcArr1[m] = rdc1Cal;
                        rdcArr2[m] = rdc2Cal;
                        ++m;
                    }
                    pdbVecN = pp.newPdb(pdbVec, A);
                    hScore1 = pR.centerFit(pdbVecA1, pdbVecN, hbVec1, false);
                    hScore = hScore1 + 4.0 * (hScore2 = pR.centerFit(pdbVecN, pdbVecA2, hbVec2, false));
                    r = weight4HB * hScore + Math.sqrt(r1 / (double)N1) + Math.sqrt(r2 / (double)N2);
                    if (r < rT || Math.abs(r - rT) < 1.0E-4) {
                        alphaS = alpha;
                        betaS = beta;
                        gammaS = gamma;
                        r1s = r1;
                        r2s = r2;
                        hScoreS = hScore;
                        rT = r;
                        if (debug) {
                            System.arraycopy(rdcArr1, 0, rdcArr1S, 0, N);
                            System.arraycopy(rdcArr2, 0, rdcArr2S, 0, N);
                            System.out.println(" rT = " + rT + "  " + r1 + "  " + r2 + "  " + hScore);
                            System.out.println(" rT = " + alphaS + "  " + betaS + "  " + gammaS);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (debug) {
            System.out.println("RDC1 RMSD = " + Math.sqrt(r1s / (double)rdcVec1.size()));
            System.out.println("RDC2 RMSD = " + Math.sqrt(r2s / (double)rdcVec2.size()));
        }
        rmsds[0] = r1s;
        rmsds[1] = r2s;
        rmsds[2] = hScoreS;
        Matrix mm = A.eulerMat(alphaS, betaS, gammaS);
        return mm;
    }

    public Matrix eulerFitHB(Vector pdbVec, Vector rdcVec1, Vector rdcVec2, double[] saupe, Matrix rot, double[] rmsds, double resolution, double weight4HB, Vector pdbVecS1, Vector hbVec, Matrix mat4Dirs, boolean debug) {
        int j;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double alphaS = 0.0;
        double betaS = 0.0;
        double gammaS = 0.0;
        int index = 0;
        Matrix A = new Matrix(3, 3);
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        Pdb pp = new Pdb();
        String atom = "";
        String resid = "";
        Dipolar dd = new Dipolar();
        double rdc1Exp = 0.0;
        double rdc2Exp = 0.0;
        Vector pdbRdcVec = new Vector();
        int N = rdcVec1.size();
        double[][] nhRdcArr = new double[N][5];
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcArr1S = new double[N];
        double[] rdcArr2S = new double[N];
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] nh2 = new double[3];
        double[] nhB = new double[3];
        double[][] mat = new double[3][3];
        double r = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double rT = 10000.0;
        double r1s = 0.0;
        double r2s = 0.0;
        double rdc1Cal = 0.0;
        double rdc2Cal = 0.0;
        Vector<Object> pdbVecN = new Vector();
        double hScore = 0.0;
        double hScoreS = 0.0;
        PdbRmsd pR = new PdbRmsd();
        int i = 0;
        while (i < N) {
            dd = (Dipolar)rdcVec1.elementAt(i);
            rdc1Exp = dd.getRdc();
            dd = (Dipolar)rdcVec2.elementAt(i);
            rdc2Exp = dd.getRdc();
            int no = dd.getResidueNo();
            index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVec.elementAt(index);
                no = pp.getResidueNo();
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equals("N")) {
                        amide = cc.getXYZ();
                    } else if (atom.equals("H")) {
                        nh = cc.getXYZ();
                    }
                    ++j;
                }
                nhRdcArr[i][0] = (nh[0] - amide[0]) / 1.02;
                nhRdcArr[i][1] = (nh[1] - amide[1]) / 1.02;
                nhRdcArr[i][2] = (nh[2] - amide[2]) / 1.02;
                nhRdcArr[i][3] = rdc1Exp;
                nhRdcArr[i][4] = rdc2Exp;
            }
            ++i;
        }
        if (debug) {
            System.out.println(" totalScore, rmsdRDC1,  rmsdRDC2,  hbScore");
        }
        i = 0;
        while ((double)i < 360.0 / resolution) {
            alpha = (double)i * resolution * Math.PI / 180.0;
            j = 0;
            while ((double)j < 180.0 / resolution) {
                beta = (double)j * resolution * Math.PI / 180.0;
                int k = 0;
                while ((double)k < 360.0 / resolution) {
                    gamma = (double)k * resolution * Math.PI / 180.0;
                    mat[0][0] = Math.cos(alpha) * Math.cos(beta) * Math.cos(gamma) - Math.sin(alpha) * Math.sin(gamma);
                    mat[0][1] = Math.sin(alpha) * Math.cos(beta) * Math.cos(gamma) + Math.cos(alpha) * Math.sin(gamma);
                    mat[0][2] = -Math.sin(beta) * Math.cos(gamma);
                    mat[1][0] = -Math.cos(alpha) * Math.cos(beta) * Math.sin(gamma) - Math.sin(alpha) * Math.cos(gamma);
                    mat[1][1] = -Math.sin(alpha) * Math.cos(beta) * Math.sin(gamma) + Math.cos(alpha) * Math.cos(gamma);
                    mat[1][2] = Math.sin(gamma) * Math.sin(beta);
                    mat[2][0] = Math.sin(beta) * Math.cos(alpha);
                    mat[2][1] = Math.sin(alpha) * Math.sin(beta);
                    mat[2][2] = Math.cos(beta);
                    A = new Matrix(mat);
                    A = A.times(mat4Dirs);
                    r = 0.0;
                    r1 = 0.0;
                    r2 = 0.0;
                    int m = 0;
                    while (m < N) {
                        nhB[0] = nhRdcArr[m][0];
                        nhB[1] = nhRdcArr[m][1];
                        nhB[2] = nhRdcArr[m][2];
                        nh = A.times(nhB);
                        nh2 = nh;
                        rdc1Cal = (nh[1] * nh[1] - nh[0] * nh[0]) * saupe[0] + (nh[2] * nh[2] - nh[0] * nh[0]) * saupe[1];
                        rdc2Cal = (nh2[1] * nh2[1] - nh2[0] * nh2[0]) * saupe[2] + (nh2[2] * nh2[2] - nh2[0] * nh2[0]) * saupe[3];
                        r1 += (rdc1Cal - nhRdcArr[m][3]) * (rdc1Cal - nhRdcArr[m][3]);
                        r2 += (rdc2Cal - nhRdcArr[m][4]) * (rdc2Cal - nhRdcArr[m][4]);
                        rdcArr1[m] = rdc1Cal;
                        rdcArr2[m] = rdc2Cal;
                        ++m;
                    }
                    pdbVecN = pp.newPdb(pdbVec, A);
                    hScore = pR.centerFit(pdbVecS1, pdbVecN, hbVec, false);
                    r = weight4HB * hScore + Math.sqrt(r1 / (double)N) + Math.sqrt(r2 / (double)N);
                    if (r < rT || Math.abs(r - rT) < 1.0E-4) {
                        alphaS = alpha;
                        betaS = beta;
                        gammaS = gamma;
                        r1s = r1;
                        r2s = r2;
                        hScoreS = hScore;
                        rT = r;
                        if (debug) {
                            System.arraycopy(rdcArr1, 0, rdcArr1S, 0, N);
                            System.arraycopy(rdcArr2, 0, rdcArr2S, 0, N);
                            System.out.println(" rT = " + rT + "  " + r1 + "  " + r2 + "  " + hScore);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (debug) {
            System.out.println();
            System.out.println("Rdc1: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                System.out.println(String.valueOf(rdcArr1S[i]) + "   " + nhRdcArr[i][3]);
                ++i;
            }
            System.out.println("RMSD = " + Math.sqrt(r1s / (double)N));
            System.out.println();
            System.out.println("Rdc2: ");
            System.out.println("back-computed RDCs,    measured RDCs");
            i = 0;
            while (i < N) {
                System.out.println(String.valueOf(rdcArr2S[i]) + "   " + nhRdcArr[i][4]);
                ++i;
            }
            System.out.println("RMSD = " + Math.sqrt(r2s / (double)N));
        }
        rmsds[0] = r1s;
        rmsds[1] = r2s;
        rmsds[2] = hScoreS;
        Matrix mm = A.eulerMat(alphaS, betaS, gammaS).times(mat4Dirs);
        return mm;
    }

    private static void check(double x, double y) {
        double eps = Math.pow(2.0, -52.0);
        if (x == 0.0 & Math.abs(y) < 10.0 * eps) {
            return;
        }
        if (y == 0.0 & Math.abs(x) < 10.0 * eps) {
            return;
        }
        if (Math.abs(x - y) > 10.0 * eps * Math.max(Math.abs(x), Math.abs(y))) {
            throw new RuntimeException("The difference x-y is too large: x = " + Double.toString(x) + "  y = " + Double.toString(y));
        }
    }

    private static void check(double[] x, double[] y) {
        if (x.length == y.length) {
            int i = 0;
            while (i < x.length) {
                PdbRdc.check(x[i], y[i]);
                ++i;
            }
        } else {
            throw new RuntimeException("Attempt to compare vectors of different lengths");
        }
    }

    private static void check(double[][] x, double[][] y) {
        Matrix A = new Matrix(x);
        Matrix B = new Matrix(y);
        PdbRdc.check(A, B);
    }

    private static void check(Matrix X, Matrix Y) {
        double eps = Math.pow(2.0, -52.0);
        if (X.norm1() == 0.0 & Y.norm1() < 10.0 * eps) {
            return;
        }
        if (Y.norm1() == 0.0 & X.norm1() < 10.0 * eps) {
            return;
        }
        if (X.minus(Y).norm1() > 1000.0 * eps * Math.max(X.norm1(), Y.norm1())) {
            throw new RuntimeException("The norm of (X-Y) is too large: " + Double.toString(X.minus(Y).norm1()));
        }
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static void try_success(String s, String e) {
        PdbRdc.print(">    " + s + "success\n");
        if (e != "") {
            PdbRdc.print(">      Message: " + e + "\n");
        }
    }

    private static int try_failure(int count, String s, String e) {
        PdbRdc.print(">    " + s + "*** failure ***\n>      Message: " + e + "\n");
        return ++count;
    }
}

