/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Cartesian;
import rdcPanda.Const;
import rdcPanda.Dipolar;
import rdcPanda.Goal;
import rdcPanda.H1CS;
import rdcPanda.Loops;
import rdcPanda.Matrix;
import rdcPanda.Model;
import rdcPanda.ModelRdc;
import rdcPanda.Nasca;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.PdbRdc;
import rdcPanda.PdbRmsd;
import rdcPanda.Peak;
import rdcPanda.PhiPsi;
import rdcPanda.vdw;

public class RdcPanda {
    public String rotLibName = "rot-lib";

    public static void main(String[] args) throws JampackException, InterruptedException {
        RdcPanda rdcPanda = new RdcPanda();
        rdcPanda.outputProgInfo();
        rdcPanda.parse(args);
    }

    public void parse(String[] args) throws JampackException, InterruptedException {
        boolean done = false;
        boolean commandLineScript = false;
        boolean firstCommandLine = false;
        String s = new String("");
        String userDir = System.getProperty("user.dir");
        String strSystemFile = String.valueOf(userDir) + "/system/system-parameters.txt";
        Assign asgTemp = new Assign();
        Vector<Map<String, String>> paraVec = asgTemp.ParamReader(strSystemFile);
        String strInputPath = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("INPUTPATH")) {
                strInputPath = paraMap.get("INPUTPATH");
            }
            ++i;
        }
        String src = String.valueOf(userDir) + strInputPath;
        String strOut = String.valueOf(userDir) + "/outFiles/";
        if (args.length > 0) {
            commandLineScript = true;
            firstCommandLine = true;
        }
        while (!done) {
            Noe noe;
            Pdb pp;
            RdcPanda rdcPanda;
            Assign asg;
            byte[] bytebuff = new byte[150];
            if (!commandLineScript) {
                System.out.print("RDC-PANDA> ");
                try {
                    System.in.read(bytebuff);
                }
                catch (Exception e) {
                    System.out.println("ERROR: An error occurred while reading input");
                    System.exit(0);
                }
                s = new String(bytebuff);
            } else if (commandLineScript && !firstCommandLine) {
                s = new String("quit");
            } else if (firstCommandLine) {
                s = new String("");
                int i2 = 0;
                while (i2 < args.length) {
                    s = s.concat(String.valueOf(args[i2]) + " ");
                    ++i2;
                }
                firstCommandLine = false;
            }
            s = s.trim();
            StringTokenizer st = new StringTokenizer(s, " ;\t\n\r\f");
            String firstToken = new String("");
            if (st.hasMoreTokens()) {
                firstToken = st.nextToken();
            }
            if (firstToken.length() > 1 && firstToken.substring(0, 2).equals("//")) continue;
            String secondToken = new String("");
            if (st.hasMoreTokens()) {
                secondToken = st.nextToken();
            }
            if (firstToken.equalsIgnoreCase("quit") || firstToken.equalsIgnoreCase("q")) {
                done = true;
                return;
            }
            if (firstToken.equalsIgnoreCase("NOEAsgFromCS")) {
                if (secondToken.length() > 0) {
                    asg = new Assign();
                    asg.NOEAsgFromCS(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("NOEAsgFromCS");
                }
            } else if (firstToken.equalsIgnoreCase("SSEPacking")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doSSEPacking(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("SSEPacking");
                }
            } else if (firstToken.equalsIgnoreCase("checkPackSym")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doCheckPackingSym(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("checkPackSym");
                }
            } else if (firstToken.equalsIgnoreCase("mergeNCluster")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doMergeNCluster(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("mergeNCluster");
                }
            } else if (firstToken.equalsIgnoreCase("mergeNClusterAll")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doMergeNClusterAll(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("mergeNClusterAll");
                }
            } else if (firstToken.equalsIgnoreCase("addSideChains")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doAddSideChains(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("addSideChains");
                }
            } else if (firstToken.equalsIgnoreCase("addRandomLoops")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doAddRandomLoops(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("addRandomLoops");
                }
            } else if (firstToken.equalsIgnoreCase("calNOEScore")) {
                if (secondToken.length() > 0) {
                    pp = new Pdb();
                    pp.doCalNOEScores(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("calNOEScore");
                }
            } else if (firstToken.equalsIgnoreCase("HANA_NOE_Asg")) {
                if (secondToken.length() > 0) {
                    asg = new Assign();
                    asg.doHANANOEAsg(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("HANA_NOE_Asg");
                }
            } else if (firstToken.equalsIgnoreCase("RefineNOEsWBB")) {
                if (secondToken.length() > 0) {
                    asg = new Assign();
                    asg.doRefineNOEsWBB(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("RefineNOEsWBB");
                }
            } else if (firstToken.equalsIgnoreCase("CompareTwoNOETables")) {
                if (secondToken.length() > 0) {
                    asg = new Assign();
                    asg.doCompareTwoNOETables(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("CompareTwoNOETables");
                }
            } else if (firstToken.equalsIgnoreCase("ExtractNOEs")) {
                if (secondToken.length() > 0) {
                    asg = new Assign();
                    asg.doExtractNOEs(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("ExtractNOEs");
                }
            } else if (firstToken.equalsIgnoreCase("LongNOEsAsgWOStructure")) {
                if (secondToken.length() > 0) {
                    asg = new Assign();
                    asg.doLongNOEsAsgWOStructure(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("LongNOEsAsgWOStructure");
                }
            } else if (firstToken.equalsIgnoreCase("LongNOEsAsgWOStructureNew")) {
                if (secondToken.length() > 0) {
                    asg = new Assign();
                    asg.doLongNOEsAsgWOStructureNew(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("LongNOEsAsgWOStructureNew");
                }
            } else if (firstToken.equalsIgnoreCase("ReadPDBEnergy")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doReadPDBEnergy(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("ReadPDBEnergy");
                }
            } else if (firstToken.equalsIgnoreCase("RefineRDCExact")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doRefineRdcExact(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("RefineRDCExact");
                }
            } else if (firstToken.equalsIgnoreCase("RefineRDCExactMiddle")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doRefineRdcExactMiddle(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("RefineRDCExactMiddle");
                }
            } else if (firstToken.equalsIgnoreCase("RdcExactHelix")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doRdcExactHelix(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("RdcExactHelix");
                }
            } else if (firstToken.equalsIgnoreCase("RdcExactHelixWOAT")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doRdcExactHelixWOAT(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("RdcExactHelixWOAT");
                }
            } else if (firstToken.equalsIgnoreCase("RdcExactSheet")) {
                if (secondToken.length() > 0) {
                    Model mod = new Model();
                    mod.doRdcExactSheet(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("RdcExactHelixWOAT");
                }
            } else if (firstToken.equalsIgnoreCase("CalAlignmentTensor")) {
                if (secondToken.length() > 0) {
                    rdcPanda = new RdcPanda();
                    rdcPanda.doCalAlignmentTensor(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("CalAlignmentTensor");
                }
            } else if (firstToken.equalsIgnoreCase("CheckNoeByEnsemble")) {
                if (secondToken.length() > 0) {
                    noe = new Noe();
                    noe.doCheckNoeByEnsemble(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("CheckNoeByEnsemble");
                }
            } else if (firstToken.equalsIgnoreCase("NoeStatistics")) {
                if (secondToken.length() > 0) {
                    noe = new Noe();
                    noe.doNoeStatistics(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("NoeStatistics");
                }
            } else if (firstToken.equalsIgnoreCase("Nasca")) {
                if (secondToken.length() > 0) {
                    Nasca nasca = new Nasca();
                    nasca.doNasca(src, strOut, secondToken);
                } else {
                    this.errorTooFewParams("Nasca");
                }
            } else if (firstToken.equalsIgnoreCase("RunXplor")) {
                rdcPanda = new RdcPanda();
                rdcPanda.doRunXplor(src, strOut, secondToken);
            } else if (firstToken.equalsIgnoreCase("ReadPdbFragments")) {
                pp = new Pdb();
                pp.doReadPdbFragments(src, strOut, secondToken);
            } else if (firstToken.equalsIgnoreCase("ComputeLoops")) {
                Loops loops = new Loops();
                loops.doCalLoops(src, strOut, secondToken);
            } else if (firstToken.equalsIgnoreCase("goal")) {
                Goal goal = new Goal();
                goal.doGoalCalLoops(src, strOut, secondToken);
            }
            System.exit(0);
        }
    }

    public void doRunXplor(String src, String strOut, String strInput) throws JampackException, InterruptedException {
        long startTime = System.currentTimeMillis();
        String userDir = System.getProperty("user.dir");
        String srcXplor = String.valueOf(userDir) + "/xplor/";
        System.setProperty("user.dir", srcXplor);
        String userDirNew = System.getProperty("user.dir");
        System.out.println("Current working directory is:" + userDirNew);
        String strRun = "/usr/project/dlab/Users/Software/xplor-NIH-64/xplor-nih-2.16.0/bin/xplor < eta.inp > eta.out";
        Runtime runtime = Runtime.getRuntime();
        try {
            File direc = new File(userDirNew);
            Process xplor = runtime.exec(strRun, null, direc);
            InputStream xplorStdOut = xplor.getInputStream();
            InputStreamReader isr = new InputStreamReader(xplorStdOut);
            BufferedReader br = new BufferedReader(isr);
            String outFileName = String.valueOf(srcXplor) + "xplorOutResults.txt";
            try {
                String line;
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outFileName)));
                while ((line = br.readLine()) != null) {
                    out.println(line);
                    System.out.println(line);
                }
                out.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + outFileName);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
            xplor.waitFor();
        }
        catch (IOException e) {
            System.err.println("Error on exec() method");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public void doSSEPacking(String src, String strOut, String strInput) throws JampackException {
        boolean success;
        boolean exists;
        boolean success2;
        int idPath;
        String userDirTemp;
        String outPackPath;
        String outPackDir;
        boolean existsAlready;
        int maxStructurePerEnsemble = 2000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        String userDirTemp0 = System.getProperty("user.dir");
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strSeq = "";
        String strIsOne2One = "";
        String strSSES = "";
        String strOutPackedStr = "";
        String strInLocation = "";
        String strIsSkipOutEnsemble = "";
        String strIsAmbiNOEs = "";
        String strNoeFormat = "";
        String strNOETable = "";
        String strIsSkipSymCheck = "";
        String strIsSkipCluster = "";
        String strEnseName = "";
        String strAveOutPackedStr = "";
        double maxEnsemSize = 1000.0;
        double resol_cluster = 0.0;
        double noeCor = 0.0;
        int nSymID = 0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("ISONE2ONE")) {
                strIsOne2One = paraMap.get("ISONE2ONE");
            }
            if (paraMap.containsKey("MAXSTRUCTURES")) {
                maxEnsemSize = Double.parseDouble(paraMap.get("MAXSTRUCTURES"));
            }
            if (paraMap.containsKey("SSES")) {
                strSSES = paraMap.get("SSES");
            }
            if (paraMap.containsKey("OUTPACKEDSTRUCTURES")) {
                strOutPackedStr = paraMap.get("OUTPACKEDSTRUCTURES");
            }
            if (paraMap.containsKey("OUTAVEPACKEDSTRUCTURES")) {
                strAveOutPackedStr = paraMap.get("OUTAVEPACKEDSTRUCTURES");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("NOE-TABLE")) {
                strNOETable = paraMap.get("NOE-TABLE");
            }
            if (paraMap.containsKey("ISSKIPSYMCHECK")) {
                strIsSkipSymCheck = paraMap.get("ISSKIPSYMCHECK");
            }
            if (paraMap.containsKey("ISSKIPOUTENSEMBLE")) {
                strIsSkipOutEnsemble = paraMap.get("ISSKIPOUTENSEMBLE");
            }
            if (paraMap.containsKey("SYMID")) {
                nSymID = Integer.parseInt(paraMap.get("SYMID"));
            }
            if (paraMap.containsKey("RESOLCLUSTER")) {
                resol_cluster = Double.parseDouble(paraMap.get("RESOLCLUSTER"));
            }
            if (paraMap.containsKey("ISSKIPCLUSTER")) {
                strIsSkipCluster = paraMap.get("ISSKIPCLUSTER");
            }
            if (paraMap.containsKey("NOE-CORRECTION")) {
                noeCor = Double.parseDouble(paraMap.get("NOE-CORRECTION"));
            }
            if (paraMap.containsKey("INPUTFILELOCATION")) {
                strInLocation = paraMap.get("INPUTFILELOCATION");
            }
            if (paraMap.containsKey("ENSEMBLENAME")) {
                strEnseName = paraMap.get("ENSEMBLENAME");
            }
            if (paraMap.containsKey("ISAMBIGUOUSNOES")) {
                strIsAmbiNOEs = paraMap.get("ISAMBIGUOUSNOES");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String rotSrc = String.valueOf(userDirTemp0) + "/system/rot-lib/";
        String manualAsgFile = String.valueOf(src) + strNOETable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, noeCor, "PDB-NEW");
            vecManAsgNew.addAll(vecManAsg);
        } else {
            vecManAsg = noe_temp.noeReader(manualAsgFile, noeCor, vecSeq);
            vecManAsgNew = noe_temp.ConvertXplorAsgToUplFormat(vecManAsg, vecSeq, "PDB-NEW");
        }
        Vector<Pdb> vecPdbAllTemp = new Vector<Pdb>();
        if (!strIsOne2One.equalsIgnoreCase("1")) {
            String userDir = System.getProperty("user.dir");
            String strInputFile = String.valueOf(userDir) + strInLocation;
            File myDir = new File(strInputFile);
            String[] contents = myDir.list();
            if (contents == null) {
                System.out.println(String.valueOf(myDir.getName()) + " is not a directory");
            }
            int t = 0;
            while (t < contents.length) {
                String filename = contents[t];
                String strEnsemPdb = "";
                strEnsemPdb = String.valueOf(strInputFile) + filename;
                Vector<Pdb> vecPdbABB = pp.readPdb(strEnsemPdb);
                if (vecPdbABB.size() > 0) {
                    Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, vecPdbABB);
                    Vector<Pdb> pdbVecSSE = pp.nameConvertOrder(pdbVecSSE_temp2);
                    vecPdbAllTemp.addAll(pdbVecSSE);
                    break;
                }
                ++t;
            }
            if (vecPdbAllTemp.size() < 1) {
                System.out.println("No input PDB is found for packing....");
                return;
            }
        }
        Vector vecOrderSSES = asg.getOrder(strSSES);
        Vector<Vector<Pdb>> vecPdbSSE = new Vector<Vector<Pdb>>();
        int i2 = 0;
        while (i2 < vecOrderSSES.size()) {
            if (!strIsOne2One.equalsIgnoreCase("1") && i2 == 0) {
                vecPdbSSE.add(vecPdbAllTemp);
            } else {
                String strPdbFile = (String)vecOrderSSES.elementAt(i2);
                strPdbFile = String.valueOf(src) + strPdbFile + ".pdb";
                Vector<Pdb> pdbVecSSE_temp = pp.readPdb(strPdbFile);
                Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
                Vector<Pdb> pdbVecSSE = pp.nameConvertOrder(pdbVecSSE_temp2);
                Collections.sort(pdbVecSSE, new Pdb.PdbComparator());
                vecPdbSSE.add(pdbVecSSE);
            }
            ++i2;
        }
        Vector<Vector> vecPdbRotSSE = new Vector<Vector>();
        Model md = new Model();
        int i3 = 0;
        while (i3 < vecPdbSSE.size()) {
            Vector vecPdbSseBb = (Vector)vecPdbSSE.elementAt(i3);
            Vector<Pdb> vecPdbSseRot = pp.AllRotamersStructure(vecPdbSseBb, rotSrc);
            Vector vecPdbSseRotNew = md.BackonbeRotation(vecPdbSseRot, vecPdbSseBb);
            Collections.sort(vecPdbSseRotNew, new Pdb.PdbComparator());
            vecPdbRotSSE.add(vecPdbSseRotNew);
            ++i3;
        }
        Vector vecPdbA = new Vector();
        Vector vecPdbB = new Vector();
        vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        Collections.sort(vecPdbA, new Pdb.PdbComparator());
        PdbRmsd pdr = new PdbRmsd();
        double[] max_score = new double[4];
        Vector[] vecEnsembPack = new Vector[4];
        PdbRmsd psd = new PdbRmsd();
        double[] noeRmsd = new double[1];
        double[] noeRms = new double[4];
        boolean debugNOE = true;
        Vector[] ubqByRdcVec = new Vector[4];
        Vector[] vecNewNOE = new Vector[4];
        Vector vecNoeUpdateOrder = noe_temp.UpdateNOE(vecManAsgNew, vecPdbSSE);
        int minSym = 0;
        if (strIsSkipSymCheck.equalsIgnoreCase("1")) {
            minSym = nSymID;
        } else {
            Vector<Pdb> vecPdbATemp = new Vector<Pdb>();
            Vector vecPdbBTemp = new Vector();
            vecPdbATemp.addAll((Vector)vecPdbRotSSE.elementAt(0));
            Collections.sort(vecPdbATemp, new Pdb.PdbComparator());
            vecPdbBTemp.addAll((Vector)vecPdbRotSSE.elementAt(1));
            Collections.sort(vecPdbBTemp, new Pdb.PdbComparator());
            Vector noeVecTemp = new Vector();
            noeVecTemp.addAll((Vector)vecNoeUpdateOrder.elementAt(0));
            double minRms = 999999.9;
            int i4 = 0;
            while (i4 < 4) {
                Vector<Pdb> vecPdbATempNew = new Vector<Pdb>();
                if (i4 == 0) {
                    vecPdbATempNew.addAll(vecPdbATemp);
                } else {
                    vecPdbATempNew = pp.newPdb(vecPdbATemp, Const.mat4ThreeDirs[i4 - 1]);
                }
                psd.calcMinPackingRms(noeVecTemp, vecPdbATempNew, vecPdbBTemp, noeRmsd, debugNOE);
                if (noeRmsd[0] < minRms) {
                    minRms = noeRmsd[0];
                    minSym = i4;
                }
                ++i4;
            }
        }
        System.out.println("The symmetry ID is: " + minSym);
        int i5 = 0;
        while (i5 < 4) {
            ubqByRdcVec[i5] = new Vector();
            vecNewNOE[i5] = new Vector();
            ++i5;
        }
        Vector<Object> vecTempBB = new Vector();
        String strPass = "";
        if (strIsSkipOutEnsemble.equalsIgnoreCase("1")) {
            psd.isSkipOutEnsembe = true;
        }
        if ((existsAlready = new File(outPackDir = (outPackPath = String.valueOf(userDirTemp = System.getProperty("user.dir")) + strOutPackedStr).substring(0, (idPath = outPackPath.lastIndexOf(47)) + 1)).exists()) && !(success2 = RdcPanda.deleteDir(new File(outPackDir)))) {
            System.out.println("Failed to delete an already existing output directry!");
            System.exit(0);
        }
        if (!(exists = new File(outPackDir).exists()) && !(success = new File(outPackDir).mkdir())) {
            System.out.println("Failed to create output directry!");
            System.exit(0);
        }
        if (strIsOne2One.equalsIgnoreCase("1")) {
            strPass = String.valueOf(userDirTemp) + strOutPackedStr + "Temp";
            int k = 1;
            while (k < vecPdbRotSSE.size()) {
                double[] dbTemp = new double[1];
                vecPdbB = new Vector();
                vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
                Vector<Object> helixVecN = new Vector();
                Vector noeVec = new Vector();
                noeVec.addAll((Vector)vecNoeUpdateOrder.elementAt(k - 1));
                Vector noeVecUpdate = new Vector();
                noeVecUpdate = noe_temp.setSameUpperBounds4All(noeVec, 6.0);
                if (isDebug) {
                    noe_temp.PrintNOE(noeVecUpdate);
                }
                helixVecN = new Vector();
                if (minSym == 0) {
                    helixVecN.addAll(vecPdbA);
                } else {
                    helixVecN = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[minSym - 1]);
                }
                ubqByRdcVec[0] = strIsAmbiNOEs.equalsIgnoreCase("1") ? psd.positionByAmbiNOEAllRotamers(noeVecUpdate, helixVecN, vecPdbB, noeRmsd, debugNOE, vecNewNOE[0], strPass, vecSeq, resol_cluster) : psd.positionByNOEAllRotamers(noeVecUpdate, helixVecN, vecPdbB, noeRmsd, debugNOE, vecNewNOE[0], strPass, vecSeq, resol_cluster);
                noeRms[0] = noeRmsd[0];
                vecTempBB = pp.OutputBackbone(ubqByRdcVec[0]);
                if (isDebug) {
                    System.out.println("REMARK here is average packed structure:");
                    pp.print(vecTempBB);
                    System.out.println("TER");
                    System.out.println("END");
                }
                String outFileName = String.valueOf(userDirTemp) + strAveOutPackedStr;
                try {
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outFileName)));
                    pp.printToFile(vecTempBB, outFileName, out);
                    out.println("TER");
                    out.println("END");
                    out.close();
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found: " + outFileName);
                }
                catch (IOException e) {
                    System.out.println("IOException: the stack trace is:");
                    e.printStackTrace();
                }
                ++k;
            }
        } else {
            String userDir = System.getProperty("user.dir");
            String strInputFile = String.valueOf(userDir) + strInLocation;
            File myDir = new File(strInputFile);
            String[] contents = myDir.list();
            if (contents == null) {
                System.out.println(String.valueOf(myDir.getName()) + " is not a directory");
            }
            int t = 0;
            while (t < contents.length) {
                String filename = contents[t];
                String strEnsemPdb = "";
                strEnsemPdb = String.valueOf(strInputFile) + filename;
                vecPdbA = new Vector();
                strPass = String.valueOf(userDirTemp) + strOutPackedStr + t + "Temp";
                System.out.println("**********************input: " + strEnsemPdb);
                File f = new File(strEnsemPdb);
                if (!f.exists()) {
                    System.out.println("Couldn't find file " + strEnsemPdb + " for packing, continue...");
                } else {
                    Vector<Pdb> vecPdbABB = pp.readPdb(strEnsemPdb);
                    Vector<Pdb> vecPdbATEmp = pp.AllRotamersStructure(vecPdbABB, rotSrc);
                    vecPdbA = md.BackonbeRotation(vecPdbATEmp, vecPdbABB);
                    int k = 1;
                    while (k < vecPdbRotSSE.size()) {
                        double[] dbTemp = new double[1];
                        vecPdbB = new Vector();
                        vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
                        Vector<Object> helixVecN = new Vector();
                        Vector noeVec = new Vector();
                        noeVec.addAll((Vector)vecNoeUpdateOrder.elementAt(k - 1));
                        Vector noeVecUpdate = new Vector();
                        noeVecUpdate = noe_temp.setSameUpperBounds4All(noeVec, 6.0);
                        if (isDebug) {
                            noe_temp.PrintNOE(noeVecUpdate);
                        }
                        helixVecN = new Vector();
                        if (minSym == 0) {
                            helixVecN.addAll(vecPdbA);
                        } else {
                            helixVecN = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[minSym - 1]);
                        }
                        ubqByRdcVec[0] = strIsAmbiNOEs.equalsIgnoreCase("1") ? psd.positionByAmbiNOEAllRotamers(noeVecUpdate, helixVecN, vecPdbB, noeRmsd, debugNOE, vecNewNOE[0], strPass, vecSeq, resol_cluster) : psd.positionByNOEAllRotamers(noeVecUpdate, helixVecN, vecPdbB, noeRmsd, debugNOE, vecNewNOE[0], strPass, vecSeq, resol_cluster);
                        noeRms[0] = noeRmsd[0];
                        vecTempBB = pp.OutputBackbone(ubqByRdcVec[0]);
                        System.out.println("REMARK here is average packed structure:");
                        pp.print(vecTempBB);
                        System.out.println("TER");
                        System.out.println("END");
                        ++k;
                    }
                }
                ++t;
            }
        }
        if (strIsSkipCluster.equalsIgnoreCase("0")) {
            int maxTempEnsem = 0;
            String strDelimited = "Temp";
            vdw vv = new vdw();
            String strPreEnsemb = "";
            if (strIsOne2One.equalsIgnoreCase("1")) {
                strPreEnsemb = String.valueOf(strOutPackedStr) + "Temp";
                maxTempEnsem = 1;
            } else {
                strPreEnsemb = strOutPackedStr;
                maxTempEnsem = (int)maxEnsemSize;
            }
            vv.mergeAndCluster(strOut, strOut, strPreEnsemb, maxStructurePerEnsemble, maxTempEnsem, resol_cluster, strOutPackedStr, strDelimited);
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for packing is:  " + totalTime + " minutes");
    }

    public void doMergeNCluster(String src, String strOut, String strInput) throws JampackException {
        String strDelimited = "000";
        int maxStructurePerEnsemble = 3000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strOutPackedStr = "";
        String strPreStrName = "";
        String strInLocation = "";
        String strDelimitedTmp = "";
        int maxEnsemSize = 1000;
        double resol_cluster = 0.0;
        int nSymID = 0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("MAXSTRUCTURES")) {
                maxEnsemSize = Integer.parseInt(paraMap.get("MAXSTRUCTURES"));
            }
            if (paraMap.containsKey("OUTPACKEDSTRUCTURES")) {
                strOutPackedStr = paraMap.get("OUTPACKEDSTRUCTURES");
            }
            if (paraMap.containsKey("STRDELIMIT")) {
                strDelimitedTmp = paraMap.get("STRDELIMIT");
            }
            if (paraMap.containsKey("SYMID")) {
                nSymID = Integer.parseInt(paraMap.get("SYMID"));
            }
            if (paraMap.containsKey("RESOLCLUSTER")) {
                resol_cluster = Double.parseDouble(paraMap.get("RESOLCLUSTER"));
            }
            if (paraMap.containsKey("PREENSEMNAME")) {
                strPreStrName = paraMap.get("PREENSEMNAME");
            }
            if (paraMap.containsKey("INPUTFILELOCATION")) {
                strInLocation = paraMap.get("INPUTFILELOCATION");
            }
            ++i;
        }
        String userDir = System.getProperty("user.dir");
        src = String.valueOf(userDir) + strInLocation;
        vdw vv = new vdw();
        String strPreEnsemb = "";
        vv.mergeAndCluster(src, strOut, strPreStrName, maxStructurePerEnsemble, maxEnsemSize, resol_cluster, strOutPackedStr, strDelimited);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for clustering is:  " + totalTime + " minutes");
    }

    public void doAddSideChains(String src, String strOut, String strInput) throws JampackException {
        boolean success;
        boolean exists;
        boolean success2;
        int idPath;
        Noe ee;
        String strDelimited = "000";
        int maxStructurePerEnsemble = 3000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        Peak pk = new Peak();
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strReson = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strNoesyFormat = "";
        String strResNameScheme = "";
        String strHaNoesy3D = "";
        String strResFormat = "";
        String strNewEnsemb = "";
        String strLocBBEnsem = "";
        String strIsCheckLocalClash = "";
        String strSSEBB = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("RESNAMESCHEME")) {
                strResNameScheme = paraMap.get("RESNAMESCHEME");
            }
            if (paraMap.containsKey("NOESY-FORMAT")) {
                strNoesyFormat = paraMap.get("NOESY-FORMAT");
            }
            if (paraMap.containsKey("SSEBB")) {
                strSSEBB = paraMap.get("SSEBB");
            }
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("LOCATIONBBENSEMBLE")) {
                strLocBBEnsem = paraMap.get("LOCATIONBBENSEMBLE");
            }
            if (paraMap.containsKey("OUTSTRUCTURENAME")) {
                strNewEnsemb = paraMap.get("OUTSTRUCTURENAME");
            }
            if (paraMap.containsKey("ISCHECKLOCALCLASH")) {
                strIsCheckLocalClash = paraMap.get("ISCHECKLOCALCLASH");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<Object> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        Vector vecNoesy = new Vector();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        String pdbSSEFile = String.valueOf(src) + strSSEBB;
        Vector<Pdb> vecSSE = pp.readPdb(pdbSSEFile);
        double[] constant = new double[1];
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        Vector<Noesy> vecNoesyNoDia = new Vector<Noesy>();
        i = 0;
        while (i < vecNoesy.size()) {
            double cs_h2;
            Noesy noesy2 = (Noesy)vecNoesy.elementAt(i);
            double cs_h1 = noesy2.getH1();
            if (Math.abs(cs_h1 - (cs_h2 = noesy2.getH2())) > 0.02) {
                vecNoesyNoDia.add(noesy2);
            }
            ++i;
        }
        vecNoesy = new Vector();
        vecNoesy.addAll(vecNoesyNoDia);
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        vecNewNoesy.addAll(vecNoesy);
        Vector<Object> vecAmbgAsg = new Vector();
        vecAmbgAsg = asg.InitAmbiAssignment(nErr, c13Err, hnErr, haErr, h1Err, assignVec, allH1Vec, vecNewNoesy);
        Collections.sort(vecAmbgAsg, new Noe.NoeComparator());
        Vector<Noe> vecNewNoes = new Vector<Noe>();
        vecNewNoes.addAll(vecAmbgAsg);
        if (strResNameScheme.equalsIgnoreCase("PDB-NEW")) {
            Vector<Object> vecTemp = new Vector();
            ee = new Noe();
            vecTemp = ee.NameConvertFromPDBNewToPDBNew(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp);
        }
        if (strResNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            Vector<Object> vecTemp = new Vector();
            ee = new Noe();
            vecTemp = ee.NameConvertFromBMRBNewToPDBNew(vecNewNoes);
            vecNewNoes = new Vector();
            vecNewNoes.addAll(vecTemp);
            Vector<Object> vecAsgNew = new Vector();
            H1CS h1cs = new H1CS();
            vecAsgNew = h1cs.CSNameConvertFromBMRBNewToPDBNew(assignVec);
            assignVec = new Vector();
            assignVec.addAll(vecAsgNew);
        }
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecNewNoes);
        Vector<Noe> vecAmbgAsgTemp = noesy.SetCalibrationCyana(vecNewNoes, vecNewNoesy, constant[0]);
        vecNewNoes = new Vector();
        vecNewNoes.addAll(vecAmbgAsgTemp);
        String userDir = System.getProperty("user.dir");
        File myDir = new File(String.valueOf(userDir) + strLocBBEnsem);
        String[] contents = myDir.list();
        if (contents == null) {
            System.out.println(String.valueOf(myDir.getName()) + " is not a directory");
            System.exit(0);
        }
        String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
        String userDirTemp = System.getProperty("user.dir");
        String outPackPath = String.valueOf(userDirTemp) + strNewEnsemb;
        String outPackDir = outPackPath.substring(0, (idPath = outPackPath.lastIndexOf(47)) + 1);
        boolean existsAlready = new File(outPackDir).exists();
        if (existsAlready && !(success2 = RdcPanda.deleteDir(new File(outPackDir)))) {
            System.out.println("Failed to delete an already existing output directry!");
            System.exit(0);
        }
        if (!(exists = new File(outPackDir).exists()) && !(success = new File(outPackDir).mkdir())) {
            System.out.println("Failed to create output directry!");
            System.exit(0);
        }
        int counter = 0;
        Vector vecPdb = new Vector();
        Vector vecEnsemAfterThin = new Vector();
        Vector vecRefPdb = new Vector();
        int t = 0;
        while (t < contents.length) {
            String filename = contents[t];
            String strEnsemPdb = "";
            strEnsemPdb = String.valueOf(userDir) + strLocBBEnsem + filename;
            System.out.println("input: " + strEnsemPdb);
            File f = new File(strEnsemPdb);
            if (!f.exists()) {
                System.out.println("Couldn't find file " + strEnsemPdb + " for adding side-chains, continue...");
            } else {
                Vector vecEnsemble = pp.readPdbAndNoeHarmFromEnsemble(strEnsemPdb);
                if (vecEnsemble != null) {
                    double[] vdwScore = new double[vecEnsemble.size()];
                    vdw vander = new vdw();
                    Vector vdwVec = new Vector();
                    double[] vdwValue = new double[1];
                    boolean hasVDW = false;
                    double vdwLevel = 0.05;
                    boolean printVDWViolation = false;
                    i = 0;
                    while (i < vecEnsemble.size()) {
                        vdw Vdw = (vdw)vecEnsemble.elementAt(i);
                        vecPdb = Vdw.getPDB();
                        if (vecPdb.size() >= 1) {
                            double noeRms = Vdw.getNoeRmsd();
                            Vector<Pdb> vecTempPdbBB = pp.OutputBackbone(vecPdb);
                            Vector<Pdb> pdbVecBBNew = pp.residueNameUpdate(vecSeq, vecTempPdbBB);
                            double[] noeRmsd = new double[2];
                            double[] noeHarmScore = new double[2];
                            int[] numConflicts = new int[2];
                            Vector<Pdb> vecTempPdbRot = pp.RotamSelectAndStructure(h1Err, nErr, c13Err, pdbVecBBNew, assignVec, rotSrc, vecNewNoesy, 4.5, 1, constant[0]);
                            Vector vecTemptt = new Vector();
                            if (strIsCheckLocalClash.equalsIgnoreCase("1")) {
                                boolean[] resClash = new boolean[140];
                                vdwVec = vander.convert2VDW(vecTempPdbRot);
                                vander.OutputStericClashResidues(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.4, 1, resClash, true);
                                int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.8);
                                if (numClashes > 0) {
                                    int firstClash = 0;
                                    i = 0;
                                    while (i < resClash.length) {
                                        if (resClash[i]) {
                                            firstClash = i;
                                            break;
                                        }
                                        ++i;
                                    }
                                    vecTemptt = pp.RefineRotamerSelectionSearch(vecTempPdbRot, firstClash, rotSrc, 0);
                                } else {
                                    vecTemptt = vecTempPdbRot;
                                }
                            } else {
                                vecTemptt = vecTempPdbRot;
                            }
                            String fileName = String.valueOf(userDir) + strNewEnsemb + counter + ".pdb";
                            try {
                                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                                out.println("REMARK the backbone file name is:" + strEnsemPdb);
                                pp.printToFile(vecTemptt, fileName, out);
                                out.println("END");
                                out.close();
                                ++counter;
                            }
                            catch (FileNotFoundException e) {
                                System.out.println("File not found: " + fileName);
                            }
                            catch (IOException e) {
                                System.out.println("IOException: the stack trace is:");
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                }
            }
            ++t;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for adding side-chains and pruning steric clashes is:  " + totalTime + " minutes");
    }

    public void doMergeNClusterAll(String src, String strOut, String strInput) throws JampackException {
        boolean success;
        boolean exists;
        boolean success2;
        int idPath;
        String strDelimited = "000";
        int maxStructurePerEnsemble = 3000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strOutPackedStr = "";
        String strPreStrName = "";
        String strInLocation = "";
        String strDelimitedTmp = "";
        int maxEnsemSize = 1000;
        double resol_cluster = 0.0;
        boolean nSymID = false;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("MAXSTRUCTURES")) {
                maxEnsemSize = Integer.parseInt(paraMap.get("MAXSTRUCTURES"));
            }
            if (paraMap.containsKey("OUTPACKEDSTRUCTURES")) {
                strOutPackedStr = paraMap.get("OUTPACKEDSTRUCTURES");
            }
            if (paraMap.containsKey("RESOLCLUSTER")) {
                resol_cluster = Double.parseDouble(paraMap.get("RESOLCLUSTER"));
            }
            if (paraMap.containsKey("INPUTFILELOCATION")) {
                strInLocation = paraMap.get("INPUTFILELOCATION");
            }
            ++i;
        }
        String userDir = System.getProperty("user.dir");
        src = String.valueOf(userDir) + strInLocation;
        vdw vv = new vdw();
        String strPreEnsemb = "";
        String userDirTemp = System.getProperty("user.dir");
        String outPackPath = String.valueOf(userDirTemp) + strOutPackedStr;
        String outPackDir = outPackPath.substring(0, (idPath = outPackPath.lastIndexOf(47)) + 1);
        boolean existsAlready = new File(outPackDir).exists();
        if (existsAlready && !(success2 = RdcPanda.deleteDir(new File(outPackDir)))) {
            System.out.println("Failed to delete an already existing output directry!");
            System.exit(0);
        }
        if (!(exists = new File(outPackDir).exists()) && !(success = new File(outPackDir).mkdir())) {
            System.out.println("Failed to create output directry!");
            System.exit(0);
        }
        vv.mergeAndClusterAll(src, strOut, resol_cluster, strOutPackedStr);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for clustering is:  " + totalTime + " minutes");
    }

    public void doAddRandomLoops(String src, String strOut, String strInput) throws JampackException {
        boolean success;
        boolean exists;
        boolean success2;
        int idPath;
        String userDirTemp;
        String outPackPath;
        String outPackDir;
        boolean existsAlready;
        String strDelimited = "000";
        int maxStructurePerEnsemble = 3000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strOutCompleteStr = "";
        String strInLocation = "";
        String strLoopPDB = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("OUTCOMPLETESTRUCTURES")) {
                strOutCompleteStr = paraMap.get("OUTCOMPLETESTRUCTURES");
            }
            if (paraMap.containsKey("LOCATIONSSEENSEMBLE")) {
                strInLocation = paraMap.get("LOCATIONSSEENSEMBLE");
            }
            if (paraMap.containsKey("LOOPPDBNAME")) {
                strLoopPDB = paraMap.get("LOOPPDBNAME");
            }
            ++i;
        }
        String strLoops = String.valueOf(src) + strLoopPDB;
        Vector<Object> vecLoops = new Vector();
        vecLoops = pp.readPdb(strLoops);
        String userDir = System.getProperty("user.dir");
        File myDir = new File(String.valueOf(userDir) + strInLocation);
        String[] contents = myDir.list();
        if (contents == null) {
            System.out.println(String.valueOf(myDir.getName()) + " is not a directory");
            System.exit(0);
        }
        if ((existsAlready = new File(outPackDir = (outPackPath = String.valueOf(userDirTemp = System.getProperty("user.dir")) + strOutCompleteStr).substring(0, (idPath = outPackPath.lastIndexOf(47)) + 1)).exists()) && !(success2 = RdcPanda.deleteDir(new File(outPackDir)))) {
            System.out.println("Failed to delete an already existing output directry!");
            System.exit(0);
        }
        if (!(exists = new File(outPackDir).exists()) && !(success = new File(outPackDir).mkdir())) {
            System.out.println("Failed to create output directry!");
            System.exit(0);
        }
        int counter = 0;
        Vector vecPdb = new Vector();
        Vector vecEnsemAfterThin = new Vector();
        Vector vecRefPdb = new Vector();
        int t = 0;
        while (t < contents.length) {
            Vector vecPdbAll = new Vector();
            vecPdbAll.addAll(vecLoops);
            String filename = contents[t];
            String strEnsemPdb = "";
            strEnsemPdb = String.valueOf(userDir) + strInLocation + filename;
            System.out.println("input: " + strEnsemPdb);
            File f = new File(strEnsemPdb);
            if (!f.exists()) {
                System.out.println("Couldn't find file " + strEnsemPdb + " for adding side-chains, continue...");
            } else {
                Vector<Pdb> vecEnsemble = pp.readPdb(strEnsemPdb);
                if (vecEnsemble != null) {
                    vecPdbAll.addAll(vecEnsemble);
                    Collections.sort(vecPdbAll, new Pdb.PdbComparator());
                    String fileName = String.valueOf(userDir) + strOutCompleteStr + counter + ".pdb";
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        out.println("REMARK :  input PDB name=:" + strEnsemPdb);
                        out.println("REMARK :  ensemble ID=:" + counter);
                        pp.printToFile(vecPdbAll, fileName, out);
                        out.println("END");
                        out.close();
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("File not found: " + fileName);
                    }
                    catch (IOException e) {
                        System.out.println("IOException: the stack trace is:");
                        e.printStackTrace();
                    }
                    ++counter;
                }
            }
            ++t;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for clustering is:  " + totalTime + " minutes");
    }

    public void doReadPDBEnergy(String src, String strOut, String strInput) throws JampackException {
        PrintWriter out;
        String fileName;
        Vector vecPdbTemp;
        String strID;
        String strDelimited = "000";
        int maxStructurePerEnsemble = 3000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        Vector<vdw> vecVdw = new Vector<vdw>();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strInLocation = "";
        String isOut = "";
        String strOutName = "";
        String isCutOff = "";
        int outNumber = 0;
        int rowPos = 0;
        int colPos = 0;
        double cutOff = 0.0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("LOCATIONSSEENSEMBLE")) {
                strInLocation = paraMap.get("LOCATIONSSEENSEMBLE");
            }
            if (paraMap.containsKey("OUTPUTNUMBER")) {
                outNumber = Integer.parseInt(paraMap.get("OUTPUTNUMBER"));
            }
            if (paraMap.containsKey("ROWPOS")) {
                rowPos = Integer.parseInt(paraMap.get("ROWPOS"));
            }
            if (paraMap.containsKey("COLPOS")) {
                colPos = Integer.parseInt(paraMap.get("COLPOS"));
            }
            if (paraMap.containsKey("ISOUTPUT")) {
                isOut = paraMap.get("ISOUTPUT");
            }
            if (paraMap.containsKey("ISCUTOFF")) {
                isCutOff = paraMap.get("ISCUTOFF");
            }
            if (paraMap.containsKey("OUTNAME")) {
                strOutName = paraMap.get("OUTNAME");
            }
            if (paraMap.containsKey("CUTOFF")) {
                cutOff = Double.parseDouble(paraMap.get("CUTOFF"));
            }
            ++i;
        }
        String userDir = System.getProperty("user.dir");
        File myDir = new File(String.valueOf(userDir) + strInLocation);
        String[] contents = myDir.list();
        if (contents == null) {
            System.out.println(String.valueOf(myDir.getName()) + " is not a directory");
            System.exit(0);
        }
        boolean counter = false;
        Vector vecPdb = new Vector();
        Vector vecEnsemAfterThin = new Vector();
        Vector vecRefPdb = new Vector();
        int t = 0;
        while (t < contents.length) {
            String filename = contents[t];
            String strEnsemPdb = "";
            strEnsemPdb = String.valueOf(userDir) + strInLocation + filename;
            System.out.println("input: " + strEnsemPdb);
            File f = new File(strEnsemPdb);
            if (!f.exists()) {
                System.out.println("Couldn't find file " + strEnsemPdb + " for adding side-chains, continue...");
            } else {
                Vector<Pdb> vecEnsemble = pp.readPdb(strEnsemPdb);
                if (vecEnsemble != null) {
                    double[] noeEnerg = new double[1];
                    pp.readPdbEnergy(strEnsemPdb, noeEnerg, rowPos, colPos);
                    System.out.println("The energy is: " + noeEnerg[0]);
                    vecVdw.add(new vdw(vecEnsemble, noeEnerg[0], 0.0, t, filename));
                }
            }
            ++t;
        }
        Collections.sort(vecVdw, new vdw.VdwComparator());
        if (isCutOff.equalsIgnoreCase("0")) {
            i = 0;
            while (i < Math.min(outNumber, contents.length)) {
                vdw vdw_temp = (vdw)vecVdw.elementAt(i);
                double scEnergy = vdw_temp.getVdwScore();
                strID = vdw_temp.getStringID();
                System.out.println("the " + (i + 1) + "-th " + "energy is : " + strID + " with energy=" + scEnergy);
                vecPdbTemp = vdw_temp.getPDB();
                if (isOut.equalsIgnoreCase("1")) {
                    fileName = String.valueOf(userDir) + strOutName + (i + 1) + ".pdb";
                    try {
                        out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        out.println("REMARK :  input PDB ID=:" + strID);
                        out.println("REMARK energy: " + scEnergy);
                        pp.printToFile(vecPdbTemp, fileName, out);
                        out.println("END");
                        out.close();
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("File not found: " + fileName);
                    }
                    catch (IOException e) {
                        System.out.println("IOException: the stack trace is:");
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        if (isCutOff.equalsIgnoreCase("1")) {
            i = 0;
            while (i < vecVdw.size()) {
                vdw vdw_temp = (vdw)vecVdw.elementAt(i);
                double scEnergy = vdw_temp.getVdwScore();
                if (!(scEnergy >= cutOff)) {
                    strID = vdw_temp.getStringID();
                    System.out.println("the " + (i + 1) + "-th " + "energy is : " + strID + " with energy=" + scEnergy);
                    vecPdbTemp = vdw_temp.getPDB();
                    if (isOut.equalsIgnoreCase("1")) {
                        fileName = String.valueOf(userDir) + strOutName + (i + 1) + ".pdb";
                        try {
                            out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                            out.println("REMARK :  input PDB ID=:" + strID);
                            out.println("REMARK vdw_energy: " + scEnergy);
                            pp.printToFile(vecPdbTemp, fileName, out);
                            out.println("END");
                            out.close();
                        }
                        catch (FileNotFoundException e) {
                            System.out.println("File not found: " + fileName);
                        }
                        catch (IOException e) {
                            System.out.println("IOException: the stack trace is:");
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for clustering is:  " + totalTime + " minutes");
    }

    public void doCheckPackingSym(String src, String strOut, String strInput) throws JampackException {
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strSeq = "";
        String strSSES = "";
        String strOutPackedStr = "";
        String strNoeFormat = "";
        String strNOETable = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("SSES")) {
                strSSES = paraMap.get("SSES");
            }
            if (paraMap.containsKey("OUTPACKEDSTRUCTURES")) {
                strOutPackedStr = paraMap.get("OUTPACKEDSTRUCTURES");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("NOE-TABLE")) {
                strNOETable = paraMap.get("NOE-TABLE");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String rotSrc = String.valueOf(src) + "rotasamp-small/";
        String manualAsgFile = String.valueOf(src) + strNOETable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
            vecManAsgNew.addAll(vecManAsg);
        } else {
            vecManAsg = noe_temp.noeReader(manualAsgFile, 0.0);
            vecManAsgNew = noe_temp.ConvertXplorAsgToUplFormat(vecManAsg, vecSeq, "PDB-NEW");
        }
        Vector vecOrderSSES = asg.getOrder(strSSES);
        Vector<Vector<Pdb>> vecPdbSSE = new Vector<Vector<Pdb>>();
        i = 0;
        while (i < vecOrderSSES.size()) {
            String strPdbFile = (String)vecOrderSSES.elementAt(i);
            strPdbFile = String.valueOf(src) + strPdbFile + ".pdb";
            Vector<Pdb> pdbVecSSE_temp = pp.readPdb(strPdbFile);
            Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
            Vector<Pdb> pdbVecSSE = pp.nameConvertOrder(pdbVecSSE_temp2);
            Collections.sort(pdbVecSSE, new Pdb.PdbComparator());
            vecPdbSSE.add(pdbVecSSE);
            ++i;
        }
        Vector<Vector> vecPdbRotSSE = new Vector<Vector>();
        Model md = new Model();
        i = 0;
        while (i < vecPdbSSE.size()) {
            Vector vecPdbSseBb = (Vector)vecPdbSSE.elementAt(i);
            Vector<Pdb> vecPdbSseRot = pp.AllRotamersStructure(vecPdbSseBb, rotSrc);
            Vector vecPdbSseRotNew = md.BackonbeRotation(vecPdbSseRot, vecPdbSseBb);
            Collections.sort(vecPdbSseRotNew, new Pdb.PdbComparator());
            vecPdbRotSSE.add(vecPdbSseRotNew);
            ++i;
        }
        Vector vecPdbA = new Vector();
        Vector vecPdbB = new Vector();
        vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        Collections.sort(vecPdbA, new Pdb.PdbComparator());
        PdbRmsd pdr = new PdbRmsd();
        double[] max_score = new double[4];
        Vector[] vecEnsembPack = new Vector[4];
        PdbRmsd psd = new PdbRmsd();
        double[] noeRmsd = new double[1];
        double[] noeRms = new double[4];
        boolean debugNOE = true;
        Vector[] ubqByRdcVec = new Vector[4];
        Vector[] vecNewNOE = new Vector[4];
        Vector vecNoeUpdateOrder = noe_temp.UpdateNOE(vecManAsgNew, vecPdbSSE);
        int minSym = 0;
        Vector<Pdb> vecPdbATemp = new Vector<Pdb>();
        Vector vecPdbBTemp = new Vector();
        vecPdbATemp.addAll((Vector)vecPdbRotSSE.elementAt(0));
        Collections.sort(vecPdbATemp, new Pdb.PdbComparator());
        vecPdbBTemp.addAll((Vector)vecPdbRotSSE.elementAt(1));
        Collections.sort(vecPdbBTemp, new Pdb.PdbComparator());
        Vector noeVecTemp = new Vector();
        noeVecTemp.addAll((Vector)vecNoeUpdateOrder.elementAt(0));
        double minRms = 999999.9;
        Vector pdbAppxPacked = new Vector();
        Vector vecPdbSave = new Vector();
        i = 0;
        while (i < 4) {
            pdbAppxPacked = new Vector();
            Vector<Pdb> vecPdbATempNew = new Vector<Pdb>();
            if (i == 0) {
                vecPdbATempNew.addAll(vecPdbATemp);
            } else {
                vecPdbATempNew = pp.newPdb(vecPdbATemp, Const.mat4ThreeDirs[i - 1]);
            }
            pdbAppxPacked = psd.calcMinPackingRms(noeVecTemp, vecPdbATempNew, vecPdbBTemp, noeRmsd, debugNOE);
            if (noeRmsd[0] < minRms) {
                vecPdbSave = new Vector();
                vecPdbSave.addAll(pdbAppxPacked);
                minRms = noeRmsd[0];
                minSym = i;
            }
            ++i;
        }
        System.out.println("The symmetry ID is: " + minSym);
        String fileName = String.valueOf(strOut) + strOutPackedStr + ".pdb";
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("REMARK :   The symmetry ID= " + minSym);
            pp.printToFile(vecPdbSave, fileName, out);
            out.println("TER");
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for packing is:  " + totalTime + " minutes");
    }

    public void doCalAlignmentTensor(String src, String strOut, String strInput) throws JampackException {
        boolean isHelix = true;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        PdbRdc pdr = new PdbRdc();
        ModelRdc mdc = new ModelRdc();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strInPdbName = "";
        String strChFile = "";
        String strNhFile = "";
        String strCaCoFile = "";
        String strCoNFile = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("CHFILE")) {
                strChFile = paraMap.get("CHFILE");
            }
            if (paraMap.containsKey("NHFILE")) {
                strNhFile = paraMap.get("NHFILE");
            }
            if (paraMap.containsKey("COCAFILE")) {
                strCaCoFile = paraMap.get("COCAFILE");
            }
            if (paraMap.containsKey("CONFILE")) {
                strCoNFile = paraMap.get("CONFILE");
            }
            if (paraMap.containsKey("INPUTPDBNAME")) {
                strInPdbName = paraMap.get("INPUTPDBNAME");
            }
            ++i;
        }
        String strChRdcFile = String.valueOf(src) + strChFile;
        String strNhRdcFile = String.valueOf(src) + strNhFile;
        String strCaCoRdcFile = String.valueOf(src) + strCaCoFile;
        String strCoNRdcFile = String.valueOf(src) + strCoNFile;
        Dipolar dd = new Dipolar();
        Vector cacoRdc = new Vector();
        Vector conRdc = new Vector();
        double scale_ca_to_nh = Math.pow(1.0686274509803921, 3.0) * 0.40267459138187217;
        scale_ca_to_nh = 1.0 / scale_ca_to_nh;
        Vector nhRdc = dd.rdcRead(strNhRdcFile, 1.0);
        Vector cahaRdc = dd.rdcRead(strChRdcFile, 1.0);
        boolean existCaCo = new File(strCaCoRdcFile).exists();
        boolean existCoN = new File(strCoNRdcFile).exists();
        if (existCaCo) {
            cacoRdc = dd.rdcRead(strCaCoRdcFile, 0.19845);
        } else {
            System.out.println("Warn: The Co-Ca RDC doesn't exist.");
        }
        if (existCoN) {
            dd.rdcRead(strCoNRdcFile, 0.12086);
        } else {
            System.out.println("Warn: The Co-N RDC doesn't exist.");
        }
        String strInPdb = String.valueOf(src) + strInPdbName;
        Vector vecInPdb = new Vector();
        Vector<Pdb> ppVec = pp.readPdb(strInPdb);
        vecInPdb = pp.nameConvert(ppVec);
        double[] saupe = new double[4];
        Vector<Pdb> ppVec1 = mdc.refineSaupe3(vecInPdb, nhRdc, cahaRdc, saupe);
    }

    public void doRefineRdcExact(String src, String strOut, String strInput) throws JampackException {
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        PdbRdc pdr = new PdbRdc();
        ModelRdc mdc = new ModelRdc();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double Syy = 0.0;
        double Szz = 0.0;
        double dbResolution = 0.0;
        double wtCoCA = 0.0;
        double wtCoN = 0.0;
        String strInPdbName = "";
        String strStartRes = "";
        String strEndRes = "";
        String strOutPdb = "";
        String strChFile = "";
        String strNhFile = "";
        String strCaCoFile = "";
        String strCoNFile = "";
        String strTalos = "";
        String isRotate = "";
        String strIsHelix = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("CHFILE")) {
                strChFile = paraMap.get("CHFILE");
            }
            if (paraMap.containsKey("TALOS")) {
                strTalos = paraMap.get("TALOS");
            }
            if (paraMap.containsKey("ISHELIX")) {
                strIsHelix = paraMap.get("ISHELIX");
            }
            if (paraMap.containsKey("ISROTATE")) {
                isRotate = paraMap.get("ISROTATE");
            }
            if (paraMap.containsKey("NHFILE")) {
                strNhFile = paraMap.get("NHFILE");
            }
            if (paraMap.containsKey("COCAFILE")) {
                strCaCoFile = paraMap.get("COCAFILE");
            }
            if (paraMap.containsKey("CONFILE")) {
                strCoNFile = paraMap.get("CONFILE");
            }
            if (paraMap.containsKey("INPUTPDBNAME")) {
                strInPdbName = paraMap.get("INPUTPDBNAME");
            }
            if (paraMap.containsKey("SYY")) {
                Syy = Double.parseDouble(paraMap.get("SYY"));
            }
            if (paraMap.containsKey("SZZ")) {
                Szz = Double.parseDouble(paraMap.get("SZZ"));
            }
            if (paraMap.containsKey("SZZ")) {
                Szz = Double.parseDouble(paraMap.get("SZZ"));
            }
            if (paraMap.containsKey("WTCOCA")) {
                wtCoCA = Double.parseDouble(paraMap.get("WTCOCA"));
            }
            if (paraMap.containsKey("WTCON")) {
                wtCoN = Double.parseDouble(paraMap.get("WTCON"));
            }
            if (paraMap.containsKey("STARTRESIDUES")) {
                strStartRes = paraMap.get("STARTRESIDUES");
            }
            if (paraMap.containsKey("ENDRESIDUES")) {
                strEndRes = paraMap.get("ENDRESIDUES");
            }
            if (paraMap.containsKey("OUTPDBNAME")) {
                strOutPdb = paraMap.get("OUTPDBNAME");
            }
            if (paraMap.containsKey("RESOLUTION")) {
                dbResolution = Double.parseDouble(paraMap.get("RESOLUTION"));
            }
            ++i;
        }
        boolean isHelix = true;
        isHelix = strIsHelix.equalsIgnoreCase("1");
        String strTalosFile = String.valueOf(src) + strTalos;
        PhiPsi phipsi0 = new PhiPsi();
        Vector<PhiPsi> vecTalos = phipsi0.talosAngleReader(strTalosFile);
        String strChRdcFile = String.valueOf(src) + strChFile;
        String strNhRdcFile = String.valueOf(src) + strNhFile;
        String strCaCoRdcFile = String.valueOf(src) + strCaCoFile;
        String strCoNRdcFile = String.valueOf(src) + strCoNFile;
        Dipolar dd = new Dipolar();
        Vector nhRdc = dd.rdcRead(strNhRdcFile, 1.0);
        Vector cahaRdc = dd.rdcRead(strChRdcFile, 1.0);
        boolean existCaCo = new File(strCaCoRdcFile).exists();
        boolean existCoN = new File(strCoNRdcFile).exists();
        Vector cacoRdc = new Vector();
        Vector conRdc = new Vector();
        if (existCaCo) {
            cacoRdc = dd.rdcRead(strCaCoRdcFile, 0.19845);
        } else {
            System.out.println("Warning: The Co-Ca RDC doesn't exist...");
        }
        if (existCoN) {
            conRdc = dd.rdcRead(strCoNRdcFile, 0.12086);
        } else {
            System.out.println("Warning: The Co-N RDC doesn't exist...");
        }
        String strInPdb = String.valueOf(src) + strInPdbName;
        Vector<Pdb> vecInPdb = new Vector<Pdb>();
        Vector<Pdb> ppVec = pp.readPdb(strInPdb);
        vecInPdb = pp.nameConvert(ppVec);
        Vector vecStartRes = asg.getOrder(strStartRes);
        Vector vecEndRes = asg.getOrder(strEndRes);
        Vector<Object> pdbVecSC = new Vector<Pdb>();
        pdbVecSC.addAll(ppVec);
        double[] rdc1Cal = new double[vecInPdb.size()];
        double[] rdc2Cal = new double[vecInPdb.size()];
        double[] saupe = new double[4];
        if (isRotate.equalsIgnoreCase("1")) {
            Matrix mm = pdr.bestFit(vecInPdb, nhRdc, cahaRdc, rdc1Cal, rdc2Cal, saupe);
            Vector<Pdb> pdbVec2 = pp.newPdb(vecInPdb, mm);
            pdbVecSC = pp.newPdb(ppVec, mm);
            vecInPdb = new Vector<Pdb>();
            vecInPdb.addAll(pdbVec2);
        }
        double[][] Inv_temp = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        Matrix Mat = new Matrix(Inv_temp);
        Vector vecPhiPsi = pp.PhiPsiTotalPdb(vecInPdb);
        Vector<Pdb> vecPdbNew = new Vector<Pdb>();
        int j = 0;
        while (j < vecEndRes.size()) {
            String strNo = (String)vecEndRes.elementAt(j);
            int ResNo = Integer.parseInt(strNo);
            double[] coordN = new double[3];
            double[] coordNH = new double[3];
            double[] coordCA = new double[3];
            int indA = Collections.binarySearch(vecInPdb, new Pdb(ResNo), new Pdb.PdbComparator());
            if (indA >= 0) {
                String atom;
                Cartesian cc;
                Pdb pdbA = (Pdb)vecInPdb.elementAt(indA);
                String resId = pdbA.getResidue();
                Vector<Cartesian> atomVecSC = new Vector<Cartesian>();
                Vector<Cartesian> atomVecA = pdbA.getAtomVec();
                Pdb pdbAsc = (Pdb)pdbVecSC.elementAt(indA);
                Vector<Cartesian> atomVecAsc = pdbAsc.getAtomVec();
                int k = 0;
                while (k < atomVecAsc.size()) {
                    cc = atomVecAsc.elementAt(k);
                    atom = cc.getAtom();
                    if (!(atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("O") || atom.equalsIgnoreCase("CB"))) {
                        atomVecSC.add(cc);
                    }
                    ++k;
                }
                k = 0;
                while (k < atomVecA.size()) {
                    cc = atomVecA.elementAt(k);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("N")) {
                        coordN = cc.getXYZ();
                    } else if (atom.equalsIgnoreCase("CA")) {
                        coordCA = cc.getXYZ();
                    } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                        coordNH = cc.getXYZ();
                    }
                    ++k;
                }
                int ind1 = Collections.binarySearch(vecPhiPsi, new PhiPsi(ResNo), new PhiPsi.PPComparator());
                PhiPsi phipsi = (PhiPsi)vecPhiPsi.elementAt(ind1);
                double dbPhi = phipsi.getPhi();
                double minSc = 99999.9;
                double psiSave = 0.0;
                double psiHigh = 0.0;
                double psiLow = 0.0;
                double psiRamHigh = 0.0;
                double psiRamLower = 0.0;
                if (isHelix) {
                    psiRamHigh = -14.999999999999998;
                    psiRamLower = -90.0;
                } else {
                    psiRamHigh = 180.0;
                    psiRamLower = 80.0;
                }
                psiHigh = psiRamHigh;
                psiLow = psiRamLower;
                int h = 0;
                while (h < vecTalos.size()) {
                    PhiPsi phipsiTemp = vecTalos.elementAt(h);
                    int resNo_temp = phipsiTemp.getResidueNo();
                    if (resNo_temp == ResNo) {
                        psiHigh = Math.min(phipsiTemp.getPsiUpper(), psiRamHigh);
                        psiLow = Math.max(phipsiTemp.getPsiLower(), psiRamLower);
                    }
                    ++h;
                }
                int t = 0;
                while ((double)t < (psiHigh - psiLow) / dbResolution) {
                    double ranPsi = psiLow * (Math.PI / 180) + (double)t * dbResolution * Math.PI / 180.0;
                    Pdb pp1 = mdc.coordByResidueFull(dbPhi, ranPsi, coordN, coordNH, coordCA, ResNo, resId, false);
                    Vector<Pdb> vecPp1 = new Vector<Pdb>();
                    vecPp1.add(pp1);
                    double r_nh = pdr.BackCalOnePdb(vecPp1, nhRdc, "N", "H", Mat, -Syy - Szz, Syy, Szz, 1.0);
                    double r_caha = pdr.BackCalOnePdb(vecPp1, cahaRdc, "CA", "HA", Mat, -Syy - Szz, Syy, Szz, 1.0);
                    double r_caco = pdr.BackCalCACOOnePdb(vecPp1, cacoRdc, "C", "CA", Mat, -Syy - Szz, Syy, Szz, Const.cacoRatio);
                    double rT = r_caha / 1.0 + r_nh / 1.0 + wtCoCA * (r_caco / Const.cacoRatio);
                    if (minSc > rT) {
                        minSc = rT;
                        psiSave = ranPsi;
                    }
                    ++t;
                }
                Pdb ppSave = mdc.coordByResidueFull(dbPhi, psiSave, coordN, coordNH, coordCA, ResNo, resId, false);
                Vector<Cartesian> atomVec = ppSave.getAtomVec();
                atomVec.addAll(atomVecSC);
                vecPdbNew.add(new Pdb(ResNo, resId, atomVec));
            }
            ++j;
        }
        j = 0;
        while (j < vecStartRes.size()) {
            Vector<Cartesian> atomVecSC = new Vector<Cartesian>();
            String strNo = (String)vecStartRes.elementAt(j);
            int ResNo = Integer.parseInt(strNo);
            int indA = Collections.binarySearch(pdbVecSC, new Pdb(ResNo), new Pdb.PdbComparator());
            if (indA >= 0) {
                Pdb pdbA = (Pdb)pdbVecSC.elementAt(indA);
                String resId = pdbA.getResidue();
                Vector<Cartesian> atomVecA = pdbA.getAtomVec();
                int k = 0;
                while (k < atomVecA.size()) {
                    Cartesian cc = atomVecA.elementAt(k);
                    String atom = cc.getAtom();
                    if (!(atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("O") || atom.equalsIgnoreCase("CB"))) {
                        atomVecSC.add(cc);
                    }
                    ++k;
                }
                double[] coordN = new double[3];
                double[] coordNH = new double[3];
                double[] coordCA = new double[3];
                int indB = Collections.binarySearch(vecInPdb, new Pdb(ResNo + 1), new Pdb.PdbComparator());
                Pdb pdbB = (Pdb)vecInPdb.elementAt(indB);
                Vector<Cartesian> atomVecB = pdbB.getAtomVec();
                int k2 = 0;
                while (k2 < atomVecB.size()) {
                    Cartesian cc = atomVecB.elementAt(k2);
                    String atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("N")) {
                        coordN = cc.getXYZ();
                    } else if (atom.equalsIgnoreCase("CA")) {
                        coordCA = cc.getXYZ();
                    } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                        coordNH = cc.getXYZ();
                    }
                    ++k2;
                }
                int ind1 = Collections.binarySearch(vecPhiPsi, new PhiPsi(ResNo), new PhiPsi.PPComparator());
                PhiPsi phipsi = (PhiPsi)vecPhiPsi.elementAt(ind1);
                double dbPsi = phipsi.getPsi();
                double minSc = 99999.9;
                double phiSave = 0.0;
                double phiHigh = 0.0;
                double phiLow = 0.0;
                double phiRamHigh = 0.0;
                double phiRamLower = 0.0;
                if (isHelix) {
                    phiRamHigh = -29.999999999999996;
                    phiRamLower = -100.0;
                } else {
                    phiRamHigh = -70.0;
                    phiRamLower = -170.0;
                }
                phiHigh = phiRamHigh;
                phiLow = phiRamLower;
                int h = 0;
                while (h < vecTalos.size()) {
                    PhiPsi phipsiTemp = vecTalos.elementAt(h);
                    int resNo_temp = phipsiTemp.getResidueNo();
                    if (resNo_temp == ResNo) {
                        phiHigh = Math.min(phipsiTemp.getPhiUpper(), phiRamHigh);
                        phiLow = Math.max(phipsiTemp.getPhiLower(), phiRamLower);
                    }
                    ++h;
                }
                int t = 0;
                while ((double)t < (phiHigh - phiLow) / dbResolution) {
                    double ranPhi = phiLow * (Math.PI / 180) + (double)t * dbResolution * Math.PI / 180.0;
                    Pdb pp1 = mdc.coordByBackward(ranPhi, dbPsi, coordN, coordNH, coordCA, ResNo, resId);
                    Vector<Pdb> vecPp1 = new Vector<Pdb>();
                    vecPp1.add(pp1);
                    double r_nh = pdr.BackCalOnePdb(vecPp1, nhRdc, "N", "H", Mat, -Syy - Szz, Syy, Szz, 1.0);
                    double r_caha = pdr.BackCalOnePdb(vecPp1, cahaRdc, "CA", "HA", Mat, -Syy - Szz, Syy, Szz, 1.0);
                    double r_caco = pdr.BackCalCACOOnePdb(vecPp1, cacoRdc, "C", "CA", Mat, -Syy - Szz, Syy, Szz, Const.cacoRatio);
                    double rT = r_caha / 1.0 + r_nh / 1.0 + wtCoCA * (r_caco / Const.cacoRatio);
                    if (minSc > rT) {
                        minSc = rT;
                        phiSave = ranPhi;
                    }
                    ++t;
                }
                Pdb ppSave = mdc.coordByBackward(phiSave, dbPsi, coordN, coordNH, coordCA, ResNo, resId);
                Vector<Cartesian> atomVec = ppSave.getAtomVec();
                atomVec.addAll(atomVecSC);
                vecPdbNew.add(new Pdb(ResNo, resId, atomVec));
            }
            ++j;
        }
        i = 0;
        while (i < pdbVecSC.size()) {
            boolean isMiddle = true;
            Pdb ppTemp = (Pdb)pdbVecSC.elementAt(i);
            int resNoTemp = ppTemp.getResidueNo();
            j = 0;
            while (j < vecEndRes.size()) {
                String strNo = (String)vecEndRes.elementAt(j);
                int ResNo = Integer.parseInt(strNo);
                if (resNoTemp == ResNo) {
                    isMiddle = false;
                }
                ++j;
            }
            j = 0;
            while (j < vecStartRes.size()) {
                Vector atomVecSC = new Vector();
                String strNo = (String)vecStartRes.elementAt(j);
                int ResNo = Integer.parseInt(strNo);
                if (resNoTemp == ResNo) {
                    isMiddle = false;
                }
                ++j;
            }
            if (isMiddle) {
                vecPdbNew.add(ppTemp);
            }
            ++i;
        }
        Collections.sort(vecPdbNew, new Pdb.PdbComparator());
        String fileName = String.valueOf(strOut) + strOutPdb;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            pp.printToFile(vecPdbNew, fileName, out);
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public void doRefineRdcExactMiddle(String src, String strOut, String strInput) throws JampackException {
        boolean isHelix = true;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        PdbRdc pdr = new PdbRdc();
        ModelRdc mdc = new ModelRdc();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double Syy = 0.0;
        double Szz = 0.0;
        double dbResolution = 0.0;
        String strInPdbName = "";
        String strMiddleRes = "";
        String strOutPdb = "";
        String strChFile = "";
        String strNhFile = "";
        String strCaCoFile = "";
        String strCoNFile = "";
        String strTalos = "";
        int nEndResNo = 0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("ENDRESIDUE")) {
                nEndResNo = Integer.parseInt(paraMap.get("ENDRESIDUE"));
            }
            if (paraMap.containsKey("CHFILE")) {
                strChFile = paraMap.get("CHFILE");
            }
            if (paraMap.containsKey("TALOS")) {
                strTalos = paraMap.get("TALOS");
            }
            if (paraMap.containsKey("NHFILE")) {
                strNhFile = paraMap.get("NHFILE");
            }
            if (paraMap.containsKey("COCAFILE")) {
                strCaCoFile = paraMap.get("COCAFILE");
            }
            if (paraMap.containsKey("CONFILE")) {
                strCoNFile = paraMap.get("CONFILE");
            }
            if (paraMap.containsKey("INPUTPDBNAME")) {
                strInPdbName = paraMap.get("INPUTPDBNAME");
            }
            if (paraMap.containsKey("SYY")) {
                Syy = Double.parseDouble(paraMap.get("SYY"));
            }
            if (paraMap.containsKey("SZZ")) {
                Szz = Double.parseDouble(paraMap.get("SZZ"));
            }
            if (paraMap.containsKey("MIDDLERESIDUES")) {
                strMiddleRes = paraMap.get("MIDDLERESIDUES");
            }
            if (paraMap.containsKey("OUTPDBNAME")) {
                strOutPdb = paraMap.get("OUTPDBNAME");
            }
            if (paraMap.containsKey("RESOLUTION")) {
                dbResolution = Double.parseDouble(paraMap.get("RESOLUTION"));
            }
            ++i;
        }
        String strTalosFile = String.valueOf(src) + strTalos;
        PhiPsi phipsi0 = new PhiPsi();
        Vector<PhiPsi> vecTalos = phipsi0.talosAngleReader(strTalosFile);
        String strChRdcFile = String.valueOf(src) + strChFile;
        String strNhRdcFile = String.valueOf(src) + strNhFile;
        String strCaCoRdcFile = String.valueOf(src) + strCaCoFile;
        String strCoNRdcFile = String.valueOf(src) + strCoNFile;
        Dipolar dd = new Dipolar();
        Vector nhRdc = dd.rdcRead(strNhRdcFile, 1.0);
        Vector cahaRdc = dd.rdcRead(strChRdcFile, 2.008);
        Vector cacoRdc = dd.rdcRead(strCaCoRdcFile, 0.19845);
        Vector conRdc = dd.rdcRead(strCoNRdcFile, 0.12086);
        String strInPdb = String.valueOf(src) + strInPdbName;
        Vector<Pdb> vecInPdb = new Vector<Pdb>();
        Vector<Pdb> ppVec = pp.readPdb(strInPdb);
        Collections.sort(ppVec, new Pdb.PdbComparator());
        vecInPdb = pp.nameConvert(ppVec);
        Vector vecMiddleRes = asg.getOrder(strMiddleRes);
        double[] rdc1Cal = new double[vecInPdb.size()];
        double[] rdc2Cal = new double[vecInPdb.size()];
        double[] saupe = new double[4];
        Matrix mm = pdr.bestFit(vecInPdb, nhRdc, cahaRdc, rdc1Cal, rdc2Cal, saupe);
        Vector<Pdb> pdbVec2 = pp.newPdb(vecInPdb, mm);
        Vector<Pdb> pdbVecSC = pp.newPdb(ppVec, mm);
        vecInPdb = new Vector<Pdb>();
        vecInPdb.addAll(pdbVec2);
        double[][] Inv_temp = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        Matrix Mat = new Matrix(Inv_temp);
        Vector vecPhiPsi = pp.PhiPsiTotalPdb(vecInPdb);
        Vector<Pdb> vecPdbNew = new Vector<Pdb>();
        int j = 0;
        while (j < vecMiddleRes.size()) {
            String atom;
            Cartesian cc;
            String strNo = (String)vecMiddleRes.elementAt(j);
            int ResNo = Integer.parseInt(strNo);
            double[] coordN = new double[3];
            double[] coordNH = new double[3];
            double[] coordCA = new double[3];
            int indA = Collections.binarySearch(vecInPdb, new Pdb(ResNo), new Pdb.PdbComparator());
            Pdb pdbA = (Pdb)vecInPdb.elementAt(indA);
            String resId = pdbA.getResidue();
            Vector<Cartesian> atomVecSC = new Vector<Cartesian>();
            Vector<Cartesian> atomVecA = pdbA.getAtomVec();
            int k = 0;
            while (k < indA) {
                Pdb pdbTT = (Pdb)vecInPdb.elementAt(k);
                vecPdbNew.add(pdbTT);
                ++k;
            }
            int EndInd = Collections.binarySearch(vecInPdb, new Pdb(nEndResNo), new Pdb.PdbComparator());
            int k2 = EndInd + 1;
            while (k2 < vecInPdb.size()) {
                Pdb pdbTT = (Pdb)vecInPdb.elementAt(k2);
                vecPdbNew.add(pdbTT);
                ++k2;
            }
            Pdb pdbAsc = pdbVecSC.elementAt(indA);
            Vector<Cartesian> atomVecAsc = pdbAsc.getAtomVec();
            int k3 = 0;
            while (k3 < atomVecAsc.size()) {
                cc = atomVecAsc.elementAt(k3);
                atom = cc.getAtom();
                if (!(atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("O") || atom.equalsIgnoreCase("CB"))) {
                    atomVecSC.add(cc);
                }
                ++k3;
            }
            k3 = 0;
            while (k3 < atomVecA.size()) {
                cc = atomVecA.elementAt(k3);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("N")) {
                    coordN = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("CA")) {
                    coordCA = cc.getXYZ();
                } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                    coordNH = cc.getXYZ();
                }
                ++k3;
            }
            double minSc = 99999.9;
            double psiSave = 0.0;
            double phiSave = 0.0;
            double psiHigh = 0.0;
            double psiLow = 0.0;
            double psiRamHigh = 0.0;
            double psiRamLower = 0.0;
            if (isHelix) {
                psiRamHigh = -14.999999999999998;
                psiRamLower = -90.0;
            } else {
                psiRamHigh = 180.0;
                psiRamLower = 80.0;
            }
            int h = 0;
            while (h < vecTalos.size()) {
                PhiPsi phipsiTemp = vecTalos.elementAt(h);
                int resNo_temp = phipsiTemp.getResidueNo();
                if (resNo_temp == ResNo) {
                    psiHigh = Math.min(phipsiTemp.getPsiUpper(), psiRamHigh);
                    psiLow = Math.max(phipsiTemp.getPsiLower(), psiRamLower);
                }
                ++h;
            }
            double phiHigh = 0.0;
            double phiLow = 0.0;
            double phiRamHigh = 0.0;
            double phiRamLower = 0.0;
            if (isHelix) {
                phiRamHigh = -29.999999999999996;
                phiRamLower = -100.0;
            } else {
                phiRamHigh = -70.0;
                phiRamLower = -170.0;
            }
            int h2 = 0;
            while (h2 < vecTalos.size()) {
                PhiPsi phipsiTemp = vecTalos.elementAt(h2);
                int resNo_temp = phipsiTemp.getResidueNo();
                if (resNo_temp == ResNo) {
                    phiHigh = Math.min(phipsiTemp.getPhiUpper(), phiRamHigh);
                    phiLow = Math.max(phipsiTemp.getPhiLower(), phiRamLower);
                }
                ++h2;
            }
            int ind0 = Collections.binarySearch(vecPhiPsi, new PhiPsi(ResNo), new PhiPsi.PPComparator());
            int indEnd = Collections.binarySearch(vecPhiPsi, new PhiPsi(nEndResNo), new PhiPsi.PPComparator());
            Vector<Double> vecPhiS = new Vector<Double>();
            Vector<Double> VecPsiS = new Vector<Double>();
            int tt = ind0 + 1;
            while (tt <= indEnd) {
                PhiPsi phipsiT = (PhiPsi)vecPhiPsi.elementAt(tt);
                vecPhiS.add(phipsiT.getPhi());
                VecPsiS.add(phipsiT.getPsi());
                ++tt;
            }
            int t = 0;
            while ((double)t < (psiHigh - psiLow) / dbResolution) {
                double ranPsi = psiLow * (Math.PI / 180) + (double)t * dbResolution * Math.PI / 180.0;
                int w = 0;
                while ((double)w < (phiHigh - psiLow) / dbResolution) {
                    double ranPhi = phiLow * (Math.PI / 180) + (double)w * dbResolution * Math.PI / 180.0;
                    Vector<Double> vecPhiSave = new Vector<Double>();
                    Vector<Double> vecPsiSave = new Vector<Double>();
                    vecPhiSave.add(ranPhi);
                    vecPhiSave.addAll(vecPhiS);
                    vecPsiSave.add(ranPsi);
                    vecPsiSave.addAll(VecPsiS);
                    double[] phiS = new double[vecPhiSave.size()];
                    double[] psiS = new double[vecPsiSave.size()];
                    int w2 = 0;
                    while (w2 < vecPhiSave.size()) {
                        phiS[w2] = (Double)vecPhiSave.elementAt(w2);
                        ++w2;
                    }
                    w2 = 0;
                    while (w2 < vecPsiSave.size()) {
                        psiS[w2] = (Double)vecPsiSave.elementAt(w2);
                        ++w2;
                    }
                    Vector pdbHelixTemp = new Vector();
                    pdbHelixTemp = mdc.modelBuild(phiS, psiS, coordN, coordNH, coordCA, ResNo, false);
                    boolean[] resIndex = new boolean[pdbHelixTemp.size()];
                    int kk = 0;
                    while (kk < resIndex.length) {
                        resIndex[kk] = false;
                        ++kk;
                    }
                    Vector vecPdbSseRot2 = new Vector();
                    String rotSrc = String.valueOf(src) + "rotasamp-small/";
                    vecPdbSseRot2 = pp.AlaninizeStructure(pdbHelixTemp, resIndex, rotSrc);
                    vdw vander = new vdw();
                    Vector vdwVec = new Vector();
                    double[] vdwValue = new double[1];
                    double vdwLevel = 0.05;
                    boolean printVDWViolation = false;
                    int[] clashResNo = new int[2];
                    vdwVec = vander.convert2VDW(vecPdbSseRot2);
                    boolean isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.4, 1, clashResNo);
                    if (isStericClash) {
                        System.out.println("here we have one steric clash...");
                    } else {
                        double r_nh = pdr.BackCalOnePdb(pdbHelixTemp, nhRdc, "N", "H", Mat, -Syy - Szz, Syy, Szz, 1.0);
                        double r_caha = pdr.BackCalOnePdb(pdbHelixTemp, cahaRdc, "CA", "HA", Mat, -Syy - Szz, Syy, Szz, 1.0);
                        double r_caco = pdr.BackCalCACOOnePdb(pdbHelixTemp, cacoRdc, "C", "CA", Mat, -Syy - Szz, Syy, Szz, Const.cacoRatio);
                        double r_con = pdr.BackCalCONOnePdb(pdbHelixTemp, conRdc, "C", "N", Mat, -Syy - Szz, Syy, Szz, Const.conRatio);
                        double rT = r_caha / 1.0 + r_nh / 1.0 + 1.0 * (r_caco / Const.cacoRatio);
                        if (minSc > rT) {
                            minSc = rT;
                            phiSave = ranPhi;
                            psiSave = ranPsi;
                        }
                    }
                    ++w;
                }
                ++t;
            }
            Vector<Double> vecPhiSave = new Vector<Double>();
            Vector<Double> vecPsiSave = new Vector<Double>();
            vecPhiSave.add(phiSave);
            vecPhiSave.addAll(vecPhiS);
            vecPsiSave.add(psiSave);
            vecPsiSave.addAll(VecPsiS);
            double[] phiS = new double[vecPhiSave.size()];
            double[] psiS = new double[vecPsiSave.size()];
            int w2 = 0;
            while (w2 < vecPhiSave.size()) {
                phiS[w2] = (Double)vecPhiSave.elementAt(w2);
                ++w2;
            }
            w2 = 0;
            while (w2 < vecPsiSave.size()) {
                psiS[w2] = (Double)vecPsiSave.elementAt(w2);
                ++w2;
            }
            Vector pdbHelixTemp = new Vector();
            pdbHelixTemp = mdc.modelBuild(phiS, psiS, coordN, coordNH, coordCA, ResNo, false);
            vecPdbNew.addAll(pdbHelixTemp);
            ++j;
        }
        Collections.sort(vecPdbNew, new Pdb.PdbComparator());
        String fileName = String.valueOf(strOut) + strOutPdb;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            pp.printToFile(vecPdbNew, fileName, out);
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    public void doRdcExactHelix(String src, String strOut, String strInput) throws JampackException {
        int maxStructurePerEnsemble = 2000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double Syy = 0.0;
        double Szz = 0.0;
        double wtCoCA = 0.0;
        double wtCoN = 0.0;
        String strResBounds = "";
        String strOutPdb = "";
        String strChFile = "";
        String strNhFile = "";
        String strCaCoFile = "";
        String strCoNFile = "";
        String strTalos = "";
        String strPrePdb = "";
        String strSeq = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("CHFILE")) {
                strChFile = paraMap.get("CHFILE");
            }
            if (paraMap.containsKey("TALOS")) {
                strTalos = paraMap.get("TALOS");
            }
            if (paraMap.containsKey("NHFILE")) {
                strNhFile = paraMap.get("NHFILE");
            }
            if (paraMap.containsKey("COCAFILE")) {
                strCaCoFile = paraMap.get("COCAFILE");
            }
            if (paraMap.containsKey("CONFILE")) {
                strCoNFile = paraMap.get("CONFILE");
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("SYY")) {
                Syy = Double.parseDouble(paraMap.get("SYY"));
            }
            if (paraMap.containsKey("SZZ")) {
                Szz = Double.parseDouble(paraMap.get("SZZ"));
            }
            if (paraMap.containsKey("WTCOCA")) {
                wtCoCA = Double.parseDouble(paraMap.get("WTCOCA"));
            }
            if (paraMap.containsKey("WTCON")) {
                wtCoN = Double.parseDouble(paraMap.get("WTCON"));
            }
            if (paraMap.containsKey("RESBOUNDS")) {
                strResBounds = paraMap.get("RESBOUNDS");
            }
            if (paraMap.containsKey("OUTPDBNAME")) {
                strOutPdb = paraMap.get("OUTPDBNAME");
            }
            if (paraMap.containsKey("PREPDBNAME")) {
                strPrePdb = paraMap.get("PREPDBNAME");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String strTalosFile = String.valueOf(src) + strTalos;
        PhiPsi phipsi0 = new PhiPsi();
        Vector<Object> vecTalos = new Vector();
        boolean existTalos = new File(strTalosFile).exists();
        if (existTalos) {
            vecTalos = phipsi0.talosAngleReader(strTalosFile);
        } else {
            System.out.println("Warning: The TALOS input is not available...");
        }
        String strChRdcFile = String.valueOf(src) + strChFile;
        String strNhRdcFile = String.valueOf(src) + strNhFile;
        String strCaCoRdcFile = String.valueOf(src) + strCaCoFile;
        String strCoNRdcFile = String.valueOf(src) + strCoNFile;
        Dipolar dd = new Dipolar();
        Vector nhRdc = dd.rdcRead(strNhRdcFile, 1.0);
        Vector cahaRdc = dd.rdcRead(strChRdcFile, 1.0);
        boolean existCaCo = new File(strCaCoRdcFile).exists();
        boolean existCoN = new File(strCoNRdcFile).exists();
        Vector cacoRdc = new Vector();
        Vector conRdc = new Vector();
        if (existCaCo) {
            cacoRdc = dd.rdcRead(strCaCoRdcFile, 0.19845);
        } else {
            System.out.println("Warning: The Co-Ca RDC doesn't exist...");
        }
        if (existCoN) {
            conRdc = dd.rdcRead(strCoNRdcFile, 0.12086);
        } else {
            System.out.println("Warning: The Co-N RDC doesn't exist...");
        }
        String strPdb = String.valueOf(src) + strPrePdb;
        Vector vecPrePdb = new Vector();
        boolean existPreFile = new File(strPdb).exists();
        if (existPreFile) {
            Vector<Pdb> ppVec = pp.readPdb(strPdb);
            vecPrePdb = pp.nameConvert(ppVec);
        } else {
            System.out.println("Warning: no previous structure was found...");
        }
        Vector vecResBounds = asg.getOrder(strResBounds);
        String strNo1 = (String)vecResBounds.elementAt(0);
        String strNo2 = (String)vecResBounds.elementAt(1);
        int StartResNo = Integer.parseInt(strNo1);
        int EndResNo = Integer.parseInt(strNo2);
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        double[] ramaFilter = new double[]{-1.7453292519943295, -0.5235987755982988, -1.5707963267948966, -0.2617993877991494};
        double resolution = 2.0;
        int refineCycle = 4;
        int dfsCycle = 931072;
        boolean debugDFS = true;
        boolean printResults = true;
        double w4Angles = 0.1;
        double phiAve = -1.1397000015522971;
        double psiAve = -0.6876597252857658;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = StartResNo;
        while (i <= EndResNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbVec = mdc.modelBuild(phiPsiVec, n1, nh1, ca1);
        int nRefineCycles = 4;
        Vector<Object> helixPdbVec22 = new Vector();
        int t = 0;
        while (t <= nRefineCycles) {
            System.out.println("===============helix" + t + "=====================");
            refineCycle = 2;
            helixPdbVec22 = new Vector();
            helixPdbVec22 = mdc.refineHelixW4RDCs(vecPrePdb, pdbVec, nhRdc, cahaRdc, cacoRdc, conRdc, Syy, Szz, ramaFilter, phiAve, psiAve, refineCycle, dfsCycle, w4Angles, resolution, debugDFS, printResults, vecTalos, wtCoCA, wtCoN, StartResNo, EndResNo, vecSeq);
            Pdb temp2 = new Pdb();
            temp2.print(helixPdbVec22);
            pdbVec = new Vector();
            pdbVec.addAll(helixPdbVec22);
            ++t;
        }
        String fileName = String.valueOf(strOut) + strOutPdb;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            pp.printToFile(pdbVec, fileName, out);
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public void doRdcExactHelixWOAT(String src, String strOut, String strInput) throws JampackException {
        int maxStructurePerEnsemble = 2000;
        boolean isDebug = true;
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double Syy = 0.0;
        double Szz = 0.0;
        double wtCoCA = 0.0;
        double wtCoN = 0.0;
        double nRefineCycles = 0.0;
        String strResBounds = "";
        String strOutPdb = "";
        String strChFile = "";
        String strNhFile = "";
        String strIsNonAT = "";
        String strCaCoFile = "";
        String strCoNFile = "";
        String strTalos = "";
        String strPrePdb = "";
        String strSeq = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("CHFILE")) {
                strChFile = paraMap.get("CHFILE");
            }
            if (paraMap.containsKey("TALOS")) {
                strTalos = paraMap.get("TALOS");
            }
            if (paraMap.containsKey("ISNONAT")) {
                strIsNonAT = paraMap.get("ISNONAT");
            }
            if (paraMap.containsKey("NHFILE")) {
                strNhFile = paraMap.get("NHFILE");
            }
            if (paraMap.containsKey("COCAFILE")) {
                strCaCoFile = paraMap.get("COCAFILE");
            }
            if (paraMap.containsKey("CONFILE")) {
                strCoNFile = paraMap.get("CONFILE");
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("SYY")) {
                Syy = Double.parseDouble(paraMap.get("SYY"));
            }
            if (paraMap.containsKey("SZZ")) {
                Szz = Double.parseDouble(paraMap.get("SZZ"));
            }
            if (paraMap.containsKey("WTCOCA")) {
                wtCoCA = Double.parseDouble(paraMap.get("WTCOCA"));
            }
            if (paraMap.containsKey("WTCON")) {
                wtCoN = Double.parseDouble(paraMap.get("WTCON"));
            }
            if (paraMap.containsKey("REFINECYCLES")) {
                nRefineCycles = Double.parseDouble(paraMap.get("REFINECYCLES"));
            }
            if (paraMap.containsKey("RESBOUNDS")) {
                strResBounds = paraMap.get("RESBOUNDS");
            }
            if (paraMap.containsKey("OUTPDBNAME")) {
                strOutPdb = paraMap.get("OUTPDBNAME");
            }
            if (paraMap.containsKey("PREPDBNAME")) {
                strPrePdb = paraMap.get("PREPDBNAME");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String strTalosFile = String.valueOf(src) + strTalos;
        PhiPsi phipsi0 = new PhiPsi();
        Vector<Object> vecTalos = new Vector();
        boolean existTalos = new File(strTalosFile).exists();
        if (existTalos) {
            vecTalos = phipsi0.talosAngleReader(strTalosFile);
        } else {
            System.out.println("Warning: The TALOS input is not available...");
        }
        String strChRdcFile = String.valueOf(src) + strChFile;
        String strNhRdcFile = String.valueOf(src) + strNhFile;
        String strCaCoRdcFile = String.valueOf(src) + strCaCoFile;
        String strCoNRdcFile = String.valueOf(src) + strCoNFile;
        Dipolar dd = new Dipolar();
        Vector nhRdc = dd.rdcRead(strNhRdcFile, 1.0);
        Vector cahaRdc = dd.rdcRead(strChRdcFile, 1.0);
        boolean existCaCo = new File(strCaCoRdcFile).exists();
        boolean existCoN = new File(strCoNRdcFile).exists();
        Vector cacoRdc = new Vector();
        Vector<Dipolar> conRdc = new Vector<Dipolar>();
        if (existCaCo) {
            cacoRdc = dd.rdcRead(strCaCoRdcFile, 0.19845);
        } else {
            System.out.println("Warning: The Co-Ca RDC doesn't exist...");
        }
        if (existCoN) {
            dd.rdcRead(strCoNRdcFile, 0.12086);
        } else {
            System.out.println("Warning: The Co-N RDC doesn't exist...");
        }
        String strPdb = String.valueOf(src) + strPrePdb;
        Vector vecPrePdb = new Vector();
        boolean existPreFile = new File(strPdb).exists();
        if (existPreFile) {
            Vector<Pdb> ppVec = pp.readPdb(strPdb);
            vecPrePdb = pp.nameConvert(ppVec);
        } else {
            System.out.println("Warning: no previous structure was found...");
        }
        Vector vecResBounds = asg.getOrder(strResBounds);
        String strNo1 = (String)vecResBounds.elementAt(0);
        String strNo2 = (String)vecResBounds.elementAt(1);
        int StartResNo = Integer.parseInt(strNo1);
        int EndResNo = Integer.parseInt(strNo2);
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        double[] ramaFilter = new double[]{-1.7453292519943295, -0.5235987755982988, -1.5707963267948966, -0.2617993877991494};
        double resolution = 2.0;
        int refineCycle = 4;
        int dfsCycle = 631072;
        boolean debugDFS = true;
        boolean printResults = true;
        double w4Angles = 11.0;
        double phiAve = -1.1397000015522971;
        double psiAve = -0.6876597252857658;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = StartResNo;
        while (i <= EndResNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbVec = mdc.modelBuild(phiPsiVec, n1, nh1, ca1);
        if (strIsNonAT.equalsIgnoreCase("1")) {
            double[] saupe = new double[5];
            System.out.println("===============helix0=====================");
            Vector helixPdbVec = mdc.refineSaupe4RDCsWOAT(vecPrePdb, pdbVec, nhRdc, cahaRdc, cacoRdc, conRdc, saupe, ramaFilter, phiAve, psiAve, refineCycle, dfsCycle, debugDFS, printResults, vecTalos, wtCoCA, wtCoN, StartResNo, EndResNo, vecSeq);
            Pdb temp1 = new Pdb();
            temp1.print(helixPdbVec);
            Syy = saupe[0];
            Szz = saupe[1];
            double rdc1Rmsd = saupe[2];
            double rdc2Rmsd = saupe[3];
            System.out.println("First  " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
            System.out.println("-----------------------------------");
            System.out.println("The alignment tensor for helix:");
            System.out.println("Sxx, Syy, Szz=    " + (-Syy - Szz) + "    " + Syy + "  " + Szz);
            System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
            System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
            System.out.println("Another format of alingment tenosr:  ");
            System.out.println("A_a, A_r =   " + Szz / 2.0 + "   " + (-Syy - Szz - Syy) / 3.0);
            System.out.println("-----------------------------------");
            System.out.println("====================================");
            pdbVec = new Vector();
            pdbVec.addAll(helixPdbVec);
        }
        Vector<Object> helixPdbVec22 = new Vector();
        int t = 0;
        while ((double)t <= nRefineCycles) {
            System.out.println("===============helix" + t + "=====================");
            refineCycle = 2;
            helixPdbVec22 = new Vector();
            helixPdbVec22 = mdc.refineHelixW4RDCs(vecPrePdb, pdbVec, nhRdc, cahaRdc, cacoRdc, conRdc, Syy, Szz, ramaFilter, phiAve, psiAve, refineCycle, dfsCycle, w4Angles, resolution, debugDFS, printResults, vecTalos, wtCoCA, wtCoN, StartResNo, EndResNo, vecSeq);
            Pdb temp2 = new Pdb();
            temp2.print(helixPdbVec22);
            pdbVec = new Vector();
            pdbVec.addAll(helixPdbVec22);
            ++t;
        }
        String fileName = String.valueOf(strOut) + strOutPdb;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            pp.printToFile(pdbVec, fileName, out);
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    private void errorTooFewParams(String s) {
        System.out.println("ERROR: Too few parameters for " + s);
    }

    public void outputProgInfo() {
        System.out.println("*****************************************************************************************");
        System.out.println("**         ,rMr.,------.,rMr.                RDC-PANDA Version 1.0                     **");
        System.out.println("**         (GNP'        `?ND)                Contact Info:                             **");
        System.out.println("**           P  xMx.  ,yMb  ?                    Bruce Donald                          **");
        System.out.println("**           (  ?X_O  O_XP  )                    Duke University                       **");
        System.out.println("**           (      qp      )   RDCs             Department of Computer Science        **");
        System.out.println("**            1  `--'`--'  7                     Levine Science Research Center (LSRC) **");
        System.out.println("**         _____         ,__)                    Durham                                **");
        System.out.println("**        (--|__) _.._  _| _,                    NC 27708-0129, USA                    **");
        System.out.println("**          _|   (_|| |(_|(_|                    brd@cs.duke.edu                       **");
        System.out.println("**         (                                                                           **");
        System.out.println("**                                                                                     **");
        System.out.println("**          J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. **");
        System.out.println("** \t    \"High-Resolution Protein Structure Determination Starting with a Global    **");
        System.out.println("**          Fold Calculated from Exact Solutions to the RDC Equations.\" J. Biom. NMR,  **");
        System.out.println("**          45(3):265-281, 2009.                                                       **");
        System.out.println("*****************************************************************************************");
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = RdcPanda.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

