/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ParametersJFrame.java
 *
 * Created on May 9, 2011, 1:19:08 PM
 */
package NascaGUI;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Vector;

import javax.swing.JFileChooser;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import rdcPanda.Assign;

/**
 *
 * @author zjy
 */
public class ParametersJFrame extends javax.swing.JFrame {

	//defulat parameter settings:
	private double haErrDefault  = 0.03;
	private double h1ErrDefault  = 0.03;
	private double c13ErrDefault = 0.3;
	private double hnErrDefault  = 0.03;
	private double nErrDefault   = 0.3; 
	
	private double noeDistLimitDefault=5.0;
	
	private String strInputDefault=System.getProperty("user.dir")+"/inputFiles/";  //default input file directory		
	private String strOutDefault=System.getProperty("user.dir")+"/inputFiles/"; //default output file directory
	
	
    /** Creates new form ParametersJFrame */
    public ParametersJFrame() {
    	createNumberSpinner();
        initComponents();
        
        //read the default system parameters
        String userDir = System.getProperty("user.dir");////
    	String srcNascaSystemDefault=userDir+"/system/nasca/nasca_system_default.input";
    	readDefaultSystemParameters(srcNascaSystemDefault); 	
         
    }

    private void createNumberSpinner()
    {
    	//jSpinnerErrHa
    
        //current value
        Double current = new Double(0.03);
        
        //Min value
        Double min = new Double(0.00);
        
        //Max value
        Double max = new Double(1.00);
        
        //Step value
        Double step = new Double(0.01);
        
        //creating the number spinner model
        SpinnerNumberModel m_numberSpinnerModel = new SpinnerNumberModel(current, min, max, step);
        jSpinnerErrHa = new JSpinner(m_numberSpinnerModel);  
        //jSpinnerErrHa.setValue(m_numberSpinnerModel);
    }
        
         
    private void readDefaultSystemParameters(String srcNascaSystemDefault){
    	Assign asg = new Assign();
    	Vector<Map<String, String>> paraVec = asg.ParamReader(srcNascaSystemDefault);
       	
    	for (int i=0;i<paraVec.size();i++)
    	{
    		
    		Map<String, String> paraMap = paraVec.elementAt(i);
    		if(paraMap.containsKey("HAERR"))
    			this.haErrDefault  =  Double.parseDouble((String)paraMap.get("HAERR"));
    		if(paraMap.containsKey("H1ERR"))
    			this.h1ErrDefault  =  Double.parseDouble((String)paraMap.get("H1ERR"));
    		if(paraMap.containsKey("C13ERR"))
    			this.c13ErrDefault  =  Double.parseDouble((String)paraMap.get("C13ERR"));
    		if(paraMap.containsKey("HNERR"))
    			this.hnErrDefault  =  Double.parseDouble((String)paraMap.get("HNERR"));
    		if(paraMap.containsKey("NERR"))
    			this.nErrDefault  =  Double.parseDouble((String)paraMap.get("NERR"));
    		if(paraMap.containsKey("NOELIMIT"))
    			this.noeDistLimitDefault  =  Double.parseDouble((String)paraMap.get("NOELIMIT"));
    		
    		//get the input file name   
    		if(paraMap.containsKey("INPUT_DIRECTORY"))
    			this.strInputDefault=Global.getCorrectFilePathAndName( (String)paraMap.get("INPUT_DIRECTORY"));
    		if(paraMap.containsKey("OUTPUT_DIRECTORY"))
    			this.strOutDefault= Global.getCorrectFilePathAndName((String)paraMap.get("OUTPUT_DIRECTORY"));
    		//if(paraMap.containsKey("INPUT_SESSION_FILE"))
    		//	Global.updateDefaultInputSessionName( (String)paraMap.get("INPUT_SESSION_FILE") );    		
    	}       	   	
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jSpinnerErrHa = new javax.swing.JSpinner(new SpinnerNumberModel(Global.haErr, 0.00, 0.50, 0.01));
        jLabel2 = new javax.swing.JLabel();
        jSpinnerErrHn = new javax.swing.JSpinner(new SpinnerNumberModel(Global.hnErr, 0.00, 0.50, 0.01));
        jLabel3 = new javax.swing.JLabel();
        jSpinnerErrH1 = new javax.swing.JSpinner(new SpinnerNumberModel(Global.h1Err, 0.00, 0.50, 0.01));
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jSpinnerErrCa = new javax.swing.JSpinner(new SpinnerNumberModel(Global.c13Err, 0.00, 5.00, 0.05));
        jSpinnerErrN = new javax.swing.JSpinner(new SpinnerNumberModel(Global.nErr, 0.00, 5.00, 0.05));
        jSpinnerErrNoeLimit = new javax.swing.JSpinner(new SpinnerNumberModel(Global.noeDistLimit, 0.00, 7.50, 0.5));
        jLabel6 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel7 = new javax.swing.JLabel();
        jTextFieldDefaultInputPath = new javax.swing.JTextField(Global.getInputFilePath());
        jLabel8 = new javax.swing.JLabel();
        jTextFieldDefaultOutputPath = new javax.swing.JTextField(Global.getOutputFilePath());
        jButtonDefaultOutputPath = new javax.swing.JButton();
        jButtonDefaultInputPath = new javax.swing.JButton();
        jButtonDefaultSetting = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jButtonApply = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setResizable(false);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Error Windows (in ppm)", javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 11))); // NOI18N
        jPanel1.setToolTipText("Error windows for constructing the NOESY graph");

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel1.setText("Ha:");

        jSpinnerErrHa.setToolTipText("Error window for Ha");

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel2.setText("Hn:");

        jSpinnerErrHn.setToolTipText("Error window for Hn");

        jLabel3.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel3.setText("H1:");

        jSpinnerErrH1.setToolTipText("Error window for H1");

        jLabel4.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel4.setText("Ca:");

        jLabel5.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel5.setText("N:");

        jSpinnerErrCa.setToolTipText("Error window for Ca");

        jSpinnerErrN.setToolTipText("Error window for N");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, 30, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSpinnerErrCa, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jSpinnerErrHa, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(66, 66, 66)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel5)
                    .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jSpinnerErrHn, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(61, 61, 61)
                        .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE)
                        .addComponent(jSpinnerErrH1, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jSpinnerErrN, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel3)
                            .addComponent(jSpinnerErrH1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2)
                            .addComponent(jSpinnerErrHn, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSpinnerErrHa, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel4)
                            .addComponent(jSpinnerErrCa, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(38, 38, 38)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jSpinnerErrN, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel5))))
                .addContainerGap(19, Short.MAX_VALUE))
        );

        jSpinnerErrNoeLimit.setToolTipText("NOE distance threashold for contructing edges between proton labels");

        jLabel6.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel6.setText("NOE Distance Threshold (in angstrom):");

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createTitledBorder(""), "Default File Paths", javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 11))); // NOI18N

        jLabel7.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel7.setText("Input File Directory:");
        jLabel7.setToolTipText("Backbone coordinate file");

        jTextFieldDefaultInputPath.setToolTipText("Default input file directory");

        jLabel8.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel8.setText("Output File Directory:");
        jLabel8.setToolTipText("Backbone coordinate file");

        jTextFieldDefaultOutputPath.setToolTipText("Default output file directory");

        jButtonDefaultOutputPath.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jButtonDefaultOutputPath.setText("Browse...");
        jButtonDefaultOutputPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDefaultOutputPathActionPerformed(evt);
            }
        });

        jButtonDefaultInputPath.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jButtonDefaultInputPath.setText("Browse...");
        jButtonDefaultInputPath.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDefaultInputPathActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jLabel7)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jTextFieldDefaultOutputPath, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jTextFieldDefaultInputPath, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 266, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButtonDefaultOutputPath)
                    .addComponent(jButtonDefaultInputPath))
                .addContainerGap(20, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel7)
                    .addComponent(jTextFieldDefaultInputPath, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonDefaultInputPath))
                .addGap(18, 18, 18)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldDefaultOutputPath, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonDefaultOutputPath)
                    .addComponent(jLabel8))
                .addContainerGap(21, Short.MAX_VALUE))
        );

        jButtonDefaultSetting.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jButtonDefaultSetting.setText("Default");
        jButtonDefaultSetting.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDefaultSettingActionPerformed(evt);
            }
        });

        jButtonCancel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jButtonApply.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jButtonApply.setText("Apply");
        jButtonApply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonApplyActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                    .addContainerGap(117, Short.MAX_VALUE)
                    .addComponent(jButtonDefaultSetting)
                    .addGap(63, 63, 63)
                    .addComponent(jButtonApply)
                    .addGap(56, 56, 56)
                    .addComponent(jButtonCancel)
                    .addGap(128, 128, 128))
                .addGroup(layout.createSequentialGroup()
                    .addGap(18, 18, 18)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap(24, Short.MAX_VALUE))
                .addGroup(layout.createSequentialGroup()
                    .addGap(59, 59, 59)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                            .addGap(24, 24, 24)
                            .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jSpinnerErrNoeLimit, javax.swing.GroupLayout.PREFERRED_SIZE, 66, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGap(202, 202, 202))
                        .addGroup(layout.createSequentialGroup()
                            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addContainerGap(79, Short.MAX_VALUE))))
            );

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jSpinnerErrNoeLimit, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6))
                .addGap(26, 26, 26)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(20, 20, 20)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonCancel)
                    .addComponent(jButtonApply)
                    .addComponent(jButtonDefaultSetting))
                .addContainerGap(33, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

//GEN-FIRST:event_jTextFieldBBPdbActionPerformed
 
//GEN-LAST:event_jTextFieldBBPdbActionPerformed

//GEN-FIRST:event_jButtonBBPdbOpenActionPerformed
 
//GEN-LAST:event_jButtonBBPdbOpenActionPerformed

    private void jButtonDefaultOutputPathActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDefaultOutputPathActionPerformed
    	 //String curDir=System.getProperty("user.dir")+File.separator;
        String curDir=Global.getInputFilePath();
        String sourceName="";
        File sourceFile=new File (sourceName);            
         
        javax.swing.JFileChooser chooser=new javax.swing.JFileChooser(curDir);         
                 
        chooser.setMultiSelectionEnabled(false);
	   	 
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY); 
        chooser.setSelectedFile(sourceFile);  // set default for output
			 
	   	//String[] html=new String[] {"PDB","pdb"};
	   	//chooser.addChoosableFileFilter(new ExtFilter(html,
	         //     "PDB file (*.pdb)"));
	   	int option=chooser.showOpenDialog(this);////////////
	    if (option==JFileChooser.APPROVE_OPTION)
        {
            sourceFile=chooser.getSelectedFile();
            try {sourceName=sourceFile.getCanonicalPath();}
            catch (IOException e) {};
            this.jTextFieldDefaultOutputPath.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());
            //Global.strOut=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();            
         }
         else {
                   /*add cancelled message here*/
       	  
         }
    }//GEN-LAST:event_jButtonDefaultOutputPathActionPerformed

    private void jButtonDefaultSettingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDefaultSettingActionPerformed
        this.jSpinnerErrHa.setValue(this.haErrDefault);
        this.jSpinnerErrHn.setValue(this.hnErrDefault);
        this.jSpinnerErrH1.setValue(this.h1ErrDefault);
        this.jSpinnerErrCa.setValue(this.c13ErrDefault);
        this.jSpinnerErrN.setValue(this.nErrDefault);
        this.jSpinnerErrNoeLimit.setValue(this.noeDistLimitDefault);

    	this.jTextFieldDefaultInputPath.setText(this.strInputDefault);
    	this.jTextFieldDefaultOutputPath.setText(this.strOutDefault);
    	
    }//GEN-LAST:event_jButtonDefaultSettingActionPerformed

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        this.dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonApplyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonApplyActionPerformed
    	Global.haErr=(Double)this.jSpinnerErrHa.getValue();
    	Global.hnErr=(Double)this.jSpinnerErrHn.getValue();
    	Global.h1Err=(Double)this.jSpinnerErrH1.getValue();
    	Global.c13Err=(Double)this.jSpinnerErrCa.getValue();
    	Global.nErr=(Double)this.jSpinnerErrN.getValue();
    	Global.noeDistLimit=(Double)this.jSpinnerErrNoeLimit.getValue();
    	
    	Global.strInput=this.jTextFieldDefaultInputPath.getText();
    	Global.strOut=this.jTextFieldDefaultOutputPath.getText();
    	
    	String userDir = System.getProperty("user.dir");////
    	String srcNascaSystem=userDir+"/system/nasca/nasca_system.input";
    	writeSystemParametersToFile(srcNascaSystem);
    	this.dispose();
    }//GEN-LAST:event_jButtonApplyActionPerformed

    private void writeSystemParametersToFile(String strOutputFileName){
    	try
    	{
    		PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(strOutputFileName)));
    		out.println("//error windows (in the ppm unit) of chemical shifts");
    		//out.println("//for constructing the NOESY graph");
    		out.println("haErr    = "+String.format("%.3f",Global.haErr)+";");  
    		out.println("hnErr    = "+String.format("%.3f",Global.hnErr)+";");  
    		out.println("h1Err    = "+String.format("%.3f",Global.h1Err)+";");    		
    		out.println("c13Err   = "+String.format("%.3f",Global.c13Err)+";");  
    		out.println("nErr     = "+String.format("%.3f", Global.nErr)+";");  
    		out.println();out.println();
    		
    		out.println("//NOE distance threashold");
    		out.println("noeLimit = "+ String.format("%.2f",Global.noeDistLimit)+";");    		
    		out.println();out.println();
    		
    		out.println("//default input file directory");
    		out.println("input_directory = "+ Global.strInput+";");     		
    		out.println();out.println();
    		
    		out.println("//default output file directory");
    		out.println("output_directory = "+ Global.strOut+";");     		
    		out.println();out.println();
    		
    		
    		out.println("//default input session file name");
    		out.println("input_session_file=/inputFiles/Nasca.input;");//need to be changed in future
    		out.println();out.println();
    		
	    	out.close();
	    	
		}catch (FileNotFoundException e)
		{
			System.out.println("File not found: " + strOutputFileName);
		}catch (IOException e)
		{
			System.out.println("IOException: the stack trace is:");
			e.printStackTrace();
		}
		 			
    	
    }
    private void jButtonDefaultInputPathActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDefaultInputPathActionPerformed
        //String curDir=System.getProperty("user.dir")+File.separator;
        String curDir=Global.getInputFilePath();
        String sourceName="";
        File sourceFile=new File (sourceName);            
         
        javax.swing.JFileChooser chooser=new javax.swing.JFileChooser(curDir);         
                 
        chooser.setMultiSelectionEnabled(false);
	   	 
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY); 
        chooser.setSelectedFile(sourceFile);  // set default for output
			 
	   	//String[] html=new String[] {"PDB","pdb"};
	   	//chooser.addChoosableFileFilter(new ExtFilter(html,
	         //     "PDB file (*.pdb)"));
	   	int option=chooser.showOpenDialog(this);////////////
	    if (option==JFileChooser.APPROVE_OPTION)
        {
            sourceFile=chooser.getSelectedFile();
            try {sourceName=sourceFile.getCanonicalPath();}
            catch (IOException e) {};
            jTextFieldDefaultInputPath.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());
            //Global.strInput=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();            
         }
         else {
                   /*add cancelled message here*/
       	  
         }
}//GEN-LAST:event_jButtonDefaultInputPathActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new ParametersJFrame().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonApply;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonDefaultInputPath;
    private javax.swing.JButton jButtonDefaultOutputPath;
    private javax.swing.JButton jButtonDefaultSetting;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JSpinner jSpinnerErrCa;
    private javax.swing.JSpinner jSpinnerErrH1;
    private javax.swing.JSpinner jSpinnerErrHa;
    private javax.swing.JSpinner jSpinnerErrHn;
    private javax.swing.JSpinner jSpinnerErrN;
    private javax.swing.JSpinner jSpinnerErrNoeLimit;
    private javax.swing.JTextField jTextFieldDefaultInputPath;
    private javax.swing.JTextField jTextFieldDefaultOutputPath;
    // End of variables declaration//GEN-END:variables
}
