package rdcPanda;

 ///////////////////////////////////////////////////////////////////////////////////////////////
//	ScNoe.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  LW            Lincong Wang                  Dartmouth College       wlincong@cs.dartmouth.edu
//    JMZ		 Jianyang (Michael) Zeng	       Duke University			zengjy@cs.duke.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////



/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */

     

import java.io. *;
import java.util. *;

// TODO: Auto-generated Javadoc
/** * 
 *  
*   This class is no longer used and replaced by H1CS.
*   Written by Lincong Wang (2001-2005) and Jianyang (Michael) Zeng (2005-2009).
*/
public class ScNoe{
   
    /** The cs h1. */
    private double csH1; 
    
    /** The cs h2. */
    private double csH2;
    
    /** The intensity. */
    private double intensity;
    
    /**
     * Instantiates a new sc noe.
     */
    public ScNoe()
    {
		csH1 = 0.0; 
		csH2 = 0.0; 
		intensity = 0.0; 
		
    }		
    
    /**
     * Instantiates a new sc noe.
     * 
     * @param cs1 the cs1
     */
    public ScNoe(double cs1)
    {
    	csH1 = cs1; 
    	csH2 = 0.0; 
    	intensity = 0.0;
    }		
    
    /**
     * Instantiates a new sc noe.
     * 
     * @param cs1 the cs1
     * @param cs2 the cs2
     */
    public ScNoe(double cs1, double cs2)
    {
    	csH1 = cs1; 
    	csH2 = cs2; 
    	intensity = 0.0;
    }		
    
    /**
     * Instantiates a new sc noe.
     * 
     * @param cs1 the cs1
     * @param cs2 the cs2
     * @param intens the intens
     */
    public ScNoe(double cs1, double cs2,double intens)
    {
    	csH1 = cs1; 
    	csH2 = cs2; 
    	intensity = intens;
    }	  

  //getting the values	
    /**
   * Gets the hC s1.
   * 
   * @return the hC s1
   */
  public double getHCS1(){
	return csH1;
    }	
    
    /**
     * Gets the hC s2.
     * 
     * @return the hC s2
     */
    public double getHCS2(){
    	return csH2;
        }	
    
    /**
     * Gets the intensity.
     * 
     * @return the intensity
     */
    public double getIntensity(){
    	return intensity;
        }	
   
   

    //set the values	
    /**
     * Sets the hC s1.
     * 
     * @param R the new hC s1
     */
    public void setHCS1(double R){
    	csH1 = R;
    }	
    
    /**
     * Sets the hC s2.
     * 
     * @param R the new hC s2
     */
    public void setHCS2(double R){
    	csH2 = R;
    }	
    
    /**
     * Sets the intensity.
     * 
     * @param R the new intensity
     */
    public void setIntensity(double R){
    	intensity = R;
    }	

    /**
     * The Class cs1Comparator.
     */
    public static class cs1Comparator implements Comparator{
	
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2){
		ScNoe n1 = (ScNoe)o1;
		ScNoe n2 = (ScNoe)o2;
	    double d1 = n1.getHCS1();
	    double d2 = n2.getHCS1();
	    if (d1 < d2)
		return -1;
	    else if (d1 > d2)
		return 1;
	    else return 0;
	}
    }

    /**
     * The Class cs2Comparator.
     */
    public static class cs2Comparator implements Comparator{
    	
	    /* (non-Javadoc)
	     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	     */
	    public int compare(Object o1, Object o2){
    		ScNoe n1 = (ScNoe)o1;
    		ScNoe n2 = (ScNoe)o2;
    	    double d1 = n1.getHCS2();
    	    double d2 = n2.getHCS2();
    	    if (d1 < d2)
    		return -1;
    	    else if (d1 > d2)
    		return 1;
    	    else return 0;
    	}
        }
   
    /**
     * The Class intensityComparator.
     */
    public static class intensityComparator implements Comparator{
    	
	    /* (non-Javadoc)
	     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	     */
	    public int compare(Object o1, Object o2){
    		ScNoe n1 = (ScNoe)o1;
    		ScNoe n2 = (ScNoe)o2;
    	    double d1 = n1.getIntensity();
    	    double d2 = n2.getIntensity();
    	    if (d1 < d2)
    		return -1;
    	    else if (d1 > d2)
    		return 1;
    	    else return 0;
    	}
        }
    
   }
